/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import splitBrain.SplitBrainBB;
import util.TestException;
import util.TestHelper;

public class SBSystemMembershipListener
implements SystemMembershipListener {
    public void memberJoined(SystemMembershipEvent event) {
        this.logCall("memberJoined", event);
    }

    public void memberLeft(SystemMembershipEvent event) {
        this.logCall("memberLeft", event);
    }

    public void memberCrashed(SystemMembershipEvent event) {
        this.logCall("memberCrashed", event);
        boolean survivingPartition = !RemoteTestModule.getMyHost().equals(SplitBrainBB.getLosingSideHost());
        DistributedMember dm = event.getDistributedMember();
        SplitBrainBB.updateMember(dm, survivingPartition);
    }

    public void memberInfo(SystemMembershipEvent event) {
        this.logCall("memberInfo", event);
    }

    private String logCall(String methodName, SystemMembershipEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    private String toString(String methodName, SystemMembershipEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName() + "\n");
        if (event == null) {
            return aStr.toString();
        }
        aStr.append("   event.getDistributedMember(): " + event.getDistributedMember().toString() + "\n");
        aStr.append("   event.getMemberId(): " + event.getMemberId() + "\n");
        return aStr.toString();
    }

    protected void throwException(String errStr) {
        SharedMap aMap = SplitBrainBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        throw new TestException(errStr);
    }
}

