/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import splitBrain.MLRioBB;
import util.AbstractListener;
import util.BaseValueHolder;
import util.TestException;
import util.TestHelper;

public class MLRioSequentialValuesListener
extends AbstractListener
implements CacheListener,
Declarable {
    public void afterCreate(EntryEvent event) {
        if (Log.getLogWriter().fineEnabled()) {
            this.logCall("afterCreate", (CacheEvent)event);
        }
    }

    public void afterUpdate(EntryEvent event) {
        Object key = event.getKey();
        Integer newValue = ((BaseValueHolder)event.getNewValue()).modVal;
        Integer oldValue = ((BaseValueHolder)event.getOldValue()).modVal;
        StringBuffer errMsg = new StringBuffer();
        int diff = newValue - oldValue;
        if (diff != 1) {
            this.logCall("afterUpdate", (CacheEvent)event);
            errMsg.append("Value for Key(" + key + ") did not incrementally increase, event.getOldValue() =  " + oldValue + ", event.getNewValue() = " + newValue);
            this.throwException(errMsg.toString());
        } else if (Log.getLogWriter().fineEnabled()) {
            this.logCall("afterUpdate", (CacheEvent)event);
        }
    }

    public void afterDestroy(EntryEvent event) {
    }

    public void afterInvalidate(EntryEvent event) {
    }

    public void afterRegionDestroy(RegionEvent event) {
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void close() {
    }

    public void afterRegionClear(RegionEvent event) {
    }

    public void afterRegionCreate(RegionEvent event) {
    }

    public void afterRegionLive(RegionEvent event) {
    }

    public void init(Properties prop) {
    }

    protected void throwException(String errStr) {
        SharedMap aMap = MLRioBB.getBB().getSharedMap();
        if (aMap.get(TestHelper.EVENT_ERROR_KEY) == null) {
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " in " + MLRioSequentialValuesListener.getMyUniqueName() + " " + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Listener encountered Exception: " + errStr + ", written to MLRioBB");
        throw new TestException(errStr);
    }

    public static String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }
}

