/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import splitBrain.ControllerBB;
import util.TestException;

public class ForcedDiscUtil {
    public static void waitForForcedDiscConditions(DistributedSystem ds, Cache theCache) {
        ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache, 1);
    }

    public static void waitForForcedDiscConditions(DistributedSystem ds, Cache theCache, int numRegionsInVm) {
        Log.getLogWriter().info("Waiting for a forced disconnect to occur...");
        while (true) {
            boolean isConnected = ds.isConnected();
            boolean cacheClosed = theCache.isClosed();
            int forcedDiscEventCount = ControllerBB.getMapCounter("NumForcedDiscEvents_");
            boolean membershipFailureComplete = ControllerBB.isMembershipFailureComplete();
            Log.getLogWriter().info("Waiting for forced disconnect conditions,\nis connected (looking for false): " + isConnected + "\nafterRegionDestroyedEvent count (looking for " + numRegionsInVm + "): " + forcedDiscEventCount + "\nmembership failure complete (looking for true): " + membershipFailureComplete + "\ncacheClosed (looking for true): " + cacheClosed);
            if (forcedDiscEventCount == numRegionsInVm && !isConnected && cacheClosed && membershipFailureComplete) break;
            if (forcedDiscEventCount > numRegionsInVm) {
                String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + "; Number of forced disconnect events for this vm is " + forcedDiscEventCount + ", expected " + numRegionsInVm;
                Log.getLogWriter().info(errStr);
                ControllerBB.getBB().getSharedMap().put("Error", errStr);
                continue;
            }
            MasterController.sleepForMs(1500);
        }
        Log.getLogWriter().info("Forced disconnect conditions have been met");
        Log.getLogWriter().info("Done waiting for forced disconnect conditions...");
        long startTime = ControllerBB.getMembershipFailureStartTime();
        long endTime = ControllerBB.getMembershipFailureCompletionTime();
        long duration = endTime - startTime;
        String aStr = "It took " + duration + " ms to complete membership failure (time between MembershipNotifyHook.beforeMembershipFailure and MembershipNotifyHook.afterMembershipFailure.";
        Log.getLogWriter().info(aStr);
        if (duration > 60000L) {
            throw new TestException(aStr);
        }
    }
}

