/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.Set;
import splitBrain.SBUtil;
import tx.TxBB;
import tx.TxPrms;
import tx.ViewTest;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;

public class FDViewTest
extends ViewTest {
    public static synchronized void HydraTask_initialize() {
        Log.getLogWriter().info("In HydraTask_initialize");
        if (viewTest == null) {
            viewTest = new FDViewTest();
            ((FDViewTest)viewTest).initialize();
        }
        TxBB.getBB().getSharedMap().put("afterCommitProcessed", new Boolean(false));
    }

    @Override
    public void initialize() {
        super.initialize();
        Cache myCache = CacheUtil.getCache();
        String FDRegionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName);
        Log.getLogWriter().info("Creating FDRegion " + FDRegionName);
        Region rootRegion = RegionHelper.createRegion(FDRegionName, ConfigPrms.getRegionConfig());
        Log.getLogWriter().info("Created FDRegion " + FDRegionName);
    }

    public static void HydraTask_executeTx() {
        try {
            ViewTest.HydraTask_executeTx();
        }
        catch (DistributedSystemDisconnectedException sde) {
            FDViewTest.checkForForcedDisconnect((Exception)((Object)sde));
        }
        catch (CancelException cce) {
            FDViewTest.checkForForcedDisconnect((Exception)((Object)cce));
        }
        catch (Exception e) {
            Log.getLogWriter().info("executeTx threw Exception " + e);
            throw new TestException("executeTx caught Exception " + TestHelper.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_forceDisconnect() {
        Log.getLogWriter().info("In HydraTask_forceDisconnect() ...");
        Object object = ViewTest.killSyncObject;
        synchronized (object) {
            Region fdRegion;
            block7: {
                try {
                    ViewTest.killSyncObject.wait();
                }
                catch (InterruptedException e) {
                    Log.getLogWriter().info("forceDisconnect interrupted, did not forceDisconnect");
                }
                SBUtil.beSick();
                SBUtil.playDead();
                Set rootRegions = CacheUtil.getCache().rootRegions();
                int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
                Object[] regionList = rootRegions.toArray();
                fdRegion = (Region)regionList[randInt];
                try {
                    fdRegion.put((Object)fdRegion.getName(), (Object)new Long(System.currentTimeMillis()));
                }
                catch (Exception e) {
                    boolean isCausedByForcedDisconnect;
                    String errStr = e.toString();
                    boolean bl = isCausedByForcedDisconnect = errStr.indexOf("com.gemstone.gemfire.ForcedDisconnectException") >= 0;
                    if (isCausedByForcedDisconnect) break block7;
                    throw new TestException("Unexpected Exception " + e + " thrown on put to fdRegion " + fdRegion.getName() + " " + TestHelper.getStackTrace(e));
                }
            }
            Log.getLogWriter().info("Done calling put on " + fdRegion.getName() + " to cause a forced disconnect");
        }
    }

    public static void HydraTask_doFDRegionOps() {
        ((FDViewTest)viewTest).doFDRegionOps();
    }

    private void doFDRegionOps() {
        String FDRegionName = TestConfig.tab().stringAt(TxPrms.excludeRegionName);
        Region aRegion = CacheUtil.getCache().getRegion(FDRegionName);
        String key = RemoteTestModule.getMyClientName();
        long startTime = System.currentTimeMillis();
        do {
            aRegion.put((Object)key, (Object)new Long(System.currentTimeMillis()));
            MasterController.sleepForMs(5000);
        } while (System.currentTimeMillis() - startTime < 60000L);
    }

    private static boolean checkForForcedDisconnect(Exception e) {
        Log.getLogWriter().info("checkForForcedDisconnect processed Exception " + e);
        String errStr = e.toString();
        boolean causedByForcedDisconnect = errStr.indexOf("com.gemstone.gemfire.ForcedDisconnectException") >= 0;
        return causedByForcedDisconnect;
    }
}

