/*
 * Decompiled with CFR 0.152.
 */
package security;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientCacheHelper;
import hydra.ClientRegionHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.GemFirePrms;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import security.EntryOperations;
import security.PKCSUserPasswordPrms;
import security.SecurityClientBB;
import security.SecurityClientsPrms;
import security.SecurityTest;
import util.TestException;

public class PerUserRequestSecurityTest {
    protected static final String SECURITY_SCHEME = TestConfig.tab().stringAt(GemFirePrms.securityName, "dummyScheme");
    public static final String USER_NAME = "security-username";
    public static final String PASSWORD = "security-password";
    public static Map<String, Region> proxyRegionMap = new HashMap<String, Region>();
    public static Map<String, RegionService> proxyAuthenticatedCacheMap = new HashMap<String, RegionService>();
    public static Map<String, Map<String, ArrayList<String>>> userToRolesMap = new HashMap<String, Map<String, ArrayList<String>>>();
    public static Boolean isFailOver = false;
    public static ClientCache clientCache = null;
    public static Boolean writeToBB = false;
    static LogWriter logger;
    static long killInterval;
    static Random rand;

    public static synchronized void openServerCacheTask() {
        try {
            String cacheConfig = ConfigPrms.getCacheConfig();
            CacheHelper.createCache(cacheConfig);
            String bridgeConfig = ConfigPrms.getBridgeConfig();
            int numOfRegion = TestConfig.tab().intAt(SecurityClientsPrms.numberOfRegions, 1);
            if (numOfRegion == 1) {
                RegionHelper.createRegion(SecurityTest.REGION_NAME, ConfigPrms.getRegionConfig());
            } else {
                for (int i = 1; i <= numOfRegion; ++i) {
                    RegionHelper.createRegion(SecurityTest.REGION_NAME + i, ConfigPrms.getRegionConfig());
                }
            }
            if (bridgeConfig != null) {
                BridgeHelper.startBridgeServer(bridgeConfig);
            }
        }
        catch (Exception e) {
            throw new TestException("Exception while openServerCacheTask :" + e.getMessage(), e.getCause());
        }
    }

    public static synchronized void openClientCacheTask() {
        block10: {
            try {
                String cacheConfig = ConfigPrms.getClientCacheConfig();
                clientCache = ClientCacheHelper.createCache(cacheConfig);
                Log.getLogWriter().info("The client cache has been created.");
                Region aRegion = ClientRegionHelper.createRegion(SecurityTest.REGION_NAME, ConfigPrms.getClientRegionConfig());
                Log.getLogWriter().info("The client region has been created.");
                Log.getLogWriter().info("Entries have been put into the region ::" + SecurityTest.REGION_NAME);
                Pool pool = PoolHelper.getPool("brloader");
                if (!pool.getMultiuserAuthentication()) break block10;
                Vector usersPerVMList = null;
                Vector usersKeyStorePathPerVMList = null;
                Vector usersKeyStoreAliasPerVMList = null;
                String schemeName = DistributedSystemHelper.getGemFireDescription().getSecurityDescription().getName();
                Log.getLogWriter().info("Security Name is :: " + schemeName);
                if (schemeName.equals("dummyScheme")) {
                    usersPerVMList = SecurityClientsPrms.getUserCredentialsListForDummyScheme();
                } else if (schemeName.equals("ldapScheme")) {
                    usersPerVMList = SecurityClientsPrms.getUserCredentialsListForLdapScheme();
                }
                if (schemeName.equals("dummyScheme") || schemeName.equals("ldapScheme")) {
                    for (int i = 0; i < usersPerVMList.size(); ++i) {
                        String userCred = (String)usersPerVMList.elementAt(i);
                        Log.getLogWriter().info("userCredentials are :: " + userCred.toString());
                        String userName = userCred.substring(0, userCred.indexOf("-"));
                        String password = userCred.substring(userCred.indexOf("-") + 1);
                        Properties userProps = new Properties();
                        userProps.setProperty(USER_NAME, userName);
                        userProps.setProperty(PASSWORD, password);
                        ProxyCache cache = (ProxyCache)clientCache.createAuthenticatedView(userProps, pool.getName());
                        Log.getLogWriter().info("Got the proxyCache for user ::" + userName);
                        proxyRegionMap.put(userName, cache.getRegion(SecurityTest.REGION_NAME));
                        proxyAuthenticatedCacheMap.put(userName, (RegionService)cache);
                        Log.getLogWriter().info("Got the proxyRegion for user ::" + userName);
                    }
                } else if (schemeName.equals("pkcsScheme")) {
                    usersKeyStorePathPerVMList = SecurityClientsPrms.getKeyStorePathListForPkcsScheme();
                    usersKeyStoreAliasPerVMList = SecurityClientsPrms.getKeyStoreAliasListForPkcsScheme();
                    String kestorePass = TestConfig.tab().stringAt(PKCSUserPasswordPrms.keystorepass, "gemfire");
                    for (int i = 0; i < usersKeyStorePathPerVMList.size(); ++i) {
                        String keystorePath = (String)usersKeyStorePathPerVMList.elementAt(i);
                        String keystoreAlias = (String)usersKeyStoreAliasPerVMList.elementAt(i);
                        keystorePath = EnvHelper.expandPath("$JTESTS" + keystorePath);
                        Properties userProps = new Properties();
                        userProps.setProperty("security-keystorepath", keystorePath);
                        userProps.setProperty("security-alias", keystoreAlias);
                        userProps.setProperty("security-keystorepass", kestorePass);
                        ProxyCache cache = (ProxyCache)clientCache.createAuthenticatedView(userProps, pool.getName());
                        Log.getLogWriter().info("Got the proxyCache for user ::" + keystoreAlias);
                        proxyRegionMap.put(keystoreAlias, cache.getRegion(SecurityTest.REGION_NAME));
                        proxyAuthenticatedCacheMap.put(keystoreAlias, (RegionService)cache);
                        Log.getLogWriter().info("Got the proxyRegion for user ::" + keystoreAlias);
                    }
                }
                EntryOperations.initCQTask(writeToBB);
            }
            catch (Exception e) {
                throw new TestException("Exception while openClientCacheTask :" + e.getMessage(), e);
            }
        }
    }

    public static synchronized void openDurableClientCacheTask() {
        try {
            writeToBB = true;
            PerUserRequestSecurityTest.openClientCacheTask();
            String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
            Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
            if (!SecurityClientBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                Iterator<String> iter = proxyRegionMap.keySet().iterator();
                HashMap<String, HashMap[]> userMap = new HashMap<String, HashMap[]>();
                while (iter.hasNext()) {
                    String userName = iter.next();
                    HashMap[] mapArray = new HashMap[]{new HashMap(), new HashMap()};
                    userMap.put(userName, mapArray);
                }
                SecurityClientBB.getBB().getSharedMap().put(VmDurableId, userMap);
            }
            clientCache.readyForEvents();
        }
        catch (Exception e) {
            throw new TestException("Exception while openDurableClientCacheTask :" + e.getMessage(), e);
        }
    }

    public static void mentionReferenceInBlackboard() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Log.getLogWriter().info("Reference VM is : " + VmDurableId);
        SecurityClientBB.getBB().getSharedMap().put("REFERENCE VM:", VmDurableId);
    }

    public static void killClient() {
        try {
            MasterController.sleepForMs(10000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void validateFailedOrPassedEntryOpsForMultiUserMode() {
        int totalOperation = 0;
        int notAuthzCount = 0;
        Iterator<String> iter = proxyRegionMap.keySet().iterator();
        Boolean opFoundInOpList = false;
        Boolean hasCQExecOp = false;
        Boolean hasGETOp = false;
        String opName2 = null;
        while (iter.hasNext()) {
            String userName = iter.next();
            hasCQExecOp = false;
            hasGETOp = false;
            Map operations = EntryOperations.userOperationMap.get(userName);
            Map exceptions = EntryOperations.userExceptionMap.get(userName);
            for (String opName2 : operations.keySet()) {
                Log.getLogWriter().fine("validateFailedOrPassed successOrFailureEntryOperations = " + operations.get(opName2));
                Log.getLogWriter().fine("OperationName ::" + opName2);
                Integer tmpTotalOperation = (Integer)operations.get(opName2);
                Integer tmpNotAuthzCount = (Integer)exceptions.get(opName2);
                totalOperation = tmpTotalOperation == null ? 0 : tmpTotalOperation;
                notAuthzCount = tmpNotAuthzCount == null ? 0 : tmpNotAuthzCount;
                Log.getLogWriter().info("Total Operations Count ::" + totalOperation);
                Log.getLogWriter().info("Total exceptions Count ::" + notAuthzCount);
                Map<String, ArrayList<String>> userRoleOpMap = userToRolesMap.get(userName);
                Iterator<String> userRoleOpIter = userRoleOpMap.keySet().iterator();
                while (userRoleOpIter.hasNext()) {
                    opFoundInOpList = false;
                    String roleName = userRoleOpIter.next();
                    ArrayList<String> roleOpNames = userRoleOpMap.get(roleName);
                    for (int i = 0; i < roleOpNames.size(); ++i) {
                        if (roleOpNames.get(i).equalsIgnoreCase("EXECUTE_CQ")) {
                            hasCQExecOp = true;
                        }
                        if (roleOpNames.get(i).equalsIgnoreCase("GET")) {
                            hasGETOp = true;
                        }
                        if (opName2.equalsIgnoreCase(roleOpNames.get(i))) {
                            opFoundInOpList = true;
                            continue;
                        }
                        if (!opName2.equalsIgnoreCase("executeQuery") || !roleOpNames.get(i).equalsIgnoreCase("QUERY")) continue;
                        opFoundInOpList = true;
                    }
                    if (!opFoundInOpList.booleanValue()) continue;
                    break;
                }
                if (opFoundInOpList.booleanValue()) {
                    if (totalOperation != 0 && notAuthzCount == 0) {
                        Log.getLogWriter().info("Task passed sucessfully with total operation = " + totalOperation + " for the user ::" + userName);
                        continue;
                    }
                    Log.getLogWriter().info("Task failed for the user :: " + userName);
                    throw new TestException(notAuthzCount + " NotAuthorizedException found for operation " + opName2 + " while expected 0");
                }
                if (totalOperation == notAuthzCount) {
                    Log.getLogWriter().info("Task passed sucessfully and got the expected number of not authorize exception: " + notAuthzCount + " with total number of operation " + totalOperation);
                    Log.getLogWriter().info("Task Passed successfully for the user ::" + userName);
                    continue;
                }
                Log.getLogWriter().info("Task failed for the user :: " + userName);
                throw new TestException("Expected NotAuthorizedException with total number of " + opName2 + " operation " + totalOperation + " but found " + notAuthzCount);
            }
            long numOfEventsForCQ1 = 0L;
            long numOfEventsForCQ2 = 0L;
            QueryService qs = proxyAuthenticatedCacheMap.get(userName).getQueryService();
            if (qs.getCq("CQ1_" + userName) != null) {
                numOfEventsForCQ1 = ((CqQueryTestListener)qs.getCq("CQ1_" + userName).getCqAttributes().getCqListeners()[0]).getTotalEventCount();
            } else {
                Log.getLogWriter().info(" CQ1 is null for user :" + userName);
            }
            if (qs.getCq("CQ2_" + userName) != null) {
                numOfEventsForCQ2 = ((CqQueryTestListener)qs.getCq("CQ2_" + userName).getCqAttributes().getCqListeners()[0]).getTotalEventCount();
            } else {
                Log.getLogWriter().info(" CQ2 is null for user :" + userName);
            }
            if (hasCQExecOp.booleanValue() && hasGETOp.booleanValue()) {
                if (numOfEventsForCQ1 > 0L && numOfEventsForCQ2 > 0L) {
                    Log.getLogWriter().info("CQ Task Passed sucessfully for user :: " + userName + " with total number of CQ events for CQ1 : " + numOfEventsForCQ1 + " and for CQ2 : " + numOfEventsForCQ2);
                    continue;
                }
                Log.getLogWriter().info("CQ Task failed for the user :: " + userName);
                throw new TestException("Expected total CQ events for CQ1 and CQ2 to be > 0 but found CQ1 : " + numOfEventsForCQ1 + " and CQ2 : " + numOfEventsForCQ2);
            }
            if (numOfEventsForCQ1 == 0L && numOfEventsForCQ2 == 0L) {
                Log.getLogWriter().info("CQ Task Passed sucessfully for user :: " + userName + " with 0 CQ events for CQ1 and CQ2");
                continue;
            }
            Log.getLogWriter().info("CQ Task failed for the user :: " + userName);
            throw new TestException("Expected total CQ events for CQ1 and CQ2 to be 0, but found " + numOfEventsForCQ1 + " and " + numOfEventsForCQ2 + " respectively.");
        }
    }

    public static void setFailOverTest() {
        isFailOver = true;
    }

    public static void validateDurableCQEvents() {
        String ReferenceVm = (String)SecurityClientBB.getBB().getSharedMap().get("REFERENCE VM:");
        Log.getLogWriter().info("Reference VM Client Id is " + ReferenceVm);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
        HashMap currentVmMap = (HashMap)SecurityClientBB.getBB().getSharedMap().get(VmDurableId);
        HashMap referenceMap = (HashMap)SecurityClientBB.getBB().getSharedMap().get(ReferenceVm);
        if (currentVmMap.isEmpty()) {
            throw new TestException(" The map is empty for " + VmDurableId);
        }
        if (referenceMap.isEmpty()) {
            throw new TestException("The map is empty for Reference Vm " + ReferenceVm);
        }
        Iterator iterator = referenceMap.entrySet().iterator();
        Map.Entry entry = null;
        Object userName = null;
        Object mapArray = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            userName = entry.getKey();
            mapArray = entry.getValue();
            HashMap[] referenceMapArray = mapArray;
            HashMap opEventCntMap = referenceMapArray[0];
            Iterator iterator1 = opEventCntMap.entrySet().iterator();
            Map.Entry entry1 = null;
            String operation = null;
            long eventCnt = 0L;
            Log.getLogWriter().info("Event Map for UserName :: " + userName);
            Log.getLogWriter().info("Operation - ReferenceVM   CurrentVM ");
            while (iterator1.hasNext()) {
                entry1 = iterator1.next();
                operation = (String)entry1.getKey();
                eventCnt = (Long)entry1.getValue();
                if (currentVmMap.get(userName) == null) {
                    throw new TestException("No event map for " + userName + " because client didnot receive any events for this user");
                }
                if (((HashMap[])currentVmMap.get(userName))[0].get(operation) == null) {
                    throw new TestException(operation + " event not received by the client for " + userName);
                }
                Log.getLogWriter().info(operation + "  -  " + eventCnt + "       " + ((HashMap[])currentVmMap.get(userName))[0].get(operation));
                long currentVmOpCount = (Long)((HashMap[])currentVmMap.get(userName))[0].get(operation);
                if (eventCnt == currentVmOpCount) continue;
                throw new TestException("For the user " + userName + ", expected " + eventCnt + " " + operation + "s but found " + currentVmOpCount);
            }
        }
    }

    public static void closeProxyCacheAndCQTask() {
        Region region = null;
        for (String userName : proxyRegionMap.keySet()) {
            region = proxyRegionMap.get(userName);
            proxyAuthenticatedCacheMap.get(userName).getQueryService().closeCqs();
            proxyAuthenticatedCacheMap.get(userName).close();
        }
    }

    static {
        ArrayList<String> ops = new ArrayList<String>();
        HashMap<String, ArrayList<String>> globalRolesToOpsMap = new HashMap<String, ArrayList<String>>();
        ops.add(0, "GET");
        ops.add(1, "CONTAINS_KEY");
        ops.add(2, "KEY_SET");
        ops.add(3, "EXECUTE_FUNCTION");
        globalRolesToOpsMap.put("reader", ops);
        ops = new ArrayList();
        ops.add(0, "PUT");
        ops.add(1, "PUTALL");
        ops.add(2, "DESTROY");
        ops.add(1, "INVALIDATE");
        ops.add(3, "REGION_CLEAR");
        globalRolesToOpsMap.put("writer", ops);
        ops = new ArrayList();
        ops.add(0, "QUERY");
        ops.add(1, "EXECUTE_CQ");
        ops.add(2, "STOP_CQ");
        ops.add(3, "CLOSE_CQ");
        globalRolesToOpsMap.put("queryRegions", ops);
        ops = new ArrayList();
        ops.add(0, "QUERY");
        ops.add(1, "EXECUTE_CQ");
        ops.add(2, "STOP_CQ");
        ops.add(3, "CLOSE_CQ");
        globalRolesToOpsMap.put("cacheOps", ops);
        HashMap rolesToOpsMap = new HashMap();
        rolesToOpsMap.put("reader", globalRolesToOpsMap.get("reader"));
        userToRolesMap.put("gemfire3", rolesToOpsMap);
        userToRolesMap.put("gemfire4", rolesToOpsMap);
        userToRolesMap.put("gemfire5", rolesToOpsMap);
        rolesToOpsMap = new HashMap();
        rolesToOpsMap.put("writer", globalRolesToOpsMap.get("writer"));
        userToRolesMap.put("user3", rolesToOpsMap);
        userToRolesMap.put("user4", rolesToOpsMap);
        userToRolesMap.put("gemfire6", rolesToOpsMap);
        userToRolesMap.put("gemfire7", rolesToOpsMap);
        userToRolesMap.put("gemfire8", rolesToOpsMap);
        rolesToOpsMap = new HashMap();
        rolesToOpsMap.put("queryRegions", globalRolesToOpsMap.get("queryRegions"));
        userToRolesMap.put("user5", rolesToOpsMap);
        userToRolesMap.put("user6", rolesToOpsMap);
        userToRolesMap.put("gemfire9", rolesToOpsMap);
        userToRolesMap.put("gemfire10", rolesToOpsMap);
        rolesToOpsMap = new HashMap();
        rolesToOpsMap.put("reader", globalRolesToOpsMap.get("reader"));
        rolesToOpsMap.put("cacheOps", globalRolesToOpsMap.get("cacheOps"));
        userToRolesMap.put("user1", rolesToOpsMap);
        userToRolesMap.put("user2", rolesToOpsMap);
        rolesToOpsMap = new HashMap();
        rolesToOpsMap.put("writer", globalRolesToOpsMap.get("writer"));
        rolesToOpsMap.put("reader", globalRolesToOpsMap.get("reader"));
        rolesToOpsMap.put("cacheOps", globalRolesToOpsMap.get("cacheOps"));
        userToRolesMap.put("root", rolesToOpsMap);
        userToRolesMap.put("admin", rolesToOpsMap);
        userToRolesMap.put("administrator", rolesToOpsMap);
        userToRolesMap.put("gemfire1", rolesToOpsMap);
        userToRolesMap.put("gemfire2", rolesToOpsMap);
        logger = Log.getLogWriter();
        killInterval = TestConfig.tab().longAt(SecurityClientsPrms.killInterval);
        rand = new Random();
    }
}

