/*
 * Decompiled with CFR 0.152.
 */
package security;

import hydra.EnvHelper;
import java.security.Principal;
import java.util.Properties;
import java.util.Random;
import security.CredentialGenerator;
import security.PKCSCredentialGenerator;

public class LdapUserCredentialGenerator
extends CredentialGenerator {
    private static final String USER_PREFIX = "gemfire";
    private static boolean enableServerAuthentication = false;
    private boolean serverAuthEnabled = enableServerAuthentication = !enableServerAuthentication;
    private static final Random prng = new Random();
    private static final String[] algos = new String[]{"", "DESede", "AES:128", "Blowfish:128"};

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        Properties extraProps = new Properties();
        String ldapServer = System.getProperty("gf.ldap.server");
        String ldapBaseDN = System.getProperty("gf.ldap.basedn");
        String ldapUseSSL = System.getProperty("gf.ldap.usessl");
        extraProps.setProperty("security-ldap-server", ldapServer);
        extraProps.setProperty("security-ldap-basedn", ldapBaseDN);
        if (ldapUseSSL != null && ldapUseSSL.length() > 0) {
            extraProps.setProperty("security-ldap-usessl", ldapUseSSL);
        }
        if (this.serverAuthEnabled) {
            String keyStoreFile = "$JTESTS" + PKCSCredentialGenerator.keyStoreDir + "/gemfire1.keystore";
            extraProps.setProperty("security-server-kspath", EnvHelper.expandPath(keyStoreFile));
            extraProps.setProperty("security-server-ksalias", "gemfire1");
            extraProps.setProperty("security-server-kspasswd", USER_PREFIX);
        }
        return extraProps;
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.LDAP;
    }

    @Override
    public String getAuthInit() {
        return "templates.security.UserPasswordAuthInit.create";
    }

    @Override
    public String getAuthenticator() {
        return "templates.security.LdapUserAuthenticator.create";
    }

    @Override
    public Properties getValidCredentials(int index) {
        Properties props = new Properties();
        props.setProperty("security-username", USER_PREFIX + (index % 10 + 1));
        props.setProperty("security-password", USER_PREFIX + (index % 10 + 1));
        props.setProperty("security-client-dhalgo", algos[prng.nextInt(algos.length)]);
        if (this.serverAuthEnabled) {
            String publicKeyFile = "$JTESTS" + PKCSCredentialGenerator.keyStoreDir + "/publickeyfile";
            props.setProperty("security-client-kspath", EnvHelper.expandPath(publicKeyFile));
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        Properties props = null;
        String userName = principal.getName();
        if (userName != null && userName.startsWith(USER_PREFIX)) {
            boolean isValid;
            try {
                int suffix = Integer.parseInt(userName.substring(USER_PREFIX.length()));
                isValid = suffix >= 1 && suffix <= 10;
            }
            catch (Exception ex) {
                isValid = false;
            }
            if (isValid) {
                props = new Properties();
                props.setProperty("security-username", userName);
                props.setProperty("security-password", userName);
            }
        }
        if (props == null) {
            throw new IllegalArgumentException("LDAP: [" + userName + "] not a valid user");
        }
        props.setProperty("security-client-dhalgo", algos[prng.nextInt(algos.length)]);
        if (this.serverAuthEnabled) {
            String publicKeyFile = "$JTESTS" + PKCSCredentialGenerator.keyStoreDir + "/publickeyfile";
            props.setProperty("security-client-kspath", EnvHelper.expandPath(publicKeyFile));
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        Properties props = new Properties();
        props.setProperty("security-username", "invalid" + index);
        props.setProperty("security-password", "none");
        props.setProperty("security-client-dhalgo", algos[prng.nextInt(algos.length)]);
        if (this.serverAuthEnabled) {
            String publicKeyFile = "$JTESTS" + PKCSCredentialGenerator.keyStoreDir + "/publickeyfile";
            props.setProperty("security-client-kspath", EnvHelper.expandPath(publicKeyFile));
            props.setProperty("security-client-kspasswd", USER_PREFIX);
        }
        return props;
    }
}

