/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.TXId;
import hydra.CacheHelper;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import resumeTx.ResumeTxBB;
import resumeTx.ResumeTxPrms;
import resumeTx.RtxUtil;
import resumeTx.RtxUtilVersionHelper;
import resumeTx.TxInfo;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class TXController
implements Function,
Declarable {
    public void execute(FunctionContext context) {
        SharedCounters sc = ResumeTxBB.getBB().getSharedCounters();
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        int numThreads = (Integer)argumentList.get(1);
        TxInfo txInfo = (TxInfo)argumentList.get(2);
        boolean status = true;
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " and " + txInfo);
        TxHelper.begin();
        TransactionId txId = TxHelper.getTransactionId();
        txInfo.setTxId(txId);
        Map activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
        try {
            Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
            activeTxns.clear();
            activeTxns.put((TXId)txId, txInfo);
            ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
        }
        catch (Exception e) {
            throw new TestException(e.toString() + e.getStackTrace().toString());
        }
        sc.zero(ResumeTxBB.inTryResume);
        sc.increment(ResumeTxBB.readyToTryResume);
        int minExecutions = TestConfig.tab().getRandGen().nextInt(10, ResumeTxPrms.getMinExecutions());
        for (int i = 0; i < minExecutions; ++i) {
            RtxUtil.doOperations();
        }
        TestHelper.waitForCounter(ResumeTxBB.getBB(), "ResumeTxBB.inTryResume", ResumeTxBB.inTryResume, numThreads - 1, true, 5000L);
        sc.zero(ResumeTxBB.readyToTryResume);
        long startTime = System.currentTimeMillis();
        int action = TestConfig.tab().getRandGen().nextInt(0, 2);
        switch (action) {
            case 0: {
                TxHelper.commit();
                break;
            }
            case 1: {
                TxHelper.rollback();
                break;
            }
            case 2: {
                TxHelper.suspend();
                break;
            }
            default: {
                throw new TestException("Unknown action, expected commit(0), rollback(1) or suspendd(2)");
            }
        }
        TestHelper.waitForCounter(ResumeTxBB.getBB(), "ResumeTxBB.inTryResume", ResumeTxBB.inTryResume, 0L, true, 300000L);
        if (action == 2) {
            if (TxHelper.isSuspended(txId)) {
                TxHelper.resume(txId);
                TxHelper.commit();
            } else {
                throw new TestException("TXController unable to resume suspended transaction " + txId);
            }
        }
        long timeDelay = System.currentTimeMillis() - startTime;
        Log.getLogWriter().info("Time delay for all threads to return from tryResume(with wait) " + timeDelay + "ms");
        Log.getLogWriter().info("TXController returning " + status);
        context.getResultSender().lastResult((Object)new Boolean(status));
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

