/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumeTxBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class ResumableApiTest {
    public static ResumableApiTest testInstance = null;
    private CacheTransactionManager ctm;
    private SharedCounters sc;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ResumableApiTest();
            testInstance.createRegions();
            testInstance.initializeInstance();
        }
    }

    private void initializeInstance() {
        this.ctm = CacheHelper.getCache().getCacheTransactionManager();
        this.sc = ResumeTxBB.getBB().getSharedCounters();
    }

    private void createRegions() {
        CacheHelper.createCache("cache1");
        HydraVector aVec = TestConfig.tab().vecAt(RegionPrms.names);
        for (String regionConfigName : aVec) {
            Log.getLogWriter().info("Creating region " + regionConfigName);
            RegionHelper.createRegion(regionConfigName);
        }
    }

    public static void HydraTask_initExtraVm() {
        SharedMap sm = ResumeTxBB.getBB().getSharedMap();
        TxHelper.begin();
        sm.put("ExtraVmTx_SuspendedTx", ResumableApiTest.testInstance.ctm.getTransactionId());
        TxHelper.suspend();
        TxHelper.begin();
        sm.put("ExtraVmTx_CommittedTx", ResumableApiTest.testInstance.ctm.getTransactionId());
        TxHelper.commit();
        TxHelper.begin();
        sm.put("ExtraVmTx_RolledBackTx", ResumableApiTest.testInstance.ctm.getTransactionId());
        TxHelper.rollback();
        TxHelper.begin();
        sm.put("ExtraVmTx_BegunTx", ResumableApiTest.testInstance.ctm.getTransactionId());
    }

    public static void HydraTask_txDoesNotExist() {
        Map aMap = ResumeTxBB.getBB().getSharedMap().getMap();
        for (Object key : aMap.keySet()) {
            if (!key.toString().startsWith("ExtraVmTx_")) continue;
            TransactionId txId = (TransactionId)aMap.get(key);
            testInstance.verifyTryResumeImmediate(txId, 60L, TimeUnit.SECONDS, false);
            testInstance.verifyTryResumeImmediate(txId, 60000L, TimeUnit.MILLISECONDS, false);
            testInstance.verifyTryResumeImmediate(txId, 6000000L, TimeUnit.MICROSECONDS, false);
            testInstance.verifyTryResumeImmediate(txId, 600000000L, TimeUnit.NANOSECONDS, false);
            testInstance.verifyTryResume(txId, false);
            testInstance.verifyExists(false);
            testInstance.verifyExists(txId, false);
            testInstance.verifyIsSuspended(txId, false);
            testInstance.verifyResume(txId, false);
        }
    }

    public static void HydraTask_txIsBusy() throws Throwable {
        TxHelper.begin();
        final TransactionId txId = ResumableApiTest.testInstance.ctm.getTransactionId();
        testInstance.verifyTryResumeImmediate(txId, 10L, TimeUnit.SECONDS, false);
        testInstance.verifyTryResumeImmediate(txId, 10000L, TimeUnit.MILLISECONDS, false);
        testInstance.verifyTryResumeImmediate(txId, 10000000L, TimeUnit.MICROSECONDS, false);
        testInstance.verifyTryResumeImmediate(txId, 1000000000L, TimeUnit.NANOSECONDS, false);
        testInstance.verifyTryResume(txId, false);
        testInstance.verifyExists(true);
        testInstance.verifyExists(txId, true);
        testInstance.verifyIsSuspended(txId, false);
        try {
            Log.getLogWriter().info("Calling resume(" + txId + ")...");
            ResumableApiTest.testInstance.ctm.resume(txId);
            Log.getLogWriter().info("resume(" + txId + ") succeeded");
            throw new TestException("Expected resume(" + txId + ") to throw " + IllegalStateException.class.getName() + ", but it succeeded");
        }
        catch (IllegalStateException e) {
            Log.getLogWriter().info("resume(" + txId + ") resulted in " + e);
            if (e.getMessage().indexOf("cannot resume another transaction") >= 0) {
                throw new TestException("Trying to resume " + txId + " which this thread already owns, but error message refers to 'another transaction': " + e);
            }
            final ArrayList failureList = new ArrayList();
            Thread testThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        testInstance.verifyTryResumeWaits(txId, 10L, TimeUnit.SECONDS, false);
                        testInstance.verifyTryResumeWaits(txId, 10000L, TimeUnit.MILLISECONDS, false);
                        testInstance.verifyTryResumeWaits(txId, 10000000L, TimeUnit.MICROSECONDS, false);
                        testInstance.verifyTryResumeWaits(txId, 1000000000L, TimeUnit.NANOSECONDS, false);
                        testInstance.verifyTryResume(txId, false);
                        testInstance.verifyExists(false);
                        testInstance.verifyExists(txId, true);
                        testInstance.verifyIsSuspended(txId, false);
                        testInstance.verifyResume(txId, false);
                    }
                    catch (Throwable e) {
                        failureList.add(e);
                    }
                }
            });
            testThread.start();
            try {
                testThread.join();
            }
            catch (InterruptedException e2) {
                throw new TestException(TestHelper.getStackTrace(e2));
            }
            if (failureList.size() > 0) {
                StringBuffer aStr = new StringBuffer();
                for (Throwable t : failureList) {
                    aStr.append(TestHelper.getStackTrace(t) + "\n");
                }
                throw new TestException(aStr.toString());
            }
            return;
        }
    }

    public static void HydraTask_txCommits() {
        int numExecutions = 10;
        for (int i = 1; i <= 10; ++i) {
            Log.getLogWriter().info("Execution number " + i);
            testInstance.txCommits();
        }
    }

    private void txCommits() throws TestException {
        List<Map> resultList = this.endTryResumeEarly("commit");
        int thresholdMs = 1000;
        StringBuffer errStr = new StringBuffer();
        TransactionId txId = (TransactionId)resultList.get(0).get("txId");
        for (Map aMap : resultList) {
            long timeDiffMs = (Long)aMap.get("timeDiffMs");
            if (timeDiffMs <= 1000L) continue;
            errStr.append(aMap.get("statusStr") + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException("Bug 43802 detected; Expected tryResume to complete when the transaction completed: " + errStr.toString());
        }
        for (Map aMap : resultList) {
            boolean result = (Boolean)aMap.get("result");
            if (!result) continue;
            errStr.append(aMap.get("statusStr") + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException("Expected tryResume to return false: " + errStr.toString());
        }
        this.verifyTryResume(txId, false);
        this.verifyExists(false);
        this.verifyExists(txId, false);
        this.verifyIsSuspended(txId, false);
        this.verifyResume(txId, false);
    }

    public static void HydraTask_txRollsBack() {
        int numExecutions = 10;
        for (int i = 1; i <= 10; ++i) {
            Log.getLogWriter().info("Execution number " + i);
            testInstance.txRollsBack();
        }
    }

    private void txRollsBack() throws TestException {
        List<Map> resultList = this.endTryResumeEarly("rollback");
        int thresholdMs = 1000;
        StringBuffer errStr = new StringBuffer();
        TransactionId txId = (TransactionId)resultList.get(0).get("txId");
        for (Map aMap : resultList) {
            long timeDiffMs = (Long)aMap.get("timeDiffMs");
            if (timeDiffMs <= 1000L) continue;
            errStr.append(aMap.get("statusStr") + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException("Bug 43802 detected; Expected tryResume to complete when the transaction completed: " + errStr.toString());
        }
        for (Map aMap : resultList) {
            boolean result = (Boolean)aMap.get("result");
            if (!result) continue;
            errStr.append(aMap.get("statusStr") + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException("Expected tryResume to return false: " + errStr.toString());
        }
        this.verifyTryResume(txId, false);
        this.verifyExists(false);
        this.verifyExists(txId, false);
        this.verifyIsSuspended(txId, false);
        this.verifyResume(txId, false);
    }

    public static void HydraTask_txSuspends() {
        int numExecutions = 10;
        for (int i = 1; i <= 10; ++i) {
            Log.getLogWriter().info("Execution number " + i);
            testInstance.txSuspends();
        }
    }

    private void txSuspends() throws TestException {
        Iterator errStr;
        List<Map> resultList = this.endTryResumeEarly("suspend");
        int thresholdMs = 1000;
        ArrayList<Map> endedEarly = new ArrayList<Map>();
        ArrayList<Map> others = new ArrayList<Map>();
        for (Map map : resultList) {
            Long l = (Long)map.get("timeDiffMs");
            if (l <= 1000L) {
                endedEarly.add(map);
                continue;
            }
            others.add(map);
        }
        if (endedEarly.size() == 0) {
            errStr = new StringBuffer();
            for (Map map : others) {
                ((StringBuffer)((Object)errStr)).append(map.get("statusStr") + "\n");
            }
            throw new TestException("No tryResume call ended its wait when suspend was called: \n" + ((StringBuffer)((Object)errStr)).toString());
        }
        if (endedEarly.size() > 1) {
            errStr = new StringBuffer();
            for (Map map : endedEarly) {
                ((StringBuffer)((Object)errStr)).append(map.get("statusStr") + "\n");
            }
            throw new TestException("More than 1 tryResume call ended its wait early when suspend was called: \n" + ((StringBuffer)((Object)errStr)).toString());
        }
        Log.getLogWriter().info("Exactly 1 tryResume call ended its wait early as expected");
        for (Map map : endedEarly) {
            boolean bl = (Boolean)map.get("result");
            if (bl) continue;
            throw new TestException(map.get("statusStr") + "; expected result to be true");
        }
        for (Map map : others) {
            boolean bl = (Boolean)map.get("result");
            if (!bl) continue;
            throw new TestException(map.get("statusStr") + "; expected result to be false");
        }
        TxHelper.begin();
        TransactionId suspendedTxId = this.ctm.getTransactionId();
        TxHelper.suspend();
        this.verifyTryResume(suspendedTxId, true);
        TxHelper.suspend();
        this.verifyExists(false);
        this.verifyExists(suspendedTxId, true);
        this.verifyIsSuspended(suspendedTxId, true);
        this.verifyResume(suspendedTxId, true);
        TxHelper.suspend();
        this.verifyTryResumeImmediate(suspendedTxId, 30L, TimeUnit.SECONDS, true);
        TxHelper.rollback();
    }

    private List<Map> endTryResumeEarly(String howToEndTx) {
        int numThreads = 10;
        TxHelper.begin();
        Region region1 = CacheHelper.getCache().getRegion("region1");
        Region region2 = CacheHelper.getCache().getRegion("region2");
        String anObj = NameFactory.getNextPositiveObjectName();
        region1.put((Object)anObj, (Object)anObj);
        Log.getLogWriter().info("Put key " + anObj + ", value " + anObj + " into " + region1.getFullPath());
        region2.put((Object)anObj, (Object)anObj);
        Log.getLogWriter().info("Put key " + anObj + ", value " + anObj + " into " + region2.getFullPath());
        final TransactionId txId = this.ctm.getTransactionId();
        long waitTime = 30L;
        final ArrayList failureList = new ArrayList();
        final List<Map> resultList = Collections.synchronizedList(new ArrayList());
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 1; i <= 10; ++i) {
            Thread testThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object[] resultArr = ResumableApiTest.this.tryResume(txId, 30L, TimeUnit.SECONDS);
                        HashMap<String, Object> aMap = new HashMap<String, Object>();
                        aMap.put("result", resultArr[0]);
                        aMap.put("duration", resultArr[1]);
                        aMap.put("timeAtCompletion", resultArr[2]);
                        aMap.put("threadName", Thread.currentThread().getName());
                        aMap.put("txId", txId);
                        resultList.add(aMap);
                    }
                    catch (Throwable e) {
                        failureList.add(e);
                    }
                }
            });
            testThread.setName("tryResumeThread_" + i);
            testThread.start();
            threadList.add(testThread);
        }
        int sleepTime = 15;
        Log.getLogWriter().info("Sleeping for 15 seconds, then doing " + howToEndTx + "...");
        MasterController.sleepForMs(15000);
        if (howToEndTx.equals("suspend")) {
            this.ctm.suspend();
        } else if (howToEndTx.equals("commit")) {
            this.ctm.commit();
        } else if (howToEndTx.equals("rollback")) {
            this.ctm.rollback();
        } else {
            throw new TestException("Unknown howToEndTx: " + howToEndTx);
        }
        long timeAtTxCompletion = System.currentTimeMillis();
        Log.getLogWriter().info(howToEndTx + " completed for " + txId);
        try {
            for (Thread thread : threadList) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (failureList.size() > 0) {
            StringBuffer aStr = new StringBuffer();
            for (Throwable t : failureList) {
                aStr.append(TestHelper.getStackTrace(t) + "\n");
            }
            throw new TestException(aStr.toString());
        }
        for (Map map : resultList) {
            boolean resultOfTryResume = (Boolean)map.get("result");
            long timeAtTryResumeCompletion = (Long)map.get("timeAtCompletion");
            String threadName = (String)map.get("threadName");
            long timeDiffMs = Math.abs(timeAtTxCompletion - timeAtTryResumeCompletion);
            map.put("timeDiffMs", timeDiffMs);
            map.put("timeAtTxCompletion", timeAtTxCompletion);
            String aStr = "For thread " + threadName + ", time of completion of " + howToEndTx + " is " + timeAtTxCompletion + ", time of completion of tryResume(" + txId + ", " + 30L + ", SECONDS) is " + timeAtTryResumeCompletion + ", difference is " + timeDiffMs + "ms, result is " + resultOfTryResume;
            map.put("statusStr", aStr);
            Log.getLogWriter().info(aStr);
        }
        return resultList;
    }

    public static void HydraTask_concSuspend() {
        testInstance.concSuspend();
    }

    private void concSuspend() {
        int numThreads = 1000;
        TxHelper.begin();
        final TransactionId txId = ResumableApiTest.testInstance.ctm.getTransactionId();
        Region region1 = CacheHelper.getCache().getRegion("region1");
        Region region2 = CacheHelper.getCache().getRegion("region2");
        String anObj = NameFactory.getNextPositiveObjectName();
        region1.put((Object)anObj, (Object)anObj);
        Log.getLogWriter().info("Put key " + anObj + ", value " + anObj + " into " + region1.getFullPath());
        region2.put((Object)anObj, (Object)anObj);
        Log.getLogWriter().info("Put key " + anObj + ", value " + anObj + " into " + region2.getFullPath());
        TxHelper.suspend();
        long timeAtFirstSuspendCompletion = System.currentTimeMillis();
        long waitTime = Integer.MAX_VALUE;
        final ArrayList failureList = new ArrayList();
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        final ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 1; i <= 1000; ++i) {
            Thread testThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object[] resultArr = ResumableApiTest.this.tryResume(txId, Integer.MAX_VALUE, TimeUnit.SECONDS);
                        boolean result = (Boolean)resultArr[0];
                        HashMap<String, Object> aMap = new HashMap<String, Object>();
                        resultList.add(aMap);
                        aMap.put("result", resultArr[0]);
                        aMap.put("duration", resultArr[1]);
                        aMap.put("timeAtCompletion", resultArr[2]);
                        aMap.put("threadName", Thread.currentThread().getName());
                        aMap.put("resumeOrder", resultArr[3]);
                        TxHelper.suspend();
                        aMap.put("timeAtSuspendCompletion", System.currentTimeMillis());
                        if (!result) {
                            throw new TestException(Thread.currentThread().getName() + " returned " + result + " from tryResume(" + txId + ", " + Integer.MAX_VALUE + ", TimeUnit.SECONDS) but expected true");
                        }
                    }
                    catch (Throwable e) {
                        failureList.add(e);
                    }
                    Log.getLogWriter().info(Thread.currentThread().getName() + " is terminating");
                }
            });
            testThread.setName("tryResumeThread_" + i);
            testThread.start();
            threadList.add(testThread);
        }
        int numAliveThreads = this.logAliveThreads(threadList);
        while (numAliveThreads > 0) {
            MasterController.sleepForMs(10000);
            numAliveThreads = this.logAliveThreads(threadList);
            Log.getLogWriter().info(txId + " is suspended: " + this.ctm.isSuspended(txId));
        }
        if (failureList.size() > 0) {
            StringBuffer aStr = new StringBuffer();
            for (Throwable t : failureList) {
                aStr.append(TestHelper.getStackTrace(t) + "\n");
            }
            throw new TestException(aStr.toString());
        }
        this.verifyTryResume(txId, true);
        TxHelper.commitExpectSuccess();
        this.verifyResumeTimes(timeAtFirstSuspendCompletion, resultList);
    }

    private void verifyResumeTimes(long firstSuspendTime, List<Map> tryResumeResultList) {
        Vector<Map> resumeOrderList = new Vector<Map>();
        for (int i = 0; i < tryResumeResultList.size(); ++i) {
            Map aMap = tryResumeResultList.get(i);
            int resumeOrder = ((Long)aMap.get("resumeOrder")).intValue();
            int index = resumeOrder - 1;
            if (resumeOrder > resumeOrderList.size()) {
                resumeOrderList.setSize(resumeOrder);
            }
            resumeOrderList.set(index, aMap);
        }
        StringBuffer aStr = new StringBuffer();
        long currentSuspendCompletionTime = firstSuspendTime;
        int thresholdMs = 1000;
        StringBuffer errStr = new StringBuffer();
        for (Map aMap : resumeOrderList) {
            long currentResumeTime = (Long)aMap.get("timeAtCompletion");
            long diff = Math.abs(currentSuspendCompletionTime - currentResumeTime);
            currentSuspendCompletionTime = (Long)aMap.get("timeAtSuspendCompletion");
            String logStr = aMap + "; took " + diff + " ms to resume\n";
            aStr.append(logStr);
            if (diff <= 1000L) continue;
            errStr.append("tx took too long to resume after previous suspend: " + logStr + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    private int logAliveThreads(List<Thread> threadList) {
        int aliveThreadCount = 0;
        StringBuffer aStr = new StringBuffer();
        for (Thread aThread : threadList) {
            if (!aThread.isAlive()) continue;
            aStr.append(aThread.getName() + " is alive\n");
            ++aliveThreadCount;
        }
        aStr.insert(0, aliveThreadCount + " of " + threadList.size() + " threads are still alive\n");
        Log.getLogWriter().info(aStr.toString());
        return aliveThreadCount;
    }

    private Object[] tryResume(TransactionId txId, long timeValue, TimeUnit unit) {
        Log.getLogWriter().info("Calling tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ")");
        long start = System.currentTimeMillis();
        boolean result = this.ctm.tryResume(txId, timeValue, unit);
        long end = System.currentTimeMillis();
        long resumeOrder = this.sc.incrementAndRead(ResumeTxBB.resumeOrder);
        long duration = end - start;
        Log.getLogWriter().info("tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ") returned in " + duration + "ms, result is " + result);
        return new Object[]{result, duration, end, resumeOrder};
    }

    private void verifyTryResumeImmediate(TransactionId txId, long timeValue, TimeUnit unit, boolean expectedResult) {
        int immediateLimitMs = 1000;
        Object[] tmp = this.tryResume(txId, timeValue, unit);
        boolean result = (Boolean)tmp[0];
        long duration = (Long)tmp[1];
        if (duration > 1000L) {
            throw new TestException("Expected tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ") to return immediately, but it took " + duration + "ms");
        }
        if (result != expectedResult) {
            throw new TestException("Expected tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ") to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyTryResumeWaits(TransactionId txId, long timeValue, TimeUnit unit, boolean expectedResult) {
        Object[] tmp = this.tryResume(txId, timeValue, unit);
        boolean result = (Boolean)tmp[0];
        long duration = (Long)tmp[1];
        long expectedWaitMs = timeValue;
        if (unit == TimeUnit.SECONDS) {
            expectedWaitMs = timeValue * 1000L;
        } else if (unit == TimeUnit.MICROSECONDS) {
            expectedWaitMs = timeValue / 1000L;
        } else if (unit == TimeUnit.NANOSECONDS) {
            expectedWaitMs = timeValue / 1000000L;
        } else if (unit != TimeUnit.MILLISECONDS) {
            throw new TestException("Unknown TimeUnit " + (Object)((Object)unit));
        }
        if (duration < expectedWaitMs) {
            throw new TestException("Expected tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ") to wait for " + expectedWaitMs + "ms but it took " + duration + "ms");
        }
        if (result != expectedResult) {
            throw new TestException("Expected tryResume(" + txId + ", " + timeValue + ", " + (Object)((Object)unit) + ") to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyTryResume(TransactionId txId, boolean expectedResult) {
        boolean result = this.ctm.tryResume(txId);
        Log.getLogWriter().info("tryResume(" + txId + ") returned " + result);
        if (result != expectedResult) {
            throw new TestException("Expected tryResume(" + txId + ") to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyExists(boolean expectedResult) {
        boolean result = this.ctm.exists();
        Log.getLogWriter().info("exists() returned " + result);
        if (result != expectedResult) {
            throw new TestException("Expected exists() to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyExists(TransactionId txId, boolean expectedResult) {
        boolean result = this.ctm.exists(txId);
        Log.getLogWriter().info("exists(" + txId + ") returned " + result);
        if (result != expectedResult) {
            throw new TestException("Expected exists(" + txId + ") to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyIsSuspended(TransactionId txId, boolean expectedResult) {
        boolean result = this.ctm.isSuspended(txId);
        Log.getLogWriter().info("isSuspended(" + txId + ") returned " + result);
        if (result != expectedResult) {
            throw new TestException("Expected isSuspended(" + txId + ") to return " + expectedResult + ", but it returned " + result);
        }
    }

    private void verifyResume(TransactionId txId, boolean expectSuccess) {
        block3: {
            try {
                Log.getLogWriter().info("Calling resume(" + txId + ")...");
                this.ctm.resume(txId);
                Log.getLogWriter().info("resume(" + txId + ") succeeded");
                if (!expectSuccess) {
                    throw new TestException("Expected resume(" + txId + ") to throw " + IllegalStateException.class.getName() + ", but it succeeded");
                }
            }
            catch (IllegalStateException e) {
                Log.getLogWriter().info("resume(" + txId + ") resulted in " + e);
                if (!expectSuccess) break block3;
                throw new TestException("resume(" + txId + ") resulted in " + e + " but expected it to succeed");
            }
        }
    }
}

