/*
 * Decompiled with CFR 0.152.
 */
package resman;

import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.SetUtils;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholds;
import com.gemstone.gemfire.internal.lang.ThreadUtils;
import getInitialImage.InitImagePrms;
import hydra.AsyncEventQueueHelper;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import resman.BlockingGListener;
import resman.Indexable;
import resman.ResourceManBB;
import resman.ResourceManPrms;
import util.BaseValueHolder;
import util.PRObserver;
import util.RandomValues;
import util.RandomValuesPrms;
import util.StopStartBB;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class ThresholdsTest
extends ParRegTest {
    private static final String CLIENTVMINFO_TO_DM = "ClientVmInfo-to-DM";
    private static final String VMID_OF_LAST_KILLED_KEY = "VMIdOfLastKilled";
    public static final String ACCESSOR_NO_LOW_MEM_TIMESTAMP = "accessorNoLowMemTimestamp";
    public static final String ACCESSOR_LOW_MEM_TIMESTAMP = "accessorLowMemTimestamp";
    protected static Region noEvictRegion;
    public volatile Indexable.ThresholdsTestStats testStats = null;
    public final Inspector inspector;
    private static final int NUM_EVICTION_ENTRIES = 20;
    private static final int NUM_CRITICAL_ENTRIES = 5;
    public static HydraThreadLocal localCriticalState;
    public static final String LOW_MEMORY_STATE = "expectLowMemoryState";
    private static final Object PUTALL_KEY;

    private ThresholdsTest() {
        String it = ResourceManPrms.getInspectorType();
        this.inspector = it != null && it.equalsIgnoreCase("easy") ? new EasyInspector() : new SternInspector();
    }

    private static ThresholdsTest getTestInstance() {
        return (ThresholdsTest)testInstance;
    }

    private static Indexable.ThresholdsTestStats getThresholdTestStats() {
        return ThresholdsTest.getTestInstance().testStats;
    }

    public static synchronized void HydraTask_initializeWithRegDef() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ThresholdsTest();
            testInstance.initializeWithRegDef();
            testInstance.initializeInstance();
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ThresholdsTest();
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            ThresholdsTest.testInstance.isBridgeClient = false;
            ThresholdsTest.testInstance.isDataStore = true;
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_initializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ThresholdsTest();
            testInstance.initializeRegion("accessorRegion");
            testInstance.initializeInstance();
            ThresholdsTest.testInstance.isDataStore = false;
            if (ThresholdsTest.testInstance.isBridgeConfiguration) {
                ThresholdsTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(ThresholdsTest.testInstance.aRegion);
            }
            ((ThresholdsTest)testInstance).initializeStats();
            DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            ThresholdsTest.putDistributedMember(dm);
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    private static ClientVmInfo getMyClientVMInfo() {
        return new ClientVmInfo(new Integer(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost());
    }

    private void initializeStats() {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
        this.testStats = new Indexable.ThresholdsTestStats((StatisticsFactory)cache.getDistributedSystem());
    }

    public static synchronized void HydraTask_HA_initializeDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ThresholdsTest();
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            ThresholdsTest.testInstance.isDataStore = true;
            if (ThresholdsTest.testInstance.isBridgeConfiguration) {
                ThresholdsTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
            ((ThresholdsTest)testInstance).initCriticalThenDie();
            DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            ThresholdsTest.putDistributedMember(dm);
            ((ThresholdsTest)testInstance).initNoEvictRegion();
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_initializeNewWanWBCL() {
        ((ThresholdsTest)testInstance).createAsyncEventQueue();
    }

    public static synchronized void HydraTask_HA_reinitializeAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ThresholdsTest();
            testInstance.HA_reinitializeRegion();
            testInstance.initializeInstance();
            ThresholdsTest.testInstance.isDataStore = false;
            if (ThresholdsTest.testInstance.isBridgeConfiguration) {
                ThresholdsTest.testInstance.isBridgeClient = true;
                ParRegUtil.registerInterest(ThresholdsTest.testInstance.aRegion);
            }
            ((ThresholdsTest)testInstance).initializeStats();
            DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            ThresholdsTest.putDistributedMember(dm);
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_HA_reinitializeDataStore() {
        if (testInstance == null) {
            Integer vmId;
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new ThresholdsTest();
            testInstance.HA_reinitializeRegion();
            testInstance.initializeInstance();
            ThresholdsTest.testInstance.isDataStore = true;
            if (ThresholdsTest.testInstance.isBridgeConfiguration) {
                ThresholdsTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
            if ((vmId = (Integer)ResourceManBB.getBB().getSharedMap().remove(VMID_OF_LAST_KILLED_KEY)) != null) {
                PRObserver.waitForRebalRecov(vmId, 1, 1, null, null, false);
            }
            DistributedMember dm = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            ThresholdsTest.putDistributedMember(dm);
            ((ThresholdsTest)testInstance).initNoEvictRegion();
            ((ThresholdsTest)testInstance).initCriticalThenDie();
        }
        ThresholdsTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static void HydraTask_InitFakeHeapThresholds() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        InternalResourceManager irm = (InternalResourceManager)cache.getResourceManager();
        HeapMemoryMonitor hmm = irm.getHeapMonitor();
        hmm.setTestMaxMemoryBytes(1000L);
        HeapMemoryMonitor.setTestBytesUsedForThresholdSet((long)500L);
        irm.setCriticalHeapPercentage(90.0f);
    }

    public static void HydraTask_CriticalBounce() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            Log.getLogWriter().info("Tried to go critical in this vm, but no cache existed.");
            return;
        }
        try {
            ThresholdsTest.goCritical(cache);
            Random r = new Random();
            int timeToStay = r.nextInt(10000);
            if (timeToStay > 0) {
                try {
                    Log.getLogWriter().info("Hanging out in Critical state for:" + timeToStay + "ms");
                    Thread.sleep(timeToStay);
                    Log.getLogWriter().info("Done hanging out in Critical state");
                }
                catch (InterruptedException tie) {
                    tie.printStackTrace();
                }
            }
            ThresholdsTest.goBelowEviction(cache);
        }
        catch (CacheClosedException cce) {
            Log.getLogWriter().info("Possibly expected CCE during CriticalBounce", (Throwable)cce);
        }
        catch (DistributedSystemDisconnectedException cce) {
            Log.getLogWriter().info("Possibly expected DSDE during CriticalBounce", (Throwable)cce);
        }
    }

    private static boolean isOffHeap() {
        return ThresholdsTest.testInstance.aRegion.getAttributes().getEnableOffHeapMemory();
    }

    public static void goBelowEviction(GemFireCacheImpl cache) {
        InternalResourceManager irm = cache.getResourceManager();
        ThresholdsTest.getTestInstance().inspector.expectLowMemoryException(false, (DistributedMember)cache.getMyId());
        if (ThresholdsTest.isOffHeap()) {
            irm.getOffHeapMonitor().updateStateAndSendEvent(750L);
        } else {
            irm.getHeapMonitor().updateStateAndSendEvent(750L);
        }
        Log.getLogWriter().info("ThresholdsTest: Moved from Artifical Critical to below eviction threshold");
    }

    public static void goCritical(GemFireCacheImpl cache) {
        InternalResourceManager irm = cache.getResourceManager();
        ThresholdsTest.getTestInstance().inspector.expectLowMemoryException(true, (DistributedMember)cache.getMyId());
        if (ThresholdsTest.isOffHeap()) {
            irm.getOffHeapMonitor().updateStateAndSendEvent(950L);
        } else {
            irm.getHeapMonitor().updateStateAndSendEvent(950L);
        }
        Log.getLogWriter().info("ThresholdsTest: Artifically moved into Critical State");
    }

    @Override
    protected void clearBBCriticalState(List<ClientVmInfo> targetVMs) {
        CriticalState publishedState = (CriticalState)ResourceManBB.getBB().getSharedMap().get(LOW_MEMORY_STATE);
        if (publishedState != null) {
            for (ClientVmInfo cli : targetVMs) {
                DistributedMember memToClear = ThresholdsTest.getDistributedMember(cli);
                if (!publishedState.mem.equals(memToClear)) continue;
                this.inspector.expectLowMemoryException(false, memToClear);
            }
        }
    }

    private static DistributedMember getDistributedMember(ClientVmInfo cli) {
        return (DistributedMember)ResourceManBB.getBB().getSharedMap().get(CLIENTVMINFO_TO_DM + cli.getVmid());
    }

    private static void putDistributedMember(DistributedMember dm) {
        ClientVmInfo cli = ThresholdsTest.getMyClientVMInfo();
        Log.getLogWriter().info("Putting dm=" + dm + " for " + cli);
        ResourceManBB.getBB().getSharedMap().put(CLIENTVMINFO_TO_DM + cli.getVmid(), dm);
    }

    public static void HydraTask_makeHighUsage() throws Exception {
        Log.getLogWriter().info("making high usage");
        ((ThresholdsTest)testInstance).makeHighUsage();
    }

    public static void HydraTask_makeCriticalUsage() throws Exception {
        Log.getLogWriter().info("making critical usage");
        ((ThresholdsTest)testInstance).makeCriticalUsage();
    }

    public static void HydraTask_criticalThenDie() throws Exception {
        ((ThresholdsTest)testInstance).criticalThenDie();
    }

    private ThresholdsTest initCriticalThenDie() {
        long mv = ResourceManBB.getBB().getSharedCounters().incrementAndRead(ResourceManBB.criticalMembers);
        Log.getLogWriter().info("criticalMembers inc: " + mv);
        return this;
    }

    private void criticalThenDie() throws Exception {
        ThresholdsTest.logExecutionNumber();
        this.checkForLastIteration();
        this.inspector.waitForNoMembersCriticalOrFail();
        this.waitForPreviousCriticalMembersToRestart();
        ThreadUtils.sleep((long)10000L);
        long counter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num criticalThenDie executions is " + ParRegBB.getBB().getSharedCounters().read(ParRegBB.ExecutionNumber));
        }
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
        long criticalThresholdBytes = this.getThresholds().getCriticalThresholdBytes();
        long currentUsage = this.getBytesUsed();
        ThreadUtils.sleep((long)10000L);
        if (currentUsage >= criticalThresholdBytes) {
            throw new TestException("Memory usage already critical, consider tuning the test");
        }
        this.inspector.expectLowMemoryException(true, (DistributedMember)cache.getMyId());
        if (currentUsage < this.getThresholds().getEvictionThresholdBytes()) {
            this.makeHighUsage();
        }
        System.gc();
        int size = (int)((double)this.getThresholds().getCriticalThresholdBytes() * 1.05 - (double)this.getBytesUsed());
        Log.getLogWriter().info("putting a byte[] of size :" + size);
        for (int i = 0; i < 5; ++i) {
            noEvictRegion.put((Object)("highToCritical" + i), (Object)new byte[size / 5]);
            System.gc();
        }
        long sleepTimeMs = TimeUnit.SECONDS.toMillis(ResourceManPrms.getTaskRemainCriticalSeconds());
        Log.getLogWriter().info("Sleeping for " + sleepTimeMs + "ms");
        Thread.sleep(sleepTimeMs);
        long mv = ResourceManBB.getBB().getSharedCounters().decrementAndRead(ResourceManBB.criticalMembers);
        Log.getLogWriter().info("criticalMembers dec: " + mv);
        ResourceManBB.getBB().getSharedMap().put(VMID_OF_LAST_KILLED_KEY, new Integer(RemoteTestModule.getMyVmid()));
        this.inspector.expectLowMemoryException(false, (DistributedMember)cache.getMyId());
        int stopMode = ResourceManPrms.getTaskStopMode();
        ClientVmMgr.stopAsync("Stopping critical member", stopMode, -30);
    }

    private void waitForPreviousCriticalMembersToRestart() {
        int totalDatastoreCount = ResourceManPrms.getTotalDatastoreCount();
        assert (totalDatastoreCount > 0);
        TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.criticalMembers", ResourceManBB.criticalMembers, totalDatastoreCount, true, TimeUnit.SECONDS.toMillis(this.secondsToRun) / 2L, 250L);
    }

    public static void HydraTask_makeLowUsage() throws Exception {
        Log.getLogWriter().info("making low usage");
        ((ThresholdsTest)testInstance).makeLowUsage();
    }

    private void makeHighUsage() throws Exception {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
        long evictionThresholdBytes = this.getThresholds().getEvictionThresholdBytes();
        long criticalThresholdBytes = this.getThresholds().getCriticalThresholdBytes();
        long currentUsage = this.getBytesUsed();
        if (currentUsage >= evictionThresholdBytes && currentUsage < criticalThresholdBytes) {
            throw new TestException("Memory already in high usage range, consider tuning the test");
        }
        if (noEvictRegion.size() > 20) {
            this.inspector.expectLowMemoryException(false, (DistributedMember)cache.getMyId());
            Log.getLogWriter().info("destroying highToCritical byte[]");
            for (int i = 0; i < 5; ++i) {
                noEvictRegion.remove((Object)("highToCritical" + i));
            }
            System.gc();
            this.inspector.waitForNoMembersCriticalOrFail();
        } else {
            int size = (int)((double)evictionThresholdBytes + (double)(criticalThresholdBytes - evictionThresholdBytes) * 0.25 - (double)currentUsage);
            Log.getLogWriter().info("Putting a byte[] of size :" + size);
            for (int i = 0; i < 20; ++i) {
                noEvictRegion.put((Object)("lowToHigh" + i), (Object)new byte[size / 20]);
            }
            System.gc();
        }
    }

    private void makeCriticalUsage() throws Exception {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
        long currentUsage = this.getBytesUsed();
        if (currentUsage >= this.getThresholds().getCriticalThresholdBytes()) {
            throw new TestException("Memory usage already critical, consider tuning the test");
        }
        this.inspector.expectLowMemoryException(true, (DistributedMember)cache.getMyId());
        if (currentUsage < this.getThresholds().getEvictionThresholdBytes()) {
            this.makeHighUsage();
            System.gc();
        }
        int size = (int)((double)this.getThresholds().getCriticalThresholdBytes() * 1.05 - (double)this.getBytesUsed());
        Log.getLogWriter().info("Putting a byte[] of size :" + size);
        for (int i = 0; i < 5; ++i) {
            noEvictRegion.put((Object)("highToCritical" + i), (Object)new byte[size / 5]);
            System.gc();
        }
        this.inspector.waitForAllMembersCriticalOrFail();
    }

    private void makeLowUsage() throws Exception {
        int i;
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
        if (noEvictRegion.size() > 20) {
            this.inspector.expectLowMemoryException(false, (DistributedMember)cache.getMyId());
            for (i = 0; i < 5; ++i) {
                noEvictRegion.remove((Object)("highToCritical" + i));
            }
            System.gc();
            this.inspector.waitForNoMembersCriticalOrFail();
        }
        for (i = 0; i < 20; ++i) {
            noEvictRegion.remove((Object)("lowToHigh" + i));
        }
        System.gc();
    }

    public static void HydraTask_turnOnGatewayDraining() throws TestException {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        List hubs = cache.getGatewayHubs();
        for (GatewayHub hub : hubs) {
            List gws = hub.getGateways();
            for (Gateway gw : gws) {
                List lists = gw.getListeners();
                for (GatewayEventListener gel : lists) {
                    ((BlockingGListener)gel).setDraining(true);
                }
            }
        }
        Set queues = cache.getAsyncEventQueues();
        for (AsyncEventQueue queue : queues) {
            ((BlockingGListener)queue.getAsyncEventListener()).setDraining(true);
        }
    }

    protected void createAsyncEventQueue() {
        String asyncEventQueueConfig = ConfigPrms.getAsyncEventQueueConfig();
        AsyncEventQueueHelper.createAndStartAsyncEventQueue(asyncEventQueueConfig);
    }

    public static void HydraTask_waitForStartupRecovery() {
        ArrayList startupVMs = new ArrayList(StopStartBB.getBB().getSharedMap().getMap().values());
        List vmsExpectingRecovery = StopStartVMs.getMatchVMs(startupVMs, "dataStore");
        vmsExpectingRecovery.addAll(StopStartVMs.getMatchVMs(startupVMs, "bridge"));
        if (vmsExpectingRecovery.size() == 0) {
            throw new TestException("No startup vms to wait for");
        }
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        if (startupRecoveryDelay >= 0L) {
            PartitionAttributes prAttr = ThresholdsTest.testInstance.aRegion.getAttributes().getPartitionAttributes();
            if (prAttr != null) {
                if (prAttr.getRedundantCopies() != 0) {
                    PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, 1, null, null, false);
                } else {
                    Log.getLogWriter().info("Not waiting for recovery because redundantCopies is 0");
                }
            } else {
                Log.getLogWriter().info("Not waiting for recovery because aRegion is not partitioned");
            }
        } else {
            Log.getLogWriter().info("Not waiting for recovery because region is not configured to run recovery at startup");
        }
    }

    public static void setCriticalPercentage(float percentage) {
        if (ThresholdsTest.isOffHeap()) {
            GemFireCacheImpl.getInstance().getResourceManager().setCriticalOffHeapPercentage(percentage);
        }
        GemFireCacheImpl.getInstance().getResourceManager().setCriticalHeapPercentage(percentage);
    }

    public static void setEvictionPercentage(float percentage) {
        if (ThresholdsTest.isOffHeap()) {
            GemFireCacheImpl.getInstance().getResourceManager().setEvictionOffHeapPercentage(percentage);
        }
        GemFireCacheImpl.getInstance().getResourceManager().setEvictionHeapPercentage(percentage);
    }

    public static void HydraTask_turnOnEvictionLate() throws TestException {
        ThresholdsTest.setEvictionPercentage((float)ResourceManPrms.getTaskEvictionPercentage());
    }

    public static void HydraTask_waitForCriticalness() throws TestException {
        ThresholdsTest.logCriticalUpNotificationTime(System.currentTimeMillis());
    }

    public void initNoEvictRegion() {
        Cache cache = CacheHelper.getCache();
        RegionFactory factory = ((GemFireCacheImpl)cache).createRegionFactory(RegionShortcut.LOCAL);
        factory.setEnableOffHeapMemory(ThresholdsTest.isOffHeap());
        EvictionAttributesImpl evictionAttrs = new EvictionAttributesImpl();
        evictionAttrs.setAlgorithm(EvictionAlgorithm.NONE);
        factory.setEvictionAttributes((EvictionAttributes)evictionAttrs);
        noEvictRegion = factory.create("noEvictRegion");
    }

    private static void logCriticalUpNotificationTime(long start) throws TestException {
        long accessorTime = ThresholdsTest.waitForAccessorTimestamp(ACCESSOR_LOW_MEM_TIMESTAMP);
        double millis = (double)(accessorTime - start) * 1.0E-5;
        Log.getLogWriter().info("REPORT: Critical up detected after " + millis + " millis");
    }

    public static long waitForAccessorTimestamp(String key) throws TestException {
        int MAX_WAIT_TIME = 30000;
        ResourceManBB bb = ResourceManBB.getBB();
        boolean done = bb.getSharedMap().get(key) != null;
        int counter = 0;
        int timeToWait = 0;
        while (!done) {
            timeToWait = MAX_WAIT_TIME - ++counter * 10;
            Log.getLogWriter().info("ThresholdsTest.waitForAccessorTimestamp: waiting for " + key + " for " + timeToWait);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                TestException te = new TestException("Interrupted!");
                te.initCause(ie);
            }
            if ((done = bb.getSharedMap().get(key) != null) || timeToWait > 0) continue;
            throw new TestException("Accessor did not register a timestamp with the blackboard for " + MAX_WAIT_TIME + " milliseconds");
        }
        long accessorTs = (Long)bb.getSharedMap().get(key);
        bb.getSharedMap().remove(key);
        return accessorTs;
    }

    public static void HydraTask_waitForLowMemoryThenDrainGateways() {
        TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowMemoryFlag", ResourceManBB.lowMemoryFlag, 1L, true, ResourceManPrms.getTaskWaitForLowMemSec() * 1000, 1000L);
        ThresholdsTest.HydraTask_turnOnGatewayDraining();
        ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.lowMemoryFlag);
    }

    public static void HydraTask_waitForLowMemoryThenTurnOnEviction() {
        TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowMemoryFlag", ResourceManBB.lowMemoryFlag, 1L, true, ResourceManPrms.getTaskWaitForLowMemSec() * 1000, 1000L);
        ThresholdsTest.HydraTask_turnOnEvictionLate();
        ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.lowMemoryFlag);
    }

    public static void HydraTask_waitForLowMemoryThenDropIndexes() {
        TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowMemoryFlag", ResourceManBB.lowMemoryFlag, 1L, true, ResourceManPrms.getTaskWaitForLowMemSec() * 1000, 1000L);
        ThresholdsTest.HydraTask_dropIndexes();
        System.gc();
        Log.getLogWriter().info("DROPPED ALL THE INDEXES");
        ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.lowMemoryFlag);
    }

    public static void HydraTask_dropIndexes() throws TestException {
        QueryService qs = ((ThresholdsTest)ThresholdsTest.testInstance).aRegion.getCache().getQueryService();
        qs.removeIndexes();
    }

    public static void HydraTask_doIndexablePutsUntilCriticalThenWaitForRecovery() throws TestException {
        ((ThresholdsTest)testInstance).doPutsUntilCriticalThenWaitForRecovery(true);
    }

    public static void HydraTask_doPutsUntilCriticalThenWaitForRecovery() throws TestException {
        ((ThresholdsTest)testInstance).doPutsUntilCriticalThenWaitForRecovery(false);
    }

    public void doPutsUntilCriticalThenWaitForRecovery(boolean useIndexable) throws TestException {
        boolean useCompression = false;
        Compressor compressor = this.aRegion.getAttributes().getCompressor();
        Log.getLogWriter().info("doPutsUntilCriticalThenWaitForRecovery compressor=" + (compressor == null ? null : compressor.getClass().getName()));
        if (compressor != null) {
            useCompression = true;
        }
        int numPuts = ResourceManPrms.getTaskNumberOfPuts();
        boolean neverWentCritical = true;
        float minPct = ResourceManPrms.getTaskMinimumPutPercentage();
        for (int i = 0; i < numPuts; ++i) {
            try {
                if (useIndexable) {
                    this.simpleIndexablePut(i, useCompression);
                    continue;
                }
                this.simplePut(i, useCompression);
                continue;
            }
            catch (LowMemoryException lme) {
                float pct = (float)i / (float)numPuts;
                if (pct > minPct || minPct < 1.0f) {
                    neverWentCritical = false;
                    ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.lowMemoryFlag);
                    ResourceManBB.getBB().getSharedCounters().increment(ResourceManBB.lowMemoryFlag);
                    TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowMemoryFlag", ResourceManBB.lowMemoryFlag, 0L, true, 30000L, 1000L);
                    long start = System.currentTimeMillis();
                    long end = System.currentTimeMillis() + 1L;
                    boolean success = false;
                    while (end - start < (long)(ResourceManPrms.getTaskTolerateLowMemSec() * 1000)) {
                        try {
                            if (useIndexable) {
                                this.simpleIndexablePut(i, useCompression);
                            } else {
                                this.simplePut(i, useCompression);
                            }
                            success = true;
                            break;
                        }
                        catch (LowMemoryException l) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ie) {
                                TestException te = new TestException("interrupted exception while sleeping!");
                                te.initCause(ie);
                                throw te;
                            }
                            end = System.currentTimeMillis();
                        }
                    }
                    if (!success) {
                        throw new TestException("We didn't get rescued from critical within " + ResourceManPrms.getTaskTolerateLowMemSec() + " seconds");
                    }
                    return;
                }
                TestException te = new TestException("Got a lowMemoryException earlier than we should! numPuts=" + numPuts + " currentPut=" + i + ", we expected to start getting LME after 80% of puts, but we are only at " + pct);
                te.initCause(lme);
                throw te;
            }
        }
        if (neverWentCritical) {
            throw new TestException("We never went critical, and we should have!");
        }
    }

    public static void HydraTask_createHeavyIndexes() {
        ((ThresholdsTest)testInstance).createHeavyIndexes();
    }

    public void createHeavyIndexes() {
        QueryService qs = this.aRegion.getCache().getQueryService();
        try {
            qs.createIndex("stateName-nma", IndexType.FUNCTIONAL, "r.a", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmb", IndexType.FUNCTIONAL, "r.b", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmc", IndexType.FUNCTIONAL, "r.c", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmd", IndexType.FUNCTIONAL, "r.d", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nme", IndexType.FUNCTIONAL, "r.e", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmf", IndexType.FUNCTIONAL, "r.f", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmg", IndexType.FUNCTIONAL, "r.g", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmh", IndexType.FUNCTIONAL, "r.h", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmi", IndexType.FUNCTIONAL, "r.i", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmj", IndexType.FUNCTIONAL, "r.j", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmk", IndexType.FUNCTIONAL, "r.k", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nml", IndexType.FUNCTIONAL, "r.l", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmm", IndexType.FUNCTIONAL, "r.m", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmn", IndexType.FUNCTIONAL, "r.n", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmo", IndexType.FUNCTIONAL, "r.o", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmp", IndexType.FUNCTIONAL, "r.p", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmq", IndexType.FUNCTIONAL, "r.q", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmr", IndexType.FUNCTIONAL, "r.r", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nms", IndexType.FUNCTIONAL, "r.s", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmt", IndexType.FUNCTIONAL, "r.t", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmu", IndexType.FUNCTIONAL, "r.u", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmv", IndexType.FUNCTIONAL, "r.v", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmw", IndexType.FUNCTIONAL, "r.w", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmx", IndexType.FUNCTIONAL, "r.x", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmy", IndexType.FUNCTIONAL, "r.y", "/" + this.aRegion.getName() + " r");
            qs.createIndex("stateName-nmz", IndexType.FUNCTIONAL, "r.z", "/" + this.aRegion.getName() + " r");
        }
        catch (IndexNameConflictException ince) {
            TestException te = new TestException(ince.getMessage());
            te.initCause(ince);
            throw te;
        }
        catch (IndexExistsException iee) {
            TestException te = new TestException(iee.getMessage());
            te.initCause(iee);
            throw te;
        }
        catch (RegionNotFoundException iee) {
            TestException te = new TestException(iee.getMessage());
            te.initCause(iee);
            throw te;
        }
    }

    public static void HydraTask_populate() {
        ((ThresholdsTest)testInstance).populate();
    }

    public void populate() {
        int numPuts = ResourceManPrms.getTaskNumberOfPuts();
        for (int i = 0; i < numPuts; ++i) {
            this.simpleIndexablePut(i);
        }
    }

    public static void HydraTask_populateGatewayQueue() {
        ((ThresholdsTest)testInstance).populateGateways();
    }

    public void populateGateways() {
        int numPuts = ResourceManPrms.getTaskNumberOfPuts();
        for (int i = 0; i < numPuts; ++i) {
            try {
                this.simplePut(i);
                this.simpleDestroy(i);
                continue;
            }
            catch (LowMemoryException lme) {
                Log.getLogWriter().info("Got potentially expected LME while populating gateways. lets bail out.");
                return;
            }
        }
    }

    private void doSimplePut(Object key, Object anObj) {
        boolean useTransactions = InitImagePrms.useTransactions();
        boolean rolledback = false;
        if (useTransactions) {
            TxHelper.begin();
        }
        try {
            this.aRegion.put(key, anObj);
        }
        catch (TransactionDataNodeHasDepartedException e) {
            if (!useTransactions) {
                throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
            Log.getLogWriter().info("Rolling back transaction.");
            try {
                TxHelper.rollback();
                Log.getLogWriter().info("Done Rolling back Transaction");
            }
            catch (TransactionException te) {
                Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
            }
            rolledback = true;
        }
        catch (TransactionDataRebalancedException e) {
            if (!useTransactions) {
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
            Log.getLogWriter().info("Rolling back transaction.");
            try {
                TxHelper.rollback();
                Log.getLogWriter().info("Done Rolling back Transaction");
            }
            catch (TransactionException te) {
                Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
            }
            rolledback = true;
        }
        catch (LowMemoryException e) {
            if (useTransactions) {
                Log.getLogWriter().info("Caught LowMemoryException, rolling back TX");
                TxHelper.rollback();
                rolledback = true;
                Log.getLogWriter().info("Done Rolling back Transaction");
            }
            throw e;
        }
        if (useTransactions && !rolledback) {
            try {
                TxHelper.commit();
            }
            catch (TransactionDataNodeHasDepartedException e) {
                Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
            }
            catch (TransactionDataRebalancedException e) {
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
            }
            catch (TransactionInDoubtException e) {
                Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
            }
            catch (ConflictException e) {
                Log.getLogWriter().info("Caught ConflictException. Expected with concurrent execution, continuing test.");
            }
        }
    }

    public void simpleIndexablePut(int i) {
        this.simpleIndexablePut(i, false);
    }

    public void simpleIndexablePut(int i, boolean useCompression) {
        String key = "Object_" + i;
        byte[] anObj = new byte[TestConfig.tab().intAt(RandomValuesPrms.elementSize)];
        if (useCompression) {
            TestConfig.tab().getRandGen().nextBytes(anObj);
        }
        Indexable idx = new Indexable(i, anObj);
        this.doSimplePut(key, idx);
        Log.getLogWriter().info("SimpleIndexablePut key=" + key + " value=" + anObj + " useCompression=" + useCompression);
    }

    public void simplePut(int i) {
        this.simplePut(i, false);
    }

    public void simplePut(int i, boolean useCompression) {
        String key = "Object_" + i;
        RandomValues rv = new RandomValues();
        byte[] anObj = rv.getRandom_arrayOfBytes();
        if (useCompression) {
            TestConfig.tab().getRandGen().nextBytes(anObj);
        }
        this.doSimplePut(key, anObj);
        Log.getLogWriter().info("SimplePut key=" + key + " value=" + anObj + " useCompression=" + useCompression);
    }

    public void simpleDestroy(int i) {
        String key = "Object_" + i;
        this.aRegion.destroy((Object)key);
        Log.getLogWriter().info("SimpleDestroy key=" + key);
    }

    @Override
    protected Object addEntry(Region r) {
        int beforeSize;
        BaseValueHolder anObj;
        Object key;
        block22: {
            block23: {
                key = this.getNewKey();
                anObj = this.getValueForKey(key);
                String callback = "Create event originated in pid " + ProcessMgr.getProcessId();
                beforeSize = r.size();
                Set<? extends DistributedMember> keyOwners = null;
                if (r instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)r;
                    pr.getOwnerForKey(pr.getKeyInfo(key));
                }
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        try {
                            keyOwners = this.getOwnersForKey(key, r);
                            Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + r.getFullPath() + " keyOwners:" + keyOwners);
                            r.create(key, (Object)anObj, (Object)callback);
                            this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                            Log.getLogWriter().info("addEntry: done creating key " + key);
                        }
                        catch (EntryExistsException e) {
                            if (this.isSerialExecution) {
                                throw new TestException(TestHelper.getStackTrace(e));
                            }
                            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                        }
                        catch (LowMemoryException lme) {
                            this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                        }
                        catch (ServerOperationException soe) {
                            if (soe.getCause() instanceof LowMemoryException) {
                                LowMemoryException lme = (LowMemoryException)soe.getCause();
                                this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                            }
                            break block22;
                        }
                    }
                    try {
                        keyOwners = this.getOwnersForKey(key, r);
                        Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + r.getFullPath() + " keyOwners:" + keyOwners);
                        r.create(key, (Object)anObj);
                        this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                        Log.getLogWriter().info("addEntry: done creating key " + key);
                    }
                    catch (EntryExistsException e) {
                        if (this.isSerialExecution) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    }
                    catch (LowMemoryException lme) {
                        this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                    }
                    catch (ServerOperationException soe) {
                        if (soe.getCause() instanceof LowMemoryException) {
                            LowMemoryException lme = (LowMemoryException)soe.getCause();
                            this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                        }
                        break block22;
                    }
                }
                Object returnVal = null;
                try {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        keyOwners = this.getOwnersForKey(key, r);
                        Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + r.getFullPath() + " keyOwners:" + keyOwners);
                        returnVal = r.put(key, (Object)anObj, (Object)callback);
                        this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                        Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
                    } else {
                        keyOwners = this.getOwnersForKey(key, r);
                        Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + r.getFullPath() + " keyOwners:" + keyOwners);
                        returnVal = r.put(key, (Object)anObj);
                        this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                        Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
                    }
                }
                catch (LowMemoryException lme) {
                    this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                }
                catch (ServerOperationException soe) {
                    if (!(soe.getCause() instanceof LowMemoryException)) break block23;
                    LowMemoryException lme = (LowMemoryException)soe.getCause();
                    this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
                }
            }
            if (!this.isSerialExecution || this.isBridgeConfiguration) {
                // empty if block
            }
        }
        if (this.isSerialExecution) {
            ParRegUtil.verifyContainsKey(r, key, true);
            ParRegUtil.verifyContainsValueForKey(r, key, true);
            ParRegUtil.verifySize(r, beforeSize + 1);
            this.regionSnapshot.put(key, anObj.myValue);
            this.destroyedKeys.remove(key);
        }
        return key;
    }

    private Set<? extends DistributedMember> getOwnersForKey(Object key, Region r) {
        Set<InternalDistributedMember> keyOwners;
        if (PartitionRegionHelper.isPartitionedRegion((Region)r)) {
            keyOwners = PartitionRegionHelper.getAllMembersForKey((Region)r, (Object)key);
        } else if (r.getAttributes().getScope().isDistributed()) {
            DistributedRegion dr = (DistributedRegion)r;
            keyOwners = dr.getCacheDistributionAdvisor().adviseGeneric();
        } else if (r.getAttributes().getScope().isLocal()) {
            LocalRegion lr = (LocalRegion)r;
            if (lr.hasServerProxy()) {
                return null;
            }
            keyOwners = Collections.singleton(lr.getCache().getMyId());
        } else {
            throw new TestException("Unable to determine owners for key=" + key + " and region=" + r);
        }
        return keyOwners;
    }

    private MemoryThresholds getThresholds() {
        if (ThresholdsTest.isOffHeap()) {
            return GemFireCacheImpl.getInstance().getResourceManager().getOffHeapMonitor().getThresholds();
        }
        return GemFireCacheImpl.getInstance().getResourceManager().getHeapMonitor().getThresholds();
    }

    public long getBytesUsed() {
        if (ThresholdsTest.isOffHeap()) {
            return GemFireCacheImpl.getInstance().getResourceManager().getOffHeapMonitor().getBytesUsed();
        }
        return GemFireCacheImpl.getInstance().getResourceManager().getHeapMonitor().getBytesUsed();
    }

    @Override
    protected void putAll(Region r) {
        Map mapToPut;
        int numNewKeysToPut;
        int beforeSize;
        block16: {
            beforeSize = r.size();
            numNewKeysToPut = 0;
            int numPutAllExistingKeys = 0;
            boolean limitPutAllToOne = ParRegPrms.getLimitPutAllToOne();
            if (limitPutAllToOne) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    numNewKeysToPut = 1;
                } else {
                    numPutAllExistingKeys = 1;
                }
            } else {
                numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
                String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
                if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
                    numNewKeysToPut = this.upperThreshold - beforeSize;
                    if (numNewKeysToPut <= 0) {
                        numNewKeysToPut = 1;
                    } else {
                        int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                        max = Math.min(numNewKeysToPut, max);
                        int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                        min = Math.min(min, max);
                        numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
                    }
                } else {
                    numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
                }
            }
            mapToPut = null;
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
            StringBuffer newKeys = new StringBuffer();
            for (int i = 1; i <= numNewKeysToPut; ++i) {
                Object key = this.getNewKey();
                BaseValueHolder anObj = this.getValueForKey(key);
                mapToPut.put(key, anObj);
                newKeys.append(key + " ");
                if (i % 10 != 0) continue;
                newKeys.append("\n");
            }
            StringBuffer existingKeys = new StringBuffer();
            List keyList = new ArrayList();
            if (numPutAllExistingKeys > 0 && (keyList = ParRegUtil.getExistingKeys(r, this.uniqueKeys, this.numThreadsInClients, numPutAllExistingKeys, false)).size() != 0) {
                for (int i = 0; i < keyList.size(); ++i) {
                    String key = (String)keyList.get(i);
                    Object anObj = this.getUpdateObject(r, key);
                    mapToPut.put(key, anObj);
                    existingKeys.append(key + " ");
                    if ((i + 1) % 10 != 0) continue;
                    newKeys.append("\n");
                }
            }
            Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
            Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
            try {
                r.putAll(mapToPut);
                this.inspector.reportNoLowMemoryException(r, PUTALL_KEY, null);
            }
            catch (LowMemoryException lme) {
                this.inspector.reportLowMemoryException(r, PUTALL_KEY, lme, null);
            }
            catch (ServerOperationException soe) {
                if (!(soe.getCause() instanceof LowMemoryException)) break block16;
                LowMemoryException lme = (LowMemoryException)soe.getCause();
                this.inspector.reportLowMemoryException(r, PUTALL_KEY, lme, null);
            }
        }
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
        if (this.isSerialExecution) {
            ParRegUtil.verifySize(r, beforeSize + numNewKeysToPut);
            for (String key : mapToPut.keySet()) {
                BaseValueHolder value = (BaseValueHolder)mapToPut.get(key);
                ParRegUtil.verifyContainsKey(r, key, true);
                ParRegUtil.verifyContainsValueForKey(r, key, true);
                this.regionSnapshot.put(key, value.myValue);
                this.destroyedKeys.remove(key);
            }
        }
    }

    @Override
    protected void updateEntry(Region r) {
        Object anObj;
        int beforeSize;
        Object key;
        block9: {
            key = ParRegUtil.getExistingKey(r, this.uniqueKeys, this.numThreadsInClients, false);
            if (key == null) {
                int size = r.size();
                if (this.isSerialExecution && size != 0) {
                    throw new TestException("getExistingKey returned " + key + ", but region size is " + size);
                }
                Log.getLogWriter().info("updateEntry: No keys in region");
                return;
            }
            beforeSize = r.size();
            anObj = this.getUpdateObject(r, (String)key);
            String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
            Object returnVal = null;
            Set<? extends DistributedMember> keyOwners = null;
            try {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
                    keyOwners = this.getOwnersForKey(key, r);
                    returnVal = r.put(key, anObj, (Object)callback);
                    this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                    Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
                } else {
                    Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
                    keyOwners = this.getOwnersForKey(key, r);
                    returnVal = r.put(key, anObj, (Object)false);
                    this.inspector.reportNoLowMemoryException(r, key, keyOwners);
                    Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
                }
            }
            catch (LowMemoryException lme) {
                this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
            }
            catch (ServerOperationException soe) {
                if (!(soe.getCause() instanceof LowMemoryException)) break block9;
                LowMemoryException lme = (LowMemoryException)soe.getCause();
                this.inspector.reportLowMemoryException(r, key, lme, keyOwners);
            }
        }
        if (this.isSerialExecution) {
            ParRegUtil.verifyContainsKey(r, key, true);
            ParRegUtil.verifyContainsValueForKey(r, key, true);
            ParRegUtil.verifySize(r, beforeSize);
            if (this.isBridgeConfiguration) {
                // empty if block
            }
            this.regionSnapshot.put(key, this.getValueForBB(anObj));
            this.destroyedKeys.remove(key);
        }
    }

    @Override
    public int getOffHeapVerifyTargetCount() {
        return ResourceManPrms.getOffHeapVerifyTargetCount();
    }

    static {
        localCriticalState = new HydraThreadLocal();
        PUTALL_KEY = "PUTALL_KEY";
    }

    public static class SternInspector
    implements Inspector {
        @Override
        public void expectLowMemoryException(boolean expect, DistributedMember member) {
            boolean serialState;
            if (member == null) {
                throw new NullPointerException();
            }
            SharedMap sm = ResourceManBB.getBB().getSharedMap();
            long v = ResourceManBB.getBB().getSharedCounters().incrementAndRead(ResourceManBB.criticalStateVersion);
            CriticalState newms = new CriticalState(new Long(System.currentTimeMillis()), expect, member, new Long(v));
            Log.getLogWriter().info("Publishing: " + newms);
            CriticalState oldms = (CriticalState)sm.put(ThresholdsTest.LOW_MEMORY_STATE, newms);
            boolean bl = serialState = oldms == null || oldms.low != newms.low;
            if (!serialState) {
                throw new IllegalStateException("More than one critical condtion at time not supported.  Old state=" + oldms + ", New state=" + newms);
            }
        }

        @Override
        public void waitForNoMembersCriticalOrFail() {
            TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowCounter", ResourceManBB.lowCounter, 0L, true, TimeUnit.SECONDS.toMillis(ResourceManPrms.getTaskWaitForLowMemSec()), 500L);
        }

        @Override
        public void waitForAllMembersCriticalOrFail() {
            int allThreads = 0;
            TestConfig tc = TestConfig.getInstance();
            for (String tgName : ResourceManPrms.getTaskThreadGroupNamesDoingEntryOps()) {
                allThreads = tc.getThreadGroup(tgName).getTotalThreads();
            }
            assert (allThreads > 0);
            TestHelper.waitForCounter(ResourceManBB.getBB(), "ResourceManBB.lowCounter", ResourceManBB.lowCounter, allThreads, true, TimeUnit.SECONDS.toMillis(ResourceManPrms.getTaskWaitForLowMemSec()), 500L);
        }

        @Override
        public void reportNoLowMemoryException(Region r, Object key, Set keyOwners) {
            this.reportLowMemoryException(r, key, null, keyOwners);
        }

        @Override
        public void reportLowMemoryException(Region r, Object key, LowMemoryException lme, Set p_keyOwners) {
            boolean expectedException;
            if (key == PUTALL_KEY) {
                return;
            }
            if (p_keyOwners == null) {
                return;
            }
            Set keyOwners = p_keyOwners;
            ResourceManBB bb = ResourceManBB.getBB();
            CriticalState cs = (CriticalState)bb.getSharedMap().get(ThresholdsTest.LOW_MEMORY_STATE);
            CriticalState lcs = (CriticalState)localCriticalState.get();
            if (lcs != null && cs == null) {
                throw new IllegalStateException("Local critical state should be null");
            }
            if (lcs != null && cs != null) {
                long versionGap = Math.abs(lcs.ver - cs.ver);
                if (versionGap > 1L) {
                    Log.getLogWriter().info("Resetting local state, because of a version gap " + versionGap + ", local critical state " + lcs + " published critical state " + cs);
                    localCriticalState.set(cs);
                } else if (versionGap == 1L && lcs.low == cs.low) {
                    throw new IllegalStateException("Local critical state " + lcs + " does not agree with published critical state " + cs);
                }
            }
            boolean caughtException = lme != null;
            boolean bl = expectedException = cs != null && cs.low;
            if (!caughtException && !expectedException) {
                if (cs != null) {
                    if (cs.low) {
                        throw new IllegalStateException("Published critical state low unexpected value");
                    }
                    if (lcs != null) {
                        localCriticalState.set(null);
                        bb.getSharedMap().replace(ThresholdsTest.ACCESSOR_NO_LOW_MEM_TIMESTAMP, null, new Long(System.currentTimeMillis()));
                        long l = bb.getSharedCounters().decrementAndRead(ResourceManBB.lowCounter);
                    }
                }
                return;
            }
            if (caughtException && expectedException) {
                Indexable.ThresholdsTestStats tstats = ThresholdsTest.getThresholdTestStats();
                if (tstats != null) {
                    tstats.incNumLMEs();
                }
                if (!SetUtils.intersectsWith((Set)keyOwners, (Set)lme.getCriticalMembers())) {
                    throw new TestException("Owners for key " + key + " " + keyOwners + " does not intersect with LME critical members", lme);
                }
                if (keyOwners.contains(cs.mem)) {
                    if (lcs == null) {
                        if (tstats != null) {
                            long delta = System.currentTimeMillis() - cs.ts;
                            tstats.setMaxLMEDiscoveryTime(delta);
                        }
                        localCriticalState.set(cs);
                        bb.getSharedMap().replace(ThresholdsTest.ACCESSOR_LOW_MEM_TIMESTAMP, null, new Long(System.currentTimeMillis()));
                        long numLow = bb.getSharedCounters().incrementAndRead(ResourceManBB.lowCounter);
                        Log.getLogWriter().info("numLow:" + numLow);
                        if (numLow == 1L) {
                            long millis = System.currentTimeMillis() - cs.ts;
                            Log.getLogWriter().info("REPORT: Critical up detected after " + millis + " millis");
                        }
                    }
                } else {
                    throw new TestException("Caught exception for the wrong member, keyOwners=" + keyOwners + ", member=" + cs.mem, lme);
                }
                return;
            }
            if (caughtException && !expectedException) {
                Indexable.ThresholdsTestStats tstats = ThresholdsTest.getThresholdTestStats();
                if (tstats != null) {
                    tstats.incNumLMEs();
                }
                if (!SetUtils.intersectsWith((Set)keyOwners, (Set)lme.getCriticalMembers())) {
                    throw new TestException("Owners for key " + key + " " + keyOwners + " does not intersect with LME critical members", lme);
                }
                if (cs == null) {
                    localCriticalState.set(null);
                    Log.getLogWriter().severe("Rethrowing unexpected LowMemoryException", (Throwable)new Exception(lme));
                    throw lme;
                }
                if (keyOwners.contains(cs.mem)) {
                    assert (!cs.low);
                    long tolerateMs = TimeUnit.SECONDS.toMillis(ResourceManPrms.getTaskTolerateLowMemSec());
                    long deltaMs = System.currentTimeMillis() - cs.ts;
                    if (deltaMs > tolerateMs) {
                        localCriticalState.set(null);
                        Log.getLogWriter().severe("Rethrowing unexpected LowMemoryException after being tolerant for " + deltaMs + "ms", (Throwable)new Exception(lme));
                        throw lme;
                    }
                } else {
                    throw new TestException("Caught unexpected exception for the wrong member, keyOwners=" + keyOwners + ", member=" + cs.mem, lme);
                }
                return;
            }
            if (!caughtException && expectedException) {
                if (keyOwners.contains(cs.mem)) {
                    long tolerateMs = TimeUnit.SECONDS.toMillis(ResourceManPrms.getTaskTolerateLowMemSec());
                    long deltaMs = System.currentTimeMillis() - cs.ts;
                    if (deltaMs > tolerateMs) {
                        localCriticalState.set(null);
                        throw new TestException("Expected LowMemoryException after being tolerant for " + deltaMs + "ms");
                    }
                }
                return;
            }
        }
    }

    public static class EasyInspector
    implements Inspector {
        @Override
        public void reportLowMemoryException(Region r, Object key, LowMemoryException lme, Set keyOwners) {
        }

        @Override
        public void reportNoLowMemoryException(Region r, Object key, Set keyOwners) {
        }

        @Override
        public void expectLowMemoryException(boolean expect, DistributedMember member) {
        }

        @Override
        public void waitForAllMembersCriticalOrFail() {
        }

        @Override
        public void waitForNoMembersCriticalOrFail() {
        }
    }

    public static class CriticalState
    implements Serializable {
        public final DistributedMember mem;
        public final boolean low;
        public final Long ts;
        public final Long ver;

        public CriticalState(Long timestamp, boolean expectLow, DistributedMember member, Long version) {
            this.ts = timestamp;
            this.low = expectLow;
            this.mem = member;
            this.ver = version;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            CriticalState other = (CriticalState)obj;
            if (other.low != this.low) {
                return false;
            }
            if (!other.ver.equals(this.ver)) {
                return false;
            }
            if (!other.ts.equals(this.ts)) {
                return false;
            }
            return other.mem.equals(this.mem);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(ver=" + this.ver + ", low=" + this.low + ", ts=" + this.ts + ", mem=" + this.mem + ")";
        }
    }

    public static interface Inspector {
        public void reportNoLowMemoryException(Region var1, Object var2, Set var3);

        public void reportLowMemoryException(Region var1, Object var2, LowMemoryException var3, Set var4);

        public void expectLowMemoryException(boolean var1, DistributedMember var2);

        public void waitForAllMembersCriticalOrFail();

        public void waitForNoMembersCriticalOrFail();
    }
}

