/*
 * Decompiled with CFR 0.152.
 */
package regions.validate;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import distcache.DistCache;
import distcache.DistCacheFactory;
import distcache.gemfire.GemFireCacheTestImpl;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.TestConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import objects.ObjectHelper;
import regions.validate.DestroyedValue;
import regions.validate.InUse;
import regions.validate.InvalidValue;
import regions.validate.ObjectValue;
import regions.validate.ValidateBlackboard;
import regions.validate.ValidatePrms;
import regions.validate.Value;
import util.NameFactory;
import util.TestException;

public class ValidateTasks {
    private static final InUse IN_USE = InUse.singleton;
    private static Region region;
    private static ValidateBlackboard bb;
    private static boolean DEBUG;
    private static LogWriter logger;
    private static GsRandom random;
    private static long latency;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeVM() throws Exception {
        Class<ValidateTasks> clazz = ValidateTasks.class;
        synchronized (ValidateTasks.class) {
            if (region != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            DistCache dc = DistCacheFactory.createInstance();
            dc.open();
            region = ((GemFireCacheTestImpl)dc).getRegion();
            Assert.assertTrue((region != null ? 1 : 0) != 0);
            bb = ValidateBlackboard.getInstance();
            DEBUG = ValidatePrms.isDebug();
            logger = Log.getLogWriter();
            random = TestConfig.tab().getRandGen();
            latency = ValidatePrms.getDistributionLatency();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            pw.println("Current cache configuration:");
            CacheXmlGenerator.generate((Cache)region.getCache(), (PrintWriter)pw);
            Log.getLogWriter().info(sw.toString());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void populateRegion() throws Exception {
        boolean receiveValuesAsInvalidates = ValidatePrms.getReceiveValuesAsInvalidates();
        if (receiveValuesAsInvalidates) {
            region.registerInterestRegex(".*", false, false);
        }
        for (int i = 0; i < 100; ++i) {
            ValidateTasks.create();
        }
    }

    public static void doEntryOperations() throws Exception {
        long duration = ValidatePrms.getEntryOperationsDuration() * 1000;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < duration) {
            String op = ValidatePrms.getEntryOperation();
            if (DEBUG) {
                logger.info("Performing operation \"" + op + "\"");
            }
            if (op.equals("create")) {
                ValidateTasks.create();
                continue;
            }
            if (op.equals("load")) {
                ValidateTasks.load();
                continue;
            }
            if (op.equals("get")) {
                ValidateTasks.get();
                continue;
            }
            if (op.equals("update")) {
                ValidateTasks.update();
                continue;
            }
            if (op.equals("invalidate")) {
                ValidateTasks.invalidate();
                continue;
            }
            if (op.equals("destroy")) {
                ValidateTasks.destroy();
                continue;
            }
            String s = "Unknown entry operation: " + op;
            throw new HydraConfigException(s);
        }
    }

    public static void validateRegion() throws Exception {
        for (Object key : region.keys()) {
            ValidateTasks.get(key);
        }
    }

    public static void ensureNotInUse() throws Exception {
        bb = ValidateBlackboard.getInstance();
        Map map = bb.getSharedMap().getMap();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof InUse)) continue;
            sb.append("  Key ");
            sb.append(entry.getKey());
            sb.append(" is still in use");
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.insert(0, "At the end of the test, some keys were still in use\n");
            throw new TestException(sb.toString());
        }
    }

    private static void create() throws Exception {
        Value oldValue;
        String key = NameFactory.getNextPositiveObjectName();
        if (DEBUG) {
            logger.info("Creating " + key);
        }
        Assert.assertTrue(((oldValue = bb.get(key)) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bb.replace(key, oldValue, IN_USE));
        String objectType = ValidatePrms.getObjectType();
        long l = NameFactory.getCounterForName(key);
        Object value = ObjectHelper.createObject(objectType, (int)l);
        if (DEBUG) {
            logger.info("Created " + key + " -> " + value);
        }
        region.create((Object)key, value);
        ObjectValue newValue = new ObjectValue(value);
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, newValue));
    }

    private static boolean get() throws Exception {
        Object key = bb.getRandomKey();
        return ValidateTasks.get(key);
    }

    private static boolean get(Object key) throws Exception {
        String s;
        Value expected = bb.get(key);
        if (expected == null) {
            s = "No value in blackboard for key " + key;
            Assert.assertTrue((expected != null ? 1 : 0) != 0, (Object)s);
        }
        if (expected instanceof InUse) {
            if (DEBUG) {
                logger.info("Not getting " + key + " because it is in use");
            }
            return false;
        }
        if (!bb.replace(key, expected, IN_USE)) {
            if (DEBUG) {
                logger.info("Not getting " + key + " because we could not put it in use");
            }
            return false;
        }
        if (expected instanceof DestroyedValue) {
            if (region.getEntry(key) != null) {
                s = "Expected entry " + key + " to be destroyed";
                throw new TestException(s);
            }
        } else if (expected instanceof InvalidValue) {
            Region.Entry entry = region.getEntry(key);
            if (entry == null) {
                if (DEBUG) {
                    logger.info("Invalid entry for " + key + " does not exist in this VM");
                }
            } else {
                Object value = entry.getValue();
                if (value != null) {
                    String s2 = "Expected entry " + key + " to be invalid, but it has value " + value;
                    throw new TestException(s2);
                }
            }
        } else if (expected instanceof ObjectValue) {
            Object actualValue;
            Object expectedValue = ((ObjectValue)expected).getValue();
            if (!expectedValue.equals(actualValue = region.get(key))) {
                if (System.currentTimeMillis() > expected.getTimestamp() + latency) {
                    String s3 = "Expected entry " + key + " to have value " + expectedValue + " from " + expected.formatTimestamp() + ", but it had value " + actualValue;
                    throw new TestException(s3);
                }
                if (DEBUG) {
                    logger.info("Have not received latest value of " + key + " (" + expected + ")");
                }
            }
        } else {
            Assert.assertTrue((boolean)false, (Object)("Don't know how to handle a " + expected.getClass().getName()));
        }
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, expected));
        if (DEBUG) {
            logger.info("Successfully got " + key);
        }
        return true;
    }

    private static void load() throws Exception {
        String key = NameFactory.getNextPositiveObjectName();
        if (DEBUG) {
            logger.info("Loading value for " + key);
        }
        region.get((Object)key);
    }

    private static boolean update() throws Exception {
        Value oldValue;
        Object key = bb.getRandomKey();
        if (DEBUG) {
            logger.info("Updating " + key);
        }
        if ((oldValue = bb.get(key)) == null) {
            String s = "No value in blackboard for key " + key;
            Assert.assertTrue((oldValue != null ? 1 : 0) != 0, (Object)s);
        }
        if (oldValue instanceof InUse) {
            if (DEBUG) {
                logger.info("Not updating " + key + " because it is in use");
            }
            return false;
        }
        if (!bb.replace(key, oldValue, IN_USE)) {
            if (DEBUG) {
                logger.info("Not updating " + key + " because we could not put it in use");
            }
            return false;
        }
        String objectType = ValidatePrms.getObjectType();
        long l = NameFactory.getCounterForName(key);
        Object value = ObjectHelper.createObject(objectType, (int)l);
        if (DEBUG) {
            if (oldValue instanceof ObjectValue) {
                logger.info("Updated " + key + " -> (" + ((ObjectValue)oldValue).getValue() + " -> " + value);
            } else {
                logger.info("Updated " + key + " -> " + value);
            }
        }
        region.put(key, value);
        ObjectValue newValue = new ObjectValue(value);
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, newValue));
        return true;
    }

    private static boolean invalidate() throws Exception {
        Value oldValue;
        Object key = bb.getRandomKey();
        if (DEBUG) {
            logger.info("Invalidating " + key);
        }
        if ((oldValue = bb.get(key)) == null) {
            String s = "No value in blackboard for key " + key;
            Assert.assertTrue((oldValue != null ? 1 : 0) != 0, (Object)s);
        }
        if (oldValue instanceof InUse) {
            if (DEBUG) {
                logger.info("Not invalidating " + key + " because it is in use");
            }
            return false;
        }
        if (!bb.replace(key, oldValue, IN_USE)) {
            if (DEBUG) {
                logger.info("Not invalidating " + key + " because we could not put it in use");
            }
            return false;
        }
        if (oldValue instanceof InvalidValue || oldValue instanceof DestroyedValue) {
            if (DEBUG) {
                logger.info("Not invalidating " + key + " because it is not valid: " + oldValue);
            }
            Assert.assertTrue((boolean)bb.replace(key, IN_USE, oldValue));
            return false;
        }
        region.get(key);
        region.invalidate(key);
        InvalidValue newValue = new InvalidValue();
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, newValue));
        return true;
    }

    private static boolean destroy() throws Exception {
        Value oldValue;
        Object key = bb.getRandomKey();
        if (DEBUG) {
            logger.info("Destroying " + key);
        }
        if ((oldValue = bb.get(key)) == null) {
            String s = "No value in blackboard for key " + key;
            Assert.assertTrue((oldValue != null ? 1 : 0) != 0, (Object)s);
        }
        if (oldValue instanceof InUse) {
            if (DEBUG) {
                logger.info("Not destroying " + key + " because it is in use");
            }
            return false;
        }
        if (!bb.replace(key, oldValue, IN_USE)) {
            if (DEBUG) {
                logger.info("Not invalidating " + key + " because we could not put it in use");
            }
            return false;
        }
        if (oldValue instanceof DestroyedValue) {
            if (DEBUG) {
                logger.info("Not destroying " + key + " because it is already destroyed: " + oldValue);
            }
            Assert.assertTrue((boolean)bb.replace(key, IN_USE, oldValue));
            return false;
        }
        if (oldValue instanceof ObjectValue) {
            region.get(key);
        } else if (oldValue instanceof InvalidValue && region.getEntry(key) == null) {
            if (DEBUG) {
                logger.info("Not destroying " + key + " because it is invalid in some other VM");
            }
            Assert.assertTrue((boolean)bb.replace(key, IN_USE, oldValue));
            return false;
        }
        Assert.assertTrue((region.getEntry(key) != null ? 1 : 0) != 0);
        region.destroy(key);
        DestroyedValue newValue = new DestroyedValue();
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, newValue));
        return true;
    }
}

