/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.BridgeHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.BitSet;
import java.util.List;
import parReg.KnownKeysTest;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import recovDelay.CountListener;
import recovDelay.EventPRObserver;
import recovDelay.RecovDelayBB;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;

public class EventsDuringRecoveryTest
extends KnownKeysTest {
    protected static boolean thisVMRestarted = false;

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new EventsDuringRecoveryTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(EventsDuringRecoveryTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            testInstance = new EventsDuringRecoveryTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
            RegionAttributes attr = EventsDuringRecoveryTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
            ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
        }
    }

    public static synchronized void HydraTask_HA_dataStoreReinitialize() {
        if (testInstance == null) {
            Log.getLogWriter().info("Reinitializing with EventPRObserver");
            EventPRObserver.installObserverHook();
            EventPRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new EventsDuringRecoveryTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            thisVMRestarted = true;
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
            RegionAttributes attr = EventsDuringRecoveryTest.testInstance.aRegion.getAttributes();
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            ParRegBB.getBB().getSharedMap().put("recoveryDelay", new Long(prAttr.getRecoveryDelay()));
            ParRegBB.getBB().getSharedMap().put("startupRecoveryDelay", new Long(prAttr.getStartupRecoveryDelay()));
        }
    }

    public static void HydraTask_stopStartVms() {
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        Log.getLogWriter().info("In stopStartVms, choosing " + numVMsToStop + " vm(s) to stop...");
        Object[] anArr = StopStartVMs.getOtherVMs(numVMsToStop, "dataStore");
        List targetVms = (List)anArr[0];
        List stopModes = (List)anArr[1];
        List vmList = (List)anArr[2];
        StopStartVMs.stopStartVMs(targetVms, stopModes);
        RecovDelayBB.getBB().getSharedMap().put("stopped vms", targetVms);
        long recoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("recoveryDelay");
        long startupRecoveryDelay = (Long)ParRegBB.getBB().getSharedMap().get("startupRecoveryDelay");
        PRObserver.waitForRecovery(recoveryDelay, startupRecoveryDelay, targetVms, vmList, numVMsToStop, 1, null, null);
        long timeToStop = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        if (timeToStop > 0L) {
            throw new TestException("Ops did not run long enough to span a stop/start; this is a test tuning issue");
        }
    }

    public static void HydraTask_doOps() {
        List stoppedVMs;
        if (!thisVMRestarted && RemoteTestModule.getMyClientName().indexOf("dataStore") >= 0 && (stoppedVMs = (List)RecovDelayBB.getBB().getSharedMap().get("stopped vms")) == null) {
            Log.getLogWriter().info("Not allowing this data store vm to run ops; vms have not yet stopped/restarted");
            MasterController.sleepForMs(2000);
            return;
        }
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        testInstance.doOps(availableOps);
        if (availableOps.cardinality() == 0) {
            ParRegBB.getBB().getSharedCounters().increment(ParRegBB.TimeToStop);
            throw new StopSchedulingTaskOnClientOrder("Finished with ops");
        }
    }

    public static void HydraTask_checkForErrors() {
        if (!thisVMRestarted) {
            Log.getLogWriter().info("Not checking counters in this vm because it was not stopped and restarted");
            return;
        }
        StringBuffer aStr = new StringBuffer();
        CountListener.logCounters();
        int threshold = 5;
        int summOfIsNotRemoteCounters = CountListener.afterCreateCount_isNotRemote + CountListener.afterCreatePutAllCount_isNotRemote + CountListener.afterDestroyCount_isNotRemote + CountListener.afterUpdateCount_isNotRemote + CountListener.afterDestroyCount_isNotRemote;
        int summThreshold = 10;
        if (CountListener.afterCreateCount_isRemote < threshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterCreateCount_isRemote + " remote create events during recovery\n");
        }
        if (CountListener.afterCreateCount_isNotRemote < threshold && summOfIsNotRemoteCounters < summThreshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterCreateCount_isNotRemote + " create events during recovery\n");
        }
        if (CountListener.afterCreatePutAllCount_isRemote < threshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterCreatePutAllCount_isRemote + " remote putAll create events during recovery\n");
        }
        if (CountListener.afterCreatePutAllCount_isNotRemote < threshold && summOfIsNotRemoteCounters < summThreshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterCreatePutAllCount_isNotRemote + " putAll create events during recovery\n");
        }
        if (CountListener.afterDestroyCount_isRemote < threshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterDestroyCount_isRemote + " remote destroy events during recovery\n");
        }
        if (CountListener.afterDestroyCount_isNotRemote < threshold && summOfIsNotRemoteCounters < summThreshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterDestroyCount_isNotRemote + " destroy events during recovery\n");
        }
        if (CountListener.afterUpdateCount_isRemote < threshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterUpdateCount_isRemote + " remote update events during recovery\n");
        }
        if (CountListener.afterUpdateCount_isNotRemote < threshold && summOfIsNotRemoteCounters < summThreshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterUpdateCount_isNotRemote + " update events during recovery\n");
        }
        if (CountListener.afterInvalidateCount_isRemote < threshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterInvalidateCount_isRemote + " remote update events during recovery\n");
        }
        if (CountListener.afterInvalidateCount_isNotRemote < threshold && summOfIsNotRemoteCounters < summThreshold) {
            aStr.append("This vm might have blocked during operations; it received " + CountListener.afterInvalidateCount_isNotRemote + " invalidate events during recovery\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }
}

