/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import util.TestException;
import util.TestHelper;

public class BucketState
implements Serializable {
    public static Map[] getBucketMaps(Region aRegion) {
        TreeMap<Integer, Integer> primaryMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> bucketMap = new TreeMap<Integer, Integer>();
        PartitionedRegion pr = (PartitionedRegion)aRegion;
        try {
            int totalBuckets = pr.getTotalNumberOfBuckets();
            for (int i = 0; i < totalBuckets; ++i) {
                List aList = pr.getBucketOwnersForValidation(i);
                if (aList.size() == 0) continue;
                for (int j = 0; j < aList.size(); ++j) {
                    Object[] tmpArr = (Object[])aList.get(j);
                    InternalDistributedMember member = (InternalDistributedMember)tmpArr[0];
                    Boolean isPrimary = (Boolean)tmpArr[1];
                    String host = member.getHost();
                    int pid = member.getVmPid();
                    Integer vmId = null;
                    try {
                        vmId = RemoteTestModule.Master.getVmid(host, pid);
                        if (vmId == null) {
                            throw new TestException("Given host " + host + " and pid " + pid + ", hydra returned a vmID of " + vmId);
                        }
                    }
                    catch (RemoteException e) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Integer key = vmId;
                    Integer currPrimaryCount = (Integer)primaryMap.get(key);
                    if (isPrimary.booleanValue()) {
                        currPrimaryCount = currPrimaryCount == null ? new Integer(1) : new Integer(currPrimaryCount + 1);
                    } else if (currPrimaryCount == null) {
                        currPrimaryCount = new Integer(0);
                    }
                    primaryMap.put(key, currPrimaryCount);
                    Integer currBucketCount = (Integer)bucketMap.get(key);
                    currBucketCount = currBucketCount == null ? new Integer(1) : new Integer(currBucketCount + 1);
                    bucketMap.put(key, currBucketCount);
                }
            }
        }
        catch (ReplyException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ForceReattemptException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new Map[]{primaryMap, bucketMap};
    }

    public static void checkPrimaryBalance(Region aRegion) {
        Map[] mapArr = BucketState.getBucketMaps(aRegion);
        Map primaryMap = mapArr[0];
        Map bucketMap = mapArr[1];
        Iterator it = primaryMap.keySet().iterator();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int total = 0;
        while (it.hasNext()) {
            Integer vmId = (Integer)it.next();
            int value = (Integer)primaryMap.get(vmId);
            min = Math.min(min, value);
            max = Math.max(max, value);
            total += value;
        }
        int span = Math.abs(max - min);
        if (span > 1) {
            throw new TestException("Primaries are not balanced, least number of primaries in a vm: " + min + ", most number of primaries in a vm: " + max + "; " + primaryMap + ", buckets: " + bucketMap);
        }
        Log.getLogWriter().info("Primaries are balanced: " + primaryMap + ", buckets: " + bucketMap);
    }
}

