/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import cq.CQUtilBB;
import hydra.CacheHelper;
import hydra.CacheServerHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.GemFireDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import parReg.ParRegBB;
import rebalance.RebalanceBB;
import rebalance.RebalanceEventCountersBB;
import rebalance.RebalancePrms;
import rebalance.RebalanceUtil;
import splitBrain.SplitBrainBB;
import util.AdminHelper;
import util.AdminTestException;
import util.ExpCounterValue;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class RebalanceTest {
    private static final String cacheServerStr = "cacheserver";
    public static RebalanceTest testInstance;
    private RebalanceOperation rebalanceOp;
    public static Object listenerSyncObject;

    public static synchronized void HydraTask_initCacheServerXml() {
        if (testInstance == null) {
            testInstance = new RebalanceTest();
            testInstance.createXml(ConfigPrms.getRegionConfig());
        }
    }

    public static void HydraTask_createXml() {
        String key = cacheServerStr;
        String xmlFileName = key + ".xml";
        CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), ConfigPrms.getRegionConfig(), xmlFileName);
    }

    public static synchronized void HydraTask_rebalanceWithCacheServer() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("HydraTask_rebalanceWithCacheServer() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        Set before = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        RebalanceBB.getBB().getSharedCounters().zero(RebalanceBB.recoveryRegionCount);
        String[] extraArgs = RebalancePrms.getExtraCacheServerArgs();
        String xmlFileName = "cacheserver.xml";
        long numCacheServers = RebalanceBB.getBB().getSharedCounters().incrementAndRead(RebalanceBB.numCacheServers);
        String serverName = "cacheserver_" + numCacheServers;
        Log.getLogWriter().info("Starting up cacheServer " + serverName + " with cache.xml file " + xmlFileName + " for Rebalance");
        GemFireDescription gfd = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName()).getGemFireDescription();
        String offHeapMemorySize = gfd.getOffHeapMemorySize();
        if (offHeapMemorySize != null) {
            extraArgs = Arrays.copyOf(extraArgs, extraArgs.length + 1);
            extraArgs[extraArgs.length - 1] = " off-heap-memory-size=" + offHeapMemorySize;
        }
        CacheServerHelper.startCacheServer(serverName, xmlFileName, extraArgs);
        Long startTime = new Long(System.currentTimeMillis());
        RebalanceUtil.waitForRecovery();
        Long stopTime = new Long(System.currentTimeMillis());
        Long rebalanceTime = stopTime - startTime;
        Log.getLogWriter().info("rebalance totalTime: " + rebalanceTime + " ms");
        String regionPath = null;
        String regionName = null;
        for (PartitionRegionInfo prdBefore : before) {
            Log.getLogWriter().info("Before Rebalance\n" + RebalanceUtil.partitionedRegionDetailsToString(prdBefore));
            regionPath = prdBefore.getRegionPath();
            regionName = RebalanceUtil.getRegionName(prdBefore);
            Region region = myCache.getRegion(regionName);
            PartitionRegionInfo prdAfter = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
            Log.getLogWriter().info("After Rebalance \n" + RebalanceUtil.partitionedRegionDetailsToString(prdAfter));
            if (!RebalancePrms.verifyBalance()) continue;
            RebalanceUtil.isBalanceImproved(regionName, prdBefore.getPartitionMemberInfo(), prdAfter.getPartitionMemberInfo());
            Log.getLogWriter().info("PR for region " + regionName + " is balanced");
        }
        MasterController.sleepForMs(10000);
        CacheServerHelper.stopCacheServer(serverName);
        long parRegCounter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop);
        long cqCounter = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.TimeToStop);
        if (parRegCounter + cqCounter > 0L) {
            throw new StopSchedulingOrder("Hydra clients have completed work, stop scheduling rebalance");
        }
    }

    public void createXml(String regDescriptName) {
        block3: {
            String key = cacheServerStr;
            String xmlFileName = key + ".xml";
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            if (TestConfig.tab().stringAt(GatewaySenderPrms.names, null) != null) {
                GatewaySenderHelper.createGatewaySenders(ConfigPrms.getGatewaySenderConfig());
            }
            try {
                RegionDescription regionDescr = RegionHelper.getRegionDescription(regDescriptName);
                CacheHelper.generateCacheXmlFile(ConfigPrms.getCacheConfig(), regDescriptName, xmlFileName);
            }
            catch (HydraRuntimeException e) {
                String errStr = e.toString();
                if (errStr.indexOf("Cache XML file was already created") >= 0) break block3;
                throw e;
            }
        }
        RegionHelper.createRegion(regDescriptName);
    }

    public static void HydraTask_adminRebalance() {
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("AdminDistributedSystem is null.  HydraTask_initializeAdminDS() must be invoked prior to HydraTask_adminRebalance().");
        }
        SystemMember[] systemMembers = null;
        try {
            systemMembers = adminDS.getSystemMemberApplications();
        }
        catch (AdminException ae) {
            throw new TestException("getSystemMemberApplications threw " + (Object)((Object)ae));
        }
        if (systemMembers.length == 0) {
            Log.getLogWriter().info("Cannot do operations on SystemMembers ... none available");
            return;
        }
        StringBuffer aStr = new StringBuffer();
        aStr.append("Discovered " + systemMembers.length + " SystemMembers");
        for (int i = 0; i < systemMembers.length; ++i) {
            aStr.append("\n");
            aStr.append("   SystemMembers[" + i + "] = " + systemMembers[i].toString());
        }
        Log.getLogWriter().info(aStr.toString());
        SystemMemberCache smCache = null;
        for (int i = 0; i < systemMembers.length; ++i) {
            SystemMember sm = systemMembers[i];
            try {
                smCache = sm.getCache();
            }
            catch (AdminException ae) {
                throw new TestException("Caught exception " + (Object)((Object)ae));
            }
            catch (OperationCancelledException oce) {
                Log.getLogWriter().info("Caught OperationCancelledException, continuing with test");
                continue;
            }
            if (smCache == null) {
                Log.getLogWriter().info("Member " + sm + " has no cache");
                continue;
            }
            Set rootRegions = smCache.getRootRegionNames();
            Log.getLogWriter().info("SystemMember " + sm + " Root Regions = " + rootRegions);
            ArrayList aList = RebalanceTest.getAllRegionNames(smCache);
            StringBuffer displayList = new StringBuffer();
            for (int j = 0; j < aList.size(); ++j) {
                displayList.append(aList.get(j) + " \n");
            }
            Log.getLogWriter().fine("regionList for member " + sm + " = \n" + displayList.toString());
        }
    }

    protected static ArrayList getAllRegionNames(SystemMemberCache smCache) {
        ArrayList regionList = new ArrayList();
        SystemMemberRegion smRegion = null;
        smCache.refresh();
        Set rootRegions = smCache.getRootRegionNames();
        regionList.addAll(rootRegions);
        Iterator it = rootRegions.iterator();
        while (it.hasNext()) {
            String regionName = null;
            try {
                regionName = (String)it.next();
                smRegion = smCache.getRegion(regionName);
            }
            catch (AdminException ae) {
                throw new AdminTestException(" could not getRegion " + regionName, (Exception)((Object)ae));
            }
            catch (RegionNotFoundException ex) {
                Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + regionName);
                continue;
            }
            catch (RegionDestroyedException de) {
                Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + regionName);
                continue;
            }
            catch (OperationCancelledException oce) {
                Log.getLogWriter().fine("Ignoring OperationCancelledException for " + regionName);
                continue;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                if (cause.toString().contains("OperationCancelledException")) {
                    Log.getLogWriter().info("Caught " + e + " (expected with concurrent execution); continuing with test");
                }
                throw new TestException(TestHelper.getStackTrace(e));
            }
            regionList.addAll(RebalanceTest.getRegionNames(smCache, smRegion));
        }
        return regionList;
    }

    protected static ArrayList getRegionNames(SystemMemberCache smCache, SystemMemberRegion smRegion) {
        ArrayList<String> aList = new ArrayList<String>();
        String subregionName = null;
        Set subRegions = null;
        try {
            smRegion.refresh();
            subRegions = smRegion.getSubregionNames();
        }
        catch (Exception e) {
            Log.getLogWriter().fine("getRegionNames caught " + e);
            return aList;
        }
        Iterator it = subRegions.iterator();
        while (it.hasNext()) {
            subregionName = new String(smRegion.getFullPath() + "/" + (String)it.next());
            aList.add(subregionName);
            SystemMemberRegion aRegion = null;
            try {
                aRegion = smCache.getRegion(subregionName);
            }
            catch (AdminException ae) {
                throw new AdminTestException(" Could not get subregion given subregionName " + subregionName, (Exception)((Object)ae));
            }
            catch (RegionNotFoundException ex) {
                Log.getLogWriter().fine("Ignoring RegionNotFoundException for " + subregionName);
                continue;
            }
            catch (RegionDestroyedException dx) {
                Log.getLogWriter().fine("Ignoring RegionDestroyedException for " + subregionName);
                continue;
            }
            if (aRegion == null) continue;
            aList.addAll(RebalanceTest.getRegionNames(smCache, aRegion));
        }
        return aList;
    }

    public static void HydraTask_rebalanceTask() {
        Log.getLogWriter().info("In HydraTask_rebalanceTask");
        if (testInstance == null) {
            testInstance = new RebalanceTest();
        }
        testInstance.rebalance();
    }

    public void rebalance() {
        long cqCounter;
        long parRegCounter;
        String taskType = RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString();
        if (taskType.equalsIgnoreCase("TASK") && (parRegCounter = ParRegBB.getBB().getSharedCounters().read(ParRegBB.TimeToStop)) + (cqCounter = CQUtilBB.getBB().getSharedCounters().read(CQUtilBB.TimeToStop)) > 0L) {
            throw new StopSchedulingOrder("Hydra clients have completed work, stop scheduling rebalance");
        }
        SplitBrainBB.getBB().getSharedCounters().zero(SplitBrainBB.dropConnectionComplete);
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("HydraTask_rebalanceTask() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        RebalanceTest.setResourceObserver();
        RebalanceFactory factory = rm.createRebalanceFactory();
        Set prdSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        for (PartitionRegionInfo prd : prdSet) {
            Log.getLogWriter().info(RebalanceUtil.partitionedRegionDetailsToString(prd));
        }
        RebalanceEventCountersBB.zeroAllCounters();
        if (RebalancePrms.getTargetEvent() == null) {
            Log.getLogWriter().info("Calling simulate ...");
            RebalanceOperation simOp = factory.simulate();
            Log.getLogWriter().info("Called simulate ...");
            RebalanceResults simResults = null;
            try {
                simResults = simOp.getResults();
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(simResults, "simulate"));
            }
            catch (CancellationException ce) {
                Log.getLogWriter().info("getResults() caught exception " + ce);
            }
            catch (InterruptedException ie) {
                Log.getLogWriter().info("getResults() caught exception " + ie);
            }
            RebalanceTest.checkRebalanceEventCounters(simResults, false);
            RebalanceEventCountersBB.zeroAllCounters();
        }
        prdSet = PartitionRegionHelper.getPartitionRegionInfo((Cache)myCache);
        Log.getLogWriter().info("Writing PartitionedRegionDetails to BB (before)");
        RebalanceBB.getBB().getSharedMap().put(RebalanceBB.PartitionedRegionDetails_before, prdSet);
        RebalanceBB.getBB().getSharedCounters().zero(RebalanceBB.processedStart);
        String action = RebalancePrms.getRebalanceAction();
        Long startTime = new Long(System.currentTimeMillis());
        if (action.equalsIgnoreCase("kill")) {
            this.killTargetVm(factory);
        } else if (action.equalsIgnoreCase("cancel")) {
            this.cancelRebalance(factory);
        } else {
            Log.getLogWriter().info("Starting rebalance ...");
            this.rebalanceOp = factory.start();
            Log.getLogWriter().info("Started rebalance.");
        }
        RebalanceResults rebalanceResults = null;
        try {
            rebalanceResults = this.rebalanceOp.getResults();
        }
        catch (CancellationException ce) {
            if (action.equalsIgnoreCase("cancel")) {
                Log.getLogWriter().info("getResults() caught exception " + ce + " expected, continuing test execution");
                return;
            }
            Log.getLogWriter().info("getResults() caught exception " + ce);
            throw new TestException("Unexpected exception " + TestHelper.getStackTrace(ce));
        }
        catch (InterruptedException ie) {
            Log.getLogWriter().info("getResults() caught exception " + ie);
            throw new TestException("Unexpected exception " + TestHelper.getStackTrace(ie));
        }
        Long stopTime = new Long(System.currentTimeMillis());
        Long rebalanceTime = stopTime - startTime;
        Log.getLogWriter().info("Completed rebalance in " + rebalanceTime + " ms, results = " + this.rebalanceOp.toString());
        Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "rebalance"));
        if (RebalancePrms.verifyBalance()) {
            RebalanceUtil.isBalanceImproved(rebalanceResults);
            Log.getLogWriter().info("PRs are balanced");
        }
        if (RebalancePrms.waitForNetworkDrop()) {
            TestHelper.waitForCounter(SplitBrainBB.getBB(), "dropConnectionComplete", SplitBrainBB.dropConnectionComplete, 1L, true, 1830000L);
        }
    }

    private static void checkRebalanceEventCounters(RebalanceResults results, boolean eventsExpected) {
        ArrayList<ExpCounterValue> aList = new ArrayList<ExpCounterValue>();
        aList.add(new ExpCounterValue(RebalanceEventCountersBB.BUCKET_CREATES, eventsExpected ? (long)results.getTotalBucketCreatesCompleted() : 0L));
        aList.add(new ExpCounterValue(RebalanceEventCountersBB.BUCKET_TRANSFERS, eventsExpected ? (long)results.getTotalBucketTransfersCompleted() : 0L));
        aList.add(new ExpCounterValue(RebalanceEventCountersBB.PRIMARY_TRANSFERS, eventsExpected ? (long)results.getTotalPrimaryTransfersCompleted() : 0L));
        RebalanceEventCountersBB.checkEventCounters(aList);
    }

    public static void setResourceObserver() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("setResourceObserver() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        InternalResourceManager.ResourceObserver ro = RebalancePrms.getResourceObserver();
        if (ro != null) {
            InternalResourceManager cfr_ignored_0 = (InternalResourceManager)rm;
            InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
            Log.getLogWriter().info("Installed ResourceObserver " + ro.toString());
        }
    }

    public static void HydraTask_checkPartitionedRegionDetails() {
        Log.getLogWriter().info("In HydraTask_checkPartitionedRegionDetails");
        Set before = (Set)RebalanceBB.getBB().getSharedMap().get(RebalanceBB.PartitionedRegionDetails_before);
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("HydraTask_checkPartitionedRegionDetails() expects hydra client to have created cache and PR via initialization tasks");
        }
        ResourceManager rm = myCache.getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        String regionPath = null;
        String regionName = null;
        for (PartitionRegionInfo prdBefore : before) {
            Log.getLogWriter().info("Before Rebalancing \n" + RebalanceUtil.partitionedRegionDetailsToString(prdBefore));
            regionPath = prdBefore.getRegionPath();
            regionName = RebalanceUtil.getRegionName(prdBefore);
            Region region = myCache.getRegion(regionName);
            PartitionRegionInfo prdAfter = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
            Log.getLogWriter().info("After Rebalancing \n" + RebalanceUtil.partitionedRegionDetailsToString(prdAfter));
            if (!RebalancePrms.verifyBalance()) continue;
            RebalanceUtil.isBalanceImproved(regionName, prdBefore.getPartitionMemberInfo(), prdAfter.getPartitionMemberInfo());
            RebalanceUtil.primariesBalanced(prdBefore);
            Log.getLogWriter().info("PR for region " + regionName + " is balanced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTargetVm(final RebalanceFactory factory) {
        String targetEvent = RebalancePrms.getTargetEvent();
        Thread rebalanceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int actionDelaySecs = RebalancePrms.getActionDelaySecs();
                try {
                    Thread.sleep(actionDelaySecs * 1000);
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Starting rebalance ...");
                testInstance.rebalanceOp = factory.start();
                Log.getLogWriter().info("Started rebalance.");
            }
        });
        rebalanceThread.start();
        Log.getLogWriter().info("In killTargetVm with targetEvent " + targetEvent);
        Object object = listenerSyncObject;
        synchronized (object) {
            try {
                Log.getLogWriter().info("killTargetVm waiting on listenerSyncObject for " + targetEvent);
                listenerSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("killTargetVm interrupted: VM not killed");
            }
        }
        ClientVmInfo targetVm = (ClientVmInfo)RebalanceBB.getBB().getSharedMap().get(RebalanceBB.targetVmInfo);
        Log.getLogWriter().info("killTargetVm notified of " + targetEvent + " for targetVm " + targetVm.toString());
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.processedStart);
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.numTargetEventsProcessed);
        try {
            if (targetVm.getVmid() == RemoteTestModule.getMyVmid()) {
                ClientVmMgr.stopAsync("killTargetVm killing rebalancer " + targetVm.toString(), -21, -30, targetVm);
            } else {
                ClientVmMgr.stop("killTargetVm killing " + targetVm.toString(), -21, -31, targetVm);
                ClientVmMgr.start("killTargetVm restarting " + targetVm.toString(), targetVm);
            }
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Failed to kill " + targetVm.toString() + ", caught Exception " + e + " (expected with concurrent execution); continuing with test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRebalance(final RebalanceFactory factory) {
        String targetEvent = RebalancePrms.getTargetEvent();
        Log.getLogWriter().info("In cancelRebalance with targetEvent " + targetEvent);
        Thread rebalanceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int actionDelaySecs = RebalancePrms.getActionDelaySecs();
                try {
                    Thread.sleep(actionDelaySecs * 1000);
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Starting rebalance ...");
                testInstance.rebalanceOp = factory.start();
                Log.getLogWriter().info("Started rebalance.");
            }
        });
        rebalanceThread.start();
        Object object = listenerSyncObject;
        synchronized (object) {
            try {
                Log.getLogWriter().info("cancelRebalance waiting on listenerSyncObject for " + targetEvent);
                listenerSyncObject.wait();
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("cancelRebalance interrupted: Rebalance not cancelled");
            }
        }
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.processedStart);
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.numTargetEventsProcessed);
        if (this.rebalanceOp.cancel()) {
            Log.getLogWriter().info("RebalanceOperation cancelled");
        } else {
            Log.getLogWriter().info("RebalanceOperation was NOT cancelled");
        }
        Log.getLogWriter().info("cancelRebalance notified of " + targetEvent);
        ResourceManager rm = CacheHelper.getCache().getResourceManager();
        Set before = (Set)RebalanceBB.getBB().getSharedMap().get(RebalanceBB.PartitionedRegionDetails_before);
        String regionPath = null;
        String regionName = null;
        for (PartitionRegionInfo prdBefore : before) {
            Log.getLogWriter().info("Before Rebalance\n" + RebalanceUtil.partitionedRegionDetailsToString(prdBefore));
            regionPath = prdBefore.getRegionPath();
            regionName = RebalanceUtil.getRegionName(prdBefore);
            Region region = CacheHelper.getCache().getRegion(regionName);
            PartitionRegionInfo prdAfter = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
            Log.getLogWriter().info("After Rebalance \n" + RebalanceUtil.partitionedRegionDetailsToString(prdAfter));
            if (!RebalancePrms.verifyBalance()) continue;
            RebalanceUtil.isBalanceImproved(regionName, prdBefore.getPartitionMemberInfo(), prdAfter.getPartitionMemberInfo());
            Log.getLogWriter().info("PR for region " + regionName + " is balanced");
        }
        String taskType = RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString();
        if (taskType.equalsIgnoreCase("TASK")) {
            ClientVmInfo targetVm = (ClientVmInfo)RebalanceBB.getBB().getSharedMap().get(RebalanceBB.targetVmInfo);
            try {
                if (targetEvent.equalsIgnoreCase("rebalancingStarted")) {
                    ClientVmMgr.stopAsync("cancelRebalance killing " + targetVm.toString(), -21, -30, targetVm);
                } else {
                    ClientVmMgr.stop("cancelRebalance killing " + targetVm.toString(), -21, -31, targetVm);
                    ClientVmMgr.start("cancelRebalance restarting" + targetVm.toString(), targetVm);
                }
            }
            catch (ClientVmNotFoundException e) {
                Log.getLogWriter().info("Failed to kill " + targetVm.toString() + ", caught Exception " + e + " (expected with concurrent execution); continuing with test");
            }
        }
    }

    public static void HydraTask_verifyTargetEventsProcessed() {
        String targetEvent = RebalancePrms.getTargetEvent();
        long numEvents = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.numTargetEventsProcessed);
        if (numEvents == 0L) {
            throw new TestException("Test config or tuning issue: Test did not kill and VMs based on " + targetEvent + " events");
        }
        Log.getLogWriter().info("Executed " + numEvents + " kills based on " + targetEvent + " events");
    }

    public static void HydraTask_stopStartNonAdminVMs() {
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        int randInt = TestConfig.tab().getRandGen().nextInt(1, numVMsToStop);
        Object[] objArr = StopStartVMs.getOtherVMsWithExclude(randInt, "rebalance");
        List clientVmInfoList = (List)objArr[0];
        List stopModeList = (List)objArr[1];
        StopStartVMs.stopStartVMs(clientVmInfoList, stopModeList);
    }

    static {
        listenerSyncObject = new Object();
    }
}

