/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.ClientVmInfo;
import hydra.Log;
import hydra.RemoteTestModule;
import java.rmi.RemoteException;
import rebalance.RebalanceBB;
import rebalance.RebalancePrms;
import rebalance.RebalanceTest;
import util.TestException;

public class HAResourceObserver
extends InternalResourceManager.ResourceObserverAdapter {
    private static String event = RebalancePrms.getTargetEvent();

    public void rebalancingOrRecoveryStarted(Region aRegion) {
        Log.getLogWriter().info("HAResourceObserver.rebalanceStarted() for Region " + aRegion.getName());
        if (event.equalsIgnoreCase("rebalancingStarted")) {
            this.handleRebalancingStarted(aRegion);
        }
    }

    public void rebalancingOrRecoveryFinished(Region aRegion) {
        Log.getLogWriter().info("HAResourceObserver.rebalanceFinished() for Region " + aRegion.getName());
        RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.recoveryRegionCount);
        this.handleRebalancingFinished(aRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movingBucket(Region aRegion, int bucketId, DistributedMember source, DistributedMember dest) {
        Log.getLogWriter().info("HAResourceObserver.movingBucket() for Region " + aRegion.getName());
        if (event.equalsIgnoreCase("rebalancingStarted")) {
            this.handleRebalancingStarted(aRegion);
        }
        if (event.equalsIgnoreCase("movingBucket")) {
            String sourceHost = source.getHost();
            int sourcePid = source.getProcessId();
            String destHost = dest.getHost();
            int destPid = dest.getProcessId();
            Log.getLogWriter().info("movingBucket: " + aRegion.getName() + ":" + bucketId + " source = " + source.toString() + " target = " + dest.toString());
            ClientVmInfo sourceVm = HAResourceObserver.getClientVmInfo(sourceHost, sourcePid);
            ClientVmInfo destVm = HAResourceObserver.getClientVmInfo(destHost, destPid);
            ClientVmInfo targetVm = null;
            if (sourceVm == null || destVm == null) {
                return;
            }
            Log.getLogWriter().info("movingBucket:  sourceVm = " + sourceVm.toString() + " targetVm = " + destVm.toString());
            int rebalancerVMid = RemoteTestModule.getMyVmid();
            targetVm = sourceVm.getVmid() != rebalancerVMid ? sourceVm : destVm;
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.targetVmInfo, targetVm);
            Log.getLogWriter().info("movingBucket: targetVm = " + targetVm.toString());
            Object object = RebalanceTest.listenerSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("Notifying listenerSyncObject with movingBucket for Vm = " + targetVm.toString());
                RebalanceTest.listenerSyncObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movingPrimary(Region aRegion, int bucketId, DistributedMember source, DistributedMember dest) {
        Log.getLogWriter().info("HAResourceObserver.movingPrimary() for Region " + aRegion.getName());
        if (event.equalsIgnoreCase("rebalancingStarted")) {
            this.handleRebalancingStarted(aRegion);
        }
        if (event.equalsIgnoreCase("movingPrimary") || event.equalsIgnoreCase("movingBucket")) {
            String sourceHost = source.getHost();
            int sourcePid = source.getProcessId();
            String destHost = dest.getHost();
            int destPid = dest.getProcessId();
            ClientVmInfo sourceVm = HAResourceObserver.getClientVmInfo(sourceHost, sourcePid);
            ClientVmInfo destVm = HAResourceObserver.getClientVmInfo(destHost, destPid);
            ClientVmInfo targetVm = null;
            Log.getLogWriter().info("movingPrimary: " + aRegion.getName() + ":" + bucketId + " source = " + source.toString() + " target = " + dest.toString());
            if (sourceVm == null || destVm == null) {
                return;
            }
            int rebalancerVMid = RemoteTestModule.getMyVmid();
            targetVm = sourceVm.getVmid() != rebalancerVMid ? sourceVm : destVm;
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.targetVmInfo, targetVm);
            Log.getLogWriter().info("movingPrimary: targetVm = " + targetVm.toString());
            Object object = RebalanceTest.listenerSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("Notifying listenerSyncObject with movingPrimary for Vm = " + targetVm.toString());
                RebalanceTest.listenerSyncObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRebalancingStarted(Region aRegion) {
        long processedStart = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.processedStart);
        if (processedStart == 0L) {
            int myVMid = RemoteTestModule.getMyVmid();
            ClientVmInfo targetVm = new ClientVmInfo(new Integer(myVMid), RemoteTestModule.getMyClientName(), null);
            Log.getLogWriter().info("rebalancingStarted: " + aRegion.getName() + " rebalancing VM " + targetVm.toString());
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.targetVmInfo, targetVm);
            Object object = RebalanceTest.listenerSyncObject;
            synchronized (object) {
                Log.getLogWriter().info("Notifying listenerSyncObject with rebalancingStarted for Vm = " + targetVm.toString());
                RebalanceTest.listenerSyncObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRebalancingFinished(Region aRegion) {
        int myVMid = RemoteTestModule.getMyVmid();
        ClientVmInfo targetVm = new ClientVmInfo(new Integer(myVMid), RemoteTestModule.getMyClientName(), null);
        Log.getLogWriter().info("rebalancingStarted: " + aRegion.getName() + " rebalancing VM " + targetVm.toString());
        RebalanceBB.getBB().getSharedMap().put(RebalanceBB.targetVmInfo, targetVm);
        Object object = RebalanceTest.listenerSyncObject;
        synchronized (object) {
            Log.getLogWriter().info("Notifying listenerSyncObject with rebalancingFinished for Vm = " + targetVm.toString());
            RebalanceTest.listenerSyncObject.notify();
        }
    }

    protected static ClientVmInfo getClientVmInfo(String host, int pid) {
        Integer vmid = null;
        try {
            vmid = RemoteTestModule.Master.getVmid(host, pid);
        }
        catch (RemoteException e) {
            throw new TestException("Could not convert dm host and pid to vmid, caught Exception " + e);
        }
        if (vmid == null) {
            Log.getLogWriter().info("HAResourceObserver cannot get vmId for host " + host + " and PID " + pid + ", returning null");
            return null;
        }
        return new ClientVmInfo(vmid);
    }

    public String toString() {
        return new String("HAResourceObserver");
    }
}

