/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.PartitionDescription;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Set;
import parReg.KnownKeysTest;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import rebalance.RebalancePrms;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class ColocatedRecoveryTest
extends KnownKeysTest {
    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            testInstance = new ColocatedRecoveryTest();
            ((ColocatedRecoveryTest)testInstance).initInstance(ConfigPrms.getRegionConfig());
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new ColocatedRecoveryTest();
            ((ColocatedRecoveryTest)testInstance).initInstance(ConfigPrms.getRegionConfig());
            if (isBridgeConfiguration) {
                Cache myCache = CacheHelper.getCache();
                Set rootRegions = myCache.rootRegions();
                for (Region aRegion : rootRegions) {
                    ParRegUtil.registerInterest(ColocatedRecoveryTest.testInstance.aRegion);
                }
            }
        }
    }

    @Override
    public void initInstance(String regionConfig) {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        this.highAvailability = TestConfig.tab().booleanAt(ParRegPrms.highAvailability, false);
        Cache myCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        InternalResourceManager.ResourceObserver ro = ParRegPrms.getResourceObserver();
        if (ro != null) {
            InternalResourceManager rm = InternalResourceManager.getInternalResourceManager((Cache)myCache);
            InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)ro);
        }
        AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
        RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
        String regionBase = rd.getRegionName();
        PartitionDescription pd = rd.getPartitionDescription();
        PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
        PartitionAttributes prAttrs = null;
        String colocatedWith = null;
        int numRegions = RebalancePrms.getNumRegions();
        for (int i = 0; i < numRegions; ++i) {
            String regionName = regionBase + "_" + (i + 1);
            if (i > 0) {
                colocatedWith = regionBase + "_" + i;
                prFactory.setColocatedWith(colocatedWith);
                prAttrs = prFactory.create();
                aFactory.setPartitionAttributes(prAttrs);
            }
            RegionHelper.createRegion(regionName, aFactory);
        }
        isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
    }

    public static void HydraTask_loadRegions() {
        ((ColocatedRecoveryTest)testInstance).loadRegions();
    }

    protected void loadRegions() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, for Region shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate;
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            Object value = this.getValueToAdd(key);
            try {
                Set rootRegions = CacheHelper.getCache().rootRegions();
                for (Region aRegion : rootRegions) {
                    aRegion.put((Object)key, value);
                }
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + " out of " + numKeysToCreate);
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }
}

