/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import hydra.FileUtil;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterProxyIF;
import hydra.ProcessMgr;
import hydra.RmiRegistryHelper;
import java.util.Properties;
import rebalance.RebalanceBB;

public class CacheServerListener
extends CacheListenerAdapter
implements Declarable {
    public static MasterProxyIF Master = null;
    protected static LogWriter log = null;

    public void init(Properties prop) {
    }

    static {
        try {
            Log.getLogWriter();
        }
        catch (HydraRuntimeException e) {
            String logName = "cacheserver_" + ProcessMgr.getProcessId();
            log = Log.createLogWriter(logName, "info");
        }
        String cacheServerDir = System.getProperty("user.dir");
        String testDir = FileUtil.pathFor(cacheServerDir);
        System.setProperty("test.dir", testDir);
        if (Master == null) {
            Master = RmiRegistryHelper.lookupMaster();
        }
        Log.getLogWriter().info("CacheServerListener installing ResourceObserver");
        InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new InternalResourceManager.ResourceObserverAdapter(){

            public void rebalancingOrRecoveryStarted(Region aRegion) {
                Log.getLogWriter().info("CacheServerListener ResourceObserver.rebalanceStarted() for Region " + aRegion.getName());
            }

            public void rebalancingOrRecoveryFinished(Region aRegion) {
                Log.getLogWriter().info("CacheServerListener ResourceObserver.rebalanceFinished() for Region " + aRegion.getName());
                RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.recoveryRegionCount);
            }
        });
        Log.getLogWriter().info("CacheServerListener installed ResourceObserver");
    }
}

