/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import quickstart.GoldenComparator;
import quickstart.GoldenStringComparator;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class PassJUnitTest
extends QuickstartTestCase {
    private ProcessWrapper process;

    public PassJUnitTest() {
        super("PassJUnitTest");
    }

    @Override
    protected GoldenComparator createGoldenComparator() {
        return new GoldenStringComparator(this.expectedProblemLines());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void testPass() throws InterruptedException, IOException {
        this.process = new ProcessWrapper(((Object)((Object)this)).getClass());
        this.process.execute(this.createProperties());
        PassJUnitTest.assertTrue((boolean)this.process.isAlive());
        this.process.waitForOutputToMatch("Begin " + this.name() + "\\.main");
        this.process.waitForOutputToMatch("Press Enter to continue\\.");
        this.process.sendInput();
        this.process.waitForOutputToMatch("End " + this.name() + "\\.main");
        this.process.waitFor();
        this.printProcessOutput(this.process);
        String goldenString = "Begin " + this.name() + ".main\nPress Enter to continue.\nEnd " + this.name() + ".main\n";
        this.assertOutputMatchesGoldenFile(this.process, goldenString);
        PassJUnitTest.assertFalse((boolean)this.process.isAlive());
        PassJUnitTest.assertFalse((boolean)this.process.getStandardOutReader().isAlive());
        PassJUnitTest.assertFalse((boolean)this.process.getStandardErrorReader().isAlive());
    }

    void execute() throws IOException {
        System.out.println("Begin " + this.name() + ".main");
        System.out.println("Press Enter to continue.");
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        inputReader.readLine();
        System.out.println("End " + this.name() + ".main");
    }

    public static void main(String[] args) throws Exception {
        new PassJUnitTest().execute();
    }
}

