/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.io.File;
import java.util.Arrays;
import quickstart.DataOverflow;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class DataOverflowTest
extends QuickstartTestCase {
    private ProcessWrapper process;

    public DataOverflowTest(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void testDataOverflow() throws Exception {
        File overflowDir = new File("overflowData1");
        overflowDir.mkdir();
        DataOverflowTest.getLogWriter().info("[testDataOverflow] start up DataOverflow");
        this.process = new ProcessWrapper(DataOverflow.class);
        this.process.execute(this.createProperties());
        this.process.waitForOutputToMatch("Press Enter in this shell to continue\\.");
        DataOverflowTest.assertTrue((String)"overflowDir is missing", (boolean)overflowDir.exists());
        File dbFile = new File(overflowDir, "DRLK_IFds1.lk");
        DataOverflowTest.assertTrue((String)(dbFile + " is missing files=" + Arrays.asList(overflowDir.list())), (boolean)dbFile.exists());
        this.process.sendInput();
        this.process.waitForOutputToMatch("Press Enter in this shell to continue\\.");
        this.process.sendInput();
        DataOverflowTest.getLogWriter().info("[testDataOverflow] joining to DataOverflow");
        this.process.waitFor();
        this.printProcessOutput(this.process);
        DataOverflowTest.assertFalse((String)(dbFile.toString() + " still exists"), (boolean)dbFile.exists());
        this.assertOutputMatchesGoldenFile(this.process.getOutput(), "DataOverflow.txt");
        overflowDir.delete();
    }
}

