/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import java.util.Properties;
import quickstart.CqClient;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class CqClientTest
extends QuickstartTestCase {
    protected ProcessWrapper clientVM;
    protected ProcessWrapper serverVM;

    public CqClientTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.clientVM != null) {
            this.clientVM.destroy();
        }
        if (this.serverVM != null) {
            this.serverVM.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testCqClient() throws Exception {
        boolean serverStarted = false;
        try {
            CqClientTest.getLogWriter().info("[testCqClient] start the server");
            String[] args = new String[]{"start", "cache-xml-file=xml/CqServer.xml", "-J-Dgemfire.mcast-port=0", "-J-Dgemfire.log-level=fine"};
            this.serverVM = new ProcessWrapper(CacheServerLauncher.class, args, false);
            this.serverVM.execute();
            this.serverVM.waitForOutputToMatch("CacheServer pid: [0-9]* status: running");
            this.serverVM.waitFor();
            CqClientTest.getLogWriter().info("[testCqClient] server started");
            serverStarted = true;
            CqClientTest.getLogWriter().info("[testCqClient] start up CqClient");
            this.clientVM = new ProcessWrapper(CqClient.class);
            Properties clientProps = this.createProperties();
            this.clientVM.execute(clientProps);
            CqClientTest.getLogWriter().info("[testCqClient] waiting for 1st \"Press Enter to continue.\"");
            this.clientVM.waitForOutputToMatch("Press Enter to continue.");
            this.clientVM.sendInput();
            CqClientTest.getLogWriter().info("[testCqClient] waiting for 2nd \"Press Enter to continue.\"");
            this.clientVM.waitForOutputToMatch("Press Enter to continue.");
            this.clientVM.sendInput();
            CqClientTest.getLogWriter().info("[testCqClient] waiting for 3rd \"Press Enter to continue.\"");
            this.clientVM.waitForOutputToMatch("Press Enter to continue.");
            this.clientVM.sendInput();
            CqClientTest.getLogWriter().info("[testCqClient] waiting for 4th \"Press Enter to continue.\"");
            this.clientVM.waitForOutputToMatch("Press Enter to continue.");
            this.clientVM.sendInput();
            CqClientTest.getLogWriter().info("[testCqClient] waiting for 5th \"Press Enter to continue.\"");
            this.clientVM.waitForOutputToMatch("Press Enter to continue.");
            this.clientVM.sendInput();
            CqClientTest.getLogWriter().info("[testCqClient] joining to CqClient");
            this.clientVM.waitFor();
            this.printProcessOutput(this.clientVM);
            this.assertOutputMatchesGoldenFile(this.clientVM.getOutput(), "CqClient.txt");
            if (!serverStarted) return;
        }
        catch (Throwable throwable) {
            if (!serverStarted) throw throwable;
            ProcessWrapper stop = new ProcessWrapper(CacheServerLauncher.class, new String[]{"stop"});
            stop.execute();
            stop.waitForOutputToMatch("The CacheServer has stopped\\.");
            stop.waitFor();
            throw throwable;
        }
        ProcessWrapper stop = new ProcessWrapper(CacheServerLauncher.class, new String[]{"stop"});
        stop.execute();
        stop.waitForOutputToMatch("The CacheServer has stopped\\.");
        stop.waitFor();
    }
}

