/*
 * Decompiled with CFR 0.152.
 */
package query.context;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import query.context.QueryFunctionContextBB;

public class QueryFunction
extends FunctionAdapter {
    public void execute(FunctionContext context) {
        Log.getLogWriter().info("QueryFunction.execute()::Executing QueryFunction on context ");
        String regionName = "QueryRegion";
        Cache cache = CacheFactory.getAnyInstance();
        try {
            PartitionedRegion region1 = (PartitionedRegion)CacheFactory.getAnyInstance().getRegion("QueryRegion1");
            if (region1 != null) {
                List bIds = region1.getLocalBucketsListTestOnly();
                Log.getLogWriter().info("Server-side region contents - Local Bucket IDs for QueryRegion1 ::::" + bIds.toString());
                for (Object key : bIds) {
                    BucketRegion br = region1.getBucketRegion(key);
                    if (br != null) {
                        Log.getLogWriter().info("Server-side region contents -Bucket ID for bucket region: " + br.getId());
                        Log.getLogWriter().info("Server-side region contents - Keys in the bucket region for key " + key + ": " + br.keySet().toString());
                        continue;
                    }
                    Log.getLogWriter().info("Server-side region contents  Bucket region not found for key:" + key);
                }
            }
        }
        catch (Exception region1) {
            // empty catch block
        }
        QueryService queryService = cache.getQueryService();
        ArrayList allQueryResults = new ArrayList();
        ArrayList arguments = (ArrayList)context.getArguments();
        String qstr = (String)arguments.get(0);
        Object initiatingThreadID = arguments.get(1);
        String aStr = "In execute with context " + context + " with query " + qstr + " initiated in hydra thread thr_" + initiatingThreadID + "_";
        for (int i = 2; i < arguments.size(); ++i) {
            aStr = aStr + " additional arg: " + arguments.get(i);
        }
        Log.getLogWriter().info(aStr);
        PartitionedRegion region = (PartitionedRegion)CacheFactory.getAnyInstance().getRegion(regionName);
        Log.getLogWriter().info("QueryFunction.execute()::Executing query:: " + qstr);
        try {
            Query query = queryService.newQuery(qstr);
            SelectResults result = (SelectResults)query.execute((RegionFunctionContext)context);
            Log.getLogWriter().info("QueryFunction.execute()::Context arguments :: " + context.getArguments().toString());
            Set filter = ((RegionFunctionContext)context).getFilter();
            if (filter != null) {
                Log.getLogWriter().info("QueryFunction.execute()::Context FILTER on server side :: " + filter.toString());
            }
            SharedCounters counters = QueryFunctionContextBB.getBB().getSharedCounters();
            counters.increment(QueryFunctionContextBB.NUM_NODES);
            ArrayList arrayResult = (ArrayList)result.asList();
            context.getResultSender().sendResult((Object)((ArrayList)result.asList()));
            context.getResultSender().lastResult(null);
        }
        catch (Exception e) {
            throw new FunctionException((Throwable)e);
        }
    }

    public String getId() {
        return "QueryFunction";
    }
}

