/*
 * Decompiled with CFR 0.152.
 */
package query;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.Utils;
import com.gemstone.gemfire.cache.query.functional.StructSetOrResultsSet;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.pdx.PdxInstance;
import event.ETListener;
import event.EventBB;
import event.EventPrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import objects.ConfigurableObject;
import objects.ObjectHelper;
import objects.Portfolio;
import parReg.ParRegUtil;
import pdx.PdxETListener;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import query.QueryBB;
import query.QueryPrms;
import query.QueryValidator;
import query.index.IndexBB;
import query.index.IndexTest;
import util.BaseValueHolder;
import util.CacheBB;
import util.CacheUtil;
import util.EventCountersBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class QueryTest {
    protected static QueryTest queryTest;
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int QUERY_OPERATION = 8;
    protected static final int CREATE_INDEX_OPERATION = 9;
    protected static final int REMOVE_INDEX_OPERATION = 10;
    protected static final int COUNT_QUERY_OPERATION = 11;
    protected static final int PDXSTRING_QUERY_OPERATION = 12;
    public static final String ID_COMPACT_RANGE_INDEX = "idCompactRangeIndex";
    public static final String STATUS_COMPACT_RANGE_INDEX = "statusCompactRangeIndex";
    public static final String ID_HASH_INDEX = "idHashIndex";
    public static final String STATUS_HASH_INDEX = "statusHashIndex";
    public static final String ID_RANGE_INDEX = "idRangeIndex";
    public static final String STATUS_RANGE_INDEX = "statusRangeIndex";
    public static final String MAP_RANGE_INDEX_1 = "mapRangeIndex1";
    public static final String MAP_RANGE_INDEX_2 = "mapRangeIndex2";
    protected static final String enumWhereClause1 = " where aDay.name = 'Wednesday'";
    protected static final String enumWhereClause2 = " where aDay = null";
    protected static boolean pdxReadSerialized;
    protected static boolean statisticsWrittenToBB;
    protected static HydraThreadLocal origClassLoader;
    protected int numOfRegions;
    protected boolean isSerialExecution;
    protected boolean isCarefulValidation = false;
    protected boolean ignoreQueryExecTimeOutException;
    protected int queryLimit = -1;
    public static final int MILLIS_TO_WAIT = 60000;
    protected int numVMs;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected RandomValues randomValues = null;
    protected boolean useEvictionController;
    protected int maxObjects;
    protected DistributedLockService distLockService;
    protected boolean isMirrored;
    protected int[][] countQueryResults;
    public Pool pool;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static AtomicLong numQueries;
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    public static final String REGION_NAME = "QueryRegion";
    protected static final String REGION_WITHOUT_INDEX = "noIndex";

    public static synchronized void HydraTask_initialize() {
        if (queryTest == null) {
            boolean isBridgeConfiguration;
            queryTest = new QueryTest();
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            Log.getLogWriter().info("gfd.getSysDirName()::" + gfd.getSysDirName());
            Log.getLogWriter().info("gfd.getSystemDirectoryStr()::" + gfd.getSystemDirectoryStr());
            Log.getLogWriter().info("gfd.getSystemDirectory():: " + gfd.getSystemDirectory());
            queryTest.initialize();
            boolean bl = isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initialize_xml() {
        if (queryTest == null) {
            boolean isBridgeConfiguration;
            queryTest = new QueryTest();
            String xmlFilename = TestConfig.tasktab().stringAt(QueryPrms.xmlFilename, TestConfig.tab().stringAt(QueryPrms.xmlFilename, null));
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            Log.getLogWriter().info("gfd.getSysDirName()::" + gfd.getSysDirName());
            String baseDir = gfd.getSysDirName();
            baseDir = baseDir.substring(0, baseDir.lastIndexOf(File.separator));
            xmlFilename = xmlFilename.substring(0, xmlFilename.indexOf("."));
            int myId = RemoteTestModule.getMyVmid();
            Log.getLogWriter().info("My Id = " + myId);
            FileUtil.mkdir(baseDir + File.separator + "queryDiskStore" + myId);
            queryTest.initialize(xmlFilename + myId + ".xml");
            boolean bl = isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initialize_clientCache() {
        if (queryTest == null) {
            queryTest = new QueryTest();
            queryTest.initialize_clientCache();
        }
    }

    public void initialize_clientCache() {
        String poolConfigName;
        Cache myCache = CacheHelper.createCache("cache1");
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        String regDescriptName = "accessorRegion";
        PoolDescription poolDescript = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
        ParRegUtil.createDiskStoreIfNecessary(regDescriptName);
        RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
        String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
        if (poolDescript != null && (poolConfigName = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription().getName()) != null) {
            this.pool = PoolHelper.createPool(poolConfigName);
            this.pool.getQueryService();
        }
        Region aRegion = CacheHelper.getCache().createRegion(regionName, attr);
        ParRegUtil.registerInterest(aRegion);
    }

    public void initialize() {
        String xmlFilename = TestConfig.tasktab().stringAt(QueryPrms.xmlFilename, TestConfig.tab().stringAt(QueryPrms.xmlFilename, null));
        this.initialize(xmlFilename);
    }

    public void initialize(String xmlFilename) {
        this.numOfRegions = TestConfig.getInstance().getRegionDescriptions().size();
        this.numOfRegions = this.numOfRegions == 0 ? 1 : this.numOfRegions;
        this.ignoreQueryExecTimeOutException = TestConfig.tab().booleanAt(QueryPrms.ignoreTimeOutException, false);
        Log.getLogWriter().info("Num of regions::" + this.numOfRegions);
        if (xmlFilename != null) {
            this.createCacheFromXml(xmlFilename);
            CacheUtil.setCache(CacheHelper.getCache());
        } else {
            this.createRootRegions();
        }
        pdxReadSerialized = CacheHelper.getCache().getPdxReadSerialized();
        this.isSerialExecution = EventBB.isSerialExecution();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.queryLimit = TestConfig.tab().intAt(QueryPrms.queryLimit, -1);
        this.numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                this.numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            this.numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        Log.getLogWriter().info("numVMs is " + this.numVMs);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        this.randomValues = new RandomValues();
        if (xmlFilename == null) {
            QueryTest.createLockService();
        }
        EventBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
    }

    public static synchronized void HydraTask_initialize_withIndexTestHook() {
        class IndexTestHook
        implements IndexManager.TestHook {
            public boolean indexCreatedAsPartOfGII;

            IndexTestHook() {
            }

            public void hook(int spot) throws RuntimeException {
                if (spot == 1) {
                    throw new RuntimeException("Index is not created as part of Region GII.");
                }
            }
        }
        IndexManager.testHook = new IndexTestHook();
        QueryTest.HydraTask_initialize();
        queryTest.validateIndexPresence();
    }

    private void validateIndexPresence() {
        String[] regions = new String[]{"QueryRegion0", "QueryRegion1", "QueryRegion2"};
        Cache c = CacheUtil.getCache();
        for (int i = 0; i < regions.length; ++i) {
            Region r = c.getRegion(regions[i]);
            int numIndexes = r.getRegionService().getQueryService().getIndexes(r).size();
            if (numIndexes == 2) continue;
            throw new TestException("Expected number of indexes not found with region " + r.getName() + ", expected: 2 but found:" + numIndexes);
        }
    }

    static synchronized void createLockService() {
        if (QueryTest.queryTest.distLockService == null) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            QueryTest.queryTest.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static void HydraTask_load() {
        long lastLogTime;
        long LOG_INTERVAL_MILLIS = 10000L;
        long startTime = lastLogTime = System.currentTimeMillis();
        int regionNumber = 0;
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        do {
            regionNumber = new Random().nextInt(QueryTest.queryTest.numOfRegions);
            regionNumber = (regionNumber + 1) % QueryTest.queryTest.numOfRegions;
            Region aRegion = (Region)regionList.get(regionNumber);
            HashMap<String, Object> aMap = new HashMap<String, Object>();
            for (int i = 1; i <= 100; ++i) {
                String name = NameFactory.getNextPositiveObjectNameInLimit(QueryTest.queryTest.maxObjects);
                aMap.put(name, queryTest.getObjectToAdd(name));
            }
            aRegion.putAll(aMap);
            aMap = null;
            long entries = NameFactory.getPositiveNameCounter();
            if (entries >= (long)QueryTest.queryTest.maxObjects) {
                TestHelper.checkForEventError(EventCountersBB.getBB());
                String aStr = "Done loading " + entries + " entries in " + QueryTest.queryTest.numOfRegions + " regions";
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + entries + " entries out of " + QueryTest.queryTest.maxObjects + " in " + QueryTest.queryTest.numOfRegions + " regions");
            lastLogTime = System.currentTimeMillis();
            TestHelper.checkForEventError(EventCountersBB.getBB());
        } while (System.currentTimeMillis() - startTime < QueryTest.queryTest.minTaskGranularityMS);
    }

    public static void HydraTask_populateRegions() {
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        for (Region aRegion : regionList) {
            HashMap aMap = new HashMap();
            for (int j = 0; j < QueryTest.queryTest.maxObjects; ++j) {
                String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
                Object val = ObjectHelper.createObject(objectType, j);
                aRegion.put((Object)(j + ""), val);
            }
        }
    }

    public static void HydraTask_doEntryAndQueryOperations() {
        origClassLoader.set(Thread.currentThread().getContextClassLoader());
        PdxTest.initClassLoader();
        if (queryTest != null) {
            queryTest.doEntryAndQueryOperations();
        }
    }

    public static void HydraTask_compareQueryResultsBetweenIndexRegions() {
        if (queryTest != null) {
            queryTest.compareQueryResultsBetweenIndexRegions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryAndQueryOperations() {
        regionNumber = new Random().nextInt(this.numOfRegions);
        aRegion = CacheHelper.getCache().getRegion("QueryRegion" + "" + regionNumber);
        startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            QueryTest.logExecutionNumber();
        }
        isMirrored = aRegion.getAttributes().getMirrorType().isMirrored();
        haveALock = false;
        block17: do {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            useRandomLocks = TestConfig.tab().booleanAt(EventPrms.useRandomLocks);
            if (useRandomLocks) {
                Log.getLogWriter().info("Trying to get distributed lock " + QueryTest.LOCK_NAME + "...");
                haveALock = this.distLockService.lock((Object)QueryTest.LOCK_NAME, -1L, -1L);
                Log.getLogWriter().info("Returned from trying to get distributed lock " + QueryTest.LOCK_NAME + ", lock acquired is " + haveALock);
                if (haveALock) {
                    Log.getLogWriter().info("Obtained distributed lock " + QueryTest.LOCK_NAME);
                }
            }
            try {
                QueryBB.putQueryValidator(new QueryValidator());
                whichOp = this.getOperation(QueryPrms.entryAndQueryOperations, isMirrored);
                switch (whichOp) {
                    case 1: {
                        this.addObject(aRegion, true);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl25:
                        // 1 sources

                        continue block17;
                    }
                    case 3: {
                        this.invalidateObject(aRegion, false);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl30:
                        // 1 sources

                        continue block17;
                    }
                    case 4: {
                        this.destroyObject(aRegion, false);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl35:
                        // 1 sources

                        continue block17;
                    }
                    case 2: {
                        this.updateObject(aRegion);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl40:
                        // 1 sources

                        continue block17;
                    }
                    case 5: {
                        this.readObject(aRegion);
                        ** break;
lbl44:
                        // 1 sources

                        continue block17;
                    }
                    case 6: {
                        this.invalidateObject(aRegion, true);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl49:
                        // 1 sources

                        continue block17;
                    }
                    case 7: {
                        this.destroyObject(aRegion, true);
                        QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_REGION_OPS);
                        ** break;
lbl54:
                        // 1 sources

                        continue block17;
                    }
                    case 8: {
                        this.doQuery(true);
                        ** break;
lbl58:
                        // 1 sources

                        continue block17;
                    }
                    case 11: {
                        this.doCountQuery(true);
                        ** break;
lbl62:
                        // 1 sources

                        continue block17;
                    }
                    case 9: {
                        this.createIndex();
                        ** break;
lbl66:
                        // 1 sources

                        continue block17;
                    }
                    case 10: {
                        this.removeIndex();
                        ** break;
lbl70:
                        // 1 sources

                        continue block17;
                    }
                    case 12: {
                        this.doPdxStringQuery();
                        ** break;
lbl74:
                        // 1 sources

                        continue block17;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            finally {
                if (haveALock) {
                    haveALock = false;
                    this.distLockService.unlock((Object)QueryTest.LOCK_NAME);
                    Log.getLogWriter().info("Released distributed lock " + QueryTest.LOCK_NAME);
                }
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected void compareQueryResultsBetweenIndexRegions() {
        String[] regions = new String[]{"QueryRegion0", "QueryRegion1", "QueryRegion2"};
        Cache c = CacheUtil.getCache();
        String qStr = "SELECT * FROM /";
        String[] filter = new String[]{" p where p.ID > 10", " p where p.ID < 10", " p where p.ID = 10", " p where p.status = 'active'", " p where p.status != 'active'", " p where p.status = 'inactive'"};
        for (int x = 0; x < filter.length; ++x) {
            String[] s = new String[2];
            for (int i = 0; i < regions.length; ++i) {
                Query q;
                QueryObserverImpl observer = new QueryObserverImpl();
                QueryObserverHolder.setInstance((QueryObserver)observer);
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                Object[][] sr = new SelectResults[1][2];
                Region r = c.getRegion(regions[i]);
                try {
                    q = r.getRegionService().getQueryService().newQuery(qStr + r.getName() + filter[x]);
                    s[0] = q.getQueryString();
                    Log.getLogWriter().info("Executing query: " + s[0]);
                    sr[0][0] = (SelectResults)q.execute();
                }
                catch (Exception ex) {
                    throw new TestException("Failed to execute the query. Query :" + s[0] + " Exception :" + ex.getMessage(), ex);
                }
                if (!observer.isIndexesUsed) {
                    throw new TestException("Index not used for query. " + s[0]);
                }
                try {
                    q = r.getRegionService().getQueryService().newQuery(qStr + r.getName() + REGION_WITHOUT_INDEX + filter[x]);
                    s[1] = q.getQueryString();
                    sr[0][1] = (SelectResults)q.execute();
                }
                catch (Exception ex) {
                    throw new TestException("Failed to execute the query on no index region.");
                }
                this.compareQueryResultsWithoutAndWithIndexes(sr, 1, false, s);
            }
        }
    }

    public void compareQueryResultsWithoutAndWithIndexes(Object[][] r, int len, boolean checkOrder, String[] queries) {
        Collection coll1 = null;
        Collection coll2 = null;
        Iterator itert1 = null;
        Iterator itert2 = null;
        for (int j = 0; j < len; ++j) {
            ObjectType type1 = ((SelectResults)r[j][0]).getCollectionType().getElementType();
            ObjectType type2 = ((SelectResults)r[j][1]).getCollectionType().getElementType();
            if (!type1.getClass().getName().equals(type2.getClass().getName())) {
                Log.getLogWriter().info("Classes are : " + type1.getClass().getName() + " " + type2.getClass().getName());
                throw new TestException("FAILED:Select result Type is different in both the cases.; failed query=" + queries[j]);
            }
            Log.getLogWriter().info("Both SelectResults are of the same Type i.e.--> " + ((SelectResults)r[j][0]).getCollectionType().getElementType());
            if (((SelectResults)r[j][0]).size() != ((SelectResults)r[j][1]).size()) {
                Log.getLogWriter().info("#### SR[0] : \n" + Utils.printResult((Object)r[j][0]));
                Log.getLogWriter().info("#### SR[1] : \n" + Utils.printResult((Object)r[j][1]));
                throw new TestException("FAILED:SelectResults size is different in both the cases. Size1=" + ((SelectResults)r[j][0]).size() + " Size2 = " + ((SelectResults)r[j][1]).size() + "; failed query=" + queries[j]);
            }
            Log.getLogWriter().info("Both SelectResults are of Same Size i.e.  Size= " + ((SelectResults)r[j][1]).size());
            if (checkOrder) {
                coll2 = ((SelectResults)r[j][1]).asList();
                coll1 = ((SelectResults)r[j][0]).asList();
            } else {
                coll2 = ((SelectResults)r[j][1]).asSet();
                coll1 = ((SelectResults)r[j][0]).asSet();
            }
            itert1 = coll1.iterator();
            itert2 = coll2.iterator();
            while (itert1.hasNext()) {
                Object p1 = itert1.next();
                if (!checkOrder) {
                    itert2 = coll2.iterator();
                }
                boolean exactMatch = false;
                while (itert2.hasNext()) {
                    Object p2 = itert2.next();
                    if (p1 instanceof Struct) {
                        Object[] values2;
                        Object[] values1 = ((Struct)p1).getFieldValues();
                        if (values1.length != (values2 = ((Struct)p2).getFieldValues()).length) {
                            throw new TestException("Struct size is different");
                        }
                        boolean elementEqual = true;
                        for (int i = 0; i < values1.length; ++i) {
                            elementEqual = elementEqual && (values1[i] == values2[i] || values1[i].equals(values2[i]));
                        }
                        exactMatch = elementEqual;
                    } else {
                        boolean bl = exactMatch = p2 == p1 || p2.equals(p1);
                    }
                    if (!exactMatch && !checkOrder) continue;
                    break;
                }
                if (exactMatch) continue;
                throw new TestException("Atleast one element in the pair of SelectResults supposedly identical, is not equal ; failed query=" + queries[j]);
            }
        }
    }

    protected void createIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.createIndex(REGION_NAME + "" + regionNumber);
    }

    protected void createIndex_task() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        IndexTest indexTest = new IndexTest();
        for (int i = 0; i < this.numOfRegions; ++i) {
            indexTest.createIndex(i);
        }
    }

    protected void removeIndex() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType, "");
        IndexTest indexTest = new IndexTest();
        int regionNumber = new Random().nextInt(this.numOfRegions);
        indexTest.removeIndex(REGION_NAME + "" + regionNumber);
    }

    protected void addObject(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectNameInLimit(this.maxObjects);
        Object anObj = this.getObjectToAdd(name);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
            QueryBB.putQueryValidator(new QueryValidator("add", name, true, true, anObj));
            Region rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX);
            if (rWithoutIndex != null) {
                rWithoutIndex.put((Object)name, anObj, (Object)callback);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numPut = EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
    }

    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object name = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get name from region");
            return;
        }
        name = it.next();
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                Region rWithoutIndex;
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    long numInvalidate = EventBB.incrementCounter("EventBB.NUM_LOCAL_INVALIDATE", EventBB.NUM_LOCAL_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("localInvalidate", name, true, false, null));
                }
                if ((rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX)) != null) {
                    rWithoutIndex.localInvalidate(name, (Object)callback);
                }
            } else {
                Region rWithoutIndex;
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    long numInvalidate = EventBB.incrementCounter("EventBB.NUM_INVALIDATE", EventBB.NUM_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("invalidate", name, true, false, null));
                }
                if ((rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX)) != null) {
                    rWithoutIndex.invalidate(name, (Object)callback);
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                long numDestroy = EventBB.incrementCounter("EventBB.NUM_LOCAL_DESTROY", EventBB.NUM_LOCAL_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("localDestroy", name, false, false, null));
                Region rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX);
                if (rWithoutIndex != null) {
                    rWithoutIndex.localDestroy(name, (Object)callback);
                }
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                long numDestroy = EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("destroy", name, false, false, null));
                Region rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX);
                if (rWithoutIndex != null) {
                    rWithoutIndex.destroy(name, (Object)callback);
                }
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = iter.next();
        this.updateObject(aRegion, name);
    }

    protected void updateObject(Region aRegion, Object name) {
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
            Region rWithoutIndex = aRegion.getCache().getRegion(aRegion.getName() + REGION_WITHOUT_INDEX);
            if (rWithoutIndex != null) {
                rWithoutIndex.put(name, newObj, (Object)callback);
            }
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        QueryBB.putQueryValidator(new QueryValidator("update", name, true, true, newObj));
        long numUpdate = EventBB.incrementCounter("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE);
    }

    protected void readObject(Region aRegion) {
        Object anObj;
        Set aSet = aRegion.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        QueryBB.putQueryValidator(new QueryValidator("read", name, true, true, anObj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuery(boolean logAddition) {
        boolean aboveThresholdRegionSize;
        String[] queries = null;
        int threshold = 30000;
        String regionName1 = this.randRgn();
        Region region1 = RegionHelper.getRegion(regionName1);
        String regionName2 = this.randRgn();
        Region region2 = RegionHelper.getRegion(regionName2);
        String regionName3 = this.randRgn();
        Region region3 = RegionHelper.getRegion(regionName3);
        boolean isPdxTest = TestConfig.tab().stringAt(QueryPrms.objectType).indexOf("VersionedPortfolio") >= 0;
        boolean isPartitioned = region1 instanceof PartitionedRegion || region2 instanceof PartitionedRegion || region3 instanceof PartitionedRegion;
        boolean bl = aboveThresholdRegionSize = this.maxObjects > 30000 && this.queryLimit == -1;
        if (aboveThresholdRegionSize) {
            queries = isPdxTest ? new String[]{"select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where ID <= 500", "select distinct * from " + regionName1 + " where ID <= 1000", "select distinct * from " + regionName1 + " where pdxID = 0", "select distinct * from " + regionName1 + " where pdxID <= 500", "select distinct * from " + regionName1 + " where pdxID <= 1000", "select distinct * from " + regionName1 + " where ID = 0 and pdxID = 0", "select distinct * from " + regionName1 + " where ID <= 500 and pdxID <= 500", "select distinct * from " + regionName1 + " where ID <= 1000 and pdxID <= 1000"} : new String[]{"select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where ID <= 500", "select distinct * from " + regionName1 + " where ID <= 800", "select distinct * from " + regionName1 + " where ID <= 1000"};
        } else if (isPdxTest) {
            queries = new String[]{"select distinct * from " + regionName1 + enumWhereClause1, "select distinct * from " + regionName1 + enumWhereClause2, "select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where status = 'active'", "select distinct * from " + regionName1 + ", " + regionName2, "select distinct * from " + regionName1 + " where ID != 0 AND status = 'active'", "select distinct * from " + regionName1 + " where pdxID = 0", "select distinct * from " + regionName1 + " where pdxStatus = 'active'", "select distinct * from " + regionName1 + " where pdxID != 0 AND pdxStatus = 'active'", "select distinct * from " + regionName1 + " where ID = 0 and pdxID = 0", "select distinct * from " + regionName1 + " where status = 'active' and pdxID = 'active'", "select distinct * from " + regionName1 + " where (ID != 0) AND (pdxID != 0) and (status = 'active') and (pdxStatus = 'active')"};
            if (isPartitioned) {
                queries = new String[]{"select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where status = 'active'", "select distinct * from " + regionName1 + " where ID != 0 AND status = 'active'", "select distinct * from " + regionName1 + " where pdxID = 0", "select distinct * from " + regionName1 + " where pdxStatus = 'active'", "select distinct * from " + regionName1 + " where pdxID != 0 AND pdxStatus = 'active'", "select distinct * from " + regionName1 + " where ID = 0 and pdxID = 0", "select distinct * from " + regionName1 + " where status = 'active' and pdxID = 'active'", "select distinct * from " + regionName1 + " where (ID != 0) AND (pdxID != 0) and (status = 'active') and (pdxStatus = 'active')"};
            }
        } else {
            queries = new String[]{"select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where status = 'active'", "select distinct * from " + regionName1 + " where ID != 0 AND status = 'active'", "select distinct * from " + regionName1 + ", " + regionName2, "select distinct * from " + regionName1 + " pf1, " + regionName2 + " pf2 where pf1.ID != 0 AND pf2.status = 'active'"};
            if (isPartitioned) {
                queries = new String[]{"select distinct * from " + regionName1 + " where ID = 0", "select distinct * from " + regionName1 + " where status = 'active'", "select distinct * from " + regionName1 + " where ID != 0 AND status = 'active'"};
            }
        }
        if (this.queryLimit != -1) {
            int q = 0;
            while (q < queries.length) {
                int n = q++;
                queries[n] = queries[n] + " limit " + this.queryLimit;
            }
        }
        for (int i = 0; i < queries.length; ++i) {
            Log.getLogWriter().info(" query = " + queries[i]);
            Query query = CacheHelper.getCache().getQueryService().newQuery(queries[i]);
            try {
                int portfolioInStructCount;
                int portfolioCount;
                int structCount;
                ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
                if (pdxReadSerialized) {
                    Log.getLogWriter().info("Setting class loader to remove domain classes in preparation of a query execute: " + origClassLoader.get());
                    Thread.currentThread().setContextClassLoader((ClassLoader)origClassLoader.get());
                }
                Object result = null;
                try {
                    Cache theCache = CacheHelper.getCache();
                    if (theCache != null) {
                        Log.getLogWriter().info("Clearing the pdx registry with a test hook");
                        ((GemFireCacheImpl)theCache).getPdxRegistry().flushCache();
                    }
                    Log.getLogWriter().info("Executing query " + queries[i]);
                    long start = System.nanoTime();
                    result = query.execute();
                    QueryBB.getBB().getSharedCounters().add(QueryBB.TOTAL_QUERY_EXEC_TIME, System.nanoTime() - start);
                    QueryBB.getBB().getSharedCounters().increment(QueryBB.NUM_QUERY_EXECS);
                    IndexBB.getBB().getSharedCounters().increment(IndexBB.TOTAL_USES);
                    Log.getLogWriter().info("Done executing queryNum:" + numQueries.incrementAndGet() + ": " + queries[i]);
                    if (!isPdxTest) {
                        QueryTest.verifySanityForQueryResultsNonPdx(i, aboveThresholdRegionSize, (SelectResults)result, queries[i]);
                    }
                }
                catch (QueryExecutionTimeoutException e1) {
                    if (!this.ignoreQueryExecTimeOutException) {
                        throw e1;
                    }
                    Log.getLogWriter().info("Caught and ignored QueryExecutionTimeoutException:  " + e1.getMessage());
                    return;
                }
                finally {
                    if (pdxReadSerialized) {
                        Log.getLogWriter().info("Setting class loader back to one that refers to domain classes: " + previousCL);
                        Thread.currentThread().setContextClassLoader(previousCL);
                    }
                }
                this.validateQueryLimit(result);
                if (result != null && result instanceof Collection) {
                    Collection coll = (Collection)result;
                    Log.getLogWriter().info("Size of result is :" + coll.size());
                    if (this.isSerialExecution) {
                        this.validatePdxQuery(queries[i], coll);
                    }
                    structCount = 0;
                    portfolioCount = 0;
                    portfolioInStructCount = 0;
                    for (Object resultElement : coll) {
                        if (resultElement instanceof PdxInstance) {
                            resultElement = PdxTestVersionHelper.toBaseObject(resultElement);
                        }
                        if (resultElement instanceof Struct) {
                            Object[] fieldValues;
                            ++structCount;
                            Struct aStruct = (Struct)resultElement;
                            for (Object aValue : fieldValues = aStruct.getFieldValues()) {
                                ++portfolioInStructCount;
                                if (aValue instanceof PdxInstance) {
                                    aValue = PdxTestVersionHelper.toBaseObject(aValue);
                                }
                                if (!(aValue instanceof Portfolio)) {
                                    throw new TestException("Query result contains struct that contains unexpected element: " + aValue + ", struct element is of class " + aValue.getClass().getName());
                                }
                                aValue.toString();
                            }
                            continue;
                        }
                        if (resultElement instanceof Portfolio) {
                            ++portfolioCount;
                            continue;
                        }
                        throw new TestException("Query result element is unexpected: " + resultElement + ", result element is of class " + resultElement.getClass().getName());
                    }
                } else {
                    throw new TestException("Result of query is " + result + " of class " + result.getClass().getName() + ", but expected a Collection");
                }
                Log.getLogWriter().info("Result of query contained " + portfolioCount + " Portfolio objects, " + structCount + " structs with all structs containing " + portfolioInStructCount + " Portfolio objects; total number of Portfolio objects: " + (portfolioCount + portfolioInStructCount));
                continue;
            }
            catch (Exception e) {
                throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
            }
        }
    }

    static void verifySanityForQueryResultsNonPdx(int queryNum, boolean aboveThresholdRegionSize, SelectResults results, String queryStr) {
        if (aboveThresholdRegionSize) {
            int[] id = new int[]{0, 500, 800, 1000};
            QueryTest.sanityCheckUsingId(results, id[queryNum], queryStr);
        } else if (queryNum == 0) {
            QueryTest.sanityCheckUsingId(results, 0, queryStr);
        } else if (queryNum == 1) {
            QueryTest.sanityCheckUsingStatusAndId(results, -1, "active", queryStr);
        } else if (queryNum == 2) {
            QueryTest.sanityCheckUsingStatusAndId(results, 0, "active", queryStr);
        } else {
            for (Object resultElement : results) {
                if (resultElement instanceof Struct) {
                    Object[] fieldValues;
                    Struct aStruct = (Struct)resultElement;
                    for (Object aValue : fieldValues = aStruct.getFieldValues()) {
                        if (aValue instanceof Portfolio) continue;
                        throw new TestException("Query result contains struct that contains unexpected element: " + aValue + ", struct element is of class " + aValue.getClass().getName());
                    }
                    if (queryNum != 4) continue;
                    Portfolio pf1 = (Portfolio)fieldValues[0];
                    Portfolio pf2 = (Portfolio)fieldValues[1];
                    if (pf1.ID == 0) {
                        throw new TestException("Sanity check failed for query: " + queryStr + " Expected pf1.ID to be != " + 0 + " for all objects but found to be 0 ");
                    }
                    if (pf2.status.equals("active")) continue;
                    throw new TestException("Sanity check failed for query: " + queryStr + " Expected pf2.status to be 'active'  for all objects but found: " + pf2.status);
                }
                throw new TestException("Query result element is unexpected: " + resultElement + ", result element is of class " + resultElement.getClass().getName());
            }
        }
    }

    static void sanityCheckUsingId(SelectResults results, int id, String queryStr) {
        for (Object resultObj : results) {
            if (((Portfolio)resultObj).ID <= id) continue;
            Log.getLogWriter().info("Result = " + Utils.printResult((Object)results));
            throw new TestException("Sanity check failed for query: " + queryStr + " Expected (Portfolio)resultObj).ID to be <= " + id + " for all objects but found: " + ((Portfolio)resultObj).ID);
        }
    }

    static void sanityCheckUsingStatusAndId(SelectResults results, int id, String status, String queryStr) {
        for (Object resultObj : results) {
            if (!((Portfolio)resultObj).status.equals(status)) {
                Log.getLogWriter().info("Result = " + Utils.printResult((Object)results));
                throw new TestException("Sanity check failed for query: " + queryStr + " Expected ((Portfolio) resultObj).status to be equal to " + status + " for all objects but found: " + ((Portfolio)resultObj).status);
            }
            if (id == -1 || ((Portfolio)resultObj).ID != id) continue;
            Log.getLogWriter().info("Result = " + Utils.printResult((Object)results));
            throw new TestException("Sanity check failed for query: " + queryStr + " Expected ((Portfolio) resultObj).id to be != " + id + " for all objects but found: " + ((Portfolio)resultObj).ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePdxQuery(String qStr, Collection coll) {
        if (qStr.indexOf("aDay") < 0 && qStr.indexOf("pdx") >= 0) {
            return;
        }
        String propValue = System.getProperty("gemfire.loadClassOnEveryDeserialization");
        boolean pdx661Behavior = propValue == null ? false : propValue.equals("true");
        ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
        if (pdx661Behavior) {
            try {
                String alternateVersionClassPath = System.getProperty("JTESTS") + File.separator + ".." + File.separator + ".." + File.separator + "testsVersions" + File.separator + "version2" + File.separator + "classes/";
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                cl = ClassLoader.getSystemClassLoader();
                URLClassLoader versionCL = new URLClassLoader(new URL[]{new File(alternateVersionClassPath).toURL()}, cl);
                Log.getLogWriter().info("Setting class loader to version2 for validation " + alternateVersionClassPath);
                Thread.currentThread().setContextClassLoader(versionCL);
            }
            catch (MalformedURLException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        try {
            boolean isNullQuery;
            Log.getLogWriter().info("Validating " + qStr);
            Set rootRegions = CacheHelper.getCache().rootRegions();
            Region qRegion = null;
            for (Region aRegion : rootRegions) {
                if (qStr.indexOf(aRegion.getFullPath()) < 0) continue;
                qRegion = aRegion;
                break;
            }
            Log.getLogWriter().info("Validating from region " + qRegion.getFullPath() + " of size " + qRegion.size());
            HashSet<Portfolio> expectedResults = new HashSet<Portfolio>();
            boolean ableToReadAllFields = true;
            boolean bl = isNullQuery = qStr.indexOf(enumWhereClause2) >= 0;
            if (qStr.indexOf(enumWhereClause1) >= 0 || isNullQuery) {
                for (Object key : qRegion.keySet()) {
                    Object value = qRegion.get(key);
                    if (value instanceof PdxInstance) {
                        value = ((PdxInstance)value).getObject();
                    }
                    if (!value.getClass().getName().equals("objects.PdxVersionedPortfolio") && !value.getClass().getName().equals("objects.VersionedPortfolio")) continue;
                    Portfolio pf = (Portfolio)value;
                    try {
                        String myVersionValue = PdxTest.getFieldValue(pf, "myVersion");
                        if (myVersionValue.indexOf("version2") < 0) continue;
                        String dayValue = PdxTest.getFieldValue(pf, "aDay");
                        Log.getLogWriter().info("day value is " + dayValue);
                        if (isNullQuery) {
                            if (dayValue != null) continue;
                            expectedResults.add(pf);
                            continue;
                        }
                        if (dayValue == null || !dayValue.equals("Wednesday")) continue;
                        expectedResults.add(pf);
                    }
                    catch (NoSuchFieldException e) {
                        Log.getLogWriter().info("Caught NoSuchFieldException");
                        ableToReadAllFields = false;
                    }
                }
            } else {
                if (qStr.indexOf("aDay") >= 0 || qStr.indexOf("pdx") >= 0) {
                    throw new TestException("Test does not know how to validate " + qStr);
                }
                return;
            }
            this.logRegions();
            boolean checkExactSize = ableToReadAllFields && !pdxReadSerialized;
            Log.getLogWriter().info("Size of result is :" + coll.size() + ", expected result size is " + expectedResults.size());
            if (checkExactSize) {
                if (coll.size() != expectedResults.size()) {
                    Log.getLogWriter().info("Expected results: " + expectedResults);
                    Log.getLogWriter().info("Actual results: " + coll);
                    throw new TestException("Expected result size of " + qStr + " to be " + expectedResults.size() + ", but it is " + coll.size());
                }
            } else if (coll.size() < expectedResults.size()) {
                Log.getLogWriter().info("Expected results: " + expectedResults);
                Log.getLogWriter().info("Actual results: " + coll);
                throw new TestException("Expected result size of " + qStr + " to be at least " + expectedResults.size() + ", but it is " + coll.size());
            }
            Log.getLogWriter().info("Validated " + qStr);
        }
        finally {
            if (pdx661Behavior) {
                Log.getLogWriter().info("Setting class loader back to what it was prior to validation: " + previousCL);
                Thread.currentThread().setContextClassLoader(previousCL);
            }
        }
    }

    private void logRegions() {
        Cache theCache = CacheHelper.getCache();
        Set rootRegions = theCache.rootRegions();
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : rootRegions) {
            aStr.append(aRegion.getFullPath() + ":\n");
            for (Object key : aRegion.keySet()) {
                aStr.append("  " + key + " " + aRegion.get(key) + "\n");
            }
        }
        Log.getLogWriter().info(aStr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCountQuery(boolean logAddition) {
        String[] queries = null;
        int threshold = 30000;
        boolean isPdxTest = TestConfig.tab().stringAt(QueryPrms.objectType).equals("objects.PdxVersionedPortfolio");
        boolean isPr = TestConfig.tab().stringAt(RegionPrms.dataPolicy).equals("partition");
        queries = isPr ? (isPdxTest ? new String[]{"select count(*) from " + this.randRgn() + " where id = 0", "select count(*) from " + this.randRgn() + " where status = 'active'", "select count(*) from " + this.randRgn() + " where id != 0 AND status = 'active'", "select count(*) from " + this.randRgn() + " where pdxID = 0", "select count(*) from " + this.randRgn() + " where pdxStatus = 'active'", "select count(*) from " + this.randRgn() + " where pdxID != 0 AND pdxStatus = 'active'", "select count(*) from " + this.randRgn() + " where id = 0 and pdxID = 0", "select count(*) from " + this.randRgn() + " where status = 'active' and pdxID = 'active'", "select count(*) from " + this.randRgn() + " where (id != 0) AND (pdxID != 0) and (status = 'active') and (pdxStatus = 'active')"} : new String[]{"select count(*) from " + this.randRgn() + " where id = 0", "select count(*) from " + this.randRgn() + " where status = 'active'", "select count(*) from " + this.randRgn() + " where id != 0 AND status = 'active'"}) : (isPdxTest ? new String[]{"select count(*) from " + this.randRgn() + " where ID = 0", "select count(*) from " + this.randRgn() + " where status = 'active'", "select count(*) from " + this.randRgn() + ", " + this.randRgn(), "select count(*) from " + this.randRgn() + ", " + this.randRgn() + ", " + this.randRgn(), "select count(*) from " + this.randRgn() + " where ID != 0 AND status = 'active'", "select count(*) from " + this.randRgn() + " where pdxID = 0", "select count(*) from " + this.randRgn() + " where pdxStatus = 'active'", "select count(*) from " + this.randRgn() + " where pdxID != 0 AND pdxStatus = 'active'", "select count(*) from " + this.randRgn() + " where ID = 0 and pdxID = 0", "select count(*) from " + this.randRgn() + " where status = 'active' and pdxID = 'active'", "select count(*) from " + this.randRgn() + " where (ID != 0) AND (pdxID != 0) and (status = 'active') and (pdxStatus = 'active')"} : new String[]{"select count(*) from " + this.randRgn() + " where ID = 0", "select count(*) from " + this.randRgn() + " where status = 'active'", "select count(*) from " + this.randRgn() + ", " + this.randRgn(), "select count(*) from " + this.randRgn() + ", " + this.randRgn() + ", " + this.randRgn(), "select count(*) from " + this.randRgn() + " where ID != 0 AND status = 'active'"});
        if (this.queryLimit != -1) {
            int q = 0;
            while (q < queries.length) {
                int n = q++;
                queries[n] = queries[n] + " limit " + this.queryLimit;
            }
        }
        this.countQueryResults = QueryBB.getCountResultsObject();
        if (this.countQueryResults == null) {
            this.countQueryResults = new int[queries.length][2];
        }
        int i = new Random().nextInt(queries.length);
        Log.getLogWriter().info(" query = " + queries[i]);
        Query countReplacedQuery = null;
        if (queries[i].contains("count(*)")) {
            String countReplacedQueryStr = queries[i].replace("count(*)", "*");
            countReplacedQuery = CacheHelper.getCache().getQueryService().newQuery(countReplacedQueryStr);
        }
        Query query = CacheHelper.getCache().getQueryService().newQuery(queries[i]);
        try {
            int count;
            Object result;
            Object nonCountResult = null;
            ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
            if (pdxReadSerialized) {
                Log.getLogWriter().info("Setting class loader to remove domain classes in preparation of a query execute: " + origClassLoader.get());
                Thread.currentThread().setContextClassLoader((ClassLoader)origClassLoader.get());
            }
            try {
                Cache theCache;
                if (countReplacedQuery != null) {
                    nonCountResult = countReplacedQuery.execute();
                }
                if ((theCache = CacheHelper.getCache()) != null) {
                    Log.getLogWriter().info("Clearing the pdx registry with a test hook");
                    ((GemFireCacheImpl)theCache).getPdxRegistry().flushCache();
                }
                Log.getLogWriter().info("Executing query " + queries[i]);
                result = query.execute();
                Log.getLogWriter().info("Done executing query " + queries[i]);
            }
            finally {
                if (pdxReadSerialized) {
                    Log.getLogWriter().info("Setting class loader back to one that refers to domain classes: " + previousCL);
                    Thread.currentThread().setContextClassLoader(previousCL);
                }
            }
            this.validateQueryLimit(result);
            if (result instanceof Collection) {
                Collection coll = (Collection)result;
                Log.getLogWriter().info("Size of result is :" + coll.size());
                count = 0;
                for (Object resultElement : coll) {
                    if (resultElement instanceof Integer) {
                        this.countQueryResults[i][0] = count = ((Integer)resultElement).intValue();
                        this.countQueryResults[i][1] = ((SelectResults)nonCountResult).size();
                        QueryBB.putCountStarResults(this.countQueryResults);
                        if (count == ((SelectResults)nonCountResult).size()) continue;
                        throw new TestException("Query result is unexpected: " + count + ", result should be " + ((SelectResults)nonCountResult).size());
                    }
                    throw new TestException("Query result element is unexpected: " + resultElement + ", result element is of class " + resultElement.getClass().getName());
                }
            } else {
                throw new TestException("Result of query is " + result + " of class " + result.getClass().getName() + ", but expected a Collection");
            }
            Log.getLogWriter().info("Result of Count(*) query is" + count);
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
        }
    }

    protected void doPdxStringQuery() {
        String[] queries = null;
        int threshold = 30000;
        boolean isPdxTest = TestConfig.tab().stringAt(QueryPrms.objectType).equals("objects.PdxVersionedPortfolio");
        if (!isPdxTest) {
            throw new TestException("Test only on pdx instances");
        }
        queries = new String[]{"select status from " + this.randRgn() + " where ID > 0", "select status from " + this.randRgn() + " where status > 'active'", "select status from " + this.randRgn() + " where status LIKE '%active'", "select status from " + this.randRgn() + " where ID != 0 AND status = 'active'", "select distinct status from " + this.randRgn() + " order by status"};
        if (this.queryLimit != -1) {
            int q = 0;
            while (q < queries.length) {
                int n = q++;
                queries[n] = queries[n] + " limit " + this.queryLimit;
            }
        }
        int i = new Random().nextInt(queries.length);
        Log.getLogWriter().info(" query = " + queries[i]);
        Query query = CacheHelper.getCache().getQueryService().newQuery(queries[i]);
        Object result = null;
        try {
            try {
                Cache theCache = CacheHelper.getCache();
                Log.getLogWriter().info("Executing query: " + queries[i]);
                result = query.execute();
                Log.getLogWriter().info("Done executing query: " + queries[i]);
            }
            catch (Exception e) {
                Log.getLogWriter().error("Failed executing query: " + queries[i]);
                throw e;
            }
            this.validateQueryLimit(result);
            if (result != null && result instanceof Collection) {
                Collection coll = (Collection)result;
                Log.getLogWriter().info("Size of result is :" + coll.size());
                for (Object resultElement : coll) {
                    if (resultElement instanceof String) continue;
                    throw new TestException("Query result element is unexpected: " + resultElement + ", result element is of class " + resultElement.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            throw new TestException("Caught exception during query execution: " + TestHelper.getStackTrace(e));
        }
    }

    protected void validateQueryLimit(Object result) {
        int size;
        Log.getLogWriter().info("Validating Query LIMIT => " + this.queryLimit);
        if (this.queryLimit != -1 && result instanceof Collection && (size = ((Collection)result).size()) > this.queryLimit) {
            String errorMsg = "Query Results exceeded the limit. expected limit=" + this.queryLimit + " Actual size of the results=" + size;
            throw new TestException(errorMsg);
        }
    }

    protected String randRgn() {
        return "/QueryRegion" + new Random().nextInt(this.numOfRegions);
    }

    protected void checkEventCounters() {
        throw new TestException("checkEventCounters must be implmented in a subclass");
    }

    protected Object getObjectToAdd(String name) {
        int payloadSize;
        boolean useRandomValues = false;
        useRandomValues = TestConfig.tab().booleanAt(QueryPrms.useRandomValues, false);
        if (useRandomValues) {
            ValueHolder anObj = new ValueHolder(name, this.randomValues);
            return anObj;
        }
        long i = NameFactory.getPositiveNameCounter();
        int index = (int)(i % (long)this.maxObjects);
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        Object val = ObjectHelper.createObject(objectType, index);
        if (val instanceof Portfolio && (payloadSize = TestConfig.tab().intAt(QueryPrms.payloadSize, -1)) > 0) {
            ((Portfolio)val).payload = new byte[payloadSize];
        }
        return val;
    }

    protected Object getUpdateObject(String name) {
        Region rootRegion = CacheHelper.getCache().getRegion(REGION_NAME);
        boolean useRandomValues = false;
        useRandomValues = TestConfig.tab().booleanAt(QueryPrms.useRandomValues, false);
        if (useRandomValues) {
            BaseValueHolder anObj = null;
            BaseValueHolder newObj = null;
            try {
                anObj = (BaseValueHolder)rootRegion.get((Object)name);
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            newObj = anObj == null ? new ValueHolder(name, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
            return newObj;
        }
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        Object val = ObjectHelper.createObject(objectType, 0);
        return val;
    }

    protected CacheListener getCacheListener() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        if (objectType.indexOf("Pdx") > 0 || objectType.indexOf("Versioned") > 0) {
            return new PdxETListener(this.isCarefulValidation);
        }
        return new ETListener(this.isCarefulValidation);
    }

    protected int getNumVMsWithListeners() {
        throw new TestException("getNumVMsWithListeners must be implemented in a subclass");
    }

    protected void createRootRegions() {
        CacheListener listener = queryTest.getCacheListener();
        CacheHelper.createCache("cache1");
        this.initPdxDiskStore();
        for (int i = 0; i < this.numOfRegions; ++i) {
            String regionDescriptionName = "region" + (i + 1);
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionDescriptionName);
            factory.addCacheListener(listener);
            RegionHelper.createRegion(REGION_NAME + "" + i, factory);
        }
    }

    public static void HydraTask_printBB() throws Throwable {
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        TestHelper.checkForEventError(EventCountersBB.getBB());
    }

    public static void HydraTask_iterate() throws Throwable {
        CacheHelper.createCache("cache1");
        RegionHelper.createRegion(REGION_NAME, "region1");
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        TestHelper.checkForEventError(EventCountersBB.getBB());
    }

    public static synchronized void HydraTask_closeTask_writeQueryStats_To_Blackboard() throws Throwable {
        if (!statisticsWrittenToBB) {
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheHelper.getCache();
            CachePerfStats stats = cache.getCachePerfStats();
            Statistics statistics = stats.getStats();
            int value = statistics.getInt("queryExecutions");
            long value_time = statistics.getLong("queryExecutionTime");
            Log.getLogWriter().info("Value queryExecutions :  " + value);
            Log.getLogWriter().info("Value time queryExecutionTime:  " + value_time);
            long valueBB = QueryBB.getBB().getSharedCounters().read(QueryBB.NUM_QUERY_EXECS);
            int numVms = TestConfig.getInstance().getTotalVMs();
            Log.getLogWriter().info("Total VMs: " + numVms);
            Log.getLogWriter().info("Total VMs: " + numVms);
            if (CacheHelper.getCache().rootRegions().iterator().next() instanceof PartitionedRegion) {
                QueryBB.getBB().getSharedCounters().add(QueryBB.NUM_QUERY_EXECS, (long)(numVms - 1) * numQueries.get());
                IndexBB.getBB().getSharedCounters().add(IndexBB.TOTAL_USES, 112L * numQueries.get());
            }
            Thread.sleep(10000L);
            Log.getLogWriter().info("Num query executions as seen from Blackboard:  " + valueBB);
            Log.getLogWriter().info("Num query executions as per AtomicLong:  " + numQueries.get());
            QueryBB.getBB().getSharedCounters().add(QueryBB.NUM_QUERY_EXEC_STATS, value);
            QueryBB.getBB().getSharedCounters().add(QueryBB.TOTAL_QUERY_EXEC_TIME_STATS, value_time);
            QueryBB.getBB().getSharedCounters().add(QueryBB.NUM_QUERY_EXECS_ATOMIC_COUNTER_SUM, numQueries.get());
            boolean isIndexValidation = TestConfig.tab().booleanAt(QueryPrms.isIndexUsageValidation, false);
            if (isIndexValidation) {
                Collection indexes = CacheHelper.getCache().getQueryService().getIndexes();
                Log.getLogWriter().info("Total indexes::  " + indexes.size());
                QueryBB.getBB().getSharedCounters().setIfLarger(QueryBB.TOTAL_INDEX_COUNT, indexes.size());
                long totalUsesInThisVM = 0L;
                for (Index index : indexes) {
                    Region region = index.getRegion();
                    long keys = region.keySet().size();
                    long numKeys = index.getStatistics().getNumberOfKeys();
                    long numValues = index.getStatistics().getNumberOfValues();
                    long numUpdates = index.getStatistics().getNumUpdates();
                    long totalUses = index.getStatistics().getTotalUses();
                    totalUsesInThisVM += totalUses;
                    Log.getLogWriter().info("Index Name:  " + index.getName());
                    Log.getLogWriter().info("Index stats numUsed:  " + totalUses);
                    IndexBB.getBB().getSharedCounters().add(IndexBB.TOTAL_USES_STATS, totalUses);
                    IndexBB.getBB().getSharedCounters().add(IndexBB.TOTAL_UPDATES_STATS, numUpdates);
                }
                Log.getLogWriter().info("Total uses in this VM : = " + totalUsesInThisVM);
            }
            statisticsWrittenToBB = true;
        }
    }

    public static void HydraTask_endTask_verifyQueryStats_With_Blackboard() throws Throwable {
        long valueBB = QueryBB.getBB().getSharedCounters().read(QueryBB.NUM_QUERY_EXECS);
        long valueStats = QueryBB.getBB().getSharedCounters().read(QueryBB.NUM_QUERY_EXEC_STATS);
        long valueTimeBB = QueryBB.getBB().getSharedCounters().read(QueryBB.TOTAL_QUERY_EXEC_TIME);
        long valueTimeStats = QueryBB.getBB().getSharedCounters().read(QueryBB.TOTAL_QUERY_EXEC_TIME_STATS);
        long valueSumAtomicLongBB = QueryBB.getBB().getSharedCounters().read(QueryBB.NUM_QUERY_EXECS_ATOMIC_COUNTER_SUM);
        long valueRegionOpsBB = QueryBB.getBB().getSharedCounters().read(QueryBB.NUM_REGION_OPS);
        long indexUpdatesStatsTotal = IndexBB.getBB().getSharedCounters().read(IndexBB.TOTAL_UPDATES_STATS);
        Log.getLogWriter().info("For num queries valueSumAtomicLongBB = " + valueSumAtomicLongBB + " valuesBB = " + valueBB + " valueStats = " + valueStats);
        if (valueBB != valueStats) {
            throw new TestException("For num queries valuesBB = " + valueBB + " valueStats = " + valueStats);
        }
        Log.getLogWriter().info("For num queries valuesBB = " + valueBB + " valueStats = " + valueStats);
        boolean isIndexValidation = TestConfig.tab().booleanAt(QueryPrms.isIndexUsageValidation, false);
        if (isIndexValidation) {
            long indexTotalUsesStats;
            long indexTotalUsesBB = IndexBB.getBB().getSharedCounters().read(IndexBB.TOTAL_USES);
            if (indexTotalUsesBB != (indexTotalUsesStats = IndexBB.getBB().getSharedCounters().read(IndexBB.TOTAL_USES_STATS))) {
                throw new TestException("BUG 47149 For index totalUses indexTotalUsesBB = " + indexTotalUsesBB + " indexTotalUsesStats = " + indexTotalUsesStats);
            }
            long totalIndexCount = QueryBB.getBB().getSharedCounters().read(QueryBB.TOTAL_INDEX_COUNT);
            Log.getLogWriter().info("Total indexes::  " + totalIndexCount);
            if (indexUpdatesStatsTotal != totalIndexCount * valueRegionOpsBB) {
                // empty if block
            }
        }
    }

    public static void HydraTask_endTask() throws Throwable {
        TestHelper.checkForEventError(EventCountersBB.getBB());
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        queryTest = new QueryTest();
        queryTest.initialize();
        StringBuffer errStr = new StringBuffer();
        try {
            queryTest.checkEventCounters();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            Log.getLogWriter().info(e.toString());
            errStr.append(e.toString());
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        TestHelper.checkForEventError(EventCountersBB.getBB());
    }

    protected void createCacheFromXml(String xmlFilename) {
        CacheHelper.createCacheFromXml(xmlFilename);
    }

    protected Object[] iterateRegion(Region aRegion, boolean allowZeroKeys, boolean allowZeroNonNullValues) {
        StringBuffer errStr = new StringBuffer();
        Set keys = aRegion.keys();
        Log.getLogWriter().info("For " + TestHelper.regionToString(aRegion, false) + ", found " + keys.size() + " keys");
        int numKeys = keys.size();
        if (numKeys == 0 && !allowZeroKeys) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + numKeys + " keys\n");
        }
        int valueCount = 0;
        for (Object key : keys) {
            long counter;
            Object value;
            try {
                value = aRegion.get(key);
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Checking key " + key + ", value " + value);
            boolean useRandomValues = false;
            useRandomValues = TestConfig.tab().booleanAt(QueryPrms.useRandomValues, false);
            if (useRandomValues) {
                String valueHolderValue;
                if (value == null) continue;
                ++valueCount;
                BaseValueHolder vh = (BaseValueHolder)value;
                String nameValue = "" + NameFactory.getCounterForName(key);
                if (nameValue.equals(valueHolderValue = "" + vh.myValue)) continue;
                String aStr = "Expected counter of key/value to match, key: " + key + ", value: " + vh.toString();
                Log.getLogWriter().info(aStr);
                errStr.append(aStr + "\n");
                continue;
            }
            if (value == null) continue;
            ++valueCount;
            ConfigurableObject cobj = (ConfigurableObject)value;
            int index = cobj.getIndex();
            if ((long)index == (counter = NameFactory.getCounterForName(key))) continue;
            String aStr = "Expected counter of key/value to match, key: " + key + ", value: " + cobj.toString();
            Log.getLogWriter().info(aStr);
            errStr.append(aStr + "\n");
        }
        if (valueCount == 0 && !allowZeroNonNullValues) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + valueCount + " non-null values\n");
        }
        return new Object[]{new Integer(numKeys), new Integer(valueCount), errStr.toString()};
    }

    protected int getOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equals("query")) {
                op = 8;
            } else if (operation.equals("countquery")) {
                op = 11;
            } else if (operation.equals("createIndex")) {
                op = 9;
            } else if (operation.equals("removeIndex")) {
                op = 10;
            } else if (operation.equals("pdxStringQuery")) {
                op = 12;
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (disallowLocalEntryOps && (op == 6 || op == 7));
        return op;
    }

    protected static void logExecutionNumber() {
        long exeNum = EventBB.getBB().getSharedCounters().incrementAndRead(EventBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void handleRegionDestroyedException(Region aRegion, RegionDestroyedException anException) {
        if (this.isCarefulValidation) {
            throw new TestException(TestHelper.getStackTrace(anException));
        }
        if (!anException.getRegionFullPath().equals(aRegion.getFullPath())) {
            TestException te = new TestException("Got a RegionDestroyedException when operating on region " + TestHelper.regionToString(aRegion, false) + ", but the region destroyed is '" + anException.getRegionFullPath() + "'");
            te.initCause(anException);
            throw te;
        }
        boolean isDestroyed = aRegion.isDestroyed();
        if (!isDestroyed) {
            throw new TestException("Bug 30645 (likely): isDestroyed returned " + isDestroyed + " for region " + TestHelper.regionToString(aRegion, false) + ", but a region destroyed exception was thrown: " + TestHelper.getStackTrace(anException));
        }
        Log.getLogWriter().info("Got " + RegionDestroyedException.class.getName() + " on " + TestHelper.regionToString(aRegion, false) + "; exception expected, continuing test");
    }

    protected int getNumNames(Region aRegion, boolean hasValueOnly) {
        int count = 0;
        StringBuffer aStr = new StringBuffer();
        aStr.append("Names in " + TestHelper.regionToString(aRegion, false) + " and its subregions:\n");
        HashSet<Region> aSet = new HashSet<Region>(aRegion.subregions(true));
        aSet.add(aRegion);
        for (Region thisRegion : aSet) {
            for (Object key : thisRegion.keys()) {
                boolean containsValue = thisRegion.containsValueForKey(key);
                if (!hasValueOnly || hasValueOnly && containsValue) {
                    ++count;
                }
                aStr.append("   " + key + " in " + TestHelper.regionToString(thisRegion, false) + " (containsValueForKey: " + containsValue + ")\n");
            }
        }
        Log.getLogWriter().info(aStr.toString());
        return count;
    }

    protected void verifyObjectInvalidated(Region aRegion, Object key) {
        Object entryValue;
        Object entryKey;
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (!containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) == null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned null\n");
        }
        if (!(entryKey = entry.getKey()).equals(key)) {
            errStr.append("getEntry.getKey() " + entryKey + " does not equal key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entryValue = entry.getValue()) != null) {
            errStr.append("Expected getEntry.getValue() " + TestHelper.toString(entryValue) + " to be null.\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void verifyObjectDestroyed(Region aRegion, Object key) {
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) != null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned was non-null; getKey is " + entry.getKey() + ", value is " + TestHelper.toString(entry.getValue()) + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    private void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    public void verifyCountQueryResults() {
        int[][] countQueryResults = QueryBB.getCountResultsObject();
        for (int i = 0; i < countQueryResults.length; ++i) {
            if (countQueryResults[i][0] == countQueryResults[i][1]) continue;
            throw new TestException("Query result is incorrect: Should be " + countQueryResults[i][1] + ", but is " + countQueryResults[i][0]);
        }
    }

    static {
        pdxReadSerialized = false;
        statisticsWrittenToBB = false;
        origClassLoader = new HydraThreadLocal();
        numQueries = new AtomicLong(0L);
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
    }

    public static class QueryObserverImpl
    extends QueryObserverAdapter {
        boolean isIndexesUsed = false;
        ArrayList indexesUsed = new ArrayList();

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexesUsed.add(index.getName());
        }

        public void afterIndexLookup(Collection results) {
            if (results != null) {
                this.isIndexesUsed = true;
            }
        }

        public void beforeIndexLookup(Index index, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
            this.indexesUsed.add(index.getName());
        }
    }
}

