/*
 * Decompiled with CFR 0.152.
 */
package perffmwk.samples;

import com.gemstone.gemfire.StatisticDescriptor;
import hydra.ClientDescription;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.util.List;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import perffmwk.RuntimeStatSpec;
import perffmwk.TrimSpec;
import perffmwk.samples.SamplePrms;
import perffmwk.samples.SampleStatException;
import perffmwk.samples.SampleThreadStatistics;

public class RuntimeStatClient {
    public static void openStatisticsTask() {
        SampleThreadStatistics.getInstance();
    }

    public static void workWithStatisticsTask() {
        RuntimeStatClient c = new RuntimeStatClient();
        c.workWithStatistics();
    }

    protected void workWithStatistics() {
        SampleThreadStatistics threadStats = SampleThreadStatistics.getInstance();
        this.doSomething(TestConfig.tab().intAt(SamplePrms.workIterations), threadStats);
    }

    protected void doSomething(int iterations, SampleThreadStatistics threadStats) {
        for (int i = 0; i < iterations; ++i) {
            threadStats.startOperation();
            this.doSomethingHere();
            threadStats.endOperation();
        }
    }

    private void doSomethingHere() {
        MasterController.sleepForMs(10);
    }

    public static void readStatisticsUsingStatInstanceTask() {
        RuntimeStatClient c = new RuntimeStatClient();
        c.readStatisticsUsingStatInstance();
    }

    private void readStatisticsUsingStatInstance() {
        SampleThreadStatistics statInst = SampleThreadStatistics.getInstance();
        Log.getLogWriter().info("My thread did " + statInst.readOps() + " operations");
        StatisticDescriptor sd = statInst.getStatisticDescriptor("operations");
        RuntimeStatSpec statSpec = new RuntimeStatSpec(statInst, sd);
        statSpec.setFilter("none");
        statSpec.setCombineType("combineAcrossArchives");
        statSpec.setStddev(false);
        List psvs = PerfStatMgr.getInstance().readStatistics(statSpec);
        PerfStatValue psv = (PerfStatValue)psvs.get(0);
        int max = (int)psv.getMax();
        Log.getLogWriter().info("All threads did " + max + " operations");
    }

    public static void closeStatisticsTask() {
        SampleThreadStatistics.getInstance().close();
    }

    public static void readStatisticsUsingSpecStringTask() {
        String spec = "* perffmwk.samples.SampleThreadStatistics * operations filter=none combine=combineAcrossArchives ops=max";
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        PerfStatValue psv = (PerfStatValue)psvs.get(0);
        int max = (int)psv.getMax();
        if (max < 1000) {
            throw new SampleStatException("Test did not do enough operations: " + max);
        }
        Log.getLogWriter().info("Did " + max + " operations");
    }

    public static void getMeanCpuActiveTask() {
        long startTime = System.currentTimeMillis();
        MasterController.sleepForMs(30000);
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Mean CPU Active: " + RuntimeStatClient.getMeanCpuActive(startTime, endTime));
    }

    public static double getMeanCpuActive(long startTime, long endTime) {
        String clientName = System.getProperty("clientName");
        ClientDescription cd = TestConfig.getInstance().getClientDescription(clientName);
        String archive = cd.getGemFireDescription().getName() + "*";
        TrimSpec trim = new TrimSpec("runtime_MeanCpuActive");
        trim.start(startTime);
        trim.end(endTime);
        Log.getLogWriter().info("HEY: trim is " + trim);
        String spec = archive + " LinuxSystemStats * cpuActive " + "filter" + "=" + "none" + " " + "combine" + "=" + "raw" + " " + "ops" + "=" + "mean";
        Log.getLogWriter().info("HEY: spec is " + spec);
        List psvs = PerfStatMgr.getInstance().readStatistics(spec, trim);
        Log.getLogWriter().info("HEY: psvs are " + psvs);
        PerfStatValue psv = (PerfStatValue)psvs.get(0);
        double mean = psv.getMean();
        Log.getLogWriter().info("HEY: mean cpu active is " + mean + " for trim " + trim);
        return mean;
    }
}

