/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import batterytest.BatteryTestConfig;
import batterytest.ConfigParser;
import com.gemstone.gemfire.LogWriter;
import hydra.FileUtil;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestFileUtil;
import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import util.TestHelper;

public class PerfSorter {
    public static final String COMPARISON_KEY_PROP = "perffmwk.comparisonKey";
    private static final String OMIT_FAILED_TESTS_PROP = "omitFailedTests";
    private static final String BATTERYTEST_FILE_PROP = "batterytestFile";
    private static final String LOG_LEVEL_PROP = "logLevel";
    private static String BatteryTestFile;
    private static boolean OmitFailedTests;
    private static Vector BatteryTests;
    private static Map TestDirs;
    private static LogWriter TestLog;

    public static void main(String[] args) {
        try {
            if (PerfSorter.sort(args)) {
                System.exit(0);
            } else {
                PerfSorter.logError("sort() returned false");
                System.exit(1);
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            PerfSorter.logError(TestHelper.getStackTrace(t));
            System.exit(1);
        }
    }

    public static boolean sort(String[] args) {
        if (PerfSorter.readParameters(args)) {
            PerfSorter.moveDirs();
            return true;
        }
        return false;
    }

    private static boolean readParameters(String[] args) {
        String logLevel = System.getProperty(LOG_LEVEL_PROP, "info");
        TestLog = Log.createLogWriter("perfsorter", "perfsorter", logLevel, true);
        TestLog.info("PerfSorter PID is " + ProcessMgr.getProcessId());
        String jtests = System.getProperty("JTESTS");
        if (jtests == null) {
            PerfSorter.usage("Missing JTESTS");
            return false;
        }
        BatteryTestFile = System.getProperty(BATTERYTEST_FILE_PROP);
        if (BatteryTestFile != null) {
            TestLog.info("Parsing batterytest file: " + BatteryTestFile + "...");
            try {
                BatteryTests = ConfigParser.parseFile(BatteryTestFile);
                if (BatteryTests.size() == 0) {
                    TestLog.info("No batterytests found in file: " + BatteryTestFile);
                    BatteryTests = null;
                } else {
                    for (BatteryTestConfig btc : BatteryTests) {
                        String testname = btc.getName();
                        String defaults = jtests + "/" + testname.substring(0, testname.indexOf(".conf")) + ".prop";
                        btc.fillInWithDefaultsFrom(defaults);
                    }
                    TestLog.info("Using batterytests: " + PerfSorter.printBatteryTests());
                }
            }
            catch (Exception e) {
                TestLog.severe("Problem reading batterytest file: " + BatteryTestFile, (Throwable)e);
                return false;
            }
        }
        OmitFailedTests = Boolean.getBoolean(OMIT_FAILED_TESTS_PROP);
        TestDirs = new TreeMap();
        for (int i = 0; i < args.length; ++i) {
            String dir = PerfSorter.absoluteName(args[i]);
            TestLog.fine("Considering test " + dir);
            if (FileUtil.exists(dir)) {
                if (TestFileUtil.isTestDirectory(dir)) {
                    if (PerfSorter.passed(dir) || !OmitFailedTests) {
                        String testPropFile = PerfSorter.getTestPropFile(dir);
                        if (FileUtil.exists(testPropFile)) {
                            String key = BatteryTests == null ? PerfSorter.getComparisonKey(testPropFile) : PerfSorter.getBatteryTestKey(testPropFile);
                            if (key == null) {
                                TestLog.warning("...skipping test -- no comparison key: " + dir);
                                continue;
                            }
                            TestLog.fine("Adding test " + key + " : " + dir);
                            PerfSorter.addDir(key, dir);
                            continue;
                        }
                        TestLog.warning("...skipping test -- prop file not found: " + testPropFile);
                        continue;
                    }
                    TestLog.warning("...skipping test -- failed: " + dir);
                    continue;
                }
                TestLog.warning("...skipping test -- not a test directory: " + dir);
                continue;
            }
            TestLog.warning("...skipping test -- directory not found: " + dir);
        }
        if (TestDirs.size() < 1) {
            PerfSorter.usage("No test directories to sort: " + TestDirs.size());
            return false;
        }
        TestLog.info("\nJTESTS = " + jtests + "\n" + BATTERYTEST_FILE_PROP + " = " + BatteryTestFile + "\n" + OMIT_FAILED_TESTS_PROP + " = " + OmitFailedTests + "\nlogLevel = " + logLevel + "\ntestDirs = " + TestDirs);
        return true;
    }

    private static void usage(String s) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n** " + s);
        buf.append("\nUsage: java");
        buf.append(" [optional_properties]");
        buf.append(" perffmwk.PerfSorter <list_of_test_directories>");
        buf.append("\nwhere optional properties include:");
        buf.append("\n-DbatterytestFile=<batterytest_filename>");
        buf.append("\n-DomitFailedTests=<whether_to_omit_failed_tests");
        System.out.println(buf.toString());
    }

    private static String printBatteryTests() {
        StringBuffer buf = new StringBuffer();
        for (BatteryTestConfig btc : BatteryTests) {
            buf.append("\n" + btc.toString());
        }
        return buf.toString();
    }

    private static String getBatteryTestKey(String testPropFile) {
        SortedMap testmap = PerfSorter.getTestProps(testPropFile);
        TestLog.fine("Matching testmap: " + testmap);
        for (BatteryTestConfig btc : BatteryTests) {
            SortedMap btmap = btc.getSortedProperties();
            btmap.put("testName", btc.getName());
            TestLog.fine("Checking btmap: " + btmap);
            String key = (String)btmap.get(COMPARISON_KEY_PROP);
            if (key == null || !PerfSorter.matchesExceptForKey(testmap, btmap)) continue;
            return key;
        }
        return null;
    }

    private static boolean matchesExceptForKey(SortedMap map1, SortedMap map2) {
        String val2;
        String val1;
        for (String key : map1.keySet()) {
            if (key.equals(COMPARISON_KEY_PROP)) continue;
            if (map2.containsKey(key)) {
                val1 = (String)map1.get(key);
                if (val1.equals(val2 = (String)map2.get(key))) continue;
                TestLog.fine("1: " + val1 + " not equal to " + val2);
                return false;
            }
            TestLog.fine("1: map2 missing key " + key);
            return false;
        }
        for (String key : map2.keySet()) {
            if (key.equals(COMPARISON_KEY_PROP)) continue;
            if (map1.containsKey(key)) {
                val1 = (String)map2.get(key);
                if (val1.equals(val2 = (String)map1.get(key))) continue;
                TestLog.fine("2: " + val1 + " not equal to " + val2);
                return false;
            }
            TestLog.fine("2: map1 missing key " + key);
            return false;
        }
        return true;
    }

    private static void addDir(String key, String dir) {
        Vector<String> bucket = (Vector<String>)TestDirs.get(key);
        if (bucket == null) {
            bucket = new Vector<String>();
            TestDirs.put(key, bucket);
        }
        bucket.add(dir);
        TestLog.fine("TestDirs: " + TestDirs);
    }

    private static void moveDirs() {
        String pwd = System.getProperty("user.dir");
        for (String key : TestDirs.keySet()) {
            Vector dirs = (Vector)TestDirs.get(key);
            for (String dir : dirs) {
                String dst = pwd + "/" + key;
                if (!FileUtil.exists(dst)) {
                    FileUtil.mkdir(dst);
                }
                if (HostHelper.isWindows()) {
                    if (new File(dir).isDirectory()) {
                        ProcessMgr.fgexec("xcopy.exe /Y /E /I /Q " + dir + " " + dst, 300);
                        continue;
                    }
                    ProcessMgr.fgexec("cmd.exe /c copy " + dir + " " + dst, 300);
                    continue;
                }
                ProcessMgr.fgexec("/bin/cp -R " + dir + " " + dst, 300);
            }
        }
    }

    private static String getTestPropFile(String dir) {
        return dir + "/" + TestFileUtil.getShortTestName(dir) + ".prop";
    }

    private static SortedMap getTestProps(String fn) {
        try {
            return FileUtil.getPropertiesAsMap(fn);
        }
        catch (Exception e) {
            throw new HydraInternalException("Should not happen");
        }
    }

    private static String getComparisonKey(String fn) {
        SortedMap map = PerfSorter.getTestProps(fn);
        return (String)map.get(COMPARISON_KEY_PROP);
    }

    private static String absoluteName(String dir) {
        return new File(dir).getAbsoluteFile().toString();
    }

    private static boolean passed(String dir) {
        return !FileUtil.exists(dir + "/errors.txt");
    }

    private static void logError(String msg) {
        if (TestLog == null) {
            System.err.println(msg);
        } else {
            TestLog.severe(msg);
        }
    }
}

