/*
 * Decompiled with CFR 0.152.
 */
package pdx.parReg;

import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.LoaderHelper;
import hydra.Log;
import hydra.TestConfig;
import java.util.Properties;
import parReg.ParRegTest;
import pdx.PdxInstanceCreator;
import pdx.PdxTest;
import util.BaseValueHolder;
import util.RandomValues;
import util.TestException;
import util.ValueHolderPrms;

public class PdxPRCacheLoader
implements CacheLoader,
Declarable {
    private static ClassLoader versionedCL = null;

    public void close() {
        Log.getLogWriter().info("In PdxPRCacheLoader, close");
    }

    public Object load(LoaderHelper helper) throws CacheLoaderException {
        Log.getLogWriter().info("In " + this.getClass().getName());
        if (TestConfig.tab().getRandGen().nextInt(1, 100) <= 35) {
            return this.createObjWithClassPath(helper);
        }
        Object anObj = PdxInstanceCreator.getVersionedValueHolder(TestConfig.tab().stringAt(ValueHolderPrms.objectType), (String)helper.getKey(), new RandomValues());
        Log.getLogWriter().info("In " + this.getClass().getName() + " for key " + helper.getKey() + ", returning " + anObj);
        if (anObj == null) {
            anObj = this.createObjWithClassPath(helper);
        }
        return anObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createObjWithClassPath(LoaderHelper helper) throws TestException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Log.getLogWriter().info("cl is " + cl + ", versionedCL is " + versionedCL);
        if (versionedCL == null) {
            versionedCL = PdxTest.initClassLoader();
            Log.getLogWriter().info("versiondCL assigned: " + versionedCL);
            if (versionedCL == null) {
                String errStr = "Test problem, did not expect PdxTest.initClassLoader to return null";
                Log.getLogWriter().info(errStr);
                throw new TestException(errStr);
            }
        }
        try {
            Log.getLogWriter().info("Setting contextClassLoader to " + versionedCL);
            Thread.currentThread().setContextClassLoader(versionedCL);
            BaseValueHolder anObj = ParRegTest.testInstance.getValueForKey(helper.getKey());
            Log.getLogWriter().info("In " + this.getClass().getName() + " for key " + helper.getKey() + ", returning " + anObj);
            BaseValueHolder baseValueHolder = anObj;
            return baseValueHolder;
        }
        finally {
            Log.getLogWriter().info("Setting class loader to original: " + cl);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void init(Properties props) {
    }
}

