/*
 * Decompiled with CFR 0.152.
 */
package pdx.compat;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import hydra.CacheHelper;
import hydra.Log;
import java.util.Set;
import pdx.PdxBB;
import pdx.PdxTest;
import pdx.compat.PdxCompatTest;
import util.BaseValueHolder;
import util.OperationsClient;

public class Operations
extends OperationsClient {
    public static void HydraTask_doOperations() {
        PdxTest.initClassLoader();
        Operations ops = new Operations();
        ops.initializeOperationsClient();
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        Set rootRegions = theCache.rootRegions();
        for (Region aRegion : rootRegions) {
            ops.doEntryOperations(aRegion);
        }
    }

    @Override
    public BaseValueHolder getValueForKey(Object key) {
        return PdxCompatTest.getValueForKey(key);
    }

    @Override
    protected BaseValueHolder getUpdateObject(Region aRegion, Object key) {
        Object cacheObj = aRegion.get(key);
        BaseValueHolder anObj = PdxTest.toValueHolder(cacheObj);
        BaseValueHolder newObj = null;
        newObj = anObj == null ? this.getValueForKey(key) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    @Override
    protected void doEntryOperations(Region aRegion) {
        try {
            Log.getLogWriter().info(aRegion.getFullPath() + " is size " + aRegion.size());
            super.doEntryOperations(aRegion);
        }
        catch (CacheClosedException e) {
            if (PdxBB.getBB().getSharedCounters().read(PdxBB.shutDownAllInProgress) >= 1L) {
                Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " during shutDownAll");
            }
            throw e;
        }
        catch (RegionDestroyedException e) {
            if (PdxBB.getBB().getSharedCounters().read(PdxBB.shutDownAllInProgress) >= 1L) {
                Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " during shutDownAll");
            }
            throw e;
        }
        catch (DistributedSystemDisconnectedException e) {
            if (PdxBB.getBB().getSharedCounters().read(PdxBB.shutDownAllInProgress) >= 1L) {
                Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " during shutDownAll");
            }
            throw e;
        }
        catch (PartitionedRegionStorageException e) {
            if (e.toString().indexOf(" Unable to find any members to host a bucket") >= 0) {
                if (PdxBB.getBB().getSharedCounters().read(PdxBB.restartingAfterShutDownAll) >= 1L || PdxBB.getBB().getSharedCounters().read(PdxBB.shutDownAllInProgress) >= 1L) {
                    Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " while shutting down or restarting after shutDownAll");
                }
                throw e;
            }
            throw e;
        }
        catch (PartitionOfflineException e) {
            if (PdxBB.getBB().getSharedCounters().read(PdxBB.restartingAfterShutDownAll) >= 1L || PdxBB.getBB().getSharedCounters().read(PdxBB.shutDownAllInProgress) >= 1L) {
                Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " while shutting down or restarting after shutDownAll");
            }
            PartitionAttributes prAttr = aRegion.getAttributes().getPartitionAttributes();
            if (prAttr != null) {
                if (prAttr.getRedundantCopies() == 0) {
                    Log.getLogWriter().info("Allowed " + (Object)((Object)e) + " because of 0 redundantCopies");
                }
                throw e;
            }
            throw e;
        }
    }
}

