/*
 * Decompiled with CFR 0.152.
 */
package parReg.wbcl.newWan;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import hydra.CacheHelper;
import hydra.Log;
import hydra.TestConfig;
import java.util.List;
import parReg.wbcl.WBCLTestBB;
import parReg.wbcl.newWan.MyAsyncEventListener;
import util.TestHelper;

public class WBCLOrderPolicyListener
extends MyAsyncEventListener {
    @Override
    public boolean processEvents(List<AsyncEvent<Object, Object>> events) {
        boolean status = false;
        Log.getLogWriter().info("processEvents received List with " + events.size() + " GatewayEvents");
        if (TestConfig.tab().getRandGen().nextInt(1, 100) < 99) {
            status = true;
            for (AsyncEvent<Object, Object> event : events) {
                try {
                    this.logCall("processEvents", event);
                    WBCLTestBB.getBB().getSharedCounters().setIfLarger(WBCLTestBB.lastEventTime, System.currentTimeMillis());
                    Region wbclRegion = CacheHelper.getCache().getRegion("wbclRegion");
                    Object key = event.getKey();
                    Object value = event.getDeserializedValue();
                    Operation op = event.getOperation();
                    Object callback = event.getCallbackArgument();
                    if (op.isCreate()) {
                        try {
                            wbclRegion.create(key, value, callback);
                        }
                        catch (EntryExistsException e) {
                            Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                        }
                        continue;
                    }
                    if (op.isUpdate()) {
                        wbclRegion.put(key, value, callback);
                        continue;
                    }
                    if (op.isInvalidate()) {
                        this.throwException("Unexpected INVALIDATE encounted in WBCLEventListener " + op.toString() + ", " + TestHelper.getStackTrace());
                        continue;
                    }
                    if (!op.isDestroy()) continue;
                    try {
                        wbclRegion.destroy(key, callback);
                    }
                    catch (EntryNotFoundException e) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                    }
                }
                catch (Exception e) {
                    status = false;
                    this.throwException("WBCL Listener caught unexpected Exception " + e + ", " + TestHelper.getStackTrace(e));
                }
            }
        }
        if (status) {
            Log.getLogWriter().info("WBCLEventListener processed batch of " + events.size() + " events, returning " + status);
        } else {
            Log.getLogWriter().info("WBCLEventListener DID NOT process batch of " + events.size() + " events, returning " + status);
        }
        return status;
    }
}

