/*
 * Decompiled with CFR 0.152.
 */
package parReg.wbcl;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.GatewayEvent;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import event.EventBB;
import hydra.CacheHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import parReg.wbcl.WBCLTestBB;
import util.TestException;
import util.TestHelper;

public class WBCLEventListener
implements GatewayEventListener,
Declarable {
    public static int lastEventTime;
    public int whereIWasRegistered = ProcessMgr.getProcessId();
    protected Executor serialExecutor = Executors.newSingleThreadExecutor();

    public boolean processEvents(List events) {
        boolean status = false;
        Log.getLogWriter().info("processEvents received List with " + events.size() + " GatewayEvents");
        if (TestConfig.tab().getRandGen().nextInt(1, 100) < 90) {
            status = true;
            for (GatewayEvent event : events) {
                try {
                    this.logCall("processEvents", event);
                    WBCLTestBB.getBB().getSharedCounters().setIfLarger(WBCLTestBB.lastEventTime, System.currentTimeMillis());
                    final Region wbclRegion = CacheHelper.getCache().getRegion("wbclRegion");
                    final Object key = event.getKey();
                    final Object value = event.getDeserializedValue();
                    final Operation op = event.getOperation();
                    this.serialExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (op.isCreate()) {
                                try {
                                    Log.getLogWriter().info("Creating key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                    wbclRegion.create(key, value);
                                    Log.getLogWriter().info("Done creating key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                }
                                catch (EntryExistsException e) {
                                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                                }
                            } else if (op.isUpdate()) {
                                Log.getLogWriter().info("Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                wbclRegion.put(key, value);
                                Log.getLogWriter().info("Done Putting key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            } else if (op.isInvalidate()) {
                                WBCLEventListener.this.throwException("Unexpected INVALIDATE encounted in WBCLEventListener " + op.toString() + ", " + TestHelper.getStackTrace());
                            } else if (op.isDestroy()) {
                                Log.getLogWriter().info("Destroying key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                                try {
                                    wbclRegion.destroy(key);
                                }
                                catch (EntryNotFoundException e) {
                                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent operations; continuing with test");
                                }
                                Log.getLogWriter().info("Done destroying key/value pair (" + key + ", " + value + ") in region named " + wbclRegion.getName());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    status = false;
                    this.throwException("WBCL Listener caught unexpected Exception " + e + ", " + TestHelper.getStackTrace(e));
                }
            }
        }
        if (status) {
            Log.getLogWriter().info("WBCLEventListener processed batch of " + events.size() + " events, returning " + status);
        } else {
            Log.getLogWriter().info("WBCLEventListener DID NOT process batch of " + events.size() + " events, returning " + status);
        }
        return status;
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    public void close() {
        this.logCall("close", null);
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public String logCall(String methodName, GatewayEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public String toString(String methodName, GatewayEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName() + "\n");
        aStr.append("   whereIWasRegistered: " + this.whereIWasRegistered + "\n");
        if (event == null) {
            return aStr.toString();
        }
        Operation op = event.getOperation();
        aStr.append("   Operation: " + op.toString() + "\n");
        if (op.isCreate()) {
            aStr.append("      Operation.getCorrespondingCreateOp(): " + op.getCorrespondingCreateOp().toString() + "\n");
        } else if (op.isUpdate()) {
            aStr.append("      Operation.getCorrespondingUpdate(Op): " + op.getCorrespondingUpdateOp().toString() + "\n");
        }
        aStr.append("      Operation.guaranteesOldValue(): " + op.guaranteesOldValue() + "\n");
        aStr.append("      Operation.isEntry(): " + op.isEntry() + "\n");
        aStr.append("      Operation.isPutAll(): " + op.isPutAll() + "\n");
        aStr.append("      Operation.isDistributed(): " + op.isDistributed() + "\n");
        aStr.append("      Operation.isLoad(): " + op.isLoad() + "\n");
        aStr.append("      Operation.isLocal(): " + op.isLocal() + "\n");
        aStr.append("      Operation.isLocalLoad(): " + op.isLocalLoad() + "\n");
        aStr.append("      Operation.isNetLoad(): " + op.isNetLoad() + "\n");
        aStr.append("      Operation.isNetSearch(): " + op.isNetSearch() + "\n");
        aStr.append("      Operation.isSearchOrLoad(): " + op.isSearchOrLoad() + "\n");
        aStr.append("   event.getCallbackArgument(): " + TestHelper.toString(event.getCallbackArgument()) + "\n");
        aStr.append("   event.getRegion(): " + TestHelper.regionToString(event.getRegion(), false) + "\n");
        aStr.append("   event.getKey(): " + event.getKey() + "\n");
        aStr.append("   event.getPossibleDuplicate(): " + event.getPossibleDuplicate() + "\n");
        aStr.append("   event.getDeserializedValue(): " + event.getDeserializedValue() + "\n");
        aStr.append("   event.getSerializedValue(): " + event.getSerializedValue() + "\n");
        return aStr.toString();
    }

    public static void waitForSilence(long desiredSilenceSec, long sleepMS) {
        Log.getLogWriter().info("Waiting for a period of silence for " + desiredSilenceSec + " seconds...");
        long desiredSilenceMS = desiredSilenceSec * 1000L;
        long silenceStartTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        long lastEventTime = WBCLTestBB.getBB().getSharedCounters().read(WBCLTestBB.lastEventTime);
        while (currentTime - silenceStartTime < desiredSilenceMS) {
            try {
                Thread.sleep(sleepMS);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            lastEventTime = WBCLTestBB.getBB().getSharedCounters().read(WBCLTestBB.lastEventTime);
            if (lastEventTime > silenceStartTime) {
                silenceStartTime = lastEventTime;
            }
            currentTime = System.currentTimeMillis();
        }
        long duration = currentTime - silenceStartTime;
        Log.getLogWriter().info("Done waiting, clients have been silent for " + duration + " ms");
    }

    class SerialExecutor
    implements Executor {
        final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
        final Executor executor;
        Runnable active;

        SerialExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.tasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.active == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.active = this.tasks.poll();
            if (this.active != null) {
                this.executor.execute(this.active);
            }
        }
    }
}

