/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import hydra.CacheHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import parReg.tx.PrTxBB;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class TxRegionListener
extends AbstractListener
implements TransactionListener {
    public void afterCommit(TransactionEvent event) {
        this.logTxEvent("afterCommit", event);
        this.verifyRegionsExist(event);
    }

    public void afterRollback(TransactionEvent event) {
        this.logTxEvent("afterRollback", event);
        this.verifyRegionsExist(event);
    }

    public void afterFailedCommit(TransactionEvent event) {
        this.logTxEvent("afterFailedCommit", event);
        this.verifyRegionsExist(event);
    }

    public void close() {
        Log.getLogWriter().info("TxRegionListener: close()");
    }

    protected void verifyRegionsExist(TransactionEvent txEvent) {
        Set existingRegions = CacheHelper.getCache().rootRegions();
        ArrayList<String> regionNames = new ArrayList<String>();
        for (Region aRegion : existingRegions) {
            regionNames.add(aRegion.getFullPath());
        }
        Log.getLogWriter().info("List of regions defined in this VM = " + regionNames);
        List events = txEvent.getEvents();
        for (CacheEvent e : events) {
            String regionName = e.getRegion().getFullPath();
            if (regionNames.contains(regionName)) continue;
            String s = "TxEvent contains CacheEvent for a region not defined in this VM.  Offending event = " + e.toString() + " with region " + regionName + ".  List of defined regions = " + regionNames;
            this.throwException(s);
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = PrTxBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }
}

