/*
 * Decompiled with CFR 0.152.
 */
package parReg.tx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;
import util.BaseValueHolder;
import util.TestException;

public class ExecuteOp
implements Function,
Declarable {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(FunctionContext context) {
        DistributedMember primaryDM;
        BaseValueHolder vh = null;
        ResultSender rs = context.getResultSender();
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isRegionContext = context instanceof RegionFunctionContext;
        boolean isPartitionedRegionContext = false;
        RegionFunctionContext regionContext = null;
        if (!(context instanceof RegionFunctionContext)) {
            throw new TestException("Function requires RegionFunctionContext!");
        }
        regionContext = (RegionFunctionContext)context;
        if (!(regionContext.getArguments() instanceof ArrayList)) throw new TestException("ExecuteOp requires an argument list with DistributedMember, opName, key, newValue, and callback");
        Region aRegion = regionContext.getDataSet();
        ArrayList argumentList = (ArrayList)regionContext.getArguments();
        String forDM = (String)argumentList.get(0);
        String opName = (String)argumentList.get(1);
        Object key = argumentList.get(2);
        Object value = null;
        Object callback = null;
        if (argumentList.size() > 3) {
            value = argumentList.get(3);
        }
        if (argumentList.size() > 4) {
            callback = argumentList.get(4);
        }
        boolean isPrimary = false;
        if (PartitionRegionHelper.isPartitionedRegion((Region)aRegion) && (primaryDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, key)).equals(dm)) {
            isPrimary = true;
        }
        if (isPrimary) {
            Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " with filter " + regionContext.getFilter());
            StringBuffer aStr = new StringBuffer();
            aStr.append("ExecuteOp args: ");
            aStr.append("dm = " + forDM + ", ");
            aStr.append("opName = " + opName + ", ");
            aStr.append("value = " + value + ", ");
            aStr.append("callback = " + callback);
            Log.getLogWriter().info(aStr.toString());
            if (opName.equalsIgnoreCase("entry-create")) {
                aRegion.create(key, value, callback);
            } else if (opName.equalsIgnoreCase("entry-update")) {
                Log.getLogWriter().info("Executing region.update (" + key + ", " + value + ", " + callback + ")");
                vh = (BaseValueHolder)aRegion.put(key, value, callback);
            } else if (opName.equalsIgnoreCase("entry-destroy")) {
                vh = (BaseValueHolder)aRegion.destroy(key, callback);
            } else if (opName.equalsIgnoreCase("entry-inval")) {
                aRegion.invalidate(key, callback);
            } else if (opName.equalsIgnoreCase("entry-getWithNewKey")) {
                vh = (BaseValueHolder)aRegion.get(key);
            } else if (opName.equalsIgnoreCase("entry-getWithExistingKey")) {
                vh = (BaseValueHolder)aRegion.get(key);
            } else {
                if (!opName.equalsIgnoreCase("entry-getWithPreviousKey")) throw new TestException("Unknown operation " + opName);
                vh = (BaseValueHolder)aRegion.get(key);
            }
        } else {
            Log.getLogWriter().info("ExecuteOp not executing on member " + dm + " because it is not the primary");
        }
        rs.lastResult(vh);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

