/*
 * Decompiled with CFR 0.152.
 */
package parReg.fixedPartitioning;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.FixedPartitionBlackboard;
import hydra.FixedPartitionPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.PartitionPrms;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import parReg.ParRegBB;
import parReg.eviction.ParRegExpirationTest;

public class FPRExpirationTest
extends ParRegExpirationTest {
    protected static Long dataStoreSequenceId;
    public static final String DATASTORE_SEQUENCE_ID = "dataStore_sequence_id_";
    protected static Cache theCache;

    public static void StartTask_initialize() {
        HydraVector fixedPartitions = TestConfig.tab().vecAt(FixedPartitionPrms.partitionNames);
        int redundantCopies = TestConfig.tab().intAt(PartitionPrms.redundantCopies);
        ArrayList secondaryFixedPartitions = new ArrayList();
        for (int i = 0; i < redundantCopies; ++i) {
            secondaryFixedPartitions.addAll(fixedPartitions);
        }
        FixedPartitionBlackboard.getInstance().getSharedMap().put("PrimaryPartitions", fixedPartitions);
        FixedPartitionBlackboard.getInstance().getSharedMap().put("SecondaryPartitions", secondaryFixedPartitions);
    }

    public static synchronized void HydraTask_initializeControlThread() {
        if (testInstance == null) {
            testInstance = new FPRExpirationTest();
            FPRExpirationTest.setDataStoreSequenceId();
            ((FPRExpirationTest)testInstance).initializeControlThread();
        }
    }

    public static synchronized void HydraTask_initServers() {
        if (testInstance == null) {
            testInstance = new FPRExpirationTest();
            FPRExpirationTest.setDataStoreSequenceId();
            ((FPRExpirationTest)testInstance).initializeServers();
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_initClients() {
        if (testInstance == null) {
            testInstance = new FPRExpirationTest();
            FPRExpirationTest.setDataStoreSequenceId();
            ((FPRExpirationTest)testInstance).initializeClients();
        }
    }

    @Override
    protected void initializeControlThread() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (String rName : regionNames) {
            String regionName = RegionHelper.getRegionDescription(rName).getRegionName();
            Region aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
            Log.getLogWriter().info("Created region " + aRegion.getName() + " with attributes " + aRegion.getAttributes());
        }
    }

    @Override
    protected void initializeServers() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (String rName : regionNames) {
            if (!rName.startsWith("bridge")) continue;
            String regionName = RegionHelper.getRegionDescription(rName).getRegionName();
            Region aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
            Log.getLogWriter().info("Created region " + aRegion.getName() + " with attributes " + aRegion.getAttributes());
        }
    }

    @Override
    public void initializeClients() {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (String rName : regionNames) {
            if (!rName.startsWith("edge")) continue;
            String regionName = RegionHelper.getRegionDescription(rName).getRegionName();
            Region aRegion = RegionHelper.createRegion(regionName, RegionHelper.getRegionAttributes(rName));
            aRegion.registerInterest((Object)"ALL_KEYS");
            Log.getLogWriter().info("Created region " + aRegion.getName() + " with attributes " + aRegion.getAttributes());
        }
    }

    public static void setDataStoreSequenceId() {
        if (ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid()) == null) {
            HashMap<String, Long> vmInfo = new HashMap<String, Long>();
            dataStoreSequenceId = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfDataStores);
            vmInfo.put(DATASTORE_SEQUENCE_ID, dataStoreSequenceId);
            ParRegBB.getBB().getSharedMap().put(RemoteTestModule.getMyVmid(), vmInfo);
        } else {
            HashMap vmInfo = (HashMap)ParRegBB.getBB().getSharedMap().get(RemoteTestModule.getMyVmid());
            dataStoreSequenceId = (Long)vmInfo.get(DATASTORE_SEQUENCE_ID);
        }
    }
}

