/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionService;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import parReg.ParRegBB;
import parReg.execute.ArrayListResultCollector;
import parReg.execute.NonPRFunction;
import parReg.execute.NonPRHctTestFunction;
import parReg.execute.NonReExecutingFunction;
import parReg.execute.ReExecutingFunction;
import util.TestException;
import util.TestHelper;

public class NonPRFunctionExecuteTest {
    protected static NonPRFunctionExecuteTest testInstance;
    protected static Cache theCache;
    protected static Region<String, Integer> aRegion;
    protected static PartitionedRegion partitionedRegion;
    public static final int NUM_KEYS = 50;
    public static final String REG_NAMES = "Region names";

    public static synchronized void HydraTask_StartTask() {
        HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
        regionNames.remove("partitionedRegion");
        ParRegBB.getBB().getSharedMap().put(REG_NAMES, regionNames);
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
            testInstance.initialize("region");
        }
    }

    public static synchronized void HydraTask_initializeWithDifferentDP() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        Vector regionNames = (Vector)ParRegBB.getBB().getSharedMap().get(REG_NAMES);
        String regionForThisNode = (String)regionNames.remove(0);
        Log.getLogWriter().info("Region description for this node " + regionForThisNode);
        testInstance.initialize(regionForThisNode);
        testInstance.initialize("partitionedRegion");
        ParRegBB.getBB().getSharedMap().put(REG_NAMES, regionNames);
    }

    public static synchronized void HydraTask_initializeServerWithDifferentDP() {
        Vector regionNames;
        String regionForThisNode;
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        if ((regionForThisNode = (String)(regionNames = (Vector)ParRegBB.getBB().getSharedMap().get(REG_NAMES)).remove(0)).equals("edge")) {
            regionForThisNode = (String)regionNames.remove(0);
        }
        Log.getLogWriter().info("Region description for this node " + regionForThisNode);
        testInstance.initialize(regionForThisNode);
        BridgeHelper.startBridgeServer("bridge");
        ParRegBB.getBB().getSharedMap().put(REG_NAMES, regionNames);
    }

    public static synchronized void HydraTask_initializeClient() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        testInstance.initialize("edge");
    }

    public static void HydraTask_populateRegion() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        testInstance.populateRegion(aRegion);
        if (partitionedRegion != null) {
            testInstance.populateRegion((Region<String, Integer>)partitionedRegion);
        }
    }

    public static void HydraTask_registerFunction() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        FunctionService.registerFunction((Function)new NonPRFunction());
        FunctionService.registerFunction((Function)new NonPRHctTestFunction());
        FunctionService.registerFunction((Function)new ReExecutingFunction());
        FunctionService.registerFunction((Function)new NonReExecutingFunction());
    }

    public static void HydraTask_executeFunction() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        testInstance.executeFunction();
    }

    public static void HydraTask_reExecuteFunctionDistributedRegion() {
        if (aRegion.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
            Log.getLogWriter().info("This node has the region with normal datapolicy. Hence not executing.");
            return;
        }
        testInstance.reExecuteFunctionDistributedRegion();
    }

    public static void HydraTask_clientReExecuteFunction() {
        testInstance.reExecuteFunctionDistributedRegion();
    }

    public static void HydraTask_executeOnRegionsFunction() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        testInstance.executeOnRegionsFunction();
    }

    public static void HydraTask_clientsExecuteFunction() {
        if (testInstance == null) {
            testInstance = new NonPRFunctionExecuteTest();
        }
        testInstance.clientsExecuteFunction();
    }

    protected void initialize(String regionDescriptName) {
        if (theCache == null) {
            theCache = CacheHelper.createCache("cache1");
        }
        String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
        Log.getLogWriter().info("Creating region " + regionName);
        RegionAttributes attributes = RegionHelper.getRegionAttributes(regionDescriptName);
        String poolName = attributes.getPoolName();
        if (poolName != null) {
            PoolHelper.createPool(poolName);
        }
        if (regionDescriptName.equals("partitionedRegion")) {
            partitionedRegion = (PartitionedRegion)theCache.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
        } else {
            aRegion = theCache.createRegion(regionName, RegionHelper.getRegionAttributes(regionDescriptName));
        }
        Log.getLogWriter().info("Completed creating region " + aRegion.getName());
    }

    protected void populateRegion(Region<String, Integer> region) {
        for (int i = 0; i < 50; ++i) {
            String keyName = "Key " + ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.numOfPutOperations);
            Integer value = new Integer(i);
            region.put((Object)keyName, (Object)value);
        }
        Log.getLogWriter().info("Completed put for 50 keys and region size is " + region.size());
    }

    protected void executeFunction() {
        Execution dataSet = FunctionService.onRegion(aRegion).withCollector((ResultCollector)new ArrayListResultCollector());
        ArrayList list = new ArrayList();
        if (aRegion.getAttributes().getDataPolicy() == DataPolicy.NORMAL || aRegion.getAttributes().getDataPolicy() == DataPolicy.EMPTY) {
            try {
                list = (ArrayList)dataSet.execute(new NonPRFunction().getId()).getResult();
            }
            catch (Exception e) {
                if (aRegion.getAttributes().getDataPolicy() == DataPolicy.NORMAL && e instanceof FunctionException && e.getMessage().contains("Function execution on region with DataPolicy.NORMAL is not supported")) {
                    Log.getLogWriter().info("Got the expected unsupported operation exception for datapolicy normal.");
                    return;
                }
                throw new TestException("Got the exception during function execution ", e);
            }
            if (aRegion.getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                throw new TestException("Function execution did not throw Unsupported operation exception with datapolicy normal but returned result of size " + list.size());
            }
        } else if (aRegion.getAttributes().getDataPolicy() == DataPolicy.REPLICATE) {
            DistributedSystem ds = aRegion.getCache().getDistributedSystem();
            DistributedMember localVM = ds.getDistributedMember();
            try {
                list = (ArrayList)dataSet.withArgs((Object)((Serializable)localVM)).execute(new NonPRFunction().getId()).getResult();
            }
            catch (Exception e) {
                throw new TestException("Caught exception during function execute ", e);
            }
        } else {
            throw new TestException("Illegal region dataPolicy " + aRegion.getAttributes().getDataPolicy());
        }
        Log.getLogWriter().info("List size is " + list.size());
        int expectedListSize = TestHelper.getNumVMs() * 50;
        if (list.size() != expectedListSize) {
            throw new TestException("Expected list size to be " + expectedListSize + " but received " + list.size());
        }
    }

    protected void executeOnRegionsFunction() {
        ArrayList list;
        HashSet<Object> regionSet = new HashSet<Object>();
        regionSet.add(aRegion);
        regionSet.add(partitionedRegion);
        Log.getLogWriter().info("Executing on region with datapolicy " + aRegion.getAttributes().getDataPolicy());
        Execution dataSet = InternalFunctionService.onRegions(regionSet).withCollector((ResultCollector)new ArrayListResultCollector());
        try {
            list = (ArrayList)dataSet.execute((Function)new NonPRFunction()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Got exception ", e);
        }
        int expectedListSize = partitionedRegion.getAllNodes().size() + 1;
        if (list.size() != expectedListSize) {
            throw new TestException("Expected the execution to have happened on " + expectedListSize + " (number of datastores + number of replicated nodes) but executed on " + list.size() + " and datapolicies are " + list);
        }
        Log.getLogWriter().info("Executed on expected nodes with datapolicies " + list);
    }

    protected void clientsExecuteFunction() {
        Execution dataSet = FunctionService.onRegion(aRegion).withCollector((ResultCollector)new ArrayListResultCollector());
        ArrayList list = new ArrayList();
        try {
            list = (ArrayList)dataSet.execute(new NonPRHctTestFunction().getId()).getResult();
        }
        catch (Exception e) {
            throw new TestException("Caught exception during function execute ", e);
        }
        Log.getLogWriter().info("List size is " + list.size());
        long expectedListSize = ParRegBB.getBB().getSharedCounters().read(ParRegBB.numOfPutOperations);
        if ((long)list.size() != expectedListSize) {
            throw new TestException("Expected list size to be " + expectedListSize + " but received " + list.size());
        }
    }

    public void reExecuteFunctionDistributedRegion() {
        ArrayList list;
        Execution execution = FunctionService.onRegion(aRegion);
        try {
            list = (ArrayList)execution.execute(new ReExecutingFunction().getId()).getResult(100L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            throw new TestException("Caught the exception during the execution of the function ReExecutionFunction " + exception);
        }
        if (list.size() == 0) {
            throw new TestException("Re-executed function should have returned results. But the result list is empty");
        }
        execution = FunctionService.onRegion(aRegion);
        try {
            list = (ArrayList)execution.execute(new NonReExecutingFunction().getId()).getResult();
            throw new TestException("NonReExecutingFunction should have thrown exception as isHA() is set false");
        }
        catch (Exception exception) {
            if (!(exception.getCause() instanceof FunctionInvocationTargetException) || !(exception.getCause().getCause() instanceof IllegalStateException)) {
                throw new TestException("Got the exception ", exception);
            }
            Log.getLogWriter().info("Got the expected exception " + exception.getMessage());
            return;
        }
    }
}

