/*
 * Decompiled with CFR 0.152.
 */
package parReg.execute;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import getInitialImage.InitImageBB;
import hydra.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import parReg.colocation.Month;
import util.TestException;

public class LocalDataSetFunctionPrimaryExecute
extends FunctionAdapter
implements Declarable {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(FunctionContext context) {
        RegionFunctionContext regionContext = (RegionFunctionContext)context;
        LocalDataSet localDataSet = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionContext);
        Region region = regionContext.getDataSet();
        int totalNumOfBuckets = ((PartitionedRegion)region).getTotalNumberOfBuckets();
        Set<Integer> expectedBucketSet = new HashSet();
        if (regionContext.getFilter() != null) {
            Set filterSet = regionContext.getFilter();
            for (Object key : filterSet) {
                Month routingObject = (Month)InitImageBB.getBB().getSharedMap().get(key);
                expectedBucketSet.add(routingObject.hashCode() % totalNumOfBuckets);
            }
            Set executedBucketSet = localDataSet.getBucketSet();
            if (!executedBucketSet.containsAll(expectedBucketSet) || executedBucketSet.size() != expectedBucketSet.size()) throw new TestException("For region " + region.getName() + " execution was supposed to happen on the buckets " + expectedBucketSet + " but happened on " + executedBucketSet);
            Log.getLogWriter().info("For region " + region.getName() + " execution happened on all the expected bucket list " + expectedBucketSet);
        } else {
            expectedBucketSet = localDataSet.getBucketSet();
        }
        Map colocatedRegionsMap = PartitionRegionHelper.getColocatedRegions((Region)localDataSet);
        Iterator iterator = colocatedRegionsMap.entrySet().iterator();
        Map.Entry entry = null;
        String colocatedRegion = null;
        LocalDataSet colocatedRegionLocalDataSet = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            colocatedRegion = (String)entry.getKey();
            colocatedRegionLocalDataSet = (LocalDataSet)entry.getValue();
            Set colocatedRegionExecutedBucketSet = colocatedRegionLocalDataSet.getBucketSet();
            if (!colocatedRegionExecutedBucketSet.containsAll(expectedBucketSet) || colocatedRegionExecutedBucketSet.size() != expectedBucketSet.size()) throw new TestException("For colocated region " + colocatedRegion + " execution was supposed to happen on the buckets " + expectedBucketSet + " but happened on " + colocatedRegionExecutedBucketSet);
            Log.getLogWriter().info("For colocated region " + colocatedRegion + " execution happened on all the expected bucket list " + expectedBucketSet);
        }
        ArrayList list = new ArrayList();
        list.addAll(localDataSet.getBucketSet());
        Log.getLogWriter().info("Returning list " + list);
        context.getResultSender().lastResult(list);
    }

    public String getId() {
        return "LocalDataSetFunctionPrimaryExecute";
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

