/*
 * Decompiled with CFR 0.152.
 */
package parReg.eviction;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceListener;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import parReg.ParRegTest;
import parReg.eviction.EvictionBB;
import parReg.eviction.EvictionPrms;
import parReg.eviction.EvictionThresholdListener;
import util.PRObserver;
import util.TestException;

public class DelayedDispatcherTest
extends ParRegTest {
    public static final String SLOW_START_TIME = "100000";
    protected static InternalResourceManager irm;
    protected static EvictionThresholdListener listener;
    public static final String CRITICAL_HEAP_PERCENTAGE = "Critical Heap Percentage";
    public static final String EVICTION_HEAP_PERCENTAGE = "Eviction Heap Percentage";
    public static final float LOWER_HEAP_LIMIT_PERCENT;
    public static final float UPPER_HEAP_LIMIT_PERCENT = 25.0f;

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            CacheClientProxy.isSlowStartForTesting = true;
            System.setProperty("slowStartTimeForTesting", SLOW_START_TIME);
            Log.getLogWriter().info("Configuring the test with slowed down dispatcher.");
            PRObserver.installObserverHook();
            testInstance = new ParRegTest();
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            BridgeHelper.startBridgeServer("bridge");
            DelayedDispatcherTest.testInstance.isBridgeClient = false;
            DelayedDispatcherTest.testInstance.isDataStore = true;
            Cache theCache = CacheHelper.getCache();
            irm = (InternalResourceManager)theCache.getResourceManager();
            Log.getLogWriter().info("Registering Listener");
            listener = new EvictionThresholdListener();
            irm.addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, (ResourceListener)listener);
        }
        DelayedDispatcherTest.testInstance.uniqueKeyIndex.set(new Integer(RemoteTestModule.getCurrentThread().getThreadId()));
    }

    public static synchronized void HydraTask_updateBB() {
        if (irm == null) {
            throw new TestException("ResourceManager is null");
        }
        float criticalHeapPercentage = irm.getCriticalHeapPercentage();
        float evictionHeapPercentage = irm.getEvictionHeapPercentage();
        EvictionBB.getBB().getSharedMap().put(CRITICAL_HEAP_PERCENTAGE, Float.valueOf(criticalHeapPercentage));
        EvictionBB.getBB().getSharedMap().put(EVICTION_HEAP_PERCENTAGE, Float.valueOf(evictionHeapPercentage));
        EvictionBB.getBB().printSharedMap();
    }

    public static synchronized void HydraTask_verifyEvictionBehavior() {
        if (TestConfig.tab().booleanAt(EvictionPrms.verifyEvictionEvents, true)) {
            DelayedDispatcherTest.checkBlackBoardForException();
        }
        if (TestConfig.tab().booleanAt(EvictionPrms.verifyHeapUsage, true)) {
            DelayedDispatcherTest.verifyHeapUsage();
        }
    }

    public static void checkBlackBoardForException() {
        Log.getLogWriter().info("Checking BB for exceptions");
        long exceptionCount = EvictionBB.getBB().getSharedCounters().read(EvictionBB.NUM_EXCEPTION);
        long exceptionLoggingComplete = EvictionBB.getBB().getSharedCounters().read(EvictionBB.NUM_COMPLETED_EXCEPTION_LOGGING);
        SharedMap sharedmap = EvictionBB.getBB().getSharedMap();
        EvictionBB.getBB().printSharedMap();
        if (exceptionCount > 5L && (exceptionLoggingComplete > 0L || sharedmap.get(new Long(1L)) != null)) {
            StringBuffer reason = new StringBuffer();
            reason.append("total exceptions = " + exceptionCount);
            reason.append("\n");
            for (long i = 1L; i < exceptionCount + 1L; ++i) {
                reason.append("Reason for exception no. " + i + " : ");
                reason.append(sharedmap.get(new Long(i)));
                reason.append("\n");
            }
            throw new TestException(reason.toString());
        }
    }

    public static void verifyHeapUsage() {
        Log.getLogWriter().info("Checking Heap Usage");
        if (irm == null) {
            throw new TestException("Resource Manager is null");
        }
        if (listener.getEvictionThresholdCalls() > 0) {
            Cache theCache = CacheHelper.getCache();
            InternalResourceManager irm = (InternalResourceManager)theCache.getResourceManager();
            long currentHeapUsage = irm.getHeapMonitor().getBytesUsed();
            double maxTenuredBytes = HeapMemoryMonitor.getTrackedMaxMemory();
            float currentHeapUsagePercentage = (float)((double)currentHeapUsage / maxTenuredBytes) * 100.0f;
            float evictionHeapPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(EVICTION_HEAP_PERCENTAGE)).floatValue();
            float criticalHeapPercentage = ((Float)EvictionBB.getBB().getSharedMap().get(CRITICAL_HEAP_PERCENTAGE)).floatValue();
            float heapLowerBound = evictionHeapPercentage - LOWER_HEAP_LIMIT_PERCENT;
            float heapUpperBound = evictionHeapPercentage + 25.0f;
            if (currentHeapUsagePercentage < heapLowerBound) {
                throw new TestException("Possible over eviction : Current heap utilization percent " + currentHeapUsagePercentage + " and eviction heap percent " + evictionHeapPercentage);
            }
            if (currentHeapUsagePercentage > heapUpperBound) {
                throw new TestException("Possibility of eviction not catching up : Current heap utilization percent " + currentHeapUsagePercentage + " and eviction heap percent " + evictionHeapPercentage);
            }
            Log.getLogWriter().info("CurrentHeapUsagePercent " + currentHeapUsagePercentage + " in allowable limits");
        } else {
            Log.getLogWriter().info("No eviction trigerred so far; hence not required to verify eviction behavior");
        }
    }

    static {
        LOWER_HEAP_LIMIT_PERCENT = System.getProperty("java.vm.vendor").startsWith("IBM") ? 25.0f : 15.0f;
    }
}

