/*
 * Decompiled with CFR 0.152.
 */
package parReg;

import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertListener;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import parReg.ParRegBB;

public class ParRegAlertListener
implements AlertListener {
    private void recordErrorIfFirst(String error) {
        Log.getLogWriter().info("Detected " + error);
        long counter = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ErrorRecorded);
        if (counter == 1L) {
            Log.getLogWriter().info("Putting error " + error + " into blackboard map at key " + "Error" + " for client to notice");
            ParRegBB.getBB().getSharedMap().put("Error", error);
        }
    }

    public void alert(Alert alert) {
        boolean isLocalMaxMemoryMsg;
        int myPID = ProcessMgr.getProcessId();
        String key = "VmId_" + RemoteTestModule.getMyVmid();
        String message = alert.getMessage();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + message + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        Log.getLogWriter().info(aStr.toString());
        boolean bl = isLocalMaxMemoryMsg = message.indexOf("has exceeded local maximum memory configuration ") >= 0;
        if (!isLocalMaxMemoryMsg) {
            boolean is15SecWarning;
            boolean bl2 = is15SecWarning = message.indexOf("15 seconds have elapsed while waiting") >= 0;
            if (is15SecWarning) {
                Log.getLogWriter().info("Ignoring " + message);
                return;
            }
            this.recordErrorIfFirst("Unexpected alert message: " + aStr);
            return;
        }
        int index1 = message.indexOf(" Mb");
        int index2 = message.lastIndexOf(" ", index1 - 1);
        int maxMemoryForThisAlert = Integer.valueOf(message.substring(index2 + 1, index1));
        Log.getLogWriter().info("MB for this alert: " + maxMemoryForThisAlert);
        String counterName = "AlertForLocalMaxMemory" + maxMemoryForThisAlert;
        int counter = ParRegBB.getBB().getSharedCounter("AlertForLocalMaxMemory" + maxMemoryForThisAlert);
        long value = ParRegBB.getBB().getSharedCounters().incrementAndRead(counter);
        Log.getLogWriter().info("Counter " + counterName + " is now " + value);
    }
}

