/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.simple.cache;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import org.jgroups.simple.cache.Attributes;
import org.jgroups.simple.cache.CacheAccess;
import org.jgroups.simple.cache.CacheAttributes;
import org.jgroups.simple.cache.CacheEvent;
import org.jgroups.simple.cache.CacheEventListener;
import org.jgroups.simple.cache.CacheLoader;
import org.jgroups.simple.cache.CacheObjectInfo;
import org.jgroups.simple.cache.JCache;
import org.jgroups.simple.cache.JCacheException;
import org.jgroups.simple.cache.ObjectExistsException;

public class CacheTest1
implements Serializable {
    public void showHelp() {
        System.out.println("");
        System.out.println("Initially you can use 'set' to set attributes for the region.");
        System.out.println("When ready, use 'connect' to define the region.");
        System.out.println("");
        System.out.println("Once connected you can use these commands:");
        System.out.println("attr name        - fetch the attributes of an object");
        System.out.println("def name         - define an object");
        System.out.println("des name         - destroy an object");
        System.out.println("get name         - get the value of an object");
        System.out.println("inv name         - invalidate an object");
        System.out.println("list             - list all objects");
        System.out.println("own name         - get ownership of an object");
        System.out.println("put name value   - initial put of an object");
        System.out.println("rel name         - release ownership");
        System.out.println("repl name value  - update an object");
        System.out.println("reset            - reset attributes");
        System.out.println("set attr <value> - set an attribute");
        System.out.println("exit or quit");
        System.out.println("");
        System.out.println("For 'set', you can set idleTime, timeToLive, defaultTimeToLive, and");
        System.out.println("attribute flags in lower case.");
        System.out.println("Use 'no ' in front of an attribute flag to turn it off");
        System.out.println("Set a loader with 'set loader value'.  Loaders do netSearch first.");
        System.out.println("Set a listener with 'set listener tag'.  The tag is displayed in notifications.");
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        new CacheTest1().go();
    }

    public String parseName(String command) {
        int space = command.indexOf(32);
        if (space < 0) {
            System.err.println("You need to give a name argument for this command");
            return null;
        }
        int space2 = command.indexOf(32, space + 1);
        if (space2 < 0) {
            return command.substring(space + 1);
        }
        return command.substring(space + 1, space2);
    }

    public String parseValue(String command) {
        int space = command.indexOf(32);
        if (space < 0) {
            System.err.println("You need to give a value for this command");
            return null;
        }
        if ((space = command.indexOf(32, space + 1)) < 0) {
            System.err.println("You need to give a value for this command");
            return null;
        }
        int space2 = command.indexOf(32, space + 1);
        if (space2 < 0) {
            return command.substring(space + 1);
        }
        return command.substring(space + 1, space2);
    }

    public int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            System.err.println("illegal number: " + value);
            return -1;
        }
    }

    public long processAttributeFlag(String flagName, long flags, boolean set) {
        if (flagName.startsWith("dis")) {
            if (!set) {
                return flags & 0xFFFFFFFFFFFFFFFEL;
            }
            return flags | 1L;
        }
        if (flagName.startsWith("rep")) {
            if (!set) {
                return flags & 0xFFFFFFFFFFFFFFFBL;
            }
            return flags | 4L;
        }
        if (flagName.startsWith("syn")) {
            if (!set) {
                return flags & 0xFFFFFFFFFFFFFFF7L;
            }
            return flags | 8L;
        }
        if (flagName.startsWith("original")) {
            if (!set) {
                return flags & 0xFFFFFFFFFFFFFFDFL;
            }
            return flags | 0x20L;
        }
        System.err.println("Flag not understood: " + flagName);
        return flags;
    }

    public void go() throws Exception {
        long attrFlags = 0L;
        CacheAttributes cattr = new CacheAttributes();
        cattr.setDistribute(true);
        int maxObjects = Integer.getInteger("maxObjects", 0);
        if (maxObjects > 0) {
            cattr.setMaxObjects(maxObjects);
        }
        JCache.init(cattr);
        BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
        CacheAccess ca = null;
        Attributes attr = new Attributes();
        attr.setFlags(attrFlags);
        System.out.println("Press Enter for help at the command prompt.");
        System.out.println("");
        block20: while (true) {
            String value;
            String name2;
            System.out.print("> ");
            System.out.flush();
            String command = bin.readLine();
            if (command.startsWith("exit") || command.startsWith("quit")) break;
            if (command.startsWith("set")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                if (name2.equals("idleTime")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        int idleTime = this.parseInt(value);
                        attr.setIdleTime(idleTime);
                    }
                } else if (name2.equals("timeToLive")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        int timeToLive = this.parseInt(value);
                        attr.setTimeToLive(timeToLive);
                    }
                } else if (name2.equals("defaultTimeToLive")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        int timeToLive = this.parseInt(value);
                        attr.setDefaultTimeToLive(timeToLive);
                    }
                } else if (name2.equals("listener")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        CacheEventListener l = new CacheEventListener(){

                            @Override
                            public void handleEvent(CacheEvent event) throws JCacheException {
                                if (event.getId() == 1) {
                                    System.out.println("object '" + value + "' invalidated: " + event);
                                } else {
                                    System.out.println("object '" + value + "' updated: " + event);
                                }
                            }
                        };
                        attr.setListener(l);
                    }
                } else if (name2.equals("loader")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        attr.setLoader(new CacheLoader(){

                            @Override
                            public Object load(Object handle, Object args) throws JCacheException {
                                try {
                                    return this.netSearch(handle, 1000);
                                }
                                catch (JCacheException jCacheException) {
                                    return value;
                                }
                            }
                        });
                    }
                } else if (name2.equals("no")) {
                    value = this.parseValue(command);
                    if (value != null) {
                        attrFlags = this.processAttributeFlag(value, attrFlags, false);
                    }
                } else {
                    attrFlags = this.processAttributeFlag(name2, attrFlags, true);
                }
                attr.setFlags(attrFlags);
                continue;
            }
            if (ca == null) {
                if (command.startsWith("con")) {
                    try {
                        CacheAccess.defineRegion("MyRegion", attr);
                        System.out.println("region MyRegion is now defined.  Attributes are now reset to defaults");
                    }
                    catch (ObjectExistsException name2) {
                        // empty catch block
                    }
                    ca = CacheAccess.getAccess("MyRegion", null);
                    attr = new Attributes();
                    attrFlags = 0L;
                    continue;
                }
                System.err.println("You need to connect before using that command");
                this.showHelp();
                continue;
            }
            if (command.startsWith("repl")) {
                name2 = this.parseName(command);
                if (name2 == null || (value = this.parseValue(command)) == null) continue;
                try {
                    ca.replace(name2, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("put")) {
                name2 = this.parseName(command);
                if (name2 == null || (value = this.parseValue(command)) == null) continue;
                try {
                    ca.put(name2, attr, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("def")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    ca.defineObject(name2, attr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("get")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    value = (String)ca.get(name2);
                    System.out.println("result: " + value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("attr")) {
                if (command.indexOf(32) < 0) {
                    Attributes regionAttr = ca.getAttributes();
                    System.out.println("region attributes: " + regionAttr);
                    continue;
                }
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    Attributes entryAttr = ca.getAttributes(name2);
                    System.out.println(entryAttr.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("own")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    ca.getOwnership(name2, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("rel")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    ca.releaseOwnership(name2, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("reset")) {
                attr = new Attributes();
                attrFlags = 0L;
                System.out.println("attributes have been reset to defaults");
                continue;
            }
            if (command.startsWith("inv")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    ca.invalidate(name2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("des")) {
                name2 = this.parseName(command);
                if (name2 == null) continue;
                try {
                    ca.destroy(name2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (command.startsWith("list")) {
                Enumeration e = JCache.listCacheObjects("MyRegion");
                while (true) {
                    if (!e.hasMoreElements()) continue block20;
                    CacheObjectInfo co = (CacheObjectInfo)e.nextElement();
                    System.out.println(co.name + "   refcount: " + co.refcount + "  accesses: " + co.accesses + "  expire: " + co.expire);
                }
            }
            this.showHelp();
        }
        ca.close();
        JCache.close();
    }
}

