/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.simple.cache;

import java.io.Serializable;
import org.jgroups.simple.cache.Attributes;
import org.jgroups.simple.cache.CacheObjectInfo;

public class CacheEntry
implements Serializable {
    private Object name;
    private Object value;
    private Attributes attr;
    private boolean valid;

    protected CacheEntry(Object name, Attributes attr) {
        this.name = name;
        this.attr = attr;
        this.valid = false;
    }

    protected CacheEntry(Object name, Attributes attr, Object value) {
        this.name = name;
        this.attr = attr;
        this.value = value;
        this.valid = value != null;
    }

    protected void invalidate() {
        this.valid = false;
    }

    protected boolean isValid() {
        if (this.value == null) {
            this.valid = false;
        }
        return this.valid;
    }

    protected void setAttributes(Attributes a) {
        this.attr = a;
    }

    protected Attributes getAttributes() {
        return this.attr;
    }

    protected Object getName() {
        return this.name;
    }

    protected Object getValue() {
        if (!this.valid) {
            return null;
        }
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
        if (value != null) {
            this.attr.valueUpdated();
            this.valid = true;
        }
    }

    protected CacheObjectInfo getInfo() {
        return new CacheObjectInfo("default", this.name, "memory", 0, 0, "" + this.getExpirationTime());
    }

    protected long getExpirationTime() {
        return 0L;
    }
}

