/*
 * Decompiled with CFR 0.152.
 */
package orderPolicy;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;
import wan.WANBlackboard;

public class SequentialValuesListener
extends AbstractListener
implements CacheListener,
Declarable {
    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        Object key = event.getKey();
        ValueHolder vh = (ValueHolder)event.getNewValue();
        Integer newValue = vh.getModVal();
        if (newValue == null) {
            this.throwException("value in afterCreate cannot be null: key = " + key);
            return;
        }
        if (newValue != 0) {
            this.throwException("Expected value of 1 for afterCreate with " + key + ", but found newValue = " + newValue);
        }
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        Object key = event.getKey();
        ValueHolder newVH = (ValueHolder)event.getNewValue();
        ValueHolder oldVH = (ValueHolder)event.getOldValue();
        Integer newValue = newVH.getModVal();
        Integer oldValue = oldVH.getModVal();
        if (newValue == null) {
            this.throwException("newValue in afterUpdate cannot be null: key = " + key);
            return;
        }
        if (oldValue == null) {
            this.throwException("oldValue in afterUpdate cannot be null: key = " + key);
            return;
        }
        long diff = newValue - oldValue;
        if (diff > 1L) {
            this.throwException("Expected incremental increase between oldValue and newValue for key = " + key + " and oldValue = " + oldValue + ", but found newValue = " + newValue + " (difference = " + diff + ")");
            return;
        }
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
    }

    protected void throwException(String errStr) {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        SharedMap aMap = WANBlackboard.getInstance().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

