/*
 * Decompiled with CFR 0.152.
 */
package orderPolicy;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import util.AbstractListener;
import util.TestHelper;
import util.ValueHolder;
import wan.WANBlackboard;

public class SequentialValuesForTidHAListener
extends AbstractListener
implements CacheListener,
Declarable {
    private static final Map latestValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            Object key = event.getKey();
            ValueHolder vh = (ValueHolder)event.getNewValue();
            Integer value = vh.modVal;
            String callback = (String)event.getCallbackArgument();
            Log.getLogWriter().info("tidListener.afterCreate(): " + key + ":" + value + ":" + callback);
            if (value == null) {
                this.throwException("value in afterCreate cannot be null: key = " + key);
                return;
            }
            if (value != 0) {
                this.validateIncreasingOpNumPerTid(callback, value);
            }
            latestValues.put(callback, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpdate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            Object key = event.getKey();
            ValueHolder vh = (ValueHolder)event.getNewValue();
            Integer newValue = vh.modVal;
            vh = (ValueHolder)event.getOldValue();
            Integer oldValue = vh.modVal;
            String callback = (String)event.getCallbackArgument();
            Log.getLogWriter().info("tidListener.afterUpdate(): " + key + ":" + newValue + ":" + callback);
            if (newValue == null) {
                this.throwException("newValue in afterUpdate cannot be null: key = " + key);
                return;
            }
            this.validateIncreasingOpNumPerTid(callback, newValue);
            latestValues.put(callback, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvalidate(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            Object key = event.getKey();
            String callback = (String)event.getCallbackArgument();
            Log.getLogWriter().info("tidListener.afterInvalidate(): " + key + ":" + null + ":" + callback);
            ValueHolder vh = (ValueHolder)event.getOldValue();
            Integer oldValue = vh.modVal;
            if (oldValue != null) {
                latestValues.put(callback, oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDestroy(EntryEvent event) {
        Map map = latestValues;
        synchronized (map) {
            Object key = event.getKey();
            String callback = (String)event.getCallbackArgument();
            Log.getLogWriter().info("tidListener.afterDestroy(): " + key + ":" + null + ":" + callback);
            ValueHolder vh = (ValueHolder)event.getOldValue();
            Integer value = vh.modVal;
            if (value != null) {
                latestValues.put(callback, value);
            }
        }
    }

    private void validateIncreasingOpNumPerTid(Object key, Integer newValue) {
        Integer oldValue = (Integer)latestValues.get(key);
        if (oldValue == null) {
            return;
        }
        long diff = newValue - oldValue;
        if (diff > 1L) {
            this.throwException("Expected incremental increase between event old value and new value (representing the operation counter for thread = " + key + ").  previousOperationCounter = " + oldValue + ", newOperationCounter = " + newValue + " (difference = " + diff + ")");
            return;
        }
    }

    protected void throwException(String errStr) {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        WANBlackboard bb = WANBlackboard.getInstance();
        SharedMap aMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        if (aMap.get(TestHelper.EVENT_ERROR_KEY) == null) {
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        }
        bb.getSharedLock().unlock();
        Log.getLogWriter().info(errStr);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

