/*
 * Decompiled with CFR 0.152.
 */
package objects.query.broker;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.Vector;
import objects.query.QueryPrms;
import objects.query.broker.Broker;
import objects.query.broker.BrokerTicket;

public class BrokerPrms
extends BasePrms {
    public static final String RANDOM_EQUALITY_ON_BROKER_ID = "randomEqualityOnBrokerId";
    public static final String EQUALITY_ON_BROKER_ID = "equalityOnBrokerId";
    public static final String TICKETS_FROM_EQUALITY_ON_BROKER_ID = "ticketsFromEqualityOnBrokerId";
    public static final String TICKETS_FROM_RANDOM_RANGE_ON_TICKET_PRICE = "ticketsFromRandomRangeOnTicketPrice";
    public static final String BROKERS_FROM_RANDOM_RANGE_ON_TICKET_PRICE = "brokersFromRandomRangeOnTicketPrice";
    public static final String BROKERS_FROM_RANDOM_SIZE_RANGE_ON_TICKET_PRICE = "brokersFromRandomSizeRangeOnTicketPrice";
    public static final String BROKERS_FROM_RANDOM_PERCENTAGE_RANGE_ON_TICKET_PRICE = "brokersFromRandomPercentageRangeOnTicketPrice";
    protected static final int RANDOM_EQUALITY_ON_BROKER_ID_QUERY = 0;
    protected static final int EQUALITY_ON_BROKER_ID_QUERY = 1;
    protected static final int TICKETS_FROM_EQUALITY_ON_BROKER_ID_QUERY = 2;
    protected static final int TICKETS_FROM_RANDOM_RANGE_ON_TICKET_PRICE_QUERY = 3;
    protected static final int BROKERS_FROM_RANDOM_RANGE_ON_TICKET_PRICE_QUERY = 4;
    protected static final int BROKERS_FROM_RANDOM_SIZE_RANGE_ON_TICKET_PRICE_QUERY = 5;
    protected static final int BROKERS_FROM_RANDOM_PERCENTAGE_RANGE_ON_TICKET_PRICE_QUERY = 6;
    protected static final String PRIMARY_KEY_INDEX_ON_BROKER_ID = "primaryKeyIndexOnBrokerId";
    protected static final String UNIQUE_INDEX_ON_BROKER_NAME = "uniqueKeyIndexOnBrokerName";
    protected static final String PRIMARY_KEY_INDEX_ON_BROKER_TICKET_ID = "uniqueKeyIndexOnBrokerTicketId";
    protected static final String UNIQUE_INDEX_ON_BROKER_TICKET_NAME = "uniqueKeyIndexOnBrokerTicketName";
    protected static final int PRIMARY_KEY_INDEX_ON_BROKER_ID_QUERY = 0;
    protected static final int UNIQUE_INDEX_ON_BROKER_NAME_QUERY = 1;
    protected static final int PRIMARY_KEY_INDEX_ON_BROKER_TICKET_ID_QUERY = 2;
    protected static final int UNIQUE_INDEX_ON_BROKER_TICKET_NAME_QUERY = 3;
    public static Long brokerDataPolicy;
    public static Long brokerTicketDataPolicy;
    public static Long indexTypes;
    public static Long queryType;
    public static Long updateQueryType;
    public static Long deleteQueryType;
    public static Long brokerFields;
    public static Long brokerTicketFields;
    public static Long distinct;
    public static Long useBestFit;
    public static Long brokerRegionConfig;
    public static Long brokerTicketRegionConfig;
    public static Long numBrokers;
    public static Long numBrokerNames;
    public static Long numTicketsPerBroker;
    public static Long numTicketPrices;
    public static Long resultSetSize;
    public static Long resultSetPercentage;
    public static Long rangeMinValue;
    public static Long rangeMaxValue;

    public static int getBrokerDataPolicy() {
        Long key = brokerDataPolicy;
        String val = BrokerPrms.tasktab().stringAt(key, BrokerPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy(key, val);
    }

    public static int getBrokerTicketDataPolicy() {
        Long key = brokerTicketDataPolicy;
        String val = BrokerPrms.tasktab().stringAt(key, BrokerPrms.tab().stringAt(key, "NONE"));
        return QueryPrms.getDataPolicy(key, val);
    }

    public static Vector getIndexTypes() {
        Long key = indexTypes;
        HydraVector val = BrokerPrms.tasktab().vecAt(key, BrokerPrms.tab().vecAt(key, new HydraVector()));
        return val;
    }

    public static int getIndexType(String val) {
        Long key = indexTypes;
        if (val.equals(PRIMARY_KEY_INDEX_ON_BROKER_ID)) {
            return 0;
        }
        if (val.equals(UNIQUE_INDEX_ON_BROKER_NAME)) {
            return 1;
        }
        if (val.equals(PRIMARY_KEY_INDEX_ON_BROKER_TICKET_ID)) {
            return 2;
        }
        if (val.equals(UNIQUE_INDEX_ON_BROKER_TICKET_NAME)) {
            return 3;
        }
        String s = "Unsupported value for " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getQueryType(int api) {
        Long key = queryType;
        String val = BrokerPrms.tasktab().stringAt(key, BrokerPrms.tab().stringAt(key));
        switch (api) {
            case 0: {
                return BrokerPrms.getOQLQueryType(key, val);
            }
            case 1: {
                return BrokerPrms.getSQLQueryType(key, val);
            }
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString(api);
        throw new HydraConfigException(s);
    }

    private static int getOQLQueryType(Long key, String val) {
        if (val.equalsIgnoreCase(RANDOM_EQUALITY_ON_BROKER_ID)) {
            return 0;
        }
        String s = "Unsupported value for " + QueryPrms.getAPIString(0) + " query " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    private static int getSQLQueryType(Long key, String val) {
        if (val.equals(RANDOM_EQUALITY_ON_BROKER_ID)) {
            return 0;
        }
        if (val.equals(EQUALITY_ON_BROKER_ID)) {
            return 1;
        }
        if (val.equals(TICKETS_FROM_EQUALITY_ON_BROKER_ID)) {
            return 2;
        }
        if (val.equals(TICKETS_FROM_RANDOM_RANGE_ON_TICKET_PRICE)) {
            return 3;
        }
        if (val.equals(BROKERS_FROM_RANDOM_RANGE_ON_TICKET_PRICE)) {
            return 4;
        }
        if (val.equals(BROKERS_FROM_RANDOM_SIZE_RANGE_ON_TICKET_PRICE)) {
            return 5;
        }
        if (val.equals(BROKERS_FROM_RANDOM_PERCENTAGE_RANGE_ON_TICKET_PRICE)) {
            return 6;
        }
        String s = "Unsupported value for SQL query " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getUpdateQueryType(int api) {
        Long key = updateQueryType;
        String val = BrokerPrms.tasktab().stringAt(key, BrokerPrms.tab().stringAt(key));
        switch (api) {
            case 0: {
                return BrokerPrms.getSQLUpdateQueryType(key, val);
            }
            case 1: {
                return BrokerPrms.getSQLUpdateQueryType(key, val);
            }
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString(api);
        throw new HydraConfigException(s);
    }

    private static int getOQLUpdateQueryType(Long key, String val) {
        String s = "Unsupported value for " + QueryPrms.getAPIString(0) + " query " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    private static int getSQLUpdateQueryType(Long key, String val) {
        String s = "Unsupported value for SQL query " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getDeleteQueryType(int api) {
        Long key = deleteQueryType;
        String val = BrokerPrms.tasktab().stringAt(key, BrokerPrms.tab().stringAt(key));
        switch (api) {
            default: 
        }
        String s = "Unsupported API: " + QueryPrms.getAPIString(api);
        throw new HydraConfigException(s);
    }

    public static String getBrokerFields() {
        Long key = brokerFields;
        HydraVector val = BrokerPrms.tasktab().vecAt(key, BrokerPrms.tab().vecAt(key, new HydraVector("*")));
        return Broker.commaSeparatedStringFor(val);
    }

    public static String getBrokerTicketFields() {
        Long key = brokerTicketFields;
        HydraVector val = BrokerPrms.tasktab().vecAt(key, BrokerPrms.tab().vecAt(key, new HydraVector("*")));
        return BrokerTicket.commaSeparatedStringFor(val);
    }

    public static String getFields() {
        String fields = "";
        if (BrokerPrms.getBrokerTicketFields().indexOf("NONE") != -1) {
            if (BrokerPrms.getBrokerFields().indexOf("NONE") != -1) {
                String s = BasePrms.nameForKey(brokerFields) + " and " + BasePrms.nameForKey(brokerTicketFields) + " cannot both be NONE";
                throw new HydraConfigException(s);
            }
            fields = BrokerPrms.getBrokerFields();
        } else {
            fields = BrokerPrms.getBrokerFields().indexOf("NONE") != -1 ? BrokerPrms.getBrokerTicketFields() : BrokerPrms.getBrokerFields() + "," + BrokerPrms.getBrokerTicketFields();
        }
        if (fields.indexOf("*") != -1) {
            fields = "*";
        }
        return fields;
    }

    public static boolean getDistinct() {
        Long key = distinct;
        return BrokerPrms.tasktab().booleanAt(key, BrokerPrms.tab().booleanAt(key, false));
    }

    public static boolean useBestFit() {
        Long key = useBestFit;
        return BrokerPrms.tasktab().booleanAt(key, BrokerPrms.tab().booleanAt(key, false));
    }

    public static String getBrokerRegionConfig() {
        Long key = brokerRegionConfig;
        return BrokerPrms.tab().stringAt(key);
    }

    public static String getBrokerTicketRegionConfig() {
        Long key = brokerTicketRegionConfig;
        return BrokerPrms.tab().stringAt(key);
    }

    public static int getNumBrokers() {
        Long key = numBrokers;
        int val = BrokerPrms.tab().intAt(key);
        if (val <= 0) {
            String s = BasePrms.nameForKey(numBrokers) + " must be positive: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static int getNumBrokerNames() {
        Long key = numBrokerNames;
        int numNames = BrokerPrms.tab().intAt(key, BrokerPrms.getNumBrokers());
        if (numNames > BrokerPrms.getNumBrokers()) {
            String s = BasePrms.nameForKey(numBrokerNames) + " cannot be larger than " + BasePrms.nameForKey(numBrokers) + ".";
            throw new HydraConfigException(s);
        }
        return numNames;
    }

    public static int getNumTicketsPerBroker() {
        Long key = numTicketsPerBroker;
        int ntpb = BrokerPrms.tab().intAt(key, 1);
        if (ntpb < 0) {
            String s = BasePrms.nameForKey(numTicketsPerBroker) + " cannot be less than 0.";
            throw new HydraConfigException(s);
        }
        return ntpb;
    }

    public static int getNumTicketPrices() {
        Long key = numTicketPrices;
        int ntp = BrokerPrms.tab().intAt(key, BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker());
        if (ntp < 0 || ntp > BrokerPrms.getNumBrokers() * BrokerPrms.getNumTicketsPerBroker()) {
            String s = BasePrms.nameForKey(numTicketPrices) + " cannot be less than 0 and cannot be greater than " + BasePrms.nameForKey(numBrokers) + " * " + BasePrms.nameForKey(numTicketsPerBroker) + ".";
            throw new HydraConfigException(s);
        }
        return ntp;
    }

    public static int getResultSetSize() {
        Long key = resultSetSize;
        int size = BrokerPrms.tab().intAt(key, 1);
        if (size < 0) {
            String s = BasePrms.nameForKey(resultSetSize) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return size;
    }

    public static int getResultSetPercentage() {
        Long key = resultSetPercentage;
        int percentage = BrokerPrms.tab().intAt(key, 1);
        if (percentage < 0) {
            String s = BasePrms.nameForKey(resultSetPercentage) + " cannot be negative.";
            throw new HydraConfigException(s);
        }
        return percentage;
    }

    public static void main(String[] args) {
        BrokerPrms.dumpKeys();
    }

    static {
        BrokerPrms.setValues(BrokerPrms.class);
    }
}

