/*
 * Decompiled with CFR 0.152.
 */
package objects;

import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import java.io.IOException;
import objects.ArrayOfByte;
import objects.BatchString;
import objects.ConfigurableObject;
import objects.FlatObject;
import objects.ObjectCreationException;
import objects.ObjectValidationException;
import objects.PosNegInteger;
import objects.SizedString;
import objects.TestInteger;
import objects.TimestampedObject;
import objects.UpdatableObject;

public class ObjectHelper {
    public static Object createName(int index) {
        return String.valueOf(index);
    }

    public static Object createName(String classname, int index) {
        if (classname.equals("java.lang.Long")) {
            return (long)index;
        }
        if (classname.equals("java.lang.Integer")) {
            return index;
        }
        if (classname.equals("java.lang.String")) {
            return String.valueOf(index);
        }
        if (classname.equals("objects.BatchString")) {
            return BatchString.init(index);
        }
        if (classname.equals("objects.PosNegInteger")) {
            return PosNegInteger.init(index);
        }
        try {
            Class<?> cls = Class.forName(classname);
            return cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new HydraConfigException("Unable to find class for type " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("Unable to instantiate object of type " + classname, e);
        }
        catch (InstantiationException e) {
            throw new ObjectCreationException("Unable to instantiate object of type " + classname, e);
        }
    }

    public static Object createObject(String classname, int index) {
        if (classname.equals("objects.FlatObject")) {
            try {
                FlatObject[] obj = FlatObject.genObjects(1);
                FlatObject result = obj[0];
                result.setId(index);
                return result;
            }
            catch (IOException e) {
                throw new HydraRuntimeException("Creating FlatObject", e);
            }
        }
        if (classname.equals("objects.ArrayOfByte")) {
            return ArrayOfByte.init(index);
        }
        if (classname.equals("objects.SizedString")) {
            return SizedString.init(index);
        }
        if (classname.equals("objects.BatchString")) {
            return BatchString.init(index);
        }
        if (classname.equals("objects.TestInteger")) {
            return TestInteger.init(index);
        }
        try {
            Class<?> cls = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            ConfigurableObject obj = (ConfigurableObject)cls.newInstance();
            obj.init(index);
            return obj;
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(classname + " is neither a specially supported type nor a ConfigurableObject", e);
        }
        catch (ClassNotFoundException e) {
            throw new HydraConfigException("Unable to find class for type " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("Unable to instantiate object of type " + classname, e);
        }
        catch (InstantiationException e) {
            throw new ObjectCreationException("Unable to instantiate object of type " + classname, e);
        }
    }

    public static int getIndex(Object obj) {
        try {
            if (obj instanceof byte[]) {
                return ArrayOfByte.getIndex((byte[])obj);
            }
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.startsWith("_")) {
                    return BatchString.getIndex((String)obj);
                }
                return SizedString.getIndex((String)obj);
            }
            if (obj instanceof Integer) {
                return TestInteger.getIndex((Integer)obj);
            }
            return ((ConfigurableObject)obj).getIndex();
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(obj.getClass().getName() + " is neither a specially supported type nor a ConfigurableObject", e);
        }
    }

    public static void validate(int index, Object obj) {
        try {
            if (obj == null) {
                throw new ObjectValidationException("The object with index " + index + " is null");
            }
            if (obj instanceof byte[]) {
                ArrayOfByte.validate(index, (byte[])obj);
            } else if (obj instanceof String) {
                String s = (String)obj;
                if (s.startsWith("_")) {
                    BatchString.validate(index, (String)obj);
                } else {
                    SizedString.validate(index, (String)obj);
                }
            } else if (obj instanceof Integer) {
                TestInteger.validate(index, (Integer)obj);
            } else {
                ((ConfigurableObject)obj).validate(index);
            }
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(obj.getClass().getName() + " is neither a specially supported type nor a ConfigurableObject", e);
        }
    }

    public static long getTimestamp(Object obj) {
        try {
            if (obj instanceof byte[]) {
                return ArrayOfByte.getTimestamp((byte[])obj);
            }
            if (obj instanceof String) {
                throw new HydraConfigException(obj.getClass().getName() + " is not a specially supported type nor a TimestampedObject");
            }
            if (obj instanceof Integer) {
                throw new HydraConfigException(obj.getClass().getName() + " is not a specially supported type nor a TimestampedObject");
            }
            return ((TimestampedObject)obj).getTimestamp();
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(obj.getClass().getName() + " is neither a specially supported type nor a TimestampedObject", e);
        }
    }

    public static void resetTimestamp(Object obj) {
        try {
            if (obj instanceof byte[]) {
                ArrayOfByte.resetTimestamp((byte[])obj);
            } else {
                if (obj instanceof String) {
                    throw new HydraConfigException(obj.getClass().getName() + " is not a specially supported type nor a TimestampedObject");
                }
                if (obj instanceof Integer) {
                    throw new HydraConfigException(obj.getClass().getName() + " is not a specially supported type nor a TimestampedObject");
                }
                ((TimestampedObject)obj).resetTimestamp();
            }
        }
        catch (ClassCastException e) {
            throw new HydraConfigException(obj.getClass().getName() + " is neither a specially supported type nor a TimestampedObject", e);
        }
    }

    public static void update(Object obj) {
        try {
            ((UpdatableObject)obj).update();
        }
        catch (ClassCastException e) {
            String s = obj.getClass().getName() + " is not an UpdatableObject";
            throw new HydraConfigException(s, e);
        }
    }
}

