/*
 * Decompiled with CFR 0.152.
 */
package objects;

import cacheperf.comparisons.replicated.delta.DeltaPrms;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import hydra.Log;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import objects.ConfigurableObject;
import objects.FastAsset;
import objects.FastAssetAccount;
import objects.FastAssetAccountPrms;
import objects.TimestampedObject;

public class DeltaFastAssetAccount
extends FastAssetAccount
implements ConfigurableObject,
TimestampedObject,
ObjectSizer,
DataSerializable,
Delta,
Cloneable {
    protected static final boolean encodeTimestamp;
    protected static final boolean getBeforeUpdate;

    public boolean hasDelta() {
        if (fineEnabled) {
            Log.getLogWriter().info("INVOKED: hasDelta on key " + this.acctId);
        }
        return true;
    }

    public void toDelta(DataOutput out) throws IOException {
        out.writeDouble(this.netWorth);
        if (encodeTimestamp) {
            out.writeLong(this.timestamp);
        }
        if (fineEnabled) {
            Log.getLogWriter().info("INVOKED: toDelta on key " + this.acctId);
        }
    }

    public void fromDelta(DataInput in) throws IOException {
        this.netWorth = getBeforeUpdate ? in.readDouble() : (this.netWorth += in.readDouble());
        if (encodeTimestamp) {
            this.timestamp = in.readLong();
        }
        if (fineEnabled) {
            Log.getLogWriter().info("INVOKED: fromDelta on key " + this.acctId);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DeltaFastAssetAccount acct = (DeltaFastAssetAccount)super.clone();
        acct.assets = new HashMap();
        for (Integer key : this.assets.keySet()) {
            FastAsset asset = (FastAsset)this.assets.get(key);
            acct.assets.put(key, asset.copy());
        }
        if (fineEnabled) {
            Log.getLogWriter().info("INVOKED: clone on key " + this.acctId);
        }
        return acct;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DeltaFastAssetAccount) {
            DeltaFastAssetAccount acct = (DeltaFastAssetAccount)obj;
            if (this.acctId == acct.acctId) {
                return true;
            }
        }
        return false;
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(DeltaFastAssetAccount.class, 41){

            public DataSerializable newInstance() {
                return new DeltaFastAssetAccount();
            }
        });
        encodeTimestamp = FastAssetAccountPrms.encodeTimestamp();
        getBeforeUpdate = DeltaPrms.getBeforeUpdate();
    }
}

