/*
 * Decompiled with CFR 0.152.
 */
package objects;

import objects.BatchStringPrms;
import objects.ObjectAccessException;
import objects.ObjectValidationException;

public class BatchString {
    public static final String PREFIXER = "_";

    public static String init(int index) {
        int batchSize = BatchStringPrms.getBatchSize();
        return PREFIXER + index / batchSize + PREFIXER + index;
    }

    public static int getIndex(String str) {
        int marker = str.indexOf(PREFIXER);
        if (marker == -1) {
            throw new ObjectAccessException("Should not happen");
        }
        String index = str.substring(marker + 1, str.length());
        try {
            return new Integer(index);
        }
        catch (NumberFormatException e) {
            throw new ObjectAccessException("Should not happen");
        }
    }

    public static void validate(int index, String str) {
        int encodedIndex = BatchString.getIndex(str);
        if (encodedIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
        }
    }

    public static String getRegex(int batchNum) {
        return PREFIXER + batchNum + PREFIXER + "[0-9]+";
    }
}

