/*
 * Decompiled with CFR 0.152.
 */
package objects;

import hydra.GsRandom;
import java.io.Serializable;
import objects.AssetPrms;
import objects.ConfigurableObject;
import objects.ObjectValidationException;

public class Asset
implements ConfigurableObject,
Serializable {
    private static final GsRandom rng = new GsRandom(12L);
    private int assetId;
    private double value;

    public void init(int anAssetId) {
        this.assetId = anAssetId;
        this.value = rng.nextDouble(1.0, AssetPrms.getMaxValue());
    }

    public int getAssetId() {
        return this.assetId;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public int getIndex() {
        return this.assetId;
    }

    public void validate(int index) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != index) {
            String s = "Expected index " + index + ", got " + encodedIndex;
            throw new ObjectValidationException(s);
        }
    }

    public String toString() {
        return "Asset [assetId=" + this.assetId + " value=" + this.value + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Asset) {
            Asset asset = (Asset)obj;
            return this.assetId == asset.assetId;
        }
        return false;
    }

    public int hashCode() {
        return this.assetId;
    }
}

