/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.internal.NanoTimer;
import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.RemoteTestModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import objects.ArrayOfBytePrms;
import objects.ObjectAccessException;
import objects.ObjectCreationException;
import objects.ObjectValidationException;

public class ArrayOfByte {
    public static byte[] init(int index) {
        int size = ArrayOfBytePrms.getSize();
        boolean encodeKey = ArrayOfBytePrms.encodeKey();
        boolean encodeTimestamp = ArrayOfBytePrms.encodeTimestamp();
        return ArrayOfByte.init(index, size, encodeKey, encodeTimestamp);
    }

    protected static byte[] init(int index, int size, boolean encodeKey, boolean encodeTimestamp) {
        if (encodeKey) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeInt(index);
                if (encodeTimestamp) {
                    dos.writeLong(NanoTimer.getTime() - RemoteTestModule.getClockSkew());
                }
            }
            catch (IOException e) {
                String s = "Unable to write to stream";
                throw new ObjectCreationException(s, e);
            }
            byte[] b = baos.toByteArray();
            if (b.length > size) {
                String s = "Unable to encode into byte array of size " + size;
                throw new ObjectCreationException(s);
            }
            byte[] result = new byte[size];
            System.arraycopy(b, 0, result, 0, b.length);
            return result;
        }
        if (encodeTimestamp) {
            throw new HydraInternalException("Should not happen");
        }
        return new byte[size];
    }

    public static int getIndex(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        try {
            return dis.readInt();
        }
        catch (IOException e) {
            throw new ObjectAccessException("Unable to read from stream", e);
        }
    }

    public static long getTimestamp(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("the bytes arg was null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        try {
            dis.readInt();
            long timestamp = dis.readLong();
            if (timestamp == 0L) {
                String s = "Object is not configured to encode timestamp";
                throw new HydraConfigException(s);
            }
            return timestamp;
        }
        catch (IOException e) {
            throw new ObjectAccessException("Unable to read from stream", e);
        }
    }

    public static void resetTimestamp(byte[] bytes) {
        int index;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        try {
            index = dis.readInt();
            long timestamp = dis.readLong();
            if (timestamp == 0L) {
                return;
            }
        }
        catch (IOException e) {
            throw new ObjectAccessException("Unable to read from stream", e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(index);
            dos.writeLong(NanoTimer.getTime() - RemoteTestModule.getClockSkew());
        }
        catch (IOException e) {
            String s = "Unable to write to stream";
            throw new ObjectCreationException(s, e);
        }
        byte[] b = baos.toByteArray();
        System.arraycopy(b, 0, bytes, 0, b.length);
    }

    public static void validate(int index, byte[] bytes) {
        int encodedIndex = ArrayOfByte.getIndex(bytes);
        if (encodedIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex + " (make sure that " + BasePrms.nameForKey(ArrayOfBytePrms.encodeKey) + " is set to true)");
        }
    }
}

