/*
 * Decompiled with CFR 0.152.
 */
package newWan.discovery;

import com.gemstone.gemfire.distributed.Locator;
import hydra.DistributedSystemBlackboard;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import newWan.WANTest;
import newWan.discovery.DynamicDiscoveryBB;
import newWan.discovery.MyDistributedSystemListener;
import util.TestException;

public class DynamicDiscoveryTest
extends WANTest {
    public static synchronized void addDistributedSystemToWANTask() {
        DynamicDiscoveryBB.getInstance().getSharedLock().lock();
        DistributedSystemHelper.startLocatorAndDS();
        String dsname = DistributedSystemHelper.getDistributedSystemName();
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        HashMap<String, Set> wanSites = (HashMap<String, Set>)DynamicDiscoveryBB.getInstance().getSharedMap().get("WanSites");
        if (wanSites == null) {
            wanSites = new HashMap<String, Set>();
            HashSet<Integer> siteVms = new HashSet<Integer>();
            siteVms.add(vmid);
            wanSites.put(dsname, siteVms);
            DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSites", wanSites);
            HashMap addVmMap = (HashMap)DynamicDiscoveryBB.getInstance().getSharedMap().get("ExpectedAddPerVM");
            if (addVmMap == null) {
                addVmMap = new HashMap();
            }
            DynamicDiscoveryBB.getInstance().getSharedMap().put("ExpectedAddPerVM", addVmMap);
        } else {
            ArrayList l;
            HashSet<Integer> siteVms = (HashSet<Integer>)wanSites.get(dsname);
            if (siteVms == null) {
                siteVms = new HashSet<Integer>();
            }
            siteVms.add(vmid);
            wanSites.put(dsname, siteVms);
            Map addVmMap = (Map)DynamicDiscoveryBB.getInstance().getSharedMap().get("ExpectedAddPerVM");
            HashSet allds = new HashSet(wanSites.keySet());
            Set vms = (Set)wanSites.get(dsname);
            if (vms.size() == 1) {
                Set wanSiteKeys = wanSites.keySet();
                for (Object ds : wanSiteKeys) {
                    if (ds.equals(dsname)) {
                        l = new ArrayList();
                        allds.remove(dsname);
                        l.addAll(allds);
                        addVmMap.put(vmid, l);
                        continue;
                    }
                    Set vminds = (Set)wanSites.get(ds);
                    for (Integer v : vminds) {
                        ArrayList<String> l2 = (ArrayList<String>)addVmMap.get(v);
                        if (l2 == null) {
                            l2 = new ArrayList<String>();
                        }
                        l2.add(dsname);
                        addVmMap.put(v, l2);
                    }
                }
            } else {
                ArrayList l3 = new ArrayList();
                allds.remove(dsname);
                l3.addAll(allds);
                addVmMap.put(vmid, l3);
            }
            Map siteRemoved = (Map)DynamicDiscoveryBB.getInstance().getSharedMap().get("WanSitesRemoved");
            if (siteRemoved != null && siteRemoved.get(dsname) != null) {
                Set removedvms = (Set)siteRemoved.remove(dsname);
                Set dsvms = (Set)wanSites.get(dsname);
                dsvms.addAll(removedvms);
                wanSites.put(dsname, dsvms);
                l = new ArrayList();
                allds.remove(dsname);
                l.addAll(allds);
                addVmMap.put(vmid, l);
                DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSitesRemoved", siteRemoved);
            }
            DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSites", wanSites);
            DynamicDiscoveryBB.getInstance().getSharedMap().put("ExpectedAddPerVM", addVmMap);
        }
        DynamicDiscoveryBB.getInstance().getSharedLock().unlock();
    }

    public static void waitForLocatorDiscoveryTask() {
        new DynamicDiscoveryTest().waitForLocatorDiscovery();
    }

    public static synchronized void removeDistributedSystemFromWANTask() {
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        DistributedSystemHelper.Endpoint endpoint = (DistributedSystemHelper.Endpoint)DistributedSystemBlackboard.getInstance().getSharedMap().get(vmid);
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        Properties p = gfd.getDistributedSystemProperties();
        logger.info("Removing distributed system " + gfd.getDistributedSystem() + " from the wan.");
        Integer dsId = gfd.getDistributedSystemId();
        p.setProperty("distributed-system-id", "-" + dsId.toString());
        String remoteds = "ds_6";
        if (rand.nextInt(10) < 5) {
            remoteds = "ds_7";
        }
        List remoteEndpoints = DistributedSystemHelper.getContacts(remoteds);
        String val = DistributedSystemHelper.endpointsToString(remoteEndpoints);
        p.setProperty("remote-locators", val);
        p.setProperty("locators", "");
        String remoteLocator = p.getProperty("remote-locators");
        logger.info("rdrd: remote locator: " + remoteLocator);
        Locator locator = null;
        try {
            HashMap<String, Set> siteRemoved;
            DynamicDiscoveryBB.getInstance().getSharedLock().lock();
            logger.info("Starting locator on port " + endpoint.getPort() + " with properties " + p);
            locator = Locator.startLocatorAndDS((int)endpoint.getPort(), null, (Properties)p);
            logger.info("Started locator " + locator);
            String dsname = DistributedSystemHelper.getDistributedSystemName();
            HashMap wanSites = (HashMap)DynamicDiscoveryBB.getInstance().getSharedMap().get("WanSites");
            if (wanSites == null) {
                wanSites = new HashMap();
                HashSet<Integer> siteVms = new HashSet<Integer>();
                siteVms.add(vmid);
                wanSites.put(dsname, siteVms);
                DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSites", wanSites);
            }
            if ((siteRemoved = (HashMap<String, Set>)DynamicDiscoveryBB.getInstance().getSharedMap().get("WanSitesRemoved")) == null) {
                siteRemoved = new HashMap<String, Set>();
            }
            Set removedVms = (Set)wanSites.remove(dsname);
            siteRemoved.put(dsname, removedVms);
            HashMap<Integer, ArrayList<String>> removeVmMap = (HashMap<Integer, ArrayList<String>>)DynamicDiscoveryBB.getInstance().getSharedMap().get("ExpectedRemovePerVM");
            if (removeVmMap == null) {
                removeVmMap = new HashMap<Integer, ArrayList<String>>();
            }
            for (Map.Entry e : wanSites.entrySet()) {
                String ds = (String)e.getKey();
                Set vminds = (Set)e.getValue();
                for (Integer v : vminds) {
                    ArrayList<String> l = (ArrayList<String>)removeVmMap.get(v);
                    if (l == null) {
                        l = new ArrayList<String>();
                    }
                    l.add(dsname);
                    removeVmMap.put(v, l);
                }
            }
            logger.info("WAN_SITES=" + wanSites + "\n EXPECTED_REMOVE_PER_VM=" + removeVmMap);
            DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSitesRemoved", siteRemoved);
            DynamicDiscoveryBB.getInstance().getSharedMap().put("WanSites", wanSites);
            DynamicDiscoveryBB.getInstance().getSharedMap().put("ExpectedRemovePerVM", removeVmMap);
            DynamicDiscoveryBB.getInstance().getSharedLock().unlock();
        }
        catch (IOException e) {
            throw new TestException("Exception is starting locator with negative ds id to remove the site", e);
        }
        MasterController.sleepForMs(10000);
        System.out.println("Stoping locator " + locator);
        locator.stop();
        System.out.println("Locator stopped " + locator);
    }

    public static void verifyRemoteSiteAddedTask() {
        List<String> siteAddedList = MyDistributedSystemListener.siteAddedList;
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        Map addVmMap = (Map)DynamicDiscoveryBB.getInstance().getSharedMap().get("ExpectedAddPerVM");
        List expectedRemoteDsList = (List)addVmMap.get(vmid);
        logger.info("Remote sites added to this ds are " + siteAddedList + ", expected are " + expectedRemoteDsList);
        ArrayList<String> extraSiteAddedList = new ArrayList<String>(siteAddedList);
        ArrayList missingSiteAddedList = new ArrayList();
        if (expectedRemoteDsList != null) {
            extraSiteAddedList.removeAll(expectedRemoteDsList);
            missingSiteAddedList = new ArrayList(expectedRemoteDsList);
            missingSiteAddedList.removeAll(siteAddedList);
        }
        StringBuilder sb = new StringBuilder();
        if (extraSiteAddedList.size() > 0) {
            sb.append("Unexpected remote sites are added. Extra sites are " + extraSiteAddedList);
        }
        if (missingSiteAddedList.size() > 0) {
            sb.append("Some remote sites are missing. Missing sites are " + missingSiteAddedList);
        }
        if (sb.length() > 0) {
            throw new TestException(sb.toString());
        }
        logger.info("Verified remote site added.");
    }

    public static void verifyRemoteSiteRemovedTask() {
        List<String> siteRemovedList = MyDistributedSystemListener.siteRemovedList;
        GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
        String mydsname = gfd.getDistributedSystem();
        Integer vmid = new Integer(RemoteTestModule.getMyVmid());
        Map removedVmMap = (Map)DynamicDiscoveryBB.getInstance().getSharedMap().get("ExpectedRemovePerVM");
        List expectedRemoteDsList = (List)removedVmMap.get(vmid);
        logger.info("Remote sites removed are " + siteRemovedList + ". Expected are " + expectedRemoteDsList);
        ArrayList<String> extraSiteRemovedList = new ArrayList<String>(siteRemovedList);
        ArrayList siteNotRemovedList = new ArrayList();
        if (expectedRemoteDsList != null) {
            extraSiteRemovedList.removeAll(expectedRemoteDsList);
            siteNotRemovedList = new ArrayList(expectedRemoteDsList);
            siteNotRemovedList.removeAll(siteRemovedList);
        }
        StringBuilder sb = new StringBuilder();
        if (extraSiteRemovedList.size() > 0) {
            sb.append("Unexpected removal of remote sites observed. Extra sites removed are " + extraSiteRemovedList);
        }
        if (siteNotRemovedList.size() > 0) {
            sb.append("Expected sites to removed, but they are still exists. Unneccessary sites are " + siteNotRemovedList);
        }
        if (sb.length() > 0) {
            throw new TestException(sb.toString());
        }
        logger.info("Verified remote site removed.");
    }
}

