/*
 * Decompiled with CFR 0.152.
 */
package mirror;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import diskReg.DiskRegBB;
import diskReg.DiskRegPrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mirror.EndTaskListener1;
import mirror.EndTaskValidator;
import mirror.MirrorBB;
import mirror.MirrorPrms;
import util.CacheBB;
import util.CachePrms;
import util.CacheUtil;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.Validator;
import util.ValueHolder;

public class MirrorTest {
    static final int POSITIVE = 0;
    static final int NEGATIVE = 1;
    static final int BOTH = 2;
    static final int NEITHER = 3;
    static final int CHECK_IF_PRESENT = 0;
    static final int CHECK_ALWAYS = 1;
    static final int waitTimeMS = 300000;
    static RandomValues randomValues = null;
    public static final String REGION_NAME = "mirrorTestRegion";

    public static synchronized void HydraTask_initWithListener() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (randomValues == null) {
            randomValues = new RandomValues();
            String listenerClassName = TestConfig.tasktab().stringAt(MirrorPrms.listenerClassName, null);
            CacheListener listener = null;
            if (listenerClassName != null) {
                Class<?> listenerClass = Class.forName(listenerClassName);
                listener = (CacheListener)listenerClass.newInstance();
            }
            DataPolicy dataPolicy = null;
            MirrorType mirroring = null;
            String dataPolicyAttribute = TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute, null);
            if (dataPolicyAttribute != null) {
                dataPolicy = TestHelper.getDataPolicy(dataPolicyAttribute);
            } else {
                String mirrorAttribute = TestConfig.tasktab().stringAt(CachePrms.mirrorAttribute, null);
                if (mirrorAttribute != null) {
                    mirroring = TestHelper.getMirrorType(mirrorAttribute);
                }
            }
            boolean expectErrorOnRegionConfig = TestConfig.tab().booleanAt(MirrorPrms.expectErrorOnRegionConfig, false);
            RegionDefinition regDef = RegionDefinition.createRegionDefinition();
            String result = TestConfig.tab().stringAt(DiskRegPrms.diskAttrSpecs, "not specified");
            if (!result.equals("not specified")) {
                MirrorTest.processDiskRegionAttrs(regDef);
            }
            if (dataPolicy != null) {
                regDef.setDataPolicy(dataPolicy);
            } else if (mirroring != null) {
                regDef.setMirroring(mirroring);
            }
            Log.getLogWriter().info("Using RegionDefinition " + regDef + " to create region");
            try {
                regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, listener, null, null);
                if (expectErrorOnRegionConfig) {
                    throw new TestException("Expected error on region configuration, but did not receive an error");
                }
            }
            catch (IllegalStateException e) {
                if (expectErrorOnRegionConfig) {
                    String errStr = e.toString();
                    if (errStr.indexOf("Local Scope is incompatible with mirroring") >= 0 || errStr.indexOf("Local Scope is incompatible with replication") >= 0) {
                        Log.getLogWriter().info("Caught expected error " + e + " " + TestHelper.getStackTrace(e));
                    }
                    throw e;
                }
                throw e;
            }
            List diskDirList = regDef.getDiskDirList();
            Boolean persist = regDef.getPersistBackup();
            if (diskDirList != null && diskDirList.size() != 0 && persist != null && persist.booleanValue()) {
                regDef.setDiskDirList(diskDirList);
                String dirListKey = new String(RemoteTestModule.getMyClientName() + "_" + DiskRegBB.BACKUP_DIR_LIST);
                DiskRegBB.getBB().getSharedMap().put(dirListKey, regDef.getDiskDirList());
                Log.getLogWriter().info("put BACKUP_DIR_LIST to BB sharedMap " + regDef.getDiskDirList() + " with key = " + dirListKey);
            }
            DiskRegBB.getBB().print();
        }
    }

    public static void HydraTask_updatePositive() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        int totalNumObjectsToMirror = TestConfig.tab().intAt(MirrorPrms.totalNumObjectsToMirror);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_updatePositive, running for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        if (MirrorPrms.useTransactions()) {
            TxHelper.begin();
        }
        do {
            String key = NameFactory.getNextPositiveObjectName();
            MirrorTest.update(key);
            long total = NameFactory.getCounterForName(key) + Math.abs(NameFactory.getNegativeNameCounter());
            if (total < (long)totalNumObjectsToMirror) continue;
            if (TxHelper.exists()) {
                TxHelper.commitExpectSuccess();
            }
            throw new StopSchedulingOrder("Test has mirrored " + total + " objects, min required is " + totalNumObjectsToMirror);
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        if (TxHelper.exists()) {
            TxHelper.commitExpectSuccess();
        }
    }

    public static void HydraTask_updateNegative() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        int totalNumObjectsToMirror = TestConfig.tab().intAt(MirrorPrms.totalNumObjectsToMirror);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_updateNegative, running for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        if (MirrorPrms.useTransactions()) {
            TxHelper.begin();
        }
        do {
            String key = NameFactory.getNextNegativeObjectName();
            MirrorTest.update(key);
            long total = Math.abs(NameFactory.getCounterForName(key)) + NameFactory.getPositiveNameCounter();
            if (total < (long)totalNumObjectsToMirror) continue;
            if (TxHelper.exists()) {
                TxHelper.commitExpectSuccess();
            }
            throw new StopSchedulingOrder("Test has mirrored " + total + " objects, min required is " + totalNumObjectsToMirror);
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        if (TxHelper.exists()) {
            TxHelper.commitExpectSuccess();
        }
    }

    protected static void update(Object key) {
        ValueHolder newValue = new ValueHolder((String)key, randomValues);
        Region aRegion = CacheUtil.getCache().getRegion(REGION_NAME);
        Log.getLogWriter().info("Putting key " + key + " with value " + TestHelper.toString(newValue));
        try {
            aRegion.put(key, (Object)newValue);
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Done putting key " + key + " with value " + TestHelper.toString(newValue));
    }

    public static void HydraTask_readPositive() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(0);
        val.setContainsValueForKeyCategory(0);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readNegative() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(1);
        val.setContainsValueForKeyCategory(1);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readPositiveAndNegative() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(2);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readKeys() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(9);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readKeysButNoValues() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(3);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(5);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readKeysButNoPositiveValues() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(1);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_readKeysButNoNegativeValues() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Validator val = new Validator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(0);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(MirrorBB.isSerialExecution());
        val.setWaitForContainsKey(true);
        val.setWaitForContainsValueForKey(true);
        val.setThrowOnFirstError(true);
        val.setBlackboard(CacheBB.getBB());
        Object[] objArr = val.validateRegionContents(CacheUtil.getCache().getRegion(REGION_NAME));
        int numKeys = (Integer)objArr[0];
        int numValues = (Integer)objArr[1];
        Log.getLogWriter().info("Validated " + numKeys + " entries");
    }

    public static void HydraTask_noKeys() {
        if (MirrorBB.isSerialExecution()) {
            MirrorTest.logExecutionNumber();
        }
        Region aRegion = CacheUtil.getCache().getRegion(REGION_NAME);
        Set keySet = aRegion.keys();
        int size = keySet.size();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Log.getLogWriter().info("Found key " + it.next());
        }
        Log.getLogWriter().info("HydraTask_noKeys: got keySet of size " + keySet.size());
        if (size > 0) {
            throw new TestException("Expected no keys to be propagated, but keySet size is " + size + "\n" + NameFactory.getKeySetDiscrepancies(aRegion, keySet, 0, 0));
        }
    }

    private static void validateNoPropagation(CacheListener listener, int numAfterCreateEventsForListener) {
        StringBuffer errStr = new StringBuffer();
        boolean scopeIsLocal = RegionDefinition.createRegionDefinition().getScope().isLocal();
        EndTaskValidator val = new EndTaskValidator();
        val.setContainsKeyCategory(3);
        val.setContainsValueForKeyCategory(3);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(scopeIsLocal ? 5 : 7);
        val.setStableKeys(true);
        val.setWaitForContainsKey(false);
        val.setWaitForContainsValueForKey(false);
        val.setThrowOnFirstError(false);
        val.setBlackboard(CacheBB.getBB());
        val.setListener(listener);
        val.setNumAfterCreateEventsForListener(numAfterCreateEventsForListener);
        val.setNumAfterCreateEventsForOtherListeners(scopeIsLocal ? 0 : -1);
        val.setCreationKeySetSize(0);
        val.setEndKeySetSize(0);
        errStr.append(val.endTaskValidate());
        CacheBB.getBB().printSharedCounters();
        MirrorBB.getMirrorBB().printSharedCounters();
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static void HydraTask_validateNoPropagation() {
        boolean scopeIsLocal = RegionDefinition.createRegionDefinition().getScope().isLocal();
        MirrorTest.validateNoPropagation(MirrorTest.getNextEndTaskListener(), 0);
    }

    public static void HydraTask_validateNoPropagationPositive() {
        boolean scopeIsLocal = RegionDefinition.createRegionDefinition().getScope().isLocal();
        int numNames = scopeIsLocal ? 0 : Math.abs((int)NameFactory.getNegativeNameCounter());
        MirrorTest.validateNoPropagation(MirrorTest.getNextEndTaskListener(), numNames);
    }

    public static void HydraTask_validateNoPropagationNegative() {
        boolean scopeIsLocal = RegionDefinition.createRegionDefinition().getScope().isLocal();
        int numNames = scopeIsLocal ? 0 : Math.abs((int)NameFactory.getPositiveNameCounter());
        MirrorTest.validateNoPropagation(MirrorTest.getNextEndTaskListener(), numNames);
    }

    private static String validateMirrorKeys(int numAfterCreateEventsForListener, int containsKeyCategory, int containsValueForKeyCategory, int creationKeySetSize) {
        EndTaskValidator val = new EndTaskValidator();
        val.setContainsKeyCategory(containsKeyCategory);
        val.setContainsValueForKeyCategory(containsValueForKeyCategory);
        val.setDoGetStrategy(4);
        val.setValueShouldBeNull(7);
        val.setStableKeys(true);
        val.setWaitForContainsKey(false);
        val.setWaitForContainsValueForKey(false);
        val.setThrowOnFirstError(false);
        val.setBlackboard(CacheBB.getBB());
        val.setListener(MirrorTest.getNextEndTaskListener());
        val.setNumAfterCreateEventsForListener(numAfterCreateEventsForListener);
        val.setNumAfterCreateEventsForOtherListeners(-1);
        val.setCreationKeySetSize(creationKeySetSize);
        val.setEndKeySetSize(creationKeySetSize);
        val.setValidatePositiveNameCounter(true);
        val.setValidateNegativeNameCounter(true);
        StringBuffer errStr = new StringBuffer();
        errStr.append(val.endTaskValidate());
        return errStr.toString();
    }

    public static void HydraTask_validateMirrorKeysPositive() {
        String errStr = MirrorTest.validateMirrorKeys((int)Math.abs(NameFactory.getNegativeNameCounter()), 0, 0, (int)NameFactory.getPositiveNameCounter());
        if (errStr.length() > 0) {
            throw new TestException(errStr);
        }
    }

    public static void HydraTask_validateMirrorKeysNegative() {
        String errStr = MirrorTest.validateMirrorKeys((int)NameFactory.getPositiveNameCounter(), 1, 1, (int)Math.abs(NameFactory.getNegativeNameCounter()));
        if (errStr.length() > 0) {
            throw new TestException(errStr);
        }
    }

    public static void HydraTask_validateMirrorKeys() {
        String errStr = MirrorTest.validateMirrorKeys((int)NameFactory.getTotalNameCounter(), 2, 3, (int)NameFactory.getTotalNameCounter());
        if (errStr.length() > 0) {
            throw new TestException(errStr);
        }
    }

    public static void HydraTask_validateMirrorKeysValues() {
        StringBuffer errStr = new StringBuffer();
        EndTaskValidator val = new EndTaskValidator();
        val.setContainsKeyCategory(2);
        val.setContainsValueForKeyCategory(2);
        val.setDoGetStrategy(5);
        val.setValueShouldBeNull(7);
        val.setStableKeys(true);
        val.setWaitForContainsKey(false);
        val.setWaitForContainsValueForKey(false);
        val.setThrowOnFirstError(false);
        val.setBlackboard(CacheBB.getBB());
        val.setListener(new EndTaskListener1());
        val.setNumAfterCreateEventsForListener(0);
        val.setNumAfterCreateEventsForOtherListeners(-1);
        val.setCreationKeySetSize((int)NameFactory.getTotalNameCounter());
        val.setEndKeySetSize((int)NameFactory.getTotalNameCounter());
        val.setValidatePositiveNameCounter(true);
        val.setValidateNegativeNameCounter(true);
        errStr.append(val.endTaskValidate());
        if (errStr.length() > 0) {
            throw new TestException(errStr);
        }
    }

    static void logExecutionNumber() {
        long exeNum = MirrorBB.getMirrorBB().getSharedCounters().incrementAndRead(MirrorBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    private static CacheListener getNextEndTaskListener() {
        long nextListenerNum = MirrorBB.getMirrorBB().getSharedCounters().incrementAndRead(MirrorBB.NEXT_END_TASK_LISTENER);
        String className = "mirror.EndTaskListener" + nextListenerNum;
        try {
            Class<?> listenerClass = Class.forName(className);
            CacheListener listener = (CacheListener)listenerClass.newInstance();
            return listener;
        }
        catch (ClassNotFoundException e) {
            throw new TestException("Attempt to use non-existent listener " + className);
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void processDiskRegionAttrs(RegionDefinition regDef) {
        int whichDiskRegionAttrs = (int)DiskRegBB.getBB().getSharedCounters().incrementAndRead(DiskRegBB.WHICH_DISK_REGION_ATTRS);
        ArrayList diskRegionSpecNames = new ArrayList(RegionDefinition.getSpecNames(DiskRegPrms.diskAttrSpecs));
        String specName = (String)diskRegionSpecNames.get(whichDiskRegionAttrs %= diskRegionSpecNames.size());
        RegionDefinition diskRegionAttrs = RegionDefinition.createRegionDefinition(DiskRegPrms.diskAttrSpecs, specName);
        Log.getLogWriter().info("Using disk region attributes from spec: " + specName);
        regDef.setPersistBackup(diskRegionAttrs.getPersistBackup());
        regDef.setEvictionLimit(diskRegionAttrs.getEvictionLimit());
        regDef.setIsSynchronous(diskRegionAttrs.getIsSynchronous());
        regDef.setTimeInterval(diskRegionAttrs.getTimeInterval());
        regDef.setBytesThreshold(diskRegionAttrs.getBytesThreshold());
        regDef.setNumDiskDirs(diskRegionAttrs.getNumDiskDirs());
        regDef.setDiskDirList(diskRegionAttrs.getDiskDirList());
        regDef.setEvictionAction(diskRegionAttrs.getEvictionAction());
        regDef.setRollOplogs(diskRegionAttrs.getRollOplogs());
        regDef.setMaxOplogSize(diskRegionAttrs.getMaxOplogSize());
        boolean useBackupDiskDirs = TestConfig.tasktab().booleanAt(DiskRegPrms.useBackupDiskDirs, TestConfig.tab().booleanAt(DiskRegPrms.useBackupDiskDirs, false));
        ArrayList<String> diskDirList = null;
        if (useBackupDiskDirs) {
            String dirListKey = new String(RemoteTestModule.getMyClientName() + "_" + DiskRegBB.BACKUP_DIR_LIST);
            diskDirList = (ArrayList<String>)DiskRegBB.getBB().getSharedMap().get(dirListKey);
            Log.getLogWriter().fine("got BACKUP_DIR_LIST from DiskRegBB " + diskDirList + " with key = " + dirListKey);
            if (diskDirList == null) {
                String s = "No disk dir list found in blackboard under name " + dirListKey;
                throw new TestException(s);
            }
            regDef.setDiskDirList(diskDirList);
            regDef.setNumDiskDirs(diskDirList.size());
        } else {
            String runID = new File(System.getProperty("user.dir")).getName();
            HydraVector aVec = TestConfig.tasktab().vecAt(DiskRegPrms.diskDirNames, TestConfig.tab().vecAt(DiskRegPrms.diskDirNames, new HydraVector()));
            diskDirList = new ArrayList<String>();
            for (int i = 0; i < aVec.size(); ++i) {
                String dirName = (String)aVec.elementAt(i) + "-" + runID;
                diskDirList.add(dirName);
            }
            if (diskDirList.size() != 0) {
                regDef.setDiskDirList(diskDirList);
            }
        }
        regDef.setEviction(diskRegionAttrs.getEviction());
        regDef.setEvictionLimit(diskRegionAttrs.getEvictionLimit());
        regDef.setEvictionAction(diskRegionAttrs.getEvictionAction());
        regDef.setObjectSizerClass(diskRegionAttrs.getObjectSizerClass());
    }
}

