/*
 * Decompiled with CFR 0.152.
 */
package mirror;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import hydra.Log;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import java.lang.reflect.Field;
import java.util.Set;
import mirror.EventCounters1BB;
import mirror.EventCounters2BB;
import mirror.EventCounters3BB;
import mirror.EventCounters4BB;
import mirror.EventCounters5BB;
import mirror.MirrorBB;
import util.CacheUtil;
import util.NameBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.Validator;

public class EndTaskValidator
extends Validator {
    protected CacheListener listener = null;
    protected long numAfterCreateEventsForListener = 0L;
    protected long numAfterCreateEventsForOtherListeners = 0L;
    protected long creationKeySetSize = 0L;
    protected long endKeySetSize = 0L;
    protected boolean validatePositiveNameCounter = true;
    protected boolean validateNegativeNameCounter = true;

    public void setListener(CacheListener listener) {
        this.listener = listener;
    }

    public void setNumAfterCreateEventsForOtherListeners(int numAfterCreateEventsForOtherListeners) {
        this.numAfterCreateEventsForOtherListeners = numAfterCreateEventsForOtherListeners;
    }

    public void setNumAfterCreateEventsForListener(int numAfterCreateEventsForListener) {
        this.numAfterCreateEventsForListener = numAfterCreateEventsForListener;
    }

    public void setCreationKeySetSize(int creationKeySetSize) {
        this.creationKeySetSize = creationKeySetSize;
    }

    public void setEndKeySetSize(int endKeySetSize) {
        this.endKeySetSize = endKeySetSize;
    }

    public void setValidatePositiveNameCounter(boolean validatePositiveNameCounter) {
        this.validatePositiveNameCounter = validatePositiveNameCounter;
    }

    public void setValidateNegativeNameCounter(boolean validateNegativeNameCounter) {
        this.validateNegativeNameCounter = validateNegativeNameCounter;
    }

    public String endTaskValidate() {
        NameBB.getBB().printSharedCounters();
        MirrorBB.getMirrorBB().printSharedCounters();
        this.blackboard.printSharedCounters();
        StringBuffer errStr = new StringBuffer();
        errStr.append(EndTaskValidator.validateKeySetSize("After creating region in end task: ", this.creationKeySetSize));
        errStr.append(this.validateNameCounters());
        try {
            this.validateRegionContents(CacheUtil.getCache().getRegion("mirrorTestRegion"));
        }
        catch (TestException e) {
            errStr.append(e.getMessage());
        }
        try {
            long sleepTime = 30000L;
            Log.getLogWriter().info("Sleeping for " + sleepTime + " millis to allow events to occur");
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        errStr.append(EndTaskValidator.validateKeySetSize("After validating region in end task: ", this.endKeySetSize));
        NameBB.getBB().printSharedCounters();
        MirrorBB.getMirrorBB().printSharedCounters();
        this.blackboard.printSharedCounters();
        return errStr.toString();
    }

    static String checkCounter(Blackboard bb, String counterName, long expectedValue) {
        try {
            if (expectedValue < 0L) {
                return "";
            }
            Class<?> BBClass = bb.getClass();
            Field aField = BBClass.getField(counterName);
            Object value = aField.get(null);
            if (value.getClass() != Integer.class) {
                throw new TestException("Expected value of " + counterName + " from " + BBClass.getName() + " to be an Integer, but it is " + value);
            }
            int whichCounter = (Integer)value;
            SharedCounters sharedCounters = bb.getSharedCounters();
            long counterValue = sharedCounters.read(whichCounter);
            String aStr = "Validating " + counterName + " in " + BBClass.getName() + ", expected value " + expectedValue + ", actual value " + counterValue;
            Log.getLogWriter().info(aStr);
            if (counterValue != expectedValue) {
                return aStr;
            }
            return "";
        }
        catch (NoSuchFieldException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    String validateNameCounters() {
        Log.getLogWriter().info("Validating name counters...");
        StringBuffer errStr = new StringBuffer();
        long positiveCounter = NameFactory.getPositiveNameCounter();
        long negativeCounter = NameFactory.getNegativeNameCounter();
        if (positiveCounter == 0L && negativeCounter == 0L) {
            errStr.append("Error in test, both positive counter and negative counters are <= 0");
        }
        if (this.validatePositiveNameCounter) {
            Log.getLogWriter().info("positiveNameCounter is " + positiveCounter);
        } else {
            Log.getLogWriter().info("Not validating positiveNameCounter because validatePositiveNameCounter is " + this.validatePositiveNameCounter);
        }
        if (this.validateNegativeNameCounter) {
            Log.getLogWriter().info("negativeNameCounter is " + negativeCounter);
        } else {
            Log.getLogWriter().info("Not validating negativeNameCounter because validateNegativeNameCounter is " + this.validateNegativeNameCounter);
        }
        return errStr.toString();
    }

    static String validateKeySetSize(String logStr, long expectedKeySetSize) {
        Log.getLogWriter().info("Validating name set size, expecting size to be " + expectedKeySetSize);
        StringBuffer errStr = new StringBuffer();
        Region aRegion = CacheUtil.createCache().getRegion("mirrorTestRegion");
        Set keySet = aRegion.keys();
        int size = keySet.size();
        Log.getLogWriter().info(logStr + "Name set size is " + size);
        if ((long)size != expectedKeySetSize) {
            errStr.append(logStr + "Expected key set size to be " + expectedKeySetSize + ", but it was " + size);
            Log.getLogWriter().info(errStr.toString());
        }
        return errStr.toString();
    }

    static String validateMirrorNoneEvents() {
        Log.getLogWriter().info("Validating mirror none events...");
        long numNames = NameFactory.getTotalNameCounter();
        long numPositiveNames = NameFactory.getPositiveNameCounter();
        long numNegativeNames = Math.abs(NameFactory.getNegativeNameCounter());
        StringBuffer errStr = new StringBuffer();
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters1BB.getBB(), numPositiveNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters2BB.getBB(), numNegativeNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters3BB.getBB(), 0L, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters4BB.getBB(), 0L, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters5BB.getBB(), 0L, false));
        return errStr.toString();
    }

    static String validateMirrorKeysEvents() {
        Log.getLogWriter().info("Validating mirror keys events...");
        long numPositiveNames = NameFactory.getPositiveNameCounter();
        long numNegativeNames = Math.abs(NameFactory.getNegativeNameCounter());
        long numNames = NameFactory.getTotalNameCounter();
        StringBuffer errStr = new StringBuffer();
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters1BB.getBB(), numPositiveNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters2BB.getBB(), numNegativeNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters3BB.getBB(), numNames, true));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters4BB.getBB(), numNames, true));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters5BB.getBB(), numNames, true));
        return errStr.toString();
    }

    static String validateMirrorKeysValuesEvents() {
        Log.getLogWriter().info("Validating mirror keys/values events...");
        long numPositiveNames = NameFactory.getPositiveNameCounter();
        long numNegativeNames = Math.abs(NameFactory.getNegativeNameCounter());
        long numNames = NameFactory.getTotalNameCounter();
        StringBuffer errStr = new StringBuffer();
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters1BB.getBB(), numPositiveNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters2BB.getBB(), numNegativeNames, false));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters3BB.getBB(), numNames, true));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters4BB.getBB(), numNames, true));
        errStr.append(EndTaskValidator.checkCountersInBB(EventCounters5BB.getBB(), numNames, true));
        return errStr.toString();
    }

    protected static String checkCountersInBB(Blackboard bb, long expectedAfterCreateCount, boolean isOriginRemote) {
        StringBuffer errStr = new StringBuffer();
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isDist", expectedAfterCreateCount));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isNotExp", expectedAfterCreateCount));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isRemote", isOriginRemote ? expectedAfterCreateCount : 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterCreateEvents_isNotRemote", isOriginRemote ? 0L : expectedAfterCreateCount));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isNotExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterDestroyEvents_isNotRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isNotExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterInvalidateEvents_isNotRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isNotExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterUpdateEvents_isNotRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isNotExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionDestroyEvents_isNotRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isNotDist", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isNotExp", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isRemote", 0L));
        errStr.append(EndTaskValidator.checkCounter(bb, "numAfterRegionInvalidateEvents_isNotRemote", 0L));
        return errStr.toString();
    }
}

