/*
 * Decompiled with CFR 0.152.
 */
package memscale;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.offheap.MemoryBlock;
import com.gemstone.gemfire.internal.offheap.MemoryInspector;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import hydra.CacheHelper;
import hydra.Log;
import hydra.MasterController;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import memscale.MemScaleBB;
import memscale.OffHeapChunkInfo;
import memscale.OffHeapHelperVersionHelper;
import util.AEQHelper;
import util.TestException;
import util.TestHelper;

public class OffHeapHelper {
    private static final int _totalNumberOffHeapObjects = 0;
    private static final int _numberInlineValues = 1;
    private static final int _numRefCountProblems = 2;
    private static final int _lobCount = 3;
    private static final int _totalNumberOnHeapObjects = 4;
    static long verifyEndTime = 0L;

    public static void verifyOffHeapMemoryConsistency(boolean checkRefCounts) {
        if (!OffHeapHelper.isOffHeapMemoryConfigured()) {
            Log.getLogWriter().info("No off-heap memory configured, skipping off-heap memory consistency checks");
            return;
        }
        Set<Region<?, ?>> allRegions = OffHeapHelper.getAllRegions();
        if (allRegions == null) {
            allRegions = new HashSet();
        }
        long beginObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        Log.getLogWriter().info("Verifying off-heap memory consistency for " + allRegions.size() + " regions " + (checkRefCounts ? "including refCounts " : "NOT including refCounts"));
        int MAX_ORPHANS_TO_REPORT = 20;
        int MAX_REF_COUNT_PROBLEMS_TO_REPORT = 20;
        StringBuilder errStr = new StringBuilder();
        StringBuilder refCountErrStr = new StringBuilder();
        long[] statNumbers = new long[5];
        ArrayList<OffHeapChunkInfo> chunkList = new ArrayList<OffHeapChunkInfo>();
        ArrayList<SimpleMemoryAllocatorImpl.Chunk> lobChunkList = new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
        for (Region<?, ?> aRegion : allRegions) {
            Set brs;
            String regionName = aRegion.getFullPath();
            Log.getLogWriter().info("Verifying off-heap memory for " + regionName + ", enableOffHeapMemory for this region is " + aRegion.getAttributes().getEnableOffHeapMemory());
            LocalRegion localReg = (LocalRegion)aRegion;
            PartitionedRegion aPR = null;
            if (aRegion.getAttributes().getDataPolicy().withPartitioning()) {
                aPR = (PartitionedRegion)aRegion;
            }
            HashSet<Object> offHeapKeys = new HashSet<Object>();
            HashSet<Object> onHeapKeys = new HashSet<Object>();
            HashSet<String> onHeapValueClasses = new HashSet<String>();
            if (aPR == null) {
                OffHeapHelper.anaLyzeLocalRegion((LocalRegion)aRegion, offHeapKeys, onHeapKeys, onHeapValueClasses, statNumbers, chunkList, lobChunkList, checkRefCounts, refCountErrStr, errStr, 20, 20);
                continue;
            }
            PartitionedRegionDataStore prs = aPR.getDataStore();
            if (prs == null || (brs = prs.getAllLocalBucketRegions()) == null) continue;
            for (BucketRegion br : brs) {
                if (br == null) continue;
                Log.getLogWriter().info("Verifying bucket " + br.getFullPath());
                OffHeapHelper.anaLyzeLocalRegion((LocalRegion)br, offHeapKeys, onHeapKeys, onHeapValueClasses, statNumbers, chunkList, lobChunkList, checkRefCounts, refCountErrStr, errStr, 20, 20);
            }
        }
        long numberInlineValues = statNumbers[1];
        long numRefCountProblems = statNumbers[2];
        long lobCount = statNumbers[3];
        long totalNumberOnHeapObjects = statNumbers[4];
        long totalNumberOffHeapObjects = statNumbers[0] + lobCount;
        if (refCountErrStr.length() > 0) {
            errStr.append((CharSequence)refCountErrStr);
            if (numRefCountProblems > 20L) {
                errStr.append("...<" + (numRefCountProblems - 20L) + " more refCount problems>...\n");
            }
        }
        int objects = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        long numUnreachable = 0L;
        if ((long)objects != totalNumberOffHeapObjects) {
            errStr.append("Total number of off-heap objects reachable via regions is " + totalNumberOffHeapObjects + (lobCount == 0L ? "" : " (including " + lobCount + " SqlFire Lobs)") + ", but the number of objects stored off-heap according to stats is " + objects + " (difference of " + Math.abs((long)objects - totalNumberOffHeapObjects) + ")\n");
            if ((long)objects > totalNumberOffHeapObjects) {
                numUnreachable = (long)objects - totalNumberOffHeapObjects;
            }
        }
        boolean foundOrphans = numUnreachable > 0L;
        SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
        if (offHeapStore != null) {
            List orphanedChunks = offHeapStore.getLostChunks();
            orphanedChunks.removeAll(lobChunkList);
            int numOrphanedChunks = orphanedChunks.size();
            if ((long)numOrphanedChunks != numUnreachable) {
                errStr.append("Number of off-heap values unreachable through regions is " + numUnreachable + " but number of orphaned chunks detected with internal free and live lists is " + numOrphanedChunks + "\n");
            }
            if (numOrphanedChunks > 0) {
                foundOrphans = true;
                String aStr = numOrphanedChunks + " orphaned chunks detected with internal free and live lists";
                Log.getLogWriter().info(aStr);
                errStr.append(aStr + "\n");
                for (int i = 0; i < orphanedChunks.size(); ++i) {
                    SimpleMemoryAllocatorImpl.Chunk aChunk = (SimpleMemoryAllocatorImpl.Chunk)orphanedChunks.get(i);
                    aStr = "orphaned @" + Long.toHexString(aChunk.getMemoryAddress()) + " rc=" + aChunk.getRefCount();
                    List info = SimpleMemoryAllocatorImpl.getRefCountInfo((long)aChunk.getMemoryAddress());
                    String logStr = info != null ? aStr + " history=" + info : aStr;
                    Log.getLogWriter().info(logStr);
                    if (i >= 20) continue;
                    errStr.append(aStr + "\n");
                }
                if (orphanedChunks.size() > 20) {
                    errStr.append("...<" + (orphanedChunks.size() - 20) + " more orphans>...\n");
                }
            }
        }
        if (foundOrphans) {
            OffHeapHelper.dumpOffHeapOrphans();
        }
        errStr.append(OffHeapHelper.verifyChunks(chunkList));
        if (errStr.length() > 0) {
            Log.getLogWriter().info(errStr.toString());
        }
        long totalVerified = totalNumberOffHeapObjects + totalNumberOnHeapObjects + numberInlineValues;
        Log.getLogWriter().info("Verified a total of " + totalVerified + " objects in " + allRegions.size() + " regions including " + totalNumberOffHeapObjects + " off-heap objects, " + totalNumberOnHeapObjects + " on-heap objects, and " + numberInlineValues + " in-line values");
        if (errStr.length() > 0) {
            Log.getLogWriter().info(errStr.toString());
            long finalObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
            if (beginObjectsStat != finalObjectsStat) {
                errStr.insert(0, "Off-heap memory was not stable during off-heap memory validation. Number of off-heap objects at the beginning of validation: " + beginObjectsStat + ", number of off-heap objects at the end of validation: " + finalObjectsStat + "\n");
            }
            throw new TestException(errStr.toString());
        }
    }

    public static void waitForGlobalOffHeapSilence() {
        OffHeapHelper.waitForGlobalOffHeapSilence(30);
    }

    public static void waitForGlobalOffHeapSilence(int secondsOfSilence) {
        if (!OffHeapHelper.isOffHeapMemoryConfigured()) {
            Log.getLogWriter().info("Off-heap memory is not present in this member");
            return;
        }
        long startObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        long msOfSilence = secondsOfSilence * 1000;
        Log.getLogWriter().info("Waiting for off-heap memory to be silent for " + secondsOfSilence + " seconds across the system, current objects stat for this member is " + startObjectsStat);
        int MS_TO_SLEEP = 750;
        MemScaleBB.getBB().getSharedCounters().setIfLarger(MemScaleBB.lastOffHeapChangeTime, System.currentTimeMillis());
        while (true) {
            long currentObjectsStat;
            if ((currentObjectsStat = (long)OffHeapHelper.getOffHeapMemoryStats().getObjects()) == startObjectsStat) {
                long lastChangeTime = MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.lastOffHeapChangeTime);
                long currentTime = System.currentTimeMillis();
                long waitTimeMs = currentTime - lastChangeTime;
                if (waitTimeMs >= msOfSilence) {
                    Log.getLogWriter().info("Done waiting for off-heap memory silence across the system, off-heap memory has been silent for " + waitTimeMs / 1000L + " seconds");
                    return;
                }
                MasterController.sleepForMs(750);
                continue;
            }
            Log.getLogWriter().info("Off-heap memory objects stat changed from " + startObjectsStat + " to " + currentObjectsStat);
            MemScaleBB.getBB().getSharedCounters().setIfLarger(MemScaleBB.lastOffHeapChangeTime, System.currentTimeMillis());
            startObjectsStat = currentObjectsStat;
        }
    }

    public static void waitForOffHeapSilence() {
        OffHeapHelper.waitForOffHeapSilence(30);
    }

    public static void waitForOffHeapSilence(int secondsOfSilence) {
        if (!OffHeapHelper.isOffHeapMemoryConfigured()) {
            Log.getLogWriter().info("Off-heap memory is not present in this member");
            return;
        }
        long silenceStartTime = System.currentTimeMillis();
        long startObjectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
        long msOfSilence = secondsOfSilence * 1000;
        Log.getLogWriter().info("Waiting for off-heap memory to be silent for " + secondsOfSilence + " seconds, current objects stat is " + startObjectsStat);
        int MS_TO_SLEEP = 750;
        while (true) {
            long currentObjectsStat;
            if ((currentObjectsStat = (long)OffHeapHelper.getOffHeapMemoryStats().getObjects()) == startObjectsStat) {
                long currentTime = System.currentTimeMillis();
                long waitTimeMs = currentTime - silenceStartTime;
                if (waitTimeMs >= msOfSilence) {
                    Log.getLogWriter().info("Done waiting for off-heap memory silence, off-heap memory has been silent for " + waitTimeMs / 1000L + " seconds");
                    return;
                }
                MasterController.sleepForMs(750);
                continue;
            }
            Log.getLogWriter().info("Off-heap memory objects stat changed from " + startObjectsStat + " to " + currentObjectsStat);
            silenceStartTime = System.currentTimeMillis();
            startObjectsStat = currentObjectsStat;
        }
    }

    private static void anaLyzeLocalRegion(LocalRegion localReg, Set<Object> offHeapKeys, Set<Object> onHeapKeys, Set<String> onHeapValueClasses, long[] statNumbers, List<OffHeapChunkInfo> chunkList, List<SimpleMemoryAllocatorImpl.Chunk> lobChunkList, boolean checkRefCounts, StringBuilder refCountErrStr, StringBuilder errStr, int MAX_ORPHANS_TO_REPORT, int MAX_REF_COUNT_PROBLEMS_TO_REPORT) {
        String regionName = localReg.getFullPath();
        for (Object key : localReg.keySet()) {
            Object value = null;
            RegionEntry entry = localReg.getRegionEntry(key);
            if (entry == null) {
                throw new TestException("For key " + key + " in region " + regionName + ", LocalRegion.getRegionEntry(key) returned " + entry);
            }
            value = entry._getValue();
            if (value instanceof SimpleMemoryAllocatorImpl.Chunk) {
                int refCount;
                offHeapKeys.add(key);
                statNumbers[0] = statNumbers[0] + 1L;
                SimpleMemoryAllocatorImpl.Chunk aChunk = (SimpleMemoryAllocatorImpl.Chunk)value;
                OffHeapChunkInfo info = new OffHeapChunkInfo(regionName, key, aChunk.getMemoryAddress(), aChunk.getSize());
                chunkList.add(info);
                OffHeapHelperVersionHelper.checkIsAllocated(aChunk);
                if (checkRefCounts && (refCount = aChunk.getRefCount()) != 1) {
                    statNumbers[2] = statNumbers[2] + 1L;
                    if (statNumbers[2] <= (long)MAX_REF_COUNT_PROBLEMS_TO_REPORT) {
                        refCountErrStr.append(localReg.getFullPath() + " key " + key + " has off-heap refCount " + refCount + " @" + Long.toHexString(aChunk.getMemoryAddress()) + "\n");
                        if (SimpleMemoryAllocatorImpl.trackReferenceCounts()) {
                            List history = SimpleMemoryAllocatorImpl.getRefCountInfo((long)aChunk.getMemoryAddress());
                            if (history != null) {
                                String logStr = "extraRefs for @" + Long.toHexString(aChunk.getMemoryAddress()) + " rc=" + refCount + " history=" + history;
                                Log.getLogWriter().info(logStr);
                            } else {
                                Log.getLogWriter().info("No history for @" + Long.toHexString(aChunk.getMemoryAddress()));
                            }
                        }
                    }
                }
                List<SimpleMemoryAllocatorImpl.Chunk> aList = OffHeapHelper.getSqlLobChunks(aChunk, regionName, key);
                for (SimpleMemoryAllocatorImpl.Chunk lobChunk : aList) {
                    info = new OffHeapChunkInfo(regionName, key, lobChunk.getMemoryAddress(), lobChunk.getSize());
                    chunkList.add(info);
                    int refCount2 = lobChunk.getRefCount();
                    if (refCount2 == 1) continue;
                    statNumbers[2] = statNumbers[2] + 1L;
                    if (statNumbers[2] > (long)MAX_REF_COUNT_PROBLEMS_TO_REPORT) continue;
                    refCountErrStr.append(localReg.getFullPath() + " key " + key + " lob at address " + lobChunk.getMemoryAddress() + " has off-heap refCount " + refCount2 + "\n");
                    List history = SimpleMemoryAllocatorImpl.getRefCountInfo((long)lobChunk.getMemoryAddress());
                    if (history == null) continue;
                    String logStr = "extraRefs for @" + Long.toHexString(lobChunk.getMemoryAddress()) + " rc=" + refCount2 + " history=" + history;
                    Log.getLogWriter().info(logStr);
                }
                lobChunkList.addAll(aList);
                statNumbers[3] = statNumbers[3] + (long)aList.size();
                continue;
            }
            if (value instanceof SimpleMemoryAllocatorImpl.DataAsAddress) {
                statNumbers[1] = statNumbers[1] + 1L;
                continue;
            }
            if (value == Token.INVALID || value == Token.LOCAL_INVALID || value == null) continue;
            onHeapKeys.add(key);
            onHeapValueClasses.add(value.getClass().getName());
        }
        statNumbers[4] = statNumbers[4] + (long)onHeapKeys.size();
        if (localReg.getAttributes().getEnableOffHeapMemory()) {
            if (onHeapKeys.size() > 0) {
                Class<?> clazz = localReg.getClass();
                boolean isHDFS = false;
                try {
                    Method isHDFSRegionMethod = clazz.getDeclaredMethod("isHDFSRegion", null);
                    isHDFSRegionMethod.setAccessible(true);
                    isHDFS = (Boolean)isHDFSRegionMethod.invoke((Object)localReg, (Object[])null);
                }
                catch (Throwable th) {
                    throw new RuntimeException("Could not determine if it is a HDFS region", th);
                }
                if (!isHDFS) {
                    errStr.append(localReg.getFullPath() + " has off-heap enabled, but the following " + onHeapKeys.size() + " keys had values not found in off-heap memory: " + onHeapKeys + ", set of value classes for those keys: " + onHeapValueClasses + "\n");
                }
            }
        } else if (offHeapKeys.size() > 0) {
            errStr.append(localReg.getFullPath() + " has off-heap disabled, but the following keys had values  found in off-heap memory: " + offHeapKeys + "\n");
        }
    }

    private static List<SimpleMemoryAllocatorImpl.Chunk> getSqlLobChunks(SimpleMemoryAllocatorImpl.Chunk value, String regionName, Object key) {
        try {
            Class<?> sqlHelperClass = Class.forName("sql.sqlutil.SqlOffHeapHelper");
            Method method = sqlHelperClass.getDeclaredMethod("getLobChunks", SimpleMemoryAllocatorImpl.Chunk.class, String.class, Object.class);
            Object returnObj = method.invoke(null, value, regionName, key);
            return (List)returnObj;
        }
        catch (ClassNotFoundException e) {
            return new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (InvocationTargetException e) {
            Throwable lastInChain = e;
            while (((Throwable)lastInChain).getCause() != null) {
                lastInChain = ((Throwable)lastInChain).getCause();
            }
            if (lastInChain instanceof ClassNotFoundException || lastInChain instanceof NoClassDefFoundError) {
                return new ArrayList<SimpleMemoryAllocatorImpl.Chunk>();
            }
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void dumpOffHeapOrphans() {
        SimpleMemoryAllocatorImpl store = SimpleMemoryAllocatorImpl.getAllocator();
        if (store == null) {
            Log.getLogWriter().info("Not dumping off-heap orphans, offHeapStore is " + store);
            return;
        }
        MemoryInspector inspector = store.getMemoryInspector();
        List orphans = inspector.getOrphans();
        for (MemoryBlock block : orphans) {
            Log.getLogWriter().error("Orphaned MemoryBlock: " + block.toString());
        }
    }

    public static synchronized void closeAllRegions() {
        OffHeapHelper.closeAllOffHeapRegions();
    }

    public static synchronized void closeAllOffHeapRegions() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("The cache is null");
            return;
        }
        Set<Region<?, ?>> regionSet = OffHeapHelper.getAllRegions();
        if (regionSet.size() > 0) {
            for (Region<?, ?> aRegion : regionSet) {
                if (aRegion.getAttributes().getEnableOffHeapMemory()) {
                    Log.getLogWriter().info("Closing " + aRegion.getFullPath());
                    try {
                        aRegion.close();
                        Log.getLogWriter().info("Closed " + aRegion.getFullPath());
                    }
                    catch (RegionDestroyedException e) {
                        Log.getLogWriter().info(aRegion.getFullPath() + " was already destroyed");
                    }
                    continue;
                }
                Log.getLogWriter().info("Not closing " + aRegion.getFullPath() + " because off-heap memory is not enabled for this region");
            }
            if (OffHeapHelper.isOffHeapMemoryConfigured()) {
                long numObjectsInOffHeapMemory = OffHeapHelper.getOffHeapMemoryStats().getObjects();
                for (int retryCount = 0; numObjectsInOffHeapMemory != 0L && retryCount < 31; ++retryCount) {
                    Log.getLogWriter().info("Waiting for off-heap memory to empty, current number of objects is " + numObjectsInOffHeapMemory);
                    MasterController.sleepForMs(2000);
                    numObjectsInOffHeapMemory = OffHeapHelper.getOffHeapMemoryStats().getObjects();
                }
                if (numObjectsInOffHeapMemory > 0L) {
                    Log.getLogWriter().error("Number of objects in off-heap memory: " + numObjectsInOffHeapMemory);
                } else {
                    Log.getLogWriter().info("Number of objects in off-heap memory: " + numObjectsInOffHeapMemory);
                }
            }
        }
    }

    private static String verifyChunks(List<OffHeapChunkInfo> chunkList) {
        Collections.sort(chunkList);
        Log.getLogWriter().info("Verifying " + chunkList.size() + " off-heap memory chunks");
        StringBuilder errStr = new StringBuilder();
        ArrayList<Integer> freeMemoryIndexes = new ArrayList<Integer>();
        long totalBytesConsumedInChunks = 0L;
        for (int i = 0; i < chunkList.size(); ++i) {
            OffHeapChunkInfo currentInfo = chunkList.get(i);
            long firstAddress = currentInfo.getFirstMemoryAddress();
            if ((firstAddress & 7L) != 0L) {
                errStr.append("Off-heap memory address was not 8 byte aligned: " + currentInfo + "\n");
            }
            if (firstAddress < 1024L) {
                throw new IllegalStateException("Off-heap memory address was smaller than expected " + currentInfo + "\n");
            }
            totalBytesConsumedInChunks += currentInfo.getNumberBytes();
            if (i <= 0) continue;
            OffHeapChunkInfo previousInfo = chunkList.get(i - 1);
            if (firstAddress == previousInfo.getFirstMemoryAddress()) {
                errStr.append("<" + currentInfo + "> is referencing the same off-heap memory address as <" + previousInfo + ">\n");
                continue;
            }
            if (firstAddress <= previousInfo.getLastMemoryAddress()) {
                errStr.append("<" + currentInfo + "> overlaps off-heap memory with <" + previousInfo + ">\n");
                continue;
            }
            if (previousInfo.getLastMemoryAddress() + 1L == firstAddress) continue;
            freeMemoryIndexes.add(i - 1);
        }
        StringBuilder aStr = new StringBuilder();
        long totalFreeMemoryInBytes = 0L;
        long minFreeMemorySizeInBytes = Long.MAX_VALUE;
        long maxFreeMemorySizeInBytes = 0L;
        int maxChunksToLog = Math.min(freeMemoryIndexes.size(), 20);
        for (int i = 0; i < freeMemoryIndexes.size(); ++i) {
            int chunkListIndex = (Integer)freeMemoryIndexes.get(i);
            OffHeapChunkInfo chunkBeforeFreeMemory = chunkList.get(chunkListIndex);
            OffHeapChunkInfo chunkAfterFreeMemory = chunkList.get(chunkListIndex + 1);
            long memoryAddressOfFreeMemory = chunkBeforeFreeMemory.getLastMemoryAddress() + 1L;
            long freeMemorySizeInBytes = chunkAfterFreeMemory.getFirstMemoryAddress() - memoryAddressOfFreeMemory;
            totalFreeMemoryInBytes += freeMemorySizeInBytes;
            minFreeMemorySizeInBytes = Math.min(minFreeMemorySizeInBytes, freeMemorySizeInBytes);
            maxFreeMemorySizeInBytes = Math.max(maxFreeMemorySizeInBytes, freeMemorySizeInBytes);
            if (i + 1 > maxChunksToLog) continue;
            aStr.append("  " + (i + 1) + ": free memory of size " + freeMemorySizeInBytes + " bytes between chunk " + chunkListIndex + " <" + chunkBeforeFreeMemory + "> and next chunk <" + chunkAfterFreeMemory + ">\n");
        }
        Log.getLogWriter().info(chunkList.size() + " chunks consumed " + totalBytesConsumedInChunks + " bytes of off-heap memory");
        if (minFreeMemorySizeInBytes < 8L) {
            errStr.append("The minimum free memory size is " + minFreeMemorySizeInBytes + ", but expected it to be >= 8\n");
        }
        if (freeMemoryIndexes.size() == 0) {
            Log.getLogWriter().info("Found 0 free memory segments between chunks");
        } else {
            double average = totalFreeMemoryInBytes / (long)freeMemoryIndexes.size();
            Log.getLogWriter().info("Found " + freeMemoryIndexes.size() + " free memory segments between chunks; free memory totals " + totalFreeMemoryInBytes + " bytes, min free memory size " + minFreeMemorySizeInBytes + " bytes, max free memory size " + maxFreeMemorySizeInBytes + " bytes, average free memory size " + average + " bytes\nFirst " + maxChunksToLog + " free memory chunks:\n" + aStr);
        }
        return errStr.toString();
    }

    public static Set<Region<?, ?>> getAllRegions() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            Log.getLogWriter().info("There are no regions in this member, cache is null");
            return null;
        }
        Set rootRegions = theCache.rootRegions();
        HashSet allRegions = new HashSet();
        allRegions.addAll(rootRegions);
        for (Region aRegion : rootRegions) {
            allRegions.addAll(aRegion.subregions(true));
        }
        return allRegions;
    }

    public static void verifyRegionsEnabledWithOffHeap(List<String> regionNames) {
        StringBuilder errStr = new StringBuilder();
        boolean expectOffHeapEnabled = false;
        Set<Region<?, ?>> allRegions = OffHeapHelper.getAllRegions();
        Iterator<Region<?, ?>> iterator = allRegions.iterator();
        while (iterator.hasNext()) {
            boolean offHeapEnabled;
            Region<?, ?> aRegion;
            expectOffHeapEnabled = regionNames == null ? true : regionNames.contains(aRegion.getFullPath());
            if (expectOffHeapEnabled == (offHeapEnabled = (aRegion = iterator.next()).getAttributes().getEnableOffHeapMemory())) continue;
            errStr.append("Expected attributes for " + aRegion.getFullPath() + " to have enableOffHeapMemory " + expectOffHeapEnabled + ", but it is " + offHeapEnabled + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public static boolean isOffHeapMemoryConfigured() {
        try {
            SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
            return offHeapStore != null;
        }
        catch (CacheClosedException e) {
            String errStr = e.toString();
            if (errStr.contains("Off Heap memory allocator does not exist")) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyOffHeapMemoryConsistencyOnce() {
        try {
            long verifyRequestedTime = System.currentTimeMillis();
            Log.getLogWriter().info("Verify requested time is " + verifyRequestedTime + ", verify end time is : " + verifyEndTime);
            Class<OffHeapHelper> clazz = OffHeapHelper.class;
            synchronized (OffHeapHelper.class) {
                if (verifyRequestedTime > verifyEndTime) {
                    try {
                        OffHeapHelperVersionHelper.verifyOffHeapMemoryConsistency();
                    }
                    finally {
                        verifyEndTime = System.currentTimeMillis();
                        Log.getLogWriter().info("Verify end time is " + verifyEndTime);
                    }
                } else {
                    Log.getLogWriter().info("This thread is not verifing off-heap memory consistency because it was attempted by another thread in this member");
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
            }
        }
        finally {
            long finishedMemCheckCounter = MemScaleBB.getBB().getSharedCounters().incrementAndRead(MemScaleBB.finishedMemCheck);
            Log.getLogWriter().info("MemScaleBB.finishedMemCheck is now " + finishedMemCheckCounter);
        }
        {
            return;
        }
    }

    public static OffHeapMemoryStats getOffHeapMemoryStats() {
        SimpleMemoryAllocatorImpl offHeapStore = SimpleMemoryAllocatorImpl.getAllocator();
        if (offHeapStore == null) {
            throw new TestException("Cannot get off-heap memory stats because the offHeapStore is null");
        }
        OffHeapMemoryStats offHeapStats = offHeapStore.getStats();
        if (offHeapStats == null) {
            throw new TestException("The off-heap stats is null");
        }
        return offHeapStats;
    }

    public static void waitForWanQueuesToDrain() {
        AEQHelper.waitForAsyncEventQueuesToDrain();
    }
}

