/*
 * Decompiled with CFR 0.152.
 */
package membership;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DistributedConnectionMgr;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import membership.MembershipBB;
import membership.MembershipPrms;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;

public class MembershipTest {
    protected static MembershipTest memberTest;

    public static synchronized void HydraTask_initialize() {
        if (memberTest == null) {
            MembershipBB.getBB().getSharedCounters().setIfLarger(MembershipBB.startTime, System.currentTimeMillis());
            memberTest = new MembershipTest();
            memberTest.initialize();
        }
    }

    protected void initialize() {
        int memberPid = RemoteTestModule.getMyPid();
        int memberVmid = RemoteTestModule.getMyVmid();
        if (MembershipBB.getBB().getSharedMap().containsValue(new Integer(memberPid))) {
            throw new TestException("Duplicate pids:  " + memberPid + " for vmid: " + memberVmid);
        }
        MembershipBB.getBB().getSharedMap().put(new Integer(memberVmid), new Integer(memberPid));
        MembershipTest.log().info("### Completed adding member vmid, pidto map: " + memberVmid + ", " + memberPid);
        CacheUtil.createCache();
        this.verifyIsMember(memberPid);
        MembershipTest.log().info("### New member intialized vmid, pid: " + memberVmid + ", " + memberPid);
    }

    public static synchronized void HydraTask_initForRestart() {
        if (memberTest == null) {
            memberTest = new MembershipTest();
            memberTest.initForRestart();
        }
    }

    protected void initForRestart() {
        MembershipTest.log().info("### starting init task after restart");
        this.initialize();
        MembershipBB.zeroCounter(MembershipBB.membershipChangeInProgress);
    }

    public static void HydraTask_disruptMember() {
        memberTest.disruptMember();
    }

    public void disruptMember() {
        String operation = TestConfig.tab().stringAt(MembershipPrms.memberOperations);
        MembershipTest.log().info("### Disrupt op: " + operation);
        if (operation.equals("kill")) {
            this.killVm();
        } else if (operation.equals("disconnect")) {
            this.disconnect();
        } else if (operation.equals("close")) {
            this.closeCache();
        } else {
            throw new TestException("Unknown member operation: " + operation);
        }
    }

    public static void HydraTask_disruptOther() {
        memberTest.disruptOther();
    }

    public void disruptOther() {
        TestHelper.waitForCounter(MembershipBB.getBB(), "MembershipBB.membershipChangeInProgress", MembershipBB.membershipChangeInProgress, TestHelper.getNumVMs() - 1, true, 3000000L);
        Integer vmId = this.getOtherRandomVmId();
        this.removeMemberFromMap(vmId);
        int disruptedPid = ClientVmMgr.getPid(vmId);
        try {
            ClientVmMgr.stop("Mean Kill" + vmId, -21, -31, new ClientVmInfo(vmId, null, null));
        }
        catch (ClientVmNotFoundException ex) {
            throw new TestException("Kill other vm failed for vm id: " + vmId, ex);
        }
        this.verifyNotMember(disruptedPid);
        try {
            ClientVmMgr.start("Starting on demand", new ClientVmInfo(vmId, null, null));
        }
        catch (Exception ex) {
            throw new TestException("Restart other vm failed for vm id: " + vmId, ex);
        }
        int newMemberPid = ClientVmMgr.getPid(vmId);
        this.verifyIsMember(newMemberPid);
        long startTime = MembershipBB.readCounter(MembershipBB.startTime);
        long elapsedTime = System.currentTimeMillis() - startTime;
        long totalTaskTimeSec = TestConfig.tab().longAt(MembershipPrms.totalTaskTimeSec);
        if (elapsedTime > (totalTaskTimeSec - 15L) * 1000L) {
            MembershipTest.log().info("### disruptOther reached end of task time");
            throw new StopSchedulingTaskOnClientOrder();
        }
    }

    public static void HydraTask_killVm() {
        memberTest.killVm();
    }

    public void killVm() {
        Integer vmId = this.getOtherRandomVmId();
        this.removeMemberFromMap(vmId);
        try {
            ClientVmMgr.stop("Mean Kill" + vmId, -21, -31, new ClientVmInfo(vmId, null, null));
        }
        catch (ClientVmNotFoundException ex) {
            throw new TestException("Kill other vm failed for vm id: " + vmId, ex);
        }
        try {
            ClientVmMgr.start("Starting on demand", new ClientVmInfo(vmId, null, null));
        }
        catch (Exception ex) {
            throw new TestException("Restart other vm failed for vm id: " + vmId, ex);
        }
    }

    public static void HydraTask_stopSelf() {
        memberTest.stopSelf();
    }

    protected void stopSelf() {
        Integer myVmid = new Integer(RemoteTestModule.getMyVmid());
        Integer myPid = new Integer(RemoteTestModule.getMyPid());
        MembershipTest.log().info("### kill self: " + myVmid);
        ClientVmInfo clientVm = new ClientVmInfo(myVmid, null, null);
        this.removeMemberFromMap(myVmid);
        String stopModePrm = TestConfig.tab().stringAt(MembershipPrms.stopMode);
        MembershipTest.log().info("stop mode is: " + stopModePrm);
        int stopMode = -1;
        if (stopModePrm.equals("MEAN_KILL")) {
            stopMode = -21;
        } else if (stopModePrm.equals("NICE_KILL")) {
            stopMode = -20;
        } else if (stopModePrm.equals("MEAN_EXIT")) {
            stopMode = -23;
        } else {
            throw new TestException("test does not support stopMode: " + stopMode);
        }
        try {
            ClientVmMgr.stopAsync("Test kill, immediate restart", stopMode, -30);
        }
        catch (ClientVmNotFoundException ex) {
            throw new TestException("Kill with immediate restart failed for vmid: " + myVmid, ex);
        }
    }

    public static void HydraTask_closeCache() {
        memberTest.closeCache();
    }

    protected void closeCache() {
        Integer myVmid = new Integer(RemoteTestModule.getMyVmid());
        boolean cacheClosed = false;
        MembershipTest.log().info("### starting close cache, vmid: " + myVmid);
        CacheUtil.closeCache();
        MasterController.sleepForMs(1000);
        MembershipTest.log().info("### Still have connection so reopen cache for vmid: " + myVmid);
        CacheUtil.createCache();
    }

    public static void HydraTask_disconnect() {
        memberTest.disconnect();
    }

    protected void disconnect() {
        Integer myVmid = new Integer(RemoteTestModule.getMyVmid());
        boolean reconnectMember = TestConfig.tab().booleanAt(MembershipPrms.reconnectMember);
        MembershipTest.log().info("### in disconnect reconnectMember: " + reconnectMember);
        boolean disconnected = false;
        MembershipTest.log().info("### Disconnecting vmid: " + myVmid);
        Integer pid = (Integer)MembershipBB.getBB().getSharedMap().get(myVmid);
        if (pid == null) {
            throw new TestException("Requested member to disconnect not in test map of system members");
        }
        DistributedConnectionMgr.disconnect();
        CacheUtil.closeCache();
        MembershipTest.log().info("### Disconnected");
        disconnected = true;
        MembershipBB.getBB().getSharedMap().remove(myVmid);
        if (reconnectMember && disconnected) {
            MembershipTest.log().info("### initialize membership test for vmid: " + myVmid);
            this.initialize();
        }
        if (!reconnectMember) {
            throw new StopSchedulingTaskOnClientOrder();
        }
    }

    public static void HydraTask_verifyMembership() {
        memberTest.verifyMembership();
    }

    private void verifyMembership() {
        if (!DistributedConnectionMgr.isConnected()) {
            return;
        }
        boolean membersMatchTest = false;
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        int sleepMs = TestConfig.tab().intAt(MembershipPrms.waitInMembershipCheck);
        int waitThresholdMs = TestConfig.tab().intAt(MembershipPrms.membershipWaitThreshold);
        MembershipTest.log().info("### Starting verify membership");
        while (!membersMatchTest) {
            MembershipTest.log().info("### checking test members vs. GemFire members");
            if (this.membersMatchTest()) {
                membersMatchTest = true;
                endTime = System.currentTimeMillis();
                MembershipTest.log().fine("### Member pids match Test pids");
                elapsedTime = endTime - startTime;
                MembershipTest.log().fine("###Elapsed time waiting ds member update:: " + elapsedTime);
            }
            if (membersMatchTest) break;
            if (elapsedTime > (long)waitThresholdMs) {
                Set testPids = this.getTestMemberPids();
                Set dsMembers = this.getMembers();
                Set dsMemberPids = this.extractPids(dsMembers);
                String str = "Exceeded threshold waiting for membership update. ";
                str = str + " Threshold: " + waitThresholdMs + "\n";
                TreeSet setDiffs = this.setDiff(testPids, dsMemberPids);
                str = str + " Pids in Test but not in ds members: " + setDiffs + "\n";
                setDiffs = this.setDiff(dsMemberPids, testPids);
                str = str + " Pids in ds members but not in test: " + setDiffs + "\n";
                throw new TestException(str);
            }
            MasterController.sleepForMs(sleepMs);
        }
        elapsedTime = endTime - startTime;
        MembershipTest.log().info("###Elapsed time waiting for member update: " + elapsedTime);
    }

    public static void HydraTask_verifyMembershipAfterChange() {
        long totalTaskTimeSec = TestConfig.tab().longAt(MembershipPrms.totalTaskTimeSec);
        TestHelper.waitForCounter(MembershipBB.getBB(), "MembershipBB.membershipChangeInProgress", MembershipBB.membershipChangeInProgress, 0L, true, 3000000L);
        MembershipBB.incrementCounter(MembershipBB.taskReadyToStart);
        TestHelper.waitForCounter(MembershipBB.getBB(), "MembershipBB.taskReadyToStart", MembershipBB.taskReadyToStart, TestHelper.getNumVMs() - 1, true, 3000000L);
        MembershipBB.zeroCounter(MembershipBB.verifyCompleted);
        memberTest.verifyMembership();
        MembershipBB.incrementCounter(MembershipBB.taskCompletedToHere);
        TestHelper.waitForCounter(MembershipBB.getBB(), "MembershipBB.taskCompletedToHere", MembershipBB.taskCompletedToHere, TestHelper.getNumVMs() - 1, true, 3000000L);
        MasterController.sleepForMs(10000);
        long startTime = MembershipBB.readCounter(MembershipBB.startTime);
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (MembershipBB.readCounter(MembershipBB.numTotalTaskCompletions) > 1L || elapsedTime > totalTaskTimeSec * 1000L) {
            MembershipTest.log().info("### Verify reached end of task time");
            MembershipBB.incrementCounter(MembershipBB.numTotalTaskCompletions);
            throw new StopSchedulingTaskOnClientOrder();
        }
        MembershipBB.zeroCounter(MembershipBB.taskReadyToStart);
        MembershipBB.incrementCounter(MembershipBB.verifyCompleted);
        TestHelper.waitForCounter(MembershipBB.getBB(), "MembershipBB.verifyCompleted", MembershipBB.verifyCompleted, TestHelper.getNumVMs() - 1, true, 3000000L);
        MembershipBB.zeroCounter(MembershipBB.taskCompletedToHere);
        MembershipBB.incrementCounter(MembershipBB.membershipChangeInProgress);
    }

    private void removeMemberFromMap(Integer vmid) {
        Integer pid = (Integer)MembershipBB.getBB().getSharedMap().remove(vmid);
        if (pid == null) {
            throw new TestException("Expected vmid: " + vmid + " not found in member map");
        }
        MembershipTest.log().info("### removed Member from test map, pid is: " + pid);
    }

    private Integer getOtherRandomVmId() {
        Vector vmIds = ClientVmMgr.getOtherClientVmids();
        int randInt = TestConfig.tab().getRandGen().nextInt(0, vmIds.size() - 1);
        while (!MembershipBB.getBB().getSharedMap().containsKey(new Integer(randInt))) {
            MembershipTest.log().info("### try another random member, rand int was: " + randInt);
            randInt = TestConfig.tab().getRandGen().nextInt(0, vmIds.size() - 1);
        }
        return (Integer)vmIds.elementAt(randInt);
    }

    private boolean membersMatchTest() {
        Set memberSet = this.getMembers();
        Set gemFireMemberPids = this.extractPids(memberSet);
        MembershipTest.log().info("###System members pids for Distribution Manager Ids are: " + gemFireMemberPids.toString());
        Set testMemberPids = this.getTestMemberPids();
        MembershipTest.log().info("###System members pids per test are: " + testMemberPids.toString());
        if (gemFireMemberPids.equals(testMemberPids)) {
            MembershipTest.log().info("### Member pids match test pids");
            return true;
        }
        MembershipTest.log().info("### Member pids do not match test pids");
        return false;
    }

    private void verifyIsMember(int pid) {
        MembershipTest.log().info("###Verifying is member: " + pid);
        boolean isMember = false;
        long elapsedTime = 0L;
        long endTime = 0L;
        int waitThresholdMs = TestConfig.tab().intAt(MembershipPrms.membershipWaitThreshold);
        MembershipTest.log().info("### Waiting for membership updates");
        long startTime = System.currentTimeMillis();
        while (!this.isMember(pid)) {
            endTime = System.currentTimeMillis();
            elapsedTime = endTime - startTime;
            MembershipTest.log().fine("###Elapsed time waiting for new member: " + elapsedTime);
            if (elapsedTime <= (long)waitThresholdMs) continue;
            String str = "Exceeded threshold waiting for membership update. ";
            str = str + " Threshold: " + waitThresholdMs + "\n";
            throw new TestException(str);
        }
        endTime = System.currentTimeMillis();
        elapsedTime = endTime - startTime;
        MembershipTest.log().info("###Elapsed time waiting for new member: " + elapsedTime);
    }

    private void verifyNotMember(int pid) {
        MembershipTest.log().info("###Verifying is not member: " + pid);
        boolean isMember = true;
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        long elapsedTime = 0L;
        int waitThresholdMs = TestConfig.tab().intAt(MembershipPrms.membershipWaitThreshold);
        MembershipTest.log().info("### Waiting for membership update");
        while (this.isMember(pid)) {
            endTime = System.currentTimeMillis();
            elapsedTime = endTime - startTime;
            MembershipTest.log().fine("###Elapsed time waiting for member to depart: " + elapsedTime);
            if (elapsedTime <= (long)waitThresholdMs) continue;
            String str = "Exceeded threshold waiting for member to depart. ";
            str = str + " Threshold: " + waitThresholdMs + "\n";
            throw new TestException(str);
        }
        endTime = System.currentTimeMillis();
        elapsedTime = endTime - startTime;
        MembershipTest.log().info("###Elapsed time waiting for member to depart: " + elapsedTime);
    }

    private boolean isMember(int pid) {
        Integer memberPid = new Integer(pid);
        Set dsMembers = this.getMembers();
        Set dsMemberPids = this.extractPids(dsMembers);
        return dsMemberPids.contains(memberPid);
    }

    private Set getTestMemberPids() {
        Map memberMap = MembershipBB.getBB().getSharedMap().getMap();
        Set keys = memberMap.keySet();
        TreeSet<Integer> pids = new TreeSet<Integer>();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Integer memberPid = (Integer)memberMap.get(it.next());
            if (pids.add(memberPid)) continue;
            throw new TestException("Test has more than one member with same pid, unable to proceed with test, problem pid is: " + memberPid);
        }
        return pids;
    }

    private Set getMembers() {
        if (CacheUtil.getCache() == null) {
            CacheUtil.createCache();
        }
        return CacheUtil.getMembers();
    }

    public void printMemberInfo() {
        Set testMemberPids = this.getTestMemberPids();
        MembershipTest.log().info("### Test Member Pids ###");
        Iterator it = testMemberPids.iterator();
        while (it.hasNext()) {
            MembershipTest.log().info("Test Member Pid:  " + (String)it.next());
        }
        Set members = this.getMembers();
        MembershipTest.log().info("### DM Members ###");
        for (InternalDistributedMember member : members) {
            MembershipTest.log().info("Member.toString: " + member.toString());
            MembershipTest.log().info("Member vmKind: " + member.getVmKind());
            MembershipTest.log().info("Member vmPid:  " + member.getVmPid());
        }
    }

    private Set extractPids(Set members) {
        String pid = "";
        TreeSet<Integer> pids = new TreeSet<Integer>();
        for (InternalDistributedMember member : members) {
            MembershipTest.log().info("### per GF member pid is: " + member.getVmPid());
            Integer vmPid = new Integer(member.getVmPid());
            if (pids.add(vmPid)) continue;
            throw new TestException("GemFire has more than one member with same pid, unable to proceed with test");
        }
        return pids;
    }

    private TreeSet setDiff(Set set1, Set set2) {
        MembershipTest.log().fine("set 1: " + set1.toString());
        MembershipTest.log().fine("set 2: " + set2.toString());
        TreeSet diffs = new TreeSet();
        for (Object element : set1) {
            if (set2.contains(element)) continue;
            diffs.add(element);
        }
        MembershipTest.log().fine("In set1 not in set2: " + diffs.toString());
        return diffs;
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

