/*
 * Decompiled with CFR 0.152.
 */
package management.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.HydraThreadLocal;
import hydra.JMXManagerHelper;
import hydra.RemoteTestModule;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import management.jmx.GemfireMBeanServerConnection;
import management.jmx.JMXPrms;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import util.TestException;

public class ManagementUtil {
    private static JMXConnectorServer cs = null;
    private static Registry registry = null;
    private static HydraThreadLocal jmxCThreadLocal = new HydraThreadLocal();

    public static boolean hasConnectorStarted() {
        return cs == null;
    }

    public static synchronized void startRmiConnector(int port) {
        if (cs == null) {
            String vmId = null;
            vmId = "jmxrmi";
            try {
                if (registry == null) {
                    registry = LocateRegistry.createRegistry(port);
                }
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + InetAddress.getLocalHost().getHostName() + ":" + port + "/" + vmId);
                cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, ManagementFactory.getPlatformMBeanServer());
                cs.start();
                HydraUtil.logInfo("JMX RMI Connector started at url " + url.toString());
                FederationBlackboard.getBB().addManagingNode(vmId, url.toString());
            }
            catch (RemoteException e) {
                HydraUtil.logErrorAndRaiseException("Could not start RMI Connector on " + vmId, e);
            }
            catch (MalformedURLException e) {
                HydraUtil.logErrorAndRaiseException("Could not start RMI Connector on " + vmId, e);
            }
            catch (UnknownHostException e) {
                HydraUtil.logErrorAndRaiseException("Could not start RMI Connector on " + vmId, e);
            }
            catch (IOException e) {
                HydraUtil.logErrorAndRaiseException("Could not start RMI Connector on " + vmId, e);
            }
        }
    }

    public static synchronized void startRmiConnector() {
        int port = AvailablePortHelper.getRandomAvailableTCPPort();
        ManagementUtil.startRmiConnector(port);
    }

    public static synchronized void stopRmiConnector() {
        try {
            cs.stop();
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Could not stop RMI Connector on ", e);
        }
    }

    private static JMXConnector _connectToUrl(String url) throws MalformedURLException, IOException {
        if (JMXPrms.useAuthentication()) {
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            String[] creds = new String[]{JMXPrms.jmxUser(), JMXPrms.jmxPassword()};
            env.put("jmx.remote.credentials", creds);
            return JMXConnectorFactory.connect(new JMXServiceURL(url), env);
        }
        return JMXConnectorFactory.connect(new JMXServiceURL(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServerConnection connectToUrlOrGemfireProxy(String url) throws MalformedURLException, IOException {
        if (JMXPrms.useGemfireProxies()) {
            return new GemfireMBeanServerConnection(ManagementService.getManagementService((Cache)CacheHelper.getCache()));
        }
        if (HydraUtil.runninghydra()) {
            HydraThreadLocal hydraThreadLocal = jmxCThreadLocal;
            synchronized (hydraThreadLocal) {
                HashMap<String, MBeanServerConnection> map = (HashMap<String, MBeanServerConnection>)jmxCThreadLocal.get();
                if (map == null) {
                    map = new HashMap<String, MBeanServerConnection>();
                    JMXConnector conn = ManagementUtil._connectToUrl(url);
                    MBeanServerConnection remoteMBS = conn.getMBeanServerConnection();
                    HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
                    map.put(url, remoteMBS);
                    jmxCThreadLocal.set(map);
                    return remoteMBS;
                }
                MBeanServerConnection remoteMBS = (MBeanServerConnection)map.get(url);
                if (remoteMBS == null) {
                    JMXConnector conn = ManagementUtil._connectToUrl(url);
                    remoteMBS = conn.getMBeanServerConnection();
                    HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
                    map.put(url, remoteMBS);
                    return remoteMBS;
                }
                return remoteMBS;
            }
        }
        JMXConnector conn = ManagementUtil._connectToUrl(url);
        MBeanServerConnection remoteMBS = conn.getMBeanServerConnection();
        HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
        return remoteMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopRmiConnectors(List<ClientVmInfo> selectedVmList) {
        for (ClientVmInfo info : selectedVmList) {
            if (!info.getClientName().contains("managing")) continue;
            int vmId = info.getVmid();
            List<JMXManagerHelper.Endpoint> dsFilteredList = JMXManagerHelper.getEndpoints();
            for (JMXManagerHelper.Endpoint pt : dsFilteredList) {
                if (pt.getVmid() != vmId) continue;
                String url = FederationBlackboard.urlTemplate.replace("?1", pt.getHost());
                url = url.replace("?2", "" + pt.getPort());
                HydraThreadLocal hydraThreadLocal = jmxCThreadLocal;
                synchronized (hydraThreadLocal) {
                    Map map = (Map)jmxCThreadLocal.get();
                    map.remove(url);
                }
                ManagementUtil.checkUrl(url);
            }
        }
    }

    public static boolean checkUrl(String url) {
        HydraUtil.logInfo("Checking url is rechable or not " + url);
        try {
            MBeanServerConnection connection = ManagementUtil.connectToUrl(url);
            connection.queryMBeans(null, null);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            HydraThreadLocal hydraThreadLocal = jmxCThreadLocal;
            synchronized (hydraThreadLocal) {
                Map map = (Map)jmxCThreadLocal.get();
                try {
                    JMXConnector conn = ManagementUtil._connectToUrl(url);
                    MBeanServerConnection remoteMBS = conn.getMBeanServerConnection();
                    HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
                    map.put(url, remoteMBS);
                    return true;
                }
                catch (MalformedURLException e1) {
                    return false;
                }
                catch (IOException e1) {
                    throw new TestException("Event after retrying url " + url + " still not reachable");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServerConnection connectToUrl(String url) throws MalformedURLException, IOException {
        if (HydraUtil.runninghydra()) {
            HydraThreadLocal hydraThreadLocal = jmxCThreadLocal;
            synchronized (hydraThreadLocal) {
                HashMap<String, MBeanServerConnection> map = (HashMap<String, MBeanServerConnection>)jmxCThreadLocal.get();
                if (map == null) {
                    map = new HashMap<String, MBeanServerConnection>();
                    JMXConnector conn = ManagementUtil._connectToUrl(url);
                    MBeanServerConnection remoteMBS = conn.getMBeanServerConnection();
                    HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
                    map.put(url, remoteMBS);
                    jmxCThreadLocal.set(map);
                    return remoteMBS;
                }
                MBeanServerConnection remoteMBS = (MBeanServerConnection)map.get(url);
                if (remoteMBS == null) {
                    JMXConnector conn = ManagementUtil._connectToUrl(url);
                    remoteMBS = conn.getMBeanServerConnection();
                    HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
                    map.put(url, remoteMBS);
                    return remoteMBS;
                }
                return remoteMBS;
            }
        }
        JMXConnector conn = ManagementUtil._connectToUrl(url);
        MBeanServerConnection remoteMBS = conn.getMBeanServerConnection();
        HydraUtil.logInfo("Created JMX connection to url " + url + " for thread " + Thread.currentThread().getName());
        return remoteMBS;
    }

    public static void doStackDump() {
        Thread.dumpStack();
    }

    public static Set<ObjectName> getGemfireMBeans(String url) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = ManagementUtil.connectToUrl(url);
        }
        catch (MalformedURLException e) {
            throw new TestException("Error trying to managing node at " + url, e);
        }
        catch (IOException e) {
            throw new TestException("Error trying to managing node at " + url, e);
        }
        try {
            Set<ObjectName> objectNames = remoteMBS.queryNames(null, null);
            HashSet<ObjectName> fileteredON = new HashSet<ObjectName>();
            for (ObjectName n : objectNames) {
                if (!n.toString().contains("GemFire")) continue;
                fileteredON.add(n);
                HydraUtil.logFine("Added " + n + " in gemfire mbean set");
            }
            HydraUtil.logInfo("All mbeans " + objectNames);
            HydraUtil.logInfo("Gemfire mbeans " + fileteredON);
            return fileteredON;
        }
        catch (IOException e) {
            throw new TestException("Error trying to managing node at " + url, e);
        }
    }

    public static DistributedMember getMember() {
        return InternalDistributedSystem.getConnectedInstance().getDistributedMember();
    }

    public static String getMemberID() {
        return MBeanJMXAdapter.getMemberNameOrId((DistributedMember)ManagementUtil.getMember());
    }

    public static ObjectName getLocalMemberMBeanON() {
        ObjectName name = MBeanJMXAdapter.getMemberMBeanName((DistributedMember)ManagementUtil.getMember());
        return name;
    }

    public static String getLocalMemberMBean() {
        return ManagementUtil.getLocalMemberMBeanON().toString();
    }

    public static ObjectName getLocalManagerMBean() {
        ObjectName name = MBeanJMXAdapter.getManagerName();
        return name;
    }

    public static ObjectName getLocalCacheServerMBean(int port) {
        ObjectName name = MBeanJMXAdapter.getClientServiceMBeanName((int)port, (DistributedMember)ManagementUtil.getMember());
        return name;
    }

    public static void saveMemberMbeanInBlackboard() {
        FederationBlackboard.getBB().addMemberON("vmId" + RemoteTestModule.getMyVmid(), ManagementUtil.getLocalMemberMBean());
    }

    public static void saveMemberManagerInBlackboard() {
        FederationBlackboard.getBB().addManagerON("vmId" + RemoteTestModule.getMyVmid(), ManagementUtil.getLocalMemberMBean());
    }

    public static boolean checkLocalMemberMBean() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = server.queryNames(null, null);
        HydraUtil.logFine("Mbean Set registered at platform mbean server : " + objectNames);
        boolean flag = false;
        for (ObjectName n : objectNames) {
            if (!n.toString().contains(ManagementUtil.getLocalMemberMBean())) continue;
            flag = true;
            HydraUtil.logFine("Found Member MBean " + n + " in gemfire mbean set");
            break;
        }
        return flag;
    }

    public static boolean checkIfMBeanExists(MBeanServerConnection server, ObjectName mbean) throws IOException {
        Set<ObjectName> objectNames = server.queryNames(null, null);
        HydraUtil.logFine("Mbean Set registered at mbean server after federation : " + objectNames);
        for (ObjectName n : objectNames) {
            if (!n.equals(mbean)) continue;
            return true;
        }
        return false;
    }

    public static String getWanSiteName() {
        String clientName = RemoteTestModule.getMyClientName();
        String[] array = clientName.split("_");
        HydraUtil.logFine("clientName split Array DSName = " + HydraUtil.ObjectToString(array));
        HydraUtil.logFine("clientName split Array length = " + array.length);
        String dsName = null;
        if (array.length >= 4) {
            dsName = array[array.length - 1];
        }
        return dsName;
    }

    public static <T> List<T> filterForThisDS(List<T> list) {
        String clientName = RemoteTestModule.getMyClientName();
        String[] array = clientName.split("_");
        HydraUtil.logFine("clientName split Array DSName = " + HydraUtil.ObjectToString(array));
        HydraUtil.logFine("clientName split Array length = " + array.length);
        if (array.length >= 4) {
            String dsName = array[array.length - 1];
            HydraUtil.logInfo("Considering names of elements with DSName = " + dsName);
            ArrayList<T> filteredList = new ArrayList<T>();
            for (T t : list) {
                String name = t.toString();
                if (!name.contains(dsName)) continue;
                filteredList.add(t);
            }
            HydraUtil.logFine("List fileted for " + dsName + " " + HydraUtil.ObjectToString(filteredList));
            return filteredList;
        }
        return list;
    }

    public static <T> List<T> filter(Collection<T> list, String string) {
        ArrayList<T> filteredList = new ArrayList<T>();
        for (T t : list) {
            String name = t.toString();
            if (name.contains(string)) continue;
            filteredList.add(t);
        }
        HydraUtil.logFine("List fileted for " + string + " " + HydraUtil.ObjectToString(filteredList));
        return filteredList;
    }

    public static boolean checkForManagedMemberMBean(MBeanServerConnection server) throws IOException {
        String clientName = RemoteTestModule.getMyClientName();
        String[] array = clientName.split("_");
        HydraUtil.logFine("clientName split Array DSName = " + HydraUtil.ObjectToString(array));
        HydraUtil.logFine("clientName split Array length = " + array.length);
        String dsName = null;
        if (array.length >= 4) {
            dsName = array[array.length - 1];
            HydraUtil.logInfo("Considering names of clients with DSName = " + dsName);
        }
        Map map = FederationBlackboard.getBB().getMemberONs();
        int count = 0;
        ArrayList<String> listOFNS = new ArrayList<String>();
        for (String s : map.values()) {
            if (dsName != null && (dsName == null || !s.contains(dsName))) continue;
            listOFNS.add(s);
            ++count;
        }
        HydraUtil.logInfo("Checking " + listOFNS + " names on server " + server);
        Set<ObjectName> objectNames = server.queryNames(null, null);
        HydraUtil.logFine("Mbean Set registered at platform mbean server after federation : " + objectNames);
        for (ObjectName n : objectNames) {
            for (String s : map.values()) {
                if (!n.toString().contains(s)) continue;
                --count;
                listOFNS.remove(s);
            }
        }
        HydraUtil.logInfo("Final count of remaining mbeans not present in Manager view : " + count + " List : " + listOFNS);
        return count == 0;
    }

    public static List<String> getBeanProxiesForBlackboardMap(MBeanServerConnection server, Map<String, String> map) throws IOException {
        String clientName = RemoteTestModule.getMyClientName();
        String[] array = clientName.split("_");
        HydraUtil.logFine("clientName split Array DSName = " + HydraUtil.ObjectToString(array));
        HydraUtil.logFine("clientName split Array length = " + array.length);
        String dsName = null;
        if (array.length >= 4) {
            dsName = array[array.length - 1];
            HydraUtil.logInfo("Considering names of clients with DSName = " + dsName);
        }
        int count = 0;
        ArrayList<String> listOFNS = new ArrayList<String>();
        for (String s : map.values()) {
            if (dsName != null && (dsName == null || !s.contains(dsName))) continue;
            listOFNS.add(s);
            ++count;
        }
        HydraUtil.logInfo("getBeanProxiesForBlackboardMap :  " + listOFNS);
        return listOFNS;
    }

    public static List<String> checkForManagedMbeanProxies(MBeanServerConnection server) throws IOException {
        Map map = FederationBlackboard.getBB().getMemberONs();
        List<String> listOFNS = ManagementUtil.getBeanProxiesForBlackboardMap(server, map);
        return ManagementUtil.checkForMBeanProxies(server, listOFNS, map);
    }

    public static List<String> checkForManagingMbeanProxies(MBeanServerConnection server) throws IOException {
        Map map = FederationBlackboard.getBB().getManagerONs();
        List<String> listOFNS = ManagementUtil.getBeanProxiesForBlackboardMap(server, map);
        return ManagementUtil.checkForMBeanProxies(server, listOFNS, map);
    }

    public static List<String> checkForMBeanProxies(MBeanServerConnection server, List<String> listOFNS, Map<String, String> map) throws IOException {
        HydraUtil.logInfo("Checking " + listOFNS + " names on server " + server);
        Set<ObjectName> objectNames = server.queryNames(null, null);
        HydraUtil.logFine("Mbean Set registered at platform mbean server after federation : " + objectNames);
        for (ObjectName n : objectNames) {
            for (String s : map.values()) {
                if (!n.toString().contains(s)) continue;
                listOFNS.remove(s);
            }
        }
        HydraUtil.logInfo("Final count of remaining mbeans not present in Manager view : " + listOFNS.size() + " List : " + listOFNS);
        return listOFNS;
    }

    public static boolean checkForDistributedMBean(MBeanServerConnection server) throws IOException {
        Set<ObjectName> objectNames = server.queryNames(null, null);
        boolean flag = false;
        for (ObjectName n : objectNames) {
            if (!n.equals(MBeanJMXAdapter.getDistributedSystemName())) continue;
            flag = true;
            HydraUtil.logFine("Found Distributed System MBean " + n + " in gemfire mbean set");
            break;
        }
        return flag;
    }

    public static boolean checkForManagerMBean(MBeanServerConnection server) throws IOException {
        Set<ObjectName> objectNames = server.queryNames(null, null);
        boolean flag = false;
        for (ObjectName n : objectNames) {
            if (!n.equals(MBeanJMXAdapter.getManagerName())) continue;
            flag = true;
            HydraUtil.logFine("Found ManagerMBean " + n + " in gemfire mbean set");
            break;
        }
        return flag;
    }

    public static boolean subscribeDSNotifs() {
        return !JMXPrms.useGemfireProxies() || !RemoteTestModule.getMyClientName().contains("managed");
    }

    public static void checkIfThisMemberIsCompliantManager(MBeanServerConnection server) throws IOException, TestException {
        List<String> list = ManagementUtil.checkForManagedMbeanProxies(server);
        if (list.size() > 0) {
            throw new TestException("Some managed member not present in Manager view. " + list);
        }
        list = ManagementUtil.checkForManagingMbeanProxies(server);
        if (list.size() > 0) {
            throw new TestException("Some managing member not present in Manager view. " + list);
        }
        if (!ManagementUtil.checkForDistributedMBean(server)) {
            throw new TestException("DistributedSystemMBean is absent in Manager View Connection= " + server);
        }
        if (!ManagementUtil.checkForManagerMBean(server)) {
            throw new TestException("Could not find manager mbean after startManager via ManagementService Connection= " + server);
        }
    }

    public static MBeanServerConnection getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static MBeanServerConnection getPlatformMBeanServerDW() {
        if (JMXPrms.useGemfireProxies()) {
            return new GemfireMBeanServerConnection(ManagementService.getManagementService((Cache)CacheHelper.getCache()));
        }
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static boolean checkIfCommandsAreLoadedOrNot() {
        try {
            CommandManager manager = CommandManager.getInstance();
            Map commands2 = manager.getCommands();
            Set set = commands2.keySet();
            HydraUtil.logInfo("Started member with " + set.size() + " commands " + HydraUtil.ObjectToString(set));
            if (commands2.size() < 1) {
                HydraUtil.logError("CommandManager failed to load any commands " + commands2);
                return false;
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            HydraUtil.logError("CommandManager failed with " + e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            HydraUtil.logError("CommandManager failed with " + e.getMessage(), e);
            return false;
        }
    }

    public static Set<String> getMembersForGroup(MBeanServerConnection connection, String group) throws MalformedObjectNameException, NullPointerException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException {
        String[] memberList;
        HashSet<String> memberSet = new HashSet<String>();
        ObjectName ds = new ObjectName("GemFire:service=System,type=Distributed");
        for (String member : memberList = (String[])connection.invoke(ds, "listMembers", null, null)) {
            String[] groups;
            ObjectName memberMBean = new ObjectName("GemFire:type=Member,member=" + member);
            for (String g : groups = (String[])connection.getAttribute(memberMBean, "Groups")) {
                if (!g.equals(group) && group != null) continue;
                memberSet.add(member);
            }
        }
        return memberSet;
    }

    public static Set<String> getMembersForGroup(String group) throws MalformedObjectNameException, InstanceNotFoundException, AttributeNotFoundException, NullPointerException, MBeanException, ReflectionException {
        String url = FederationBlackboard.getBB().getManagingNode();
        try {
            MBeanServerConnection connection = ManagementUtil.connectToUrl(url);
            return ManagementUtil.getMembersForGroup(connection, group);
        }
        catch (MalformedURLException e) {
            throw new TestException("Error connecting manger", e);
        }
        catch (IOException e) {
            throw new TestException("Error connecting manger", e);
        }
    }
}

